Rem
Rem $Header: utlpwdmg.sql 31-aug-2000.11:00:47 nireland Exp $
Rem
Rem utlpwdmg.sql
Rem
Rem  Copyright (c) Oracle Corporation 1996, 2000. All Rights Reserved.
Rem
Rem    NAZWA
Rem      utlpwdmg.sql - skrypt obsugujcy ograniczenia zasobw domylnego hasa
Rem
Rem    OPIS
Rem      Skrypt wcza funkcje zarzdzania hasami
Rem      przez ustawienie ogranicze zasobw domylnego hasa.

CREATE OR REPLACE FUNCTION verify_function
 (username varchar2,
 password varchar2,
 old_password varchar2)
 RETURN boolean IS
  n boolean;
  m integer;
  differ integer;
  isdigit boolean;
  ischar  boolean;
  ispunct boolean;
  digitarray varchar2(20);
  punctarray varchar2(25);
  chararray varchar2(52);

BEGIN
  digitarray:= '0123456789';
  chararray:= 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
  punctarray:='!"#$%&()``*+,-/:;<=>?_';

-- Sprawdzenie, czy haso jest takie samo jak nazwa konta uytkownika.
IF NLS_LOWER(password) = NLS_LOWER(username) THEN
  raise_application_error(-20001, 'Haso jest identyczne z nazw uytkownika lub 
  podobne do niej');
END IF;

-- Sprawdzenie minimalnej dugoci hasa.
IF length(password) < 4 THEN
  raise_application_error(-20002, 'Dugo hasa jest mniejsza ni 4 znaki');
END IF;

-- Sprawdzenie, czy haso nie jest zbyt proste. Moe by zastosowany sownik
-- i przeprowadzane sprawdzenie majce na celu uniemoliwienie uycia
-- sw, ktre s zbyt proste, aby by hasem.
IF NLS_LOWER(password) IN ('witaj', 'baza_danych', 'konto',
       'uzytkownik', 'haslo', 'oracle', 'komputer', 'abcd') THEN
   raise_application_error(-20002, 'Haso jest zbyt proste');
END IF;

-- Sprawdzenie, czy haso zawiera co najmniej jedn liter, jedn cyfr i
-- jeden znak interpunkcyjny.
-- 1. Sprawdzenie istnienia cyfry
isdigit:=FALSE;
m := length(password);
FOR i IN 1..10 LOOP
 FOR j IN 1..m LOOP
  IF substr(password,j,1) = substr(digitarray,i,1) THEN
     isdigit:=TRUE;
      GOTO findchar;
  END IF;
 END LOOP;
END LOOP;
IF isdigit = FALSE THEN

   raise_application_error(-20003, 'Haso powinno zawiera co najmniej
           jedn liter, jedn cyfr i jeden znak interpunkcyjny.');
END IF;
-- 2. Sprawdzenie istnienia litery
<<findchar>>
ischar:=FALSE;
FOR i IN 1..length(chararray) LOOP
 FOR j IN 1..m LOOP
  IF substr(password,j,1) = substr(chararray,i,1) THEN
     ischar:=TRUE;
     GOTO findpunct;
  END IF;
 END LOOP;
END LOOP;
IF ischar = FALSE THEN
   raise_application_error(-20003, 'Haso powinno zawiera co najmniej
             jedn liter, jedn cyfr i jeden znak interpunkcyjny.');
END IF;
-- 3. Sprawdzenie istnienia znaku interpunkcyjnego
<<findpunct>>
ispunct:=FALSE;
FOR i IN 1..length(punctarray) LOOP
 FOR j IN 1..m LOOP
  IF substr(password,j,1) = substr(punctarray,i,1) THEN
     ispunct:=TRUE;
     GOTO endsearch;
  END IF;
 END LOOP;
END LOOP;
IF ispunct = FALSE THEN
   raise_application_error(-20003, 'Haso powinno zawiera co najmniej
             jedn liter, jedn cyfr i jeden znak interpunkcyjny.');
END IF;

<<endsearch>>
-- Sprawdzenie, czy haso rni si od poprzedniego co najmniej
-- trzema znakami.
IF old_password IS NOT NULL THEN
 differ := length(old_password) - length(password);

IF abs(differ) < 3 THEN
 IF length(password) < length(old_password) THEN
  m := length(password);
ELSE
  m := length(old_password);
END IF;

differ := abs(differ);
FOR i IN 1..m LOOP
 IF substr(password,i,1) != substr(old_password,i,1) THEN
  differ := differ + 1;
 END IF;
END LOOP;

IF differ < 3 THEN
  raise_application_error(-20004, 'Haso powinno si rni co najmniej
  trzema znakami');
  END IF;
  END IF;
 END IF;
 -- Gdy wszystko jest w porzdku, zwracana jest warto TRUE.
 RETURN(TRUE);
END;