package com.apress.proandroid.layouts;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewStub;

public class LayoutsActivity extends Activity {
	private static final String TAG = "LayoutsActivity";
	
    /** Wywoywana, kiedy aktywno jest tworzona po raz pierwszy. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        int layoutResID = R.layout.frame;
        
        // Sprawdzanie poprawnoci rozwijania wszystkich ukadw do klas
        setContentView(R.layout.all);
        setContentView(R.layout.frame);
        setContentView(R.layout.linear);
        setContentView(R.layout.main);
        setContentView(R.layout.merge);
        setContentView(R.layout.mylayout);
        setContentView(R.layout.nested);
        setContentView(R.layout.relative);
        
        // Ostatni ukad (jedyny widoczny dla uytkownika)
        setContentView(layoutResID);
        
        inflateStub(R.id.myid, true);
    }
    
    private View inflateStub(int id, boolean useSetVisibility) {
    	View view = null;
    	if (useSetVisibility) {
    		// Testowanie klasy ViewStub (uwaga: nie dla wszystkich ukadw istnieje taka klasa, 
    		// dlatego naley sprawdzi, czy v jest rne od null)
            View v = findViewById(id);
            if (v != null) {
            	Log.d(TAG, "Ukad nadrzdny v? " + v.getParent().toString());
            	v.setVisibility(View.VISIBLE);
            	Log.d(TAG, "Ukad nadrzdny v? " + v.getParent());
            	view = findViewById(id);
            }
    	} else {
    		ViewStub stub = (ViewStub) findViewById(id);
    		if (stub != null) {
    			view = stub.inflate();
    		}
    	}
    	return view;
    }
}