package com.apress.proandroid.opengl;

import android.app.Activity;
import android.opengl.GLES20;
import android.os.Bundle;
import android.util.Log;

public class OpenGLActivity extends Activity {
	private static final String TAG = "OpenGLActivity";
	
	private MyGLES20View mGLView;
	
    /** Wywoywana, kiedy aktywno jest tworzona po raz pierwszy. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.main);
        
		String extensions = GLES20.glGetString(GLES20.GL_EXTENSIONS);
		Log.d(TAG, "Rozszerzenia: " + extensions);

		mGLView = new MyGLES20View(this);
		setContentView(mGLView);
		
		// Nic si nie pojawi (brak kontekstu OpenGL ES 2.0 na tym etapie - zobacz okno LogCat)
		extensions = GLES20.glGetString(GLES20.GL_EXTENSIONS);
		Log.d(TAG, "Rozszerzenia: " + extensions);
    }

	@Override
	protected void onPause() {
		super.onPause();
		mGLView.onPause();
	}

	@Override
	protected void onResume() {
		super.onResume();
		mGLView.onResume();
	}
}