package com.apress.proandroid.java;

import android.util.Log;

public class MyClass {
	private static final String TAG = "MyClass";
	private static int mValue;
	
	public MyClass(int n) {
		mValue = n;
	}
	
	public void add (int a) {
		synchronized (this) {
			mValue += a;
		}
		Log.i(TAG, "+" + a); // Blokada nie jest potrzebna
	}
	
	public void multiplyAndAdd (int m, int a) {
		synchronized (this) {
			mValue = mValue * m + a;
		}
		Log.i(TAG, "*" + m + ", +" + a); // Blokada nie jest potrzebna
	}
	
	public static synchronized void setValue(int n) {
		mValue = n;
	}
	
	public static void loop () {
		while (mValue != 100) {
			try {
				Log.i(TAG, "Warto to " + mValue);
				Thread.sleep(1000);
			} catch (Exception e) {
				// Ignorowanie wyjtku
			}
		}
	}
}
