 // Misja w nadprzestrzeń C++14/17, program z paragrafu   3.12.2

#include <iostream>
#include <vector>
#include <array>
using namespace std;
/////////////////////////////////////////////////////////////////////////////////////////
struct Tsubstancja															// `1
{
public:
	// wszystkie składniki-dane niestatyczne (czyli zwykłe) muszą być publiczne
	string 		napis;
	double 		liczba;

	static bool 	statek;													// `2
	int 			pole_bitowe: 4;											// `3
	bool 		czy_sensowna_informacja;

	Tsubstancja(string s, double li, int pb, bool czy) :								// `4
				napis(s), liczba(li), pole_bitowe(pb), czy_sensowna_informacja(czy)
	{ }
};
/////////////////////////////////////////////////////////////////////////////////////////
bool Tsubstancja::statek = true;												// `5
//*******************************************************************
vector<Tsubstancja> wektor_substancji = {									// `6
			{ "Woda", 100, 1, true},
			{ "Maslo", 150, 1, true},
			{ "Alkohol etylowy", 78, 2, true},
			{ "Alkohol metylowy", 65, 2, true}
	};
//*******************************************************************
Tsubstancja  zwroc_dane_o_substancji_nr(unsigned int nr); 			// deklaracja funkcji
//*******************************************************************
int main()
{
	Tsubstancja 	obj{"Eter", 35, 3, true }; 										// `7
	auto [a,b,c,d] = obj;														// `8
	a += "_rozrzedzony"; 													// `9
	cout << "a = " << a << ", obj.napis = " << obj.napis << endl;

	auto & [refa, refb, refc, refd] = obj;										// `10
	refa += "_sprezony";													// `11
	cout << "refa = " << refa << ", obj.napis = " << obj.napis << endl;

	for (int nr = 0;	; ++nr)													// `12
	{
		//-------------------- inicjalizacja dowiązania rezultatem funkcji
		auto[substancja, stopni, pb, poprawne] =
								zwroc_dane_o_substancji_nr(nr); 			// `13

		if(poprawne) {
			cout << substancja << " wrze w temperaturze " << stopni << " stopni C" << endl;
			stopni *= 100;													// `14
	 	} else {
			cout << "Pod numerem " << nr << " jest " << substancja << endl;
			break;
		}
	}
	// nie da się zdefiniować takiego dowiązania, skoro ta funkcja nie zwraca l-wartości
	// auto & [co1, stopni1, pbit, poprawne1] = zwroc_dane_o_substancji_nr(2);			// `15

	const auto & [co2, stopni2, pbit2, poprawne2] = zwroc_dane_o_substancji_nr(2); 		// `16

	// można zrobić dowiązanie na zasadzie referencji do r-wartości (czyli wartości chwilowej)
	auto && [co3, stopni3, pbit3, poprawne3] = zwroc_dane_o_substancji_nr(2); 			// `17

	cout << "--- Dowiazanie mozna umiescic w warunku instrukcji if ---\n";
	for (int n = 0;	; ++n)
	{
		if(auto[co, stopni, symbol, poprawne] = zwroc_dane_o_substancji_nr(n) ; poprawne) 	// `18
		{
			cout << co << " wrze w temperaturze " << stopni << " stopni C" << endl;
		} else {
			cout << "Pod tym numerem jest: " << co << endl;
			break;
		}
	}
	// za pomocą zakresowej pętli for można przeglądać pojemnik
	// a umieszczenie w tej instrukcji deklaracji strukturalnego dowiązania
	// pozwala łatwo rozpakowywać składniki poszczególnych elementów pojemnika.
	cout << "--- Deklaracja dowiazania umieszczona w zakresowym for ---\n";

	for (auto  [co, stopni, pb, poprawne] : wektor_substancji) 						// `19
	{
		if(poprawne) {
			cout << co << " wrze w temperaturze " << stopni << " stopni C" << endl;
		}
	}
}
//*******************************************************************
// funkcja zwracająca rezultat przez kopię
Tsubstancja zwroc_dane_o_substancji_nr(unsigned int nr)						// `20
{
	if(nr < wektor_substancji.size() )
		return wektor_substancji[nr] ; 										// `21
	else
		return Tsubstancja {"Substancja niezdefiniowana", 0, 0, false}; 			// `22
}
