//  Misja w nadprzestrzeń C++14/17, program z paragrafu 1.2.1

#include <iostream>
#include <string>
using namespace std;
//******************************************************
template <typename T, typename...   Tpakiet>									// `1
auto suma(T arg, Tpakiet... reszta)
{
	if constexpr(sizeof...(Tpakiet) > 0)											// `2
	{
		return  arg + suma(reszta...);		// wywołanie niby-rekurencyjne  			// `3
	}
	else return arg;														// `4
}
//******************************************************
template <typename T, typename...   Tpakiet>									// `5
auto suma_kwadratow(T arg, Tpakiet... reszta)
{
	auto kwadr = arg * arg;													// `6
	if constexpr(sizeof...(Tpakiet) > 0)
	{
		return  kwadr + suma_kwadratow(reszta...);		// wywołanie niby-rekurencyjne 	 (poprawka)		// `7
	}
	else return kwadr;														// `8
}
//******************************************************
int main()
{
	auto wynik = suma(3, 1, 2.5, -1);											// `9
	cout << "\nwynik = "<< wynik << endl;

	cout << "Mozemy obsluzyc nawet wiele argumentow\n";
	cout << "  suma 15 argumentow = "
			<< suma(100, 20, 3, 40, 55, 6, 7, 8, 9, 10.33, 111, 142, 13, 114, 15 ) << endl; 		 // `10

	cout << "Mozemy tez dodawac stringi (operatorem +) \n";
	auto z = suma(string(" Start "), string("o godzinie ") , string("15:30") );			// `11
	cout << "  Zsumowany tekst:   " << z << endl;

	auto r = suma_kwadratow(12, 3, 9, 5);										// `12
	cout << "Wynik sumy kwadratow = " << r << endl;
}
