 // Misja w nadprzestrzeń C++14/17, program z paragrafu 3.3.1


#include <iostream>
#include <string>
using namespace std;
#include <stdio.h> 						// dla funkcji printf
/////////////////////////////////////////////////////////////////////////////////////////
// przykładowe klasy użytkownika
/////////////////////////////////////////////////////////////////////////////////////////
class TypZw															// `1
{
	int numer;
	double liczba;
};
/////////////////////////////////////////////////////////////////////////////////////////
class alignas(32) TypWy												// `2
{
	int numer;
	double liczba;
};
//*******************************************************************
// przeładowanie globalnych operatorów
//*******************************************************************
// dla pojedynczych obiektów ----------------------------------------------
void * operator new(size_t rozmiar)										// `3
{
	printf("\t(N1) new pojedynczy obiekt, rozmiar %lu bajtow\n", (unsigned long) rozmiar);
	void *wsk = malloc(rozmiar);
	if(!wsk) throw std::bad_alloc();
	return wsk;
}
//*******************************************************************
// nowość w C++17
void * operator new(size_t rozmiar, align_val_t wyrownanie)					// `4
{
	printf("\t(N2) new pojedynczy obiekt, rozmiar %lu, wyrownanie %d \n",
									(unsigned long) rozmiar, (int) wyrownanie);
	void *wsk = aligned_alloc((size_t)wyrownanie, rozmiar );					// `5
	if(!wsk) throw std::bad_alloc();
	return wsk;
}
//*******************************************************************
void operator delete(void * wsk) noexcept
{
	printf("\t(D1) delete pojedynczy obiekt\n");
	free(wsk);
}
//*******************************************************************
void operator delete (void * wsk, std::size_t rozmiar) 		 				// `6
{
	printf("\t(D2) delete (void * wsk, rozmiar = %lu bajtow)\n", rozmiar);
	free(wsk);
}
//*******************************************************************
// nowość w C++17:
void operator delete (void * wsk, std::size_t rozmiar, align_val_t wyrownanie)		// `7
{
	printf("\t(D3) delete (void * wsk, rozmiar = %lu, wyrownanie = %d)\n",
		 rozmiar, (int)wyrownanie);
	free(wsk);
}
//*******************************************************************
//---dla tablic ----------------------------------------------------------
void * operator new[ ](std::size_t rozmiar)									// `8
{
	printf("\t(N3) new[ ](size_t rozmiar = %lu bajtow)\n", rozmiar);
	void *wsk = malloc(rozmiar);
	if(!wsk) throw std::bad_alloc();
	return wsk;
}
//*******************************************************************
// nowość C++17
void * operator new[ ](std::size_t rozmiar, align_val_t wyrownanie) 			// `9
{
	printf("\t(N4) new[ ](size_t rozmiar = %lu bajtow, wyrownanie = %d)\n",
		rozmiar, (int) wyrownanie);
	void *wsk = aligned_alloc((size_t)wyrownanie, rozmiar );
	if(!wsk) throw std::bad_alloc();
	return wsk;
}
//*******************************************************************
void operator delete[ ](void * wsk)										// `10
{
	printf("\t(D4) delete [ ] (void*);	<-> bez arg. 'rozmiar'\n");
	free(wsk);
}
//*******************************************************************
// delete[] z argumentem określającym rozmiar -----------
void operator delete [ ](void * wsk, std::size_t rozmiar)
{
	printf("\t(D5) delete [ ](void * wsk, rozmiar = %lu bajtow)\n", rozmiar);
	free(wsk);
}
//*******************************************************************
// C++17: delete[] z argumentem określającym rozmiar i wyrównanie-----------
void operator delete [ ](void * wsk, size_t rozmiar, align_val_t wyrownanie)
{
	printf("\t(D6) delete [ ](void * wsk, rozmiar = %lu bajtow, wyrownanie %d)\n",
	rozmiar, (int)wyrownanie);
	free(wsk);
}
//*******************************************************************
// C++17: delete[] z argumentem określającym wyrównanie -----------
void operator delete [ ](void * wsk, align_val_t wyrownanie) 	noexcept 		// `11
{
	printf("\t(D7) delete [ ](void * wsk, wyrownanie %d)\n", (int)wyrownanie);
	free(wsk);
}
//*******************************************************************
int main()
{
	try {
		cout << "Wytwarzanie pojedynczych obiektow------------------------\n";
		cout << "a) Obiekt TypZw, rozmiar [bajtow], " << sizeof(TypZw)
			<< ", wyrownanie domniemane = (" << alignof(TypZw) << ")\n";		// `12

		auto *wsk1 = new TypZw;										// `13
		delete wsk1;

		cout << "\nb) Obiekt TypWy, rozmiar [bajtow], " << sizeof(TypWy)
			<< ", WYROWNANIE (ustawione) = " << alignof(TypWy)<< ")\n";		// `14

		auto *wsk2 = new TypWy; 										// `15
		delete wsk2;													// `16

		cout << "\nWytwarzanie tablic obiektow----------------------------\n" ;
		cout << "c) Tablica 'zwyklego' typu: TypZw[3]\n";
		auto *tablica = new TypZw[3];									// `17
		delete [ ] tablica;

		cout << "\nd) Tablica 'WYROWNYWANEGO' typu: TypWy[3]\n";
		auto tab = new TypWy [3];										// `18
		delete [ ] tab;
	}
	catch(bad_alloc)
	{
		cout << "Niepowodzenie w trakcie rezerwacji pamieci " << endl;
	}
}





