 // Misja w nadprzestrzeń C++14/17, program z paragrafu   3.12

#include <iostream>
#include <vector>
#include <array>
using namespace std;
//*******************************************************************
int main()
{
	int tabl[3] { 15 , 70, 54 };

	// dowiązania strukturalne zmiennych do elementów powyższej (zwykłej) tablicy --------
	auto [predkosc, droga, czas]  = tabl;				 // `1
	predkosc += 500;								// `2

	cout << "predkosc = " << predkosc << ", droga= " << droga
	 		<< ", czas=" << czas << endl;
									// wydruk: predkosc = 515, droga= 70, czas=54

	cout << "(Niezmieniona) tresc oryginalnej tablicy: " ;
	for(auto elem : tabl) cout << elem << " " ;			// `3
	cout << endl;
						// wydruk: "(Niezmieniona) tresc oryginalnej tablicy: 15 70 54 "

	// Dowiązanie w postaci referencji pozwala zmienić tresc oryginalej tablicy
	auto & [pr, dr, cz] = tabl; 						 // `4

	pr += 200;										// `5
	cout << "Po modyfikacji pr, oryginalna tablica: " ;
	for(auto elem : tabl) cout << elem << " " ;	// wydruk: 215, 70, 54
	cout << endl;

	// Dowiązanie w postaci referencji rwartości
	auto && [p2, d2, c2]  = tabl;  							// `6

	// Dowiązanie w postaci referencji stałej l-wartości
	const auto & [pc, dc, cc] = tabl;	 // `7
	// pc = 33; // skoro dowiązanie pc ma przydomek const, to taka operacja jest niedopuszczalna

	volatile 	auto & [pv, dv, cv] = tabl;	 // `8

	//============================================
	cout<< "Mozliwe sa tez dowiazania do elementow pojemnika typu std::array" << endl;

	std::array<double, 5> arr = { 1, 2, 3.3, 4 , 5 };		// `9

	auto &[m, n, p, q, r] = arr;		// referencje do elementów tej tablicy // `10

	p+= 1000;
	cout << "po modyfikacji referencji p= " << p << endl;

	cout << "Obecna zawartosc arr: " ;
	for(auto x :  arr) cout << x << ", " ;									// `11
						// wydruk: "Obecna zawartosc arr: 1, 2, 1003.3, 4, 5,"
}


