// Misja w nadprzestrzeń C++14/17, program z paragrafu   3.15

#include <iostream>
#include <vector>
#include <cstddef> 	// nagłówek dla std::byte
#include <bitset>  	// nagłówek dla std::bitset
using namespace std;
//*******************************************************************
void funkcja_przyjmujaca_znak ( unsigned char znak );
void wypisz ( byte b, string txt );
void opracuj_bufor ( unsigned char * wsk, int ile_bajtow );
void fun (vector<byte> & ref);
//*******************************************************************
int main()
{
	// inicjalizacja komórki pamięci
	byte  komorka {3};					// 00000011 po inicjalizacji liczbą 3 		// `1
	byte b {'z'};	 													// `2

	// różne postacie przypisania
	// komorka = 2; 					// niemożliwe						// `3
	komorka = byte {2};			 	// 00000010						// `4
	komorka = byte { 0xf2 };				// 11110010 						// `5
	komorka = byte {0b101100};			// 00101100						// `6

	// komorka++;		// niemożliwe są operacje arytmetyczne				// `7

	// Nie można wysłać obiektu byte do funkcji przyjmujących unsigned char
	// funkcja_znakowa(komorka);		// błąd							// `8

	funkcja_przyjmujaca_znak ( to_integer<unsigned char> ( komorka ) );		// `9

	// Przykłady operacji bitowych ---------------------------------------------
	komorka = komorka | byte {0b10};		// 00101110				 		// `10
	wypisz ( komorka, "po ustawieniu bitu nr 1, \n" );							// `11

	komorka &= byte {0b100};			// 00000100					 	// `12
	wypisz ( komorka, "po zerowaniu bitów (oprocz nr 2) \n" );

	komorka ^= byte {0b111};			// 00000011 						// `13
	wypisz ( komorka, "po negacji bitów nr: 0, 1, 2 \n" );

	komorka <<= 2;								// 00001100	  		// `14
	wypisz ( komorka, "po przesunieciu o 2 bity w lewo\n" );

	komorka =	 ~byte {0b00011100};									// `15
	wypisz ( komorka, "po przypisaniu zanegowanego bajtu: 0x00011100 \n" );

	cout <<	"Jaki stan ma bit nr 2?	(sprawdzamy dzieki koniunkcji bitowej)\n";
	byte koniunkcja = komorka & byte {0b100};			// maskujemy bit nr 2 		// `16

	if ( to_integer<bool> ( koniunkcja ) )									// `17
		wypisz ( komorka, "<->bit nr 2 jest w stanie 1 \n" );
	else
		wypisz ( komorka, "<->bit nr 2 jest w stanie 0 \n" );

	//	Inny sposób sprawdzania pojedynczego bitu-------------------------
	cout <<	"Jaki stan ma bit nr 2?	(sprawdzamy dzieki klasie bitset)\n";

	bitset<sizeof ( byte ) *8> rozklad	=  to_integer<unsigned char> ( komorka ); 		// `18

	if ( rozklad[2] ==	true )				//	operator [ ] w klasie bitset 		// `19
		wypisz ( komorka, "<->bit nr 2 jest w stanie 1 \n" );
	else
		wypisz ( komorka, "<->bit nr 2 jest w stanie 0\n" );
	// ----------------------------------------------------------------------------------

	cout << "Tablica wielu bajtow --------\n";
	vector<byte>	bufor = { byte ( 255 ), byte ( 32 ), byte ( 63 ) , byte ( 12 ), byte ( 15 ) }; 	// `20

	fun(bufor);														// `21

	//	sposób wysłania bufora do funkcji spodziewającej się bufora unsigned char
	opracuj_bufor ( reinterpret_cast<unsigned char *> ( &bufor[0] ),	bufor.size() ); 	// `22

	for ( unsigned int i = 0 ; i < bufor.size() ; ++i )
	{
		wypisz ( bufor[i], " w bajcie nr " + to_string ( i ) + " bit nr 0 ma wartosc: " );
		if ( to_integer<bool> ( bufor[i] & byte {0b1} ) ) 						// `23
			cout <<	"1" <<	endl;
		else
			cout <<	"0" <<	endl;
	 }
}
//*******************************************************************
void funkcja_przyjmujaca_znak ( unsigned char znak )
{
	cout << __func__ <<	" przyjela znak [" <<	znak <<	"]	dec ="
		<< (unsigned short) (znak) <<	endl;
}
//*******************************************************************
void wypisz ( byte b, string txt )											// `24
{
	uint8_t liczba = to_integer<uint8_t> ( b );								// `25
	bitset<8>		obiekt ( liczba );										// `26
	cout << obiekt << "	 " << txt;						 					// `27
}
//*******************************************************************
void fun ( vector<byte> & ref)											// `28
{
	cout <<	__func__ <<	": ";
		for (unsigned int i = 0; i < ref.size(); ++i)
			cout <<	to_integer<short int>(ref[i]) <<	", ";
		cout <<	endl;
}
//*******************************************************************
void opracuj_bufor ( unsigned char * wsk,	int ile_bajtow ) 					// `29
{
	cout << "w funkcji:	opracuj_bufor(unsigned char * wsk,	int ile_bajtow)\n";

	for ( int i = 0; i < ile_bajtow; ++i,	++wsk )
	{
		cout << int ( *wsk ) <<	", ";
	}
	cout << endl;
}


