 // Misja w nadprzestrzeń C++14/17, program z paragrafu   3.13


// Załóżmy, że w bieżącym katalogu jest plik o nazwie Tklasa.h  zawierający
// taką definicję klasy:

/*----
#ifndef __TKLASA_H_
class Tklasa
{
public:
	auto wazne_obliczenie() { return "Zwyklym sposobem"; }
};
#endif
---*/
//-----------------------------------------------------------------

// W podkatalogu experimental może (ale nie musi) znaleźć się nowa prototypowa wersja definicji
// tej samej klasy. (Plik ma tę samą nazwę).
/*
#ifndef __TKLASA_H_
class Tklasa
{
public:
	auto wazne_obliczenie() { return "NOWYM sposobem"; }
	auto info() { return "Nowy algorytm obliczen opracowala Kazia"; }
};
#endif
*/

//-----------------------------------------------------------------

/*
A oto właściwy program, w którym skorzystamy z nowej
prototypowej wersji (jeśli tylko jest dostępna), a jeśli
nie – to skorzystamy z tej zwykłej, dotychczasowej wersji.
*/

#include <iostream>
#include <string>
using namespace std;

#if __has_include("experimental/Tklasa.h") // czy istnieje wersja „prototypowa”?		// `1
	#include "experimental/Tklasa.h"										// `2
	#define JEST_WERSJA_PROTOTYPOWA true							// `3

#elif __has_include("Tklasa.h") // w przeciwnym razie, czy istnieje wersja „zwykła”? 	// `4
	#include "Tklasa.h"
	#define JEST_WERSJA_PROTOTYPOWA false

#else																 // `5
	#error "Error: Jakas wersja naglowka Tklasa.h musi istniec!"				// `6
#endif
//*******************************************************************98]>
int main()
{
	Tklasa obiekt;
	auto rezultat = obiekt.wazne_obliczenie();
	cout << "Obliczenie zostalo zrobione " << rezultat << endl;
#if(JEST_WERSJA_PROTOTYPOWA)									// `7
	cout << obiekt.info() << endl;
#endif
}
