 // Misja w nadprzestrzeń C++14/17, program z paragrafu 2.5.6

 #include <iostream>
#include <string>
using namespace std;
//*******************************************************************
template<typename T>
std::false_type   czy_lubiany_typ;									 // `1
//*******************************************************************
template< >
std::true_type   czy_lubiany_typ<const char*> ;							 // `2
//*******************************************************************
template< >
std::true_type   czy_lubiany_typ<std::string>;							 // `3
//*******************************************************************
// szablon funkcji dla typów nadających się (bo tekstowych)
template <typename T>
void fun_dwoista(T arg, std::true_type ) 				// [czarna wielka litera] szablon A  // `4
{
	cout <<  "\tF. dwoista wg szablonu A dla typow lubianych" << endl;
	std::string tekst (arg);
	cout << "\tTekst: >" << tekst << "<, \n\ta litera nr [2] to '" << arg[2] << "'"<< endl;
}
//*******************************************************************
// szablon funkcji dla typów nie nadających się (bo nie-tekstowych)
template <typename T>
void fun_dwoista(T arg, std::false_type)				// [czarna wielka litera] szablon B  // `5
{
	// nietekstowa wersja
	cout << "\tf. dwoista wg szablonu B dla typow NIElubianych" << endl;
	T  tmp = arg;
	cout << "\tWydruk nie-tekstowego arg = " << tmp << endl;
}
//*******************************************************************
template <typename T>
void funkcja_robocza(T arg)				// szablon funkcji 				 // `6
{
	 // najważniejsza instrukcja
	fun_dwoista(arg, czy_lubiany_typ<T>  ); 							 // `7

	// poniżej to już tylko kosmetyka –––––––––––––
	cout << "Czy ten typ T jest aprobowany? ";
	if(czy_lubiany_typ<T> )  		// if(nazwa_zmiennej_szablonowej)		 // `8
	{
		cout << "TAK" << endl;
	} else {
		cout << "NIE" << endl;
	}
}
//*******************************************************************
int main()
{
	cout << "\nProba z liczba typu T ---> int \n";
	funkcja_robocza(5);											 // `9

	cout << "\nProba z C-stringiem (typ const char*) \n";
	funkcja_robocza("abc"); 										 // `10

	cout << "\nProba z obj. kl. std::string \n";
	string s("Nowosci w C++14");
	funkcja_robocza(s) ;											 // `11

	cout << "\nProba ze wskaznikiem int * \n";
	int roboczy = 4;
	int *wsk = &roboczy;
	funkcja_robocza(wsk);											 // `12
}
