package eu.sig.training.r04.v1;

import eu.sig.training.r04.BusinessException;
import eu.sig.training.r04.Money;

// tag::SavingsAccount[]
public class SavingsAccount {
    CheckingAccount registeredCounterAccount;

    public Transfer makeTransfer(String counterAccount, Money amount) 
        throws BusinessException {
        // 1. Zakładając, że wynik jest 9-cyfrowym numerem konta bankowego, sprawdzenie go przy użyciu algorytmu modulo 11
        int sum = 0; // <1>
        for (int i = 0; i < counterAccount.length(); i++) {
            sum = sum + (9 - i) * Character.getNumericValue(
                counterAccount.charAt(i));
        }
        if (sum % 11 == 0) {
            // 2. Wyszukanie konta docelowego i utworzenie obiektu przelewu
            CheckingAccount acct = Accounts.findAcctByNumber(counterAccount);
            Transfer result = new Transfer(this, acct, amount); // <2>
            // 3. Sprawdzenie, czy przelew następuje na zarejestrowany rachunek bieżący
            if (result.getCounterAccount().equals(this.registeredCounterAccount)) 
            {
                return result;
            } else {
                throw new BusinessException("Konto rozliczeniowe niezarejestrowane!!!");
            }
        } else {
            throw new BusinessException("Nieprawidłowy numer konta!!!");
        }
    }
}
// end::SavingsAccount[]
