package eu.sig.training.r05.boardpanel.v3;

import java.awt.Graphics;
import java.awt.Point;
import java.util.List;

import eu.sig.training.r05.boardpanel.v2.Rectangle;

public class BoardPanel {
    @SuppressWarnings("unused")
    /**
     * Rysuje pojedyncze pole w podanym kontekście graficznym w określonym
     * prostokącie.
     * 
     * @param square
     *            Pole do narysowania.
     * @param g
     *            Kontekst graficzny do rysowania.
     * @param r
     *            Pozycja i wymiary do rysowania pola.
     */
    // tag::render[]
    private void render(Square square, Graphics g, Rectangle r) {
        Point position = r.getPosition();
        square.getSprite().draw(g, r);
        for (Unit unit : square.getOccupants()) {
            unit.getSprite().draw(g, r);
        }
    }
    // end::render[]

    private class Sprite {
        @SuppressWarnings("unused")
        public void draw(Graphics g, Rectangle r) {

        }
    }

    private class Unit {
        public Sprite getSprite() {
            return null;
        }
    }

    private class Square extends Unit {

        public List<Unit> getOccupants() {
            return null;
        }

    }
}
