//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry materiau
//////////////////////////////////////////////////////////////////////
struct MaterialParameters
{
    vec4 ambient;       // wspczynnik odbicia wiata otoczenia; oznaczenie Ma
    vec4 diffuse;       // wspczynnik odbicia wiata rozproszonego; oznaczenie Md
    vec4 specular;      // wspczynnik odbicia wiata zwierciadlanego; oznaczenie Ms
    float shininess;    // wykadnik wspczynnika funkcji rozbysku;
                        // zakres wartoci <0;128>; oznaczenie Msh
};

//////////////////////////////////////////////////////////////////////
// prototypy funkcji
//////////////////////////////////////////////////////////////////////
MaterialParameters GetMaterial( const int material );
vec4 BlinnPhongLight( const int light, const vec3 normal, const vec3 position,
                        const vec4 ambient, const vec4 diffuse,
                        const vec4 specular, const float shininess );
vec4 LambertLight( const int light, const vec3 normal, const vec3 position,
                    const vec4 ambient, const vec4 diffuse );

//////////////////////////////////////////////////////////////////////
// prototyp funkcji zwracajcej mask filtra 3x3
//////////////////////////////////////////////////////////////////////
mat3x3 Filter3x3( const int filter );

//////////////////////////////////////////////////////////////////////
// numer materiau
//////////////////////////////////////////////////////////////////////
uniform int material;

//////////////////////////////////////////////////////////////////////
// tekstura gbokoci z map cienia
//////////////////////////////////////////////////////////////////////
uniform sampler2DShadow shadowTex;

//////////////////////////////////////////////////////////////////////
// interpolowany wektor normalny
//////////////////////////////////////////////////////////////////////
in vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
in vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec4 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

void main()
{
    // normalizacja wektora normalnego zalena od strony wielokta
    vec3 normal = gl_FrontFacing ? normalize( inoutNormal ) : -normalize( inoutNormal );

    // pobranie wybranego materiau
    MaterialParameters mat = GetMaterial( material );

    // kolor owietlonego fragmentu
    vec4 lightColor = BlinnPhongLight( 0, normal, inoutPosition, mat.ambient, mat.diffuse, mat.specular, mat.shininess );

    // kolor fragmentu w cieniu
    vec4 shadowColor = LambertLight( 0, normal, inoutPosition, mat.ambient, mat.diffuse );

    // maska filtra, #define GAUSS_FILTER 5 filtr Gaussa
    mat3x3 filter = Filter3x3( 5 );

    // prbkowanie tekstury cienia
    float shadow = 0.0;
    shadow += dot( vec3( textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1, -1 ) ),
                         textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0, -1 ) ),
                         textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1, -1 ) ) ), filter[0] );
    shadow += dot( vec3( textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1,  0 ) ),
                         textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0,  0 ) ),
                         textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1,  0 ) ) ), filter[1] );
    shadow += dot( vec3( textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1,  1 ) ),
                         textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0,  1 ) ),
                         textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1,  1 ) ) ), filter[2] );

    // kolor fragmentu z cieniem pomnoonym przez kolor cienia
    outColor = mix( 1.5 * shadowColor * vec4( 0.184314f, 0.309804f, 0.309804f, 1.000000f ), lightColor, shadow );
}
