//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();
extern GLfloat tessLevelOuter[3];
extern GLfloat tessLevelInner[1];

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // zewntrzny poziom teselacji
    TESS_LEVEL_OUTER_0_1,
    TESS_LEVEL_OUTER_0_2,
    TESS_LEVEL_OUTER_0_3,
    TESS_LEVEL_OUTER_0_4,
    TESS_LEVEL_OUTER_1_1,
    TESS_LEVEL_OUTER_1_2,
    TESS_LEVEL_OUTER_1_3,
    TESS_LEVEL_OUTER_1_4,
    TESS_LEVEL_OUTER_2_1,
    TESS_LEVEL_OUTER_2_2,
    TESS_LEVEL_OUTER_2_3,
    TESS_LEVEL_OUTER_2_4,

    // wewntrzny poziom teselacji
    TESS_LEVEL_INNER_0_1,
    TESS_LEVEL_INNER_0_2,
    TESS_LEVEL_INNER_0_3,
    TESS_LEVEL_INNER_0_4,

    EXIT // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // zewntrzny poziom teselacji
        case TESS_LEVEL_OUTER_0_1:
        case TESS_LEVEL_OUTER_0_2:
        case TESS_LEVEL_OUTER_0_3:
        case TESS_LEVEL_OUTER_0_4:
            tessLevelOuter[0] = value - TESS_LEVEL_OUTER_0_1 + 1.0f;
            break;
        case TESS_LEVEL_OUTER_1_1:
        case TESS_LEVEL_OUTER_1_2:
        case TESS_LEVEL_OUTER_1_3:
        case TESS_LEVEL_OUTER_1_4:
            tessLevelOuter[1] = value - TESS_LEVEL_OUTER_1_1 + 1.0f;
            break;
        case TESS_LEVEL_OUTER_2_1:
        case TESS_LEVEL_OUTER_2_2:
        case TESS_LEVEL_OUTER_2_3:
        case TESS_LEVEL_OUTER_2_4:
            tessLevelOuter[2] = value - TESS_LEVEL_OUTER_2_1 + 1.0f;
            break;

        // wewntrzny poziom teselacji
        case TESS_LEVEL_INNER_0_1:
        case TESS_LEVEL_INNER_0_2:
        case TESS_LEVEL_INNER_0_3:
        case TESS_LEVEL_INNER_0_4:
            tessLevelInner[0] = value - TESS_LEVEL_INNER_0_1 + 1.0f;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 4, 0 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "Trjkt - teselacja" );
#else
    glutCreateWindow( "Trojkat - teselacja" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_4_0 )
    {
        std::cout << "Brak OpenGL 4.0" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu "gl_TessLevelOuter"
    int menuTessLevelOuter = glutCreateMenu( Menu );
    glutAddMenuEntry( "gl_TessLevelOuter[0] = 1", TESS_LEVEL_OUTER_0_1 );
    glutAddMenuEntry( "gl_TessLevelOuter[0] = 2", TESS_LEVEL_OUTER_0_2 );
    glutAddMenuEntry( "gl_TessLevelOuter[0] = 3", TESS_LEVEL_OUTER_0_3 );
    glutAddMenuEntry( "gl_TessLevelOuter[0] = 4", TESS_LEVEL_OUTER_0_4 );
    glutAddMenuEntry( "-------------------------", -1 );
    glutAddMenuEntry( "gl_TessLevelOuter[1] = 1", TESS_LEVEL_OUTER_1_1 );
    glutAddMenuEntry( "gl_TessLevelOuter[1] = 2", TESS_LEVEL_OUTER_1_2 );
    glutAddMenuEntry( "gl_TessLevelOuter[1] = 3", TESS_LEVEL_OUTER_1_3 );
    glutAddMenuEntry( "gl_TessLevelOuter[1] = 4", TESS_LEVEL_OUTER_1_4 );
    glutAddMenuEntry( "-------------------------", -1 );
    glutAddMenuEntry( "gl_TessLevelOuter[2] = 1", TESS_LEVEL_OUTER_2_1 );
    glutAddMenuEntry( "gl_TessLevelOuter[2] = 2", TESS_LEVEL_OUTER_2_2 );
    glutAddMenuEntry( "gl_TessLevelOuter[2] = 3", TESS_LEVEL_OUTER_2_3 );
    glutAddMenuEntry( "gl_TessLevelOuter[2] = 4", TESS_LEVEL_OUTER_2_4 );

    // utworzenie podmenu "gl_TessLevelInner"
    int menuTessLevelInner = glutCreateMenu( Menu );
    glutAddMenuEntry( "gl_TessLevelInner[0] = 1", TESS_LEVEL_INNER_0_1 );
    glutAddMenuEntry( "gl_TessLevelInner[0] = 2", TESS_LEVEL_INNER_0_2 );
    glutAddMenuEntry( "gl_TessLevelInner[0] = 3", TESS_LEVEL_INNER_0_3 );
    glutAddMenuEntry( "gl_TessLevelInner[0] = 4", TESS_LEVEL_INNER_0_4 );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "gl_TessLevelOuter", menuTessLevelOuter );
    glutAddSubMenu( "gl_TessLevelInner", menuTessLevelInner );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
