//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw w wyjciowym pacie wierzchokw
//////////////////////////////////////////////////////////////////////
layout( vertices = 3 ) out;

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In[];

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} Out[];

//////////////////////////////////////////////////////////////////////
// zmienne wyjciowe okrelone na pat wierzchokw
//////////////////////////////////////////////////////////////////////
patch out vec3 b210;
patch out vec3 b120;
patch out vec3 b021;
patch out vec3 b012;
patch out vec3 b102;
patch out vec3 b201;
patch out vec3 b111;
patch out vec3 n110;
patch out vec3 n011;
patch out vec3 n101;

//////////////////////////////////////////////////////////////////////
// wewntrzny i zewntrzny poziom teselacji
//////////////////////////////////////////////////////////////////////
uniform float tessLevel;

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw trjkta
//////////////////////////////////////////////////////////////////////
#define b300 In[0].position.xyz
#define b030 In[1].position.xyz
#define b003 In[2].position.xyz

//////////////////////////////////////////////////////////////////////
// wsprzdne wektorw normalnych wierzchokw
//////////////////////////////////////////////////////////////////////
#define n200 In[0].normal
#define n020 In[1].normal
#define n002 In[2].normal

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // parametry teselacji zapisywane tylko w pierwszym wywoaniu shadera
    if( gl_InvocationID == 0 )
    {
        gl_TessLevelOuter[0] = tessLevel;
        gl_TessLevelOuter[1] = tessLevel;
        gl_TessLevelOuter[2] = tessLevel;
        gl_TessLevelInner[0] = tessLevel;
    }

    // wsprzdne wierzchoka
    Out[gl_InvocationID].position = In[gl_InvocationID].position;

    // wsprzdne wektora normalnego
    Out[gl_InvocationID].normal = In[gl_InvocationID].normal;

    // obliczenie danych do teselacji (dane stae w obrbie pata wierzchokw)
    if( gl_InvocationID == 0 )
    {
        // wsprzdne punktw kontrolnych (stycznych)
        //
        //         b003
        //          /\
        //         /  \
        //    b102/----\b012
        //       / \  / \
        //  b201/---\/---\b021
        //     / \b1/\11/ \
        //    /___\/__\/___\
        // b300  b210 b120  b030
        //
        b210 = (2.0 * b300 + b030 - dot( b030 - b300, n200 ) * n200) / 3.0;
        b120 = (2.0 * b030 + b300 - dot( b300 - b030, n020 ) * n020) / 3.0;
        b021 = (2.0 * b030 + b003 - dot( b003 - b030, n020 ) * n020) / 3.0;
        b012 = (2.0 * b003 + b030 - dot( b030 - b003, n002 ) * n002) / 3.0;
        b102 = (2.0 * b003 + b300 - dot( b300 - b003, n002 ) * n002) / 3.0;
        b201 = (2.0 * b300 + b003 - dot( b003 - b300, n200 ) * n200) / 3.0;

        // wsprzdne punktu centralnego
        b111 = (b210 + b120 + b021 + b012 + b102 + b201) / 4.0 - (b300 + b030 + b003) / 6.0;

        // obliczenie wsprzdnych wektorw normalnych rodkw krawdzi wierzchokw trjkta
        //
        //      n002
        //       /\
        //      /  \
        // n101/----\n011
        //    / \  / \
        //   /___\/___\
        // n200 n110 n020
        //
        vec3 d0 = b030 - b300;
        vec3 d1 = b003 - b030;
        vec3 d2 = b300 - b003;
        vec3 n0 = n020 + n200;
        vec3 n1 = n002 + n020;
        vec3 n2 = n200 + n002;
        vec3 v0 = (2.0 * dot( d0, n0 ) / dot( d0, d0 )) * d0;
        vec3 v1 = (2.0 * dot( d1, n1 ) / dot( d1, d1 )) * d1;
        vec3 v2 = (2.0 * dot( d2, n2 ) / dot( d2, d2 )) * d2;
        n110 = normalize( n0 - v0 );
        n011 = normalize( n1 - v1 );
        n101 = normalize( n2 - v2 );
    }
}
