//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// parametry teselacji
//////////////////////////////////////////////////////////////////////
layout( quads, equal_spacing, ccw ) in;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// interpolowany wektor normalny
//////////////////////////////////////////////////////////////////////
out vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
out vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wsprzdne liniowe wierzchoka prymitywu
    float u = gl_TessCoord.x;
    float v = gl_TessCoord.y;

    // wektor wartoci parametrw uv powierzchni
    vec2 uv = (1 - u) * (1 - v) * gl_in[0].gl_Position.xy +
              u * (1 - v) * gl_in[1].gl_Position.xy +
              u * v * gl_in[2].gl_Position.xy +
              (1 - u) * v * gl_in[3].gl_Position.xy;

    // obliczenie wsprzdnych punktu powierzchni
    float sinx = sin( uv.x );
    float cosx = cos( uv.x );
    float cosy = cos( uv.y );
    float siny = sin( uv.y );
    vec3 abc = vec3( 1.0 );
    vec4 position = vec4( abc * vec3( sinx * cosy, sinx * siny, cosx ), 1.0 );

    // obliczenie i normalizacja wektora normalnego
    inoutNormal = normalize( position.xyz / abc );

    // obliczenie wsprzdnych tekstury
    inoutTexCoord = vec2( 1.0 - v, u );

    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * position;

    // wsprzdne wierzchoka do interpolacji
    inoutPosition = position.xyz;
}
