//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateZ;
enum
{
    CUBEMAP_MASKONAIVE,
    CUBEMAP_TEIDE,
    CUBEMAP_TENERIFE,
    CUBEMAP_VASA,
    TEXTURE_SIZE
};
extern int texNumber;
extern GLint minFilter;
extern GLint magFilter;
extern GLint textureWrap;
extern GLboolean cubeMapSeamless;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // GL_TEXTURE_MAG_FILTER
    TEXTURE_MAG_FILTER_NEAREST = TEXTURE_SIZE,
    TEXTURE_MAG_FILTER_LINEAR,

    // GL_TEXTURE_MIN_FILTER
    TEXTURE_MIN_FILTER_NEAREST,
    TEXTURE_MIN_FILTER_LINEAR,
    TEXTURE_MIN_FILTER_NEAREST_MIPMAP_NEAREST,
    TEXTURE_MIN_FILTER_LINEAR_MIPMAP_NEAREST,
    TEXTURE_MIN_FILTER_NEAREST_MIPMAP_LINEAR,
    TEXTURE_MIN_FILTER_LINEAR_MIPMAP_LINEAR,

    // GL_TEXTURE_WRAP_S/T/R
    TEXTURE_WRAP_S_T_R_REPEAT,
    TEXTURE_WRAP_S_T_R_CLAMP_TO_BORDER,
    TEXTURE_WRAP_S_T_R_MIRRORED_REPEAT,
    TEXTURE_WRAP_S_T_R_CLAMP_TO_EDGE,
    TEXTURE_WRAP_S_T_R_MIRROR_CLAMP_TO_EDGE,

    // GL_TEXTURE_CUBE_MAP_SEAMLESS
    TEXTURE_CUBE_MAP_SEAMLESS_FALSE,
    TEXTURE_CUBE_MAP_SEAMLESS_TRUE,

    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // rodzaj tekstury
        case CUBEMAP_MASKONAIVE:
        case CUBEMAP_TEIDE:
        case CUBEMAP_TENERIFE:
        case CUBEMAP_VASA:
            texNumber = value;
            break;

        // GL_TEXTURE_MAG_FILTER
        case TEXTURE_MAG_FILTER_NEAREST:
            magFilter = GL_NEAREST;
            break;
        case TEXTURE_MAG_FILTER_LINEAR:
            magFilter = GL_LINEAR;
            break;

        // GL_TEXTURE_MIN_FILTER
        case TEXTURE_MIN_FILTER_NEAREST:
            minFilter = GL_NEAREST;
            break;
        case TEXTURE_MIN_FILTER_LINEAR:
            minFilter = GL_LINEAR;
            break;
        case TEXTURE_MIN_FILTER_NEAREST_MIPMAP_NEAREST:
            minFilter = GL_NEAREST_MIPMAP_NEAREST;
            break;
        case TEXTURE_MIN_FILTER_LINEAR_MIPMAP_NEAREST:
            minFilter = GL_LINEAR_MIPMAP_NEAREST;
            break;
        case TEXTURE_MIN_FILTER_NEAREST_MIPMAP_LINEAR:
            minFilter = GL_NEAREST_MIPMAP_LINEAR;
            break;
        case TEXTURE_MIN_FILTER_LINEAR_MIPMAP_LINEAR:
            minFilter = GL_LINEAR_MIPMAP_LINEAR;
            break;

        // GL_TEXTURE_WRAP_S/T/R
        case TEXTURE_WRAP_S_T_R_REPEAT:
            textureWrap = GL_REPEAT;
            break;
        case TEXTURE_WRAP_S_T_R_CLAMP_TO_BORDER:
            textureWrap = GL_CLAMP_TO_BORDER;
            break;
        case TEXTURE_WRAP_S_T_R_MIRRORED_REPEAT:
            textureWrap = GL_MIRRORED_REPEAT;
            break;
        case TEXTURE_WRAP_S_T_R_CLAMP_TO_EDGE:
            textureWrap = GL_CLAMP_TO_EDGE;
            break;
        case TEXTURE_WRAP_S_T_R_MIRROR_CLAMP_TO_EDGE:
            textureWrap = GL_MIRROR_CLAMP_TO_EDGE;
            break;

        // GL_TEXTURE_CUBE_MAP_SEAMLESS
        case TEXTURE_CUBE_MAP_SEAMLESS_FALSE:
            cubeMapSeamless = GL_FALSE;
            break;
        case TEXTURE_CUBE_MAP_SEAMLESS_TRUE:
            cubeMapSeamless = GL_TRUE;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // 1
        case '1':
            texNumber = CUBEMAP_MASKONAIVE;
            break;
        // 2
        case '2':
            texNumber = CUBEMAP_TEIDE;
            break;
        // 3
        case '3':
            texNumber = CUBEMAP_TENERIFE;
            break;
        // 4
        case '4':
            texNumber = CUBEMAP_VASA;
            break;
        // a
        case 'A':
        case 'a':
            translateX += 0.1f;
            break;
        // w
        case 'W':
        case 'w':
            translateZ += 0.1f;
            break;
        // s
        case 'S':
        case 's':
            translateZ -= 0.1f;
            break;
        // d
        case 'D':
        case 'd':
            translateX -= 0.1f;
            break;
        // z
        case 'Z':
        case 'z':
            cubeMapSeamless = !cubeMapSeamless;
            break;
        // x
        case 'X':
        case 'x':
            if( magFilter == GL_NEAREST )
                magFilter = GL_LINEAR;
            else
                magFilter = GL_NEAREST;
            break;
        // c
        case 'C':
        case 'c':
            switch( minFilter )
            {
                case GL_NEAREST: minFilter = GL_LINEAR; break;
                case GL_LINEAR: minFilter = GL_NEAREST_MIPMAP_NEAREST; break;
                case GL_NEAREST_MIPMAP_NEAREST: minFilter = GL_LINEAR_MIPMAP_NEAREST; break;
                case GL_LINEAR_MIPMAP_NEAREST: minFilter = GL_NEAREST_MIPMAP_LINEAR; break;
                case GL_NEAREST_MIPMAP_LINEAR: minFilter = GL_LINEAR_MIPMAP_LINEAR; break;
                case GL_LINEAR_MIPMAP_LINEAR: minFilter = GL_NEAREST; break;
            }
            break;
        // v
        case 'V':
        case 'v':
            switch( textureWrap )
            {
                case GL_REPEAT: textureWrap = GL_CLAMP_TO_BORDER; break;
                case GL_CLAMP_TO_BORDER: textureWrap = GL_MIRRORED_REPEAT; break;
                case GL_MIRRORED_REPEAT: textureWrap = GL_CLAMP_TO_EDGE; break;
                case GL_CLAMP_TO_EDGE: textureWrap = GL_MIRROR_CLAMP_TO_EDGE; break;
                case GL_MIRROR_CLAMP_TO_EDGE: textureWrap = GL_REPEAT; break;
            }
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
    glutCreateWindow( "Skybox" );

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - GL_TEXTURE_MAG_FILTER
    int menuMagFilter = glutCreateMenu( Menu );
    glutAddMenuEntry( "GL_NEAREST", TEXTURE_MAG_FILTER_NEAREST );
    glutAddMenuEntry( "GL_LINEAR", TEXTURE_MAG_FILTER_LINEAR );

    // utworzenie podmenu - GL_TEXTURE_MIN_FILTER
    int menuMinFilter = glutCreateMenu( Menu );
    glutAddMenuEntry( "GL_NEAREST", TEXTURE_MIN_FILTER_NEAREST );
    glutAddMenuEntry( "GL_LINEAR", TEXTURE_MIN_FILTER_LINEAR );
    glutAddMenuEntry( "GL_NEAREST_MIPMAP_NEAREST", TEXTURE_MIN_FILTER_NEAREST_MIPMAP_NEAREST );
    glutAddMenuEntry( "GL_LINEAR_MIPMAP_NEAREST", TEXTURE_MIN_FILTER_LINEAR_MIPMAP_NEAREST );
    glutAddMenuEntry( "GL_NEAREST_MIPMAP_LINEAR",TEXTURE_MIN_FILTER_NEAREST_MIPMAP_LINEAR  );
    glutAddMenuEntry( "GL_LINEAR_MIPMAP_LINEAR", TEXTURE_MIN_FILTER_LINEAR_MIPMAP_LINEAR );

    // utworzenie podmenu - GL_TEXTURE_WRAP_S/T/R
    int menuTextureWrap = glutCreateMenu( Menu );
    glutAddMenuEntry( "GL_REPEAT", TEXTURE_WRAP_S_T_R_REPEAT );
    glutAddMenuEntry( "GL_CLAMP_TO_BORDER", TEXTURE_WRAP_S_T_R_CLAMP_TO_BORDER );
    glutAddMenuEntry( "GL_MIRRORED_REPEAT", TEXTURE_WRAP_S_T_R_MIRRORED_REPEAT );
    glutAddMenuEntry( "GL_CLAMP_TO_EDGE", TEXTURE_WRAP_S_T_R_CLAMP_TO_EDGE );
    glutAddMenuEntry( "GL_MIRROR_CLAMP_TO_EDGE", TEXTURE_WRAP_S_T_R_MIRROR_CLAMP_TO_EDGE );

    // utworzenie podmenu - GL_TEXTURE_CUBE_MAP_SEAMLESS
    int menuTextureSemaless = glutCreateMenu( Menu );
    glutAddMenuEntry( "GL_FALSE", TEXTURE_CUBE_MAP_SEAMLESS_FALSE );
    glutAddMenuEntry( "GL_TRUE", TEXTURE_CUBE_MAP_SEAMLESS_TRUE );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddMenuEntry( "Tekstura: Maskonaive", CUBEMAP_MASKONAIVE );
    glutAddMenuEntry( "Tekstura: Teide", CUBEMAP_TEIDE );
    glutAddMenuEntry( "Tekstura: Tenerife", CUBEMAP_TENERIFE );
    glutAddMenuEntry( "Tekstura: Vasa", CUBEMAP_VASA );
    glutAddSubMenu( "GL_TEXTURE_MAG_FILTER", menuMagFilter );
    glutAddSubMenu( "GL_TEXTURE_MIN_FILTER", menuMinFilter );
    glutAddSubMenu( "GL_TEXTURE_WRAP_S/T/R", menuTextureWrap );
    glutAddSubMenu( "GL_TEXTURE_CUBE_MAP_SEAMLESS", menuTextureSemaless );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
