//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#ifndef __TEXTURES__H__
#define __TEXTURES__H__

#include <GL/glew.h>

//////////////////////////////////////////////////////////////////////
// zaadowanie tekstury z pliku graficznego
// fileName - nazwa pliku graficznego z tekstur
// target - rodzaj tworzonej tekstury
// level - poziom tworzonego obrazu tekstury, domylna warto 0
//////////////////////////////////////////////////////////////////////
bool LoadTexture( const char *fileName, GLenum target, GLint level = 0 );

//////////////////////////////////////////////////////////////////////
// zaadowanie tablicy tekstur z plikw graficznych
// fileNames - nazwy plikw graficznych z teksturami
// target - rodzaj tworzonej tekstury
// layers - liczba warstw tekstury
//////////////////////////////////////////////////////////////////////
bool LoadTextures( const char **fileNames, GLenum target, GLint layers );

//////////////////////////////////////////////////////////////////////
// zapis tekstury szeciennej do plikw graficznych w formacie PNG
// fileNames - nazwy plikw graficznych z teksturami
// level - poziom zapisywanych obrazw tekstury, domylna warto 0
//////////////////////////////////////////////////////////////////////
bool SaveCubeTexture( const char **fileNames, GLint level = 0 );

#endif // __TEXTURES__H__
