//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// iloczyny macierzy modelu-widoku i macierzy rzutowania
// dla poszczeglnych paszczyzn rzutowania cienia
//////////////////////////////////////////////////////////////////////
uniform mat4 wallPlanesModelViewProjectionMatrix[5];

//////////////////////////////////////////////////////////////////////
// macierz modelu-widoku obiektu rzucajcego cie
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewMatrix;

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy, liczba wywoa shadera
//////////////////////////////////////////////////////////////////////
layout( triangles, invocations = 5 ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy
//////////////////////////////////////////////////////////////////////
layout( triangle_strip, max_vertices = 3 ) out;

//////////////////////////////////////////////////////////////////////
// wspczynniki rwna paszczyzn obcinania
//////////////////////////////////////////////////////////////////////
uniform vec4 clipPlane[5];

//////////////////////////////////////////////////////////////////////
// tablica z odlegociami od paszczyzn obcinania
//////////////////////////////////////////////////////////////////////
out float gl_ClipDistance[5];

void main ()
{
    // generowanie kolejnych wierzchokw prymitywu nalecych
    // do biecej paszczyzny rzutowania cienia; kade kolejne
    // wywoanie shadera okrela odrbn paszczyzn rzutowania
    for( int v = 0; v < gl_in.length(); v++ )
    {
        // wsprzdne wierzchoka cienia
        gl_Position = wallPlanesModelViewProjectionMatrix[gl_InvocationID] * gl_in[v].gl_Position;

        // obliczenie odlegoci wierzchoka obiektu
        // rzucajcego cie od paszczyzn obcinania
        vec4 position = modelViewMatrix * gl_in[v].gl_Position;
        for( int c = 0; c < 5; c++ )
        {
            gl_ClipDistance[c] = dot( clipPlane[c], position );
        }

        // emisja wierzchoka
        EmitVertex();
    }

    // koniec prymitywu
    EndPrimitive();
}
