//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLboolean lerp;

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // mieszanie tekseli
    LERP_ON,
    LERP_OFF,

    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // mieszanie tekseli
        case LERP_ON:
            lerp = GL_TRUE;
            break;
        case LERP_OFF:
            lerp = GL_FALSE;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // l,L
        case 'L':
        case 'l':
            lerp = !lerp;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
    glutCreateWindow( "Tablica tekstur 2D" );

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - Mieszanie tekseli
    int menuLerp = glutCreateMenu( Menu );
    glutAddMenuEntry( "wlaczone", LERP_ON );
    glutAddMenuEntry( "wylaczone", LERP_OFF );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "Mieszanie tekseli", menuLerp );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
