//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry rda wiata
//////////////////////////////////////////////////////////////////////
struct LightSourceParameters
{
    vec4 ambient;               // intensywno wiata otoczenia; oznaczenie La
    vec4 diffuse;               // intensywno wiata rozproszonego; oznaczenie Ld
    vec4 specular;              // intensywno wiata zwierciadlanego; oznaczenie Ls
    vec4 position;              // pooenie rda wiata punktowego (position.w = 1.0)
                                // lub wektor kierunku wiata kierunkowego, skierowany
                                // do rda wiata (position.w = 0.0)
    float constantAttenuation;  // stay wspczynnik tumienia wiata; oznaczenie kc
    float linearAttenuation;    // liniowy wspczynnik tumienia wiata; oznaczenie kl
    float quadraticAttenuation; // kwadratowy wspczynnik tumienia wiata; oznaczenie kq
};

//////////////////////////////////////////////////////////////////////
// maksymalna liczba rde wiata
//////////////////////////////////////////////////////////////////////
const int maxLights = 4;

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry modelu owietlenia
//////////////////////////////////////////////////////////////////////
struct LightModelParameters
{
    vec4 ambient;   // globalne wiato otoczenia; oznaczenie Ga
};

//////////////////////////////////////////////////////////////////////
// parametry rde wiata, modelu owietlenia i pooenia obserwatora
//////////////////////////////////////////////////////////////////////
layout( shared ) uniform LightModel
{
    // tablica z parametrami poszczeglnych rde wiata
    LightSourceParameters lightSource[maxLights];

    // parametry modelu owietlenia
    LightModelParameters lightModel;

    // wsprzdne pooenia obserwatora
    vec4 eyePosition;
};

//////////////////////////////////////////////////////////////////////
// pobranie parametrw wybranego rda wiata
//////////////////////////////////////////////////////////////////////
LightSourceParameters LightSource( const int light )
{
    return lightSource[light];
}

//////////////////////////////////////////////////////////////////////
// pobranie pooenia obserwatora
//////////////////////////////////////////////////////////////////////
vec4 EyePosition()
{
    return eyePosition;
}

//////////////////////////////////////////////////////////////////////
// globalne wiato otoczenia
// ambient - wspczynnik odbicia wiata otoczenia; oznaczenie Ma
//////////////////////////////////////////////////////////////////////
vec4 GlobalAmbientLight( const vec4 ambient )
{
    return lightModel.ambient * ambient;
}

//////////////////////////////////////////////////////////////////////
// lokalne wiato otoczenia
// light - numer rda wiata
// ambient - wspczynnik odbicia wiata otoczenia; oznaczenie Ma
//////////////////////////////////////////////////////////////////////
vec4 LocalAmbientLight( const int light, const vec4 ambient )
{
    return lightSource[light].ambient * ambient;
}
