//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.10
//////////////////////////////////////////////////////////////////////
#version 410

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw prymitywu wejciowego i wyjciowego
//////////////////////////////////////////////////////////////////////
#define MAX_VERTICES 3

//////////////////////////////////////////////////////////////////////
// liczba warstw renderingu
//////////////////////////////////////////////////////////////////////
#define FRAME_LAYERS 16

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy, liczba wywoa shadera
//////////////////////////////////////////////////////////////////////
layout( triangles, invocations = FRAME_LAYERS ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy
//////////////////////////////////////////////////////////////////////
layout( triangle_strip, max_vertices = MAX_VERTICES ) out;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix[FRAME_LAYERS];

//////////////////////////////////////////////////////////////////////
// tablica blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // numer materiau
    int material;
} In[MAX_VERTICES];

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // numer materiau
    flat int material;
} Out;

void main ()
{
    // numer kolejnej warstwy = numer wywoania shadera
    gl_Layer = gl_InvocationID;

    // generowanie kolejnych wierzchokw prymitywu
    for( int v = 0; v < gl_in.length(); v++ )
    {
        // standardowe przeksztacenie wsprzdnych wierzchokw
        gl_Position = modelViewProjectionMatrix[gl_InvocationID] * In[v].position;

        // warstwa obszaru renderingu
        gl_ViewportIndex = 1;

        // atrybuty wierzchoka
        Out.position = In[v].position.xyz;
        Out.normal = In[v].normal;
        Out.material = In[v].material;
        EmitVertex();
    }

    // koniec prymitywu
    EndPrimitive();
}
