//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// uchwyt tekstury 3D
//////////////////////////////////////////////////////////////////////
uniform sampler3D tex;

//////////////////////////////////////////////////////////////////////
// warto referencyjna skadowej alfa fragmentu uywana do usuwania
// fragmentw z potoku renderingu
//////////////////////////////////////////////////////////////////////
uniform float refAlpha;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec3 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // prbkowanie tekstury w formacie GL_RED
    float color = texture( tex, inoutTexCoord ).r;

    // test skadowej alfa
    if( color > refAlpha )
        outColor = vec4( color );
    else
        discard;
}
