//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <cstdlib>
#include <iostream>
#include <fstream>
#include "shaders.h"

//////////////////////////////////////////////////////////////////////
// zaadowanie kodu rdowego shadera z pliku i jego kompilacja,
// rodzaj shadera okrela parametr type; funkcja zwraca identyfikator
// obiektu shadera ze skompilowanym shaderem
//////////////////////////////////////////////////////////////////////
GLuint LoadShader( const GLenum type, const char *name )
{
    // odczyt kodu shadera do bufora
    std::ifstream file;
    file.open( name, std::ios::binary );

    // sprawdzenie poprawnoci odczytu pliku
    if( file.bad() )
    {
        std::cout << "Niepoprawny odczyt pliku shadera " << name << std::endl;
        exit( 0 );
    }

    // sprawdzenie dugoci pliku
    file.seekg( 0, std::ios::end );
    int len = static_cast<int>( file.tellg() );
    if( len <= 0 )
    {
        std::cout << "Niepoprawny odczyt pliku shadera " << name << std::endl;
        exit( 0 );
    }

    // waciwy odczyt pliku
    file.seekg( 0, std::ios::beg );
    GLchar *srcBuf = new GLchar[(len + 1) * sizeof( GLchar )];
    file.read( srcBuf, len );
    srcBuf[len] = '\0';
    file.close();

    // utworzenie obiektu shadera
    GLuint shader = glCreateShader( type );

    // zaadowanie kodu do obiektu shadera
    glShaderSource( shader, 1, const_cast<const GLchar**>( &srcBuf ), NULL );

    // porzdki
    delete[] srcBuf;

    // kompilacja shadera
    glCompileShader( shader );

    // sprawdzenie statusu kompilacji shadera
    GLint status;
    glGetShaderiv( shader, GL_COMPILE_STATUS, &status );
    if( status != GL_TRUE )
    {
        std::cout << "Niepoprawna kompilacja shadera " << name << std::endl;

        // pobranie i wywietlenie komunikatu bdu
        GLint logLength;
        glGetShaderiv( shader, GL_INFO_LOG_LENGTH, &logLength );
        char *log = new char[logLength];
        glGetShaderInfoLog( shader, logLength, NULL, log );
        std::cout << log << std::endl;
        delete[] log;
        exit( 0 );
    }

    // zwrcenie identyfikatora obiektu shadera
    return shader;
}

//////////////////////////////////////////////////////////////////////
// konsolidacja i walidacja obiektu programu
//////////////////////////////////////////////////////////////////////
void LinkValidateProgram( GLuint program )
{
    // konsolidacja shaderw
    glLinkProgram( program );

    // sprawdzenie poprawnoci konsolidacji obiektu programu
    GLint status;
    glGetProgramiv( program, GL_LINK_STATUS, &status );
    if( status == GL_FALSE )
    {
        std::cout << "Niepoprawna konsolidacja programu" << std::endl;

        // pobranie i wywietlenie komunikatu bdu
        GLint logLength;
        glGetProgramiv( program, GL_INFO_LOG_LENGTH, &logLength );
        char *log = new char[logLength];
        glGetProgramInfoLog( program, logLength, NULL, log );
        std::cout << log << std::endl;
        delete[] log;
        exit( 0 );
    }

    // walidacja shaderw
    glValidateProgram( program );

    // sprawdzenie poprawnoci walidacji obiektu programu
    glGetProgramiv( program, GL_VALIDATE_STATUS, &status );
    if( status == GL_FALSE )
    {
        std::cout << "Niepoprawna walidacja programu" << std::endl;

        // pobranie i wywietlenie komunikatu bdu
        GLint logLength;
        glGetProgramiv( program, GL_INFO_LOG_LENGTH, &logLength );
        char *log = new char[logLength];
        glGetProgramInfoLog( program, logLength, NULL, log );
        std::cout << log << std::endl;
        delete[] log;
        exit( 0 );
    }
}
