//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#ifndef __GLENUM_MAP__H__
#define __GLENUM_MAP__H__

#include <GL/glew.h>
#include <GL/glext.h>
#include <map>

//////////////////////////////////////////////////////////////////////
// rozszerzenia OpenGL ES
//////////////////////////////////////////////////////////////////////
#define GL_APIENTRY
#define GL_EXT_texture_storage
#define GL_EXT_geometry_shader
#define GL_EXT_texture_border_clamp
#define GL_EXT_texture_buffer
#define GL_EXT_multisampled_render_to_texture
#define GL_EXT_disjoint_timer_query
#include <GLES2/gl2ext.h>

//////////////////////////////////////////////////////////////////////
// mapa z numerem staej OpenGL i jej nazw
//////////////////////////////////////////////////////////////////////
typedef std::map< GLenum, std::string > GLenumMapType;

//////////////////////////////////////////////////////////////////////
// tablica z formatami tekstur i ich nazwami oraz wybranymi
// innymi staymi OpenGL
//////////////////////////////////////////////////////////////////////
const GLenumMapType::value_type GLenumMapData[] = 
{
    // formaty rozszerzenia GL_ARB_texture_compression_rgtc/GL_EXT_texture_compression_rgtc
    GLenumMapType::value_type( GL_COMPRESSED_RED_RGTC1, "GL_COMPRESSED_RED_RGTC1" ),
    GLenumMapType::value_type( GL_COMPRESSED_SIGNED_RED_RGTC1, "GL_COMPRESSED_SIGNED_RED_RGTC1" ),
    GLenumMapType::value_type( GL_COMPRESSED_RG_RGTC2, "GL_COMPRESSED_RG_RGTC2" ),
    GLenumMapType::value_type( GL_COMPRESSED_SIGNED_RG_RGTC2, "GL_COMPRESSED_SIGNED_RG_RGTC2" ),

    // formaty rozszerzenia GL_ARB_texture_compression_bptc
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_BPTC_UNORM, "GL_COMPRESSED_RGBA_BPTC_UNORM" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM, "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT, "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT, "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT" ),

    // formaty rozszerzenia GL_EXT_texture_compression_s3tc, GL_EXT_texture_sRGB
    GLenumMapType::value_type( GL_COMPRESSED_RGB_S3TC_DXT1_EXT, "GL_COMPRESSED_RGB_S3TC_DXT1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_S3TC_DXT1_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_S3TC_DXT3_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_S3TC_DXT5_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_S3TC_DXT1_EXT, "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT" ),

    // formaty rozszerzenia GL_3DFX_texture_compression_FXT1
    GLenumMapType::value_type( GL_COMPRESSED_RGB_FXT1_3DFX, "GL_COMPRESSED_RGB_FXT1_3DFX" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_FXT1_3DFX, "GL_COMPRESSED_RGBA_FXT1_3DFX" ),

    // formaty rozszerzenia GL_EXT_texture_compression_latc
    GLenumMapType::value_type( GL_COMPRESSED_LUMINANCE_LATC1_EXT, "GL_COMPRESSED_LUMINANCE_LATC1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT, "GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT, "GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT, "GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT" ),

    // format rozszerzenia GL_ATI_texture_compression_3dc (nie wystpuje w pliku glext.h)
    GLenumMapType::value_type( GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI, "GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI" ),

    // formaty rozszerzenia GL_ARB_ES3_compatibility
    GLenumMapType::value_type( GL_COMPRESSED_RGB8_ETC2, "GL_COMPRESSED_RGB8_ETC2" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ETC2, "GL_COMPRESSED_SRGB8_ETC2" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2, "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2, "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA8_ETC2_EAC, "GL_COMPRESSED_RGBA8_ETC2_EAC" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC, "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC" ),
    GLenumMapType::value_type( GL_COMPRESSED_R11_EAC, "GL_COMPRESSED_R11_EAC" ),
    GLenumMapType::value_type( GL_COMPRESSED_SIGNED_R11_EAC, "GL_COMPRESSED_SIGNED_R11_EAC" ),
    GLenumMapType::value_type( GL_COMPRESSED_RG11_EAC, "GL_COMPRESSED_RG11_EAC" ),
    GLenumMapType::value_type( GL_COMPRESSED_SIGNED_RG11_EAC, "GL_COMPRESSED_SIGNED_RG11_EAC" ),

    // formaty rozszerzenia GL_OES_compressed_ETC1_RGB8_texture
    GLenumMapType::value_type( GL_ETC1_RGB8_OES, "GL_ETC1_RGB8_OES" ),

    // formaty rozszerzenia GL_OES_compressed_paletted_texture
    GLenumMapType::value_type( GL_PALETTE4_RGB8_OES, "GL_PALETTE4_RGB8_OES" ),
    GLenumMapType::value_type( GL_PALETTE4_RGBA8_OES, "GL_PALETTE4_RGBA8_OES" ),
    GLenumMapType::value_type( GL_PALETTE4_R5_G6_B5_OES, "GL_PALETTE4_R5_G6_B5_OES" ),
    GLenumMapType::value_type( GL_PALETTE4_RGBA4_OES, "GL_PALETTE4_RGBA4_OES" ),
    GLenumMapType::value_type( GL_PALETTE4_RGB5_A1_OES, "GL_PALETTE4_RGB5_A1_OES" ),
    GLenumMapType::value_type( GL_PALETTE8_RGB8_OES, "GL_PALETTE8_RGB8_OES" ),
    GLenumMapType::value_type( GL_PALETTE8_RGBA8_OES, "GL_PALETTE8_RGBA8_OES" ),
    GLenumMapType::value_type( GL_PALETTE8_R5_G6_B5_OES, "GL_PALETTE8_R5_G6_B5_OES" ),
    GLenumMapType::value_type( GL_PALETTE8_RGBA4_OES, "GL_PALETTE8_RGBA4_OES" ),
    GLenumMapType::value_type( GL_PALETTE8_RGB5_A1_OES, "GL_PALETTE8_RGB5_A1_OES" ),

    // formaty rozszerzenia GL_KHR_texture_compression_astc_ldr
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_4x4_KHR, "GL_COMPRESSED_RGBA_ASTC_4x4_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_5x4_KHR, "GL_COMPRESSED_RGBA_ASTC_5x4_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_5x5_KHR, "GL_COMPRESSED_RGBA_ASTC_5x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_6x5_KHR, "GL_COMPRESSED_RGBA_ASTC_6x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_6x6_KHR, "GL_COMPRESSED_RGBA_ASTC_6x6_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_8x5_KHR, "GL_COMPRESSED_RGBA_ASTC_8x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_8x6_KHR, "GL_COMPRESSED_RGBA_ASTC_8x6_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_8x8_KHR, "GL_COMPRESSED_RGBA_ASTC_8x8_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_10x5_KHR, "GL_COMPRESSED_RGBA_ASTC_10x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_10x6_KHR, "GL_COMPRESSED_RGBA_ASTC_10x6_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_10x8_KHR, "GL_COMPRESSED_RGBA_ASTC_10x8_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_10x10_KHR, "GL_COMPRESSED_RGBA_ASTC_10x10_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_12x10_KHR, "GL_COMPRESSED_RGBA_ASTC_12x10_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_12x12_KHR, "GL_COMPRESSED_RGBA_ASTC_12x12_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR" ),

    // formaty rozszerzenia GL_OES_texture_compression_astc
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_3x3x3_OES, "GL_COMPRESSED_RGBA_ASTC_3x3x3_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_4x3x3_OES, "GL_COMPRESSED_RGBA_ASTC_4x3x3_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_4x4x3_OES, "GL_COMPRESSED_RGBA_ASTC_4x4x3_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_4x4x4_OES, "GL_COMPRESSED_RGBA_ASTC_4x4x4_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_5x4x4_OES, "GL_COMPRESSED_RGBA_ASTC_5x4x4_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_5x5x4_OES, "GL_COMPRESSED_RGBA_ASTC_5x5x4_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_5x5x5_OES, "GL_COMPRESSED_RGBA_ASTC_5x5x5_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_6x5x5_OES, "GL_COMPRESSED_RGBA_ASTC_6x5x5_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_6x6x5_OES, "GL_COMPRESSED_RGBA_ASTC_6x6x5_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_ASTC_6x6x6_OES, "GL_COMPRESSED_RGBA_ASTC_6x6x6_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES" ),

    // formaty rozszerzenia GL_IMG_texture_compression_pvrtc
    GLenumMapType::value_type( GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG, "GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG, "GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG, "GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG, "GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG" ),

    // formaty rozszerzenia GL_IMG_texture_compression_pvrtc2
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG, "GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG" ),
    GLenumMapType::value_type( GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG, "GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG" ),

    // formaty rozszerzenia GL_AMD_compressed_3DC_texture
    GLenumMapType::value_type( GL_3DC_X_AMD, "GL_3DC_X_AMD" ),
    GLenumMapType::value_type( GL_3DC_XY_AMD, "GL_3DC_XY_AMD" ),

    // formaty rozszerzenia GL_AMD_compressed_ATC_texture
    GLenumMapType::value_type( GL_ATC_RGB_AMD, "GL_ATC_RGB_AMD" ),
    GLenumMapType::value_type( GL_ATC_RGBA_EXPLICIT_ALPHA_AMD, "GL_ATC_RGBA_EXPLICIT_ALPHA_AMD" ),
    GLenumMapType::value_type( GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD, "GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD" ),

    // formaty rozszerzenia GL_EXT_pvrtc_sRGB
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT, "GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT, "GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG" ),
    GLenumMapType::value_type( GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG, "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG" ),

    // pozostae
    GLenumMapType::value_type( GL_EXTENSIONS, "GL_EXTENSIONS" ),
    GLenumMapType::value_type( GL_SHADING_LANGUAGE_VERSION, "GL_SHADING_LANGUAGE_VERSION" )
};

//////////////////////////////////////////////////////////////////////
// mapa z numerem staej OpenGL i jej nazw
//////////////////////////////////////////////////////////////////////
GLenumMapType GLenumMap( GLenumMapData, GLenumMapData + sizeof( GLenumMapData ) / sizeof( GLenumMapData[0] ) );

#endif // __GLENUM_MAP__H__
