//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.10
//////////////////////////////////////////////////////////////////////
#version 410

//////////////////////////////////////////////////////////////////////
// liczba warstw renderingu
//////////////////////////////////////////////////////////////////////
#define FRAME_LAYERS 6

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw prymitywu wejciowego i wyjciowego
//////////////////////////////////////////////////////////////////////
#define MAX_VERTICES 3

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy, liczba wywoa shadera
//////////////////////////////////////////////////////////////////////
layout( triangles, invocations = FRAME_LAYERS ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy
//////////////////////////////////////////////////////////////////////
layout( triangle_strip, max_vertices = MAX_VERTICES ) out;

//////////////////////////////////////////////////////////////////////
// iloczyny macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix[FRAME_LAYERS];

//////////////////////////////////////////////////////////////////////
// blok zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne tekstury
    vec3 texCoord;
} In[MAX_VERTICES];

//////////////////////////////////////////////////////////////////////
// wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec3 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main ()
{
    // numer kolejnej warstwy = numer wywoania shadera
    gl_Layer = gl_InvocationID;

    // generowanie kolejnych wierzchokw prymitywu
    for( int v = 0; v < gl_in.length(); v++ )
    {
        // standardowe przeksztacenie wsprzdnych wierzchokw
        gl_Position = modelViewProjectionMatrix[gl_InvocationID] * gl_in[v].gl_Position;

        // wsprzdne tekstury do interpolacji
        inoutTexCoord = In[v].texCoord;

        // numer obszaru renderingu
        gl_ViewportIndex = 1;

        // emisja wierzchoka
        EmitVertex();
    }

    // koniec prymitywu
    EndPrimitive();
}
