//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// maska filtra Gaussa
// http://www.packtpub.com/sites/default/files/9781849695046_Chapter_04.pdf?utm_source=packtpub&utm_medium=free&utm_campaign=pdf
//////////////////////////////////////////////////////////////////////
const float Gauss21[21] = float[21]
(
    0.000272337, 0.00089296, 0.002583865,
    0.00659813, 0.014869116, 0.029570767,
    0.051898313, 0.080381679, 0.109868729,
    0.132526984, 0.14107424, 0.132526984,
    0.109868729, 0.080381679, 0.051898313,
    0.029570767, 0.014869116, 0.00659813,
    0.002583865, 0.00089296, 0.000272337
);

//////////////////////////////////////////////////////////////////////
// tekstura 2D
//////////////////////////////////////////////////////////////////////
uniform sampler2D tex;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec2 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // pocztkowy kolor fragmentu
    outColor = vec2( 0.0 );

    // nakadanie maski filtra
    outColor += Gauss21[ 0] * textureOffset( tex, inoutTexCoord, ivec2( 0, -10 ) ).rg;
    outColor += Gauss21[ 1] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -9 ) ).rg;
    outColor += Gauss21[ 2] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -8 ) ).rg;
    outColor += Gauss21[ 3] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -7 ) ).rg;
    outColor += Gauss21[ 4] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -6 ) ).rg;
    outColor += Gauss21[ 5] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -5 ) ).rg;
    outColor += Gauss21[ 6] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -4 ) ).rg;
    outColor += Gauss21[ 7] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -3 ) ).rg;
    outColor += Gauss21[ 8] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -2 ) ).rg;
    outColor += Gauss21[ 9] * textureOffset( tex, inoutTexCoord, ivec2( 0,  -1 ) ).rg;
    outColor += Gauss21[10] * textureOffset( tex, inoutTexCoord, ivec2( 0,   0 ) ).rg;
    outColor += Gauss21[11] * textureOffset( tex, inoutTexCoord, ivec2( 0,   1 ) ).rg;
    outColor += Gauss21[12] * textureOffset( tex, inoutTexCoord, ivec2( 0,   2 ) ).rg;
    outColor += Gauss21[13] * textureOffset( tex, inoutTexCoord, ivec2( 0,   3 ) ).rg;
    outColor += Gauss21[14] * textureOffset( tex, inoutTexCoord, ivec2( 0,   4 ) ).rg;
    outColor += Gauss21[15] * textureOffset( tex, inoutTexCoord, ivec2( 0,   5 ) ).rg;
    outColor += Gauss21[16] * textureOffset( tex, inoutTexCoord, ivec2( 0,   6 ) ).rg;
    outColor += Gauss21[17] * textureOffset( tex, inoutTexCoord, ivec2( 0,   7 ) ).rg;
    outColor += Gauss21[18] * textureOffset( tex, inoutTexCoord, ivec2( 0,   8 ) ).rg;
    outColor += Gauss21[19] * textureOffset( tex, inoutTexCoord, ivec2( 0,   9 ) ).rg;
    outColor += Gauss21[20] * textureOffset( tex, inoutTexCoord, ivec2( 0,  10 ) ).rg;
}
