//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.20
//////////////////////////////////////////////////////////////////////
#version 420

//////////////////////////////////////////////////////////////////////
// uchwyt tablicy tekstur 2D
//////////////////////////////////////////////////////////////////////
uniform sampler2DArray tex;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 texCoord;

//////////////////////////////////////////////////////////////////////
// numer tekstury patka niegu
//////////////////////////////////////////////////////////////////////
flat in float snowFlake;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

void main()
{
    // prbkowanie tekstury
    vec4 color = texture( tex, vec3( texCoord, snowFlake ) );

    // test przezroczystoci teksela
    if( color.r + color.g + color.b < 0.2 )
        discard;
    else
        outColor = color;
}
