//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw w wyjciowym pacie wierzchokw
//////////////////////////////////////////////////////////////////////
layout( vertices = 3 ) out;

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In[];

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} Out[];

//////////////////////////////////////////////////////////////////////
// zmienne wyjciowe okrelone na pat wierzchokw
//////////////////////////////////////////////////////////////////////
patch out vec3 termIJ;
patch out vec3 termJK;
patch out vec3 termIK;

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw trjkta
//////////////////////////////////////////////////////////////////////
#define Pi In[0].position.xyz
#define Pj In[1].position.xyz
#define Pk In[2].position.xyz

//////////////////////////////////////////////////////////////////////
// rzut prostoktny wierzchoka q na paszczyzn definiowan
// przez wierzchoek i wektor normalny o numerze i
//////////////////////////////////////////////////////////////////////
vec3 PIi( const int i, const vec3 q )
{
    return q - dot( q - In[i].position.xyz, In[i].normal ) * In[i].normal;
}

//////////////////////////////////////////////////////////////////////
// wewntrzny i zewntrzny poziom teselacji
//////////////////////////////////////////////////////////////////////
uniform float tessLevel;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // parametry teselacji zapisywane tylko w pierwszym wywoaniu shadera
    if( gl_InvocationID == 0 )
    {
        gl_TessLevelOuter[0] = tessLevel;
        gl_TessLevelOuter[1] = tessLevel;
        gl_TessLevelOuter[2] = tessLevel;
        gl_TessLevelInner[0] = tessLevel;
    }

    // wsprzdne wierzchoka
    Out[gl_InvocationID].position = In[gl_InvocationID].position;

    // wsprzdne wektora normalnego
    Out[gl_InvocationID].normal = In[gl_InvocationID].normal;

    // obliczenie danych do teselacji (dane stae w obrbie pata wierzchokw)
    if( gl_InvocationID == 0 )
    {
         termIJ = PIi( 0, Pj ) + PIi( 1, Pi );
         termJK = PIi( 1, Pk ) + PIi( 2, Pj );
         termIK = PIi( 2, Pi ) + PIi( 0, Pk );
    }
}
