//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>
#include <materials.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat scale;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateY;
extern int iterationCount;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // klawisz +
        case '+':
            scale += 0.03f;
            break;
        // klawisz -
        case '-':
            if( scale > 0.03f ) scale -= 0.03f;
            break;
        // 1
        case '1':
            iterationCount = 0;
            break;
        // 2
        case '2':
            iterationCount = 1;
            break;
        // 3
        case '3':
            iterationCount = 2;
            break;
        // 4
        case '4':
            iterationCount = 3;
            break;
        // 5
        case '5':
            iterationCount = 4;
            break;
        // 6
        case '6':
            iterationCount = 5;
            break;
        // 7
        case '7':
            iterationCount = 6;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        // kursor w lewo
        case GLUT_KEY_LEFT:
            translateX -= 0.03f;
            break;

        // kursor w gr
        case GLUT_KEY_UP:
            translateY += 0.03f;
            break;

        // kursor w prawo
        case GLUT_KEY_RIGHT:
            translateX += 0.03f;
            break;

        // kursor w d
        case GLUT_KEY_DOWN:
            translateY -= 0.03f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // liczba iteracji
    ITERATION_COUNT_0,
    ITERATION_COUNT_1,
    ITERATION_COUNT_2,
    ITERATION_COUNT_3,
    ITERATION_COUNT_4,
    ITERATION_COUNT_5,
    ITERATION_COUNT_6,

    EXIT       // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // liczba iteracji
        case ITERATION_COUNT_0:
        case ITERATION_COUNT_1:
        case ITERATION_COUNT_2:
        case ITERATION_COUNT_3:
        case ITERATION_COUNT_4:
        case ITERATION_COUNT_5:
        case ITERATION_COUNT_6:
            iterationCount = value;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 4, 0 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
    glutCreateWindow( "Krzywa Kocha" );

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_4_0 )
    {
        std::cout << "Brak OpenGL 4.0" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddMenuEntry( "Liczba iteracji: 1", ITERATION_COUNT_0 );
    glutAddMenuEntry( "Liczba iteracji: 2", ITERATION_COUNT_1 );
    glutAddMenuEntry( "Liczba iteracji: 3", ITERATION_COUNT_2 );
    glutAddMenuEntry( "Liczba iteracji: 4", ITERATION_COUNT_3 );
    glutAddMenuEntry( "Liczba iteracji: 5", ITERATION_COUNT_4 );
    glutAddMenuEntry( "Liczba iteracji: 6", ITERATION_COUNT_5 );
    glutAddMenuEntry( "Liczba iteracji: 7", ITERATION_COUNT_6 );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
