//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy
//////////////////////////////////////////////////////////////////////
layout( lines_adjacency ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy
//////////////////////////////////////////////////////////////////////
layout( line_strip, max_vertices = 50 ) out;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// liczba generowanych odcinkw krzywej
//////////////////////////////////////////////////////////////////////
uniform int segments = 50;

//////////////////////////////////////////////////////////////////////
// macierz bazowa wspczynnikw rwnania krzywej Bziera
//////////////////////////////////////////////////////////////////////
mat4 base = mat4( -1.0, 3.0, -3.0, 1.0,
                   3.0, -6.0, 3.0, 0.0,
                  -3.0, 3.0, 0.0, 0.0,
                   1.0, 0.0, 0.0, 0.0 );

//////////////////////////////////////////////////////////////////////
// macierz utworzona ze wsprzdnych punktw
// kontrolnych rwnania krzywej Bziera
//////////////////////////////////////////////////////////////////////
mat4 m = mat4( gl_in[0].gl_Position,
               gl_in[1].gl_Position,
               gl_in[2].gl_Position,
               gl_in[3].gl_Position );

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // kolejne parametry rwnania krzywej Bziera
    float t = 0.0;
    while( t <= 1.0 )
    {
        // wektor wspczynnikw rwnania krzywej Bziera
        vec4 tvec = vec4( t*t*t, t*t, t, 1 );

        // obliczenie wsprzdnych punktu krzywej
        gl_Position = modelViewProjectionMatrix * m * base * tvec;

        // emisja wierzchoka prymitywu
        EmitVertex();

        // nastpny punkt
        t += 1.0 / (segments - 1.0 );
    }

    // koniec prymitywu
    EndPrimitive();
}
