//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////
// dane wygenerowane przy uyciu programu sphere:
// http://student.ulb.ac.be/~claugero/sphere/index.html
//////////////////////////////////////////////////////////////////////

#ifndef __SPHERE__H__
#define __SPHERE__H__

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw i indeksw wierzchokw (trjktw)
// poszczeglnych kul (sfer)
//////////////////////////////////////////////////////////////////////
const int SPHERE_LOW_VERTEX_COUNT = 42;
const int SPHERE_LOW_INDICES_COUNT = 80;
const int SPHERE_MID_VERTEX_COUNT = 162;
const int SPHERE_MID_INDICES_COUNT = 320;
const int SPHERE_HIGH_VERTEX_COUNT = 642;
const int SPHERE_HIGH_INDICES_COUNT = 1280;
const int SPHERE_VERY_HIGH_VERTEX_COUNT = 2562;
const int SPHERE_VERY_HIGH_INDICES_COUNT = 5120;

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw i zarazem wektorw normalnych
//////////////////////////////////////////////////////////////////////
GLfloat sphereLowPositionNormal[SPHERE_LOW_VERTEX_COUNT * 3] =
{
    0.850651f, 0.525731f, 0.000000f,
    -0.850651f, 0.525731f, 0.000000f,
    -0.850651f, -0.525731f, 0.000000f,
    0.850651f, -0.525731f, 0.000000f,
    0.525731f, 0.000000f, 0.850651f,
    0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, 0.850651f,
    0.000000f, 0.850651f, 0.525731f,
    0.000000f, -0.850651f, 0.525731f,
    0.000000f, -0.850651f, -0.525731f,
    0.000000f, 0.850651f, -0.525731f,
    0.309017f, 0.500000f, 0.809017f,
    -0.309017f, 0.500000f, 0.809017f,
    0.000000f, 0.000000f, 1.000000f,
    -0.309017f, -0.500000f, 0.809017f,
    0.309017f, -0.500000f, 0.809017f,
    0.000000f, 0.000000f, -1.000000f,
    -0.309017f, 0.500000f, -0.809017f,
    0.309017f, 0.500000f, -0.809017f,
    0.309017f, -0.500000f, -0.809017f,
    -0.309017f, -0.500000f, -0.809017f,
    0.809017f, 0.309017f, 0.500000f,
    0.809017f, -0.309017f, 0.500000f,
    1.000000f, 0.000000f, 0.000000f,
    0.809017f, -0.309017f, -0.500000f,
    0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, 0.500000f,
    -0.809017f, 0.309017f, 0.500000f,
    -1.000000f, 0.000000f, 0.000000f,
    -0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, -0.500000f,
    0.500000f, 0.809017f, 0.309017f,
    0.500000f, 0.809017f, -0.309017f,
    0.000000f, 1.000000f, 0.000000f,
    -0.500000f, 0.809017f, -0.309017f,
    -0.500000f, 0.809017f, 0.309017f,
    0.000000f, -1.000000f, 0.000000f,
    0.500000f, -0.809017f, -0.309017f,
    0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, -0.309017f
};

//////////////////////////////////////////////////////////////////////
// dane indeksw wierzchokw trjktw
//////////////////////////////////////////////////////////////////////
GLuint sphereLowIndices[SPHERE_LOW_INDICES_COUNT * 3]=
{
    4, 12, 14,
    14, 12, 13,
    14, 13, 7,
    12, 8, 13,
    4, 14, 16,
    16, 14, 15,
    16, 15, 9,
    14, 7, 15,
    5, 17, 19,
    19, 17, 18,
    19, 18, 11,
    17, 6, 18,
    5, 20, 17,
    17, 20, 21,
    17, 21, 6,
    20, 10, 21,
    0, 22, 24,
    24, 22, 23,
    24, 23, 3,
    22, 4, 23,
    0, 24, 26,
    26, 24, 25,
    26, 25, 5,
    24, 3, 25,
    2, 27, 29,
    29, 27, 28,
    29, 28, 1,
    27, 7, 28,
    2, 29, 31,
    31, 29, 30,
    31, 30, 6,
    29, 1, 30,
    8, 32, 34,
    34, 32, 33,
    34, 33, 11,
    32, 0, 33,
    8, 34, 36,
    36, 34, 35,
    36, 35, 1,
    34, 11, 35,
    9, 37, 39,
    39, 37, 38,
    39, 38, 3,
    37, 10, 38,
    9, 40, 37,
    37, 40, 41,
    37, 41, 10,
    40, 2, 41,
    8, 12, 32,
    32, 12, 22,
    32, 22, 0,
    12, 4, 22,
    11, 33, 19,
    19, 33, 26,
    19, 26, 5,
    33, 0, 26,
    4, 16, 23,
    23, 16, 39,
    23, 39, 3,
    16, 9, 39,
    5, 25, 20,
    20, 25, 38,
    20, 38, 10,
    25, 3, 38,
    7, 13, 28,
    28, 13, 36,
    28, 36, 1,
    13, 8, 36,
    6, 30, 18,
    18, 30, 35,
    18, 35, 11,
    30, 1, 35,
    7, 27, 15,
    15, 27, 40,
    15, 40, 9,
    27, 2, 40,
    6, 21, 31,
    31, 21, 41,
    31, 41, 2,
    21, 10, 41
};

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw i zarazem wektorw normalnych
//////////////////////////////////////////////////////////////////////
GLfloat sphereMidPositionNormal[SPHERE_MID_VERTEX_COUNT * 3] =
{
    0.850651f, 0.525731f, 0.000000f,
    -0.850651f, 0.525731f, 0.000000f,
    -0.850651f, -0.525731f, 0.000000f,
    0.850651f, -0.525731f, 0.000000f,
    0.525731f, 0.000000f, 0.850651f,
    0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, 0.850651f,
    0.000000f, 0.850651f, 0.525731f,
    0.000000f, -0.850651f, 0.525731f,
    0.000000f, -0.850651f, -0.525731f,
    0.000000f, 0.850651f, -0.525731f,
    0.309017f, 0.500000f, 0.809017f,
    -0.309017f, 0.500000f, 0.809017f,
    0.000000f, 0.000000f, 1.000000f,
    -0.309017f, -0.500000f, 0.809017f,
    0.309017f, -0.500000f, 0.809017f,
    0.000000f, 0.000000f, -1.000000f,
    -0.309017f, 0.500000f, -0.809017f,
    0.309017f, 0.500000f, -0.809017f,
    0.309017f, -0.500000f, -0.809017f,
    -0.309017f, -0.500000f, -0.809017f,
    0.809017f, 0.309017f, 0.500000f,
    0.809017f, -0.309017f, 0.500000f,
    1.000000f, 0.000000f, 0.000000f,
    0.809017f, -0.309017f, -0.500000f,
    0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, 0.500000f,
    -0.809017f, 0.309017f, 0.500000f,
    -1.000000f, 0.000000f, 0.000000f,
    -0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, -0.500000f,
    0.500000f, 0.809017f, 0.309017f,
    0.500000f, 0.809017f, -0.309017f,
    0.000000f, 1.000000f, 0.000000f,
    -0.500000f, 0.809017f, -0.309017f,
    -0.500000f, 0.809017f, 0.309017f,
    0.000000f, -1.000000f, 0.000000f,
    0.500000f, -0.809017f, -0.309017f,
    0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, -0.309017f,
    0.433889f, 0.259892f, 0.862669f,
    0.162460f, 0.262866f, 0.951057f,
    0.273267f, 0.000000f, 0.961938f,
    0.000000f, 0.525731f, 0.850651f,
    -0.162460f, 0.262866f, 0.951057f,
    -0.433889f, 0.259892f, 0.862669f,
    -0.273267f, 0.000000f, 0.961938f,
    0.160622f, 0.702046f, 0.693780f,
    -0.160622f, 0.702046f, 0.693780f,
    0.162460f, -0.262866f, 0.951057f,
    0.433889f, -0.259892f, 0.862669f,
    -0.162460f, -0.262866f, 0.951057f,
    0.000000f, -0.525731f, 0.850651f,
    -0.160622f, -0.702046f, 0.693780f,
    0.160622f, -0.702046f, 0.693780f,
    -0.433889f, -0.259892f, 0.862669f,
    0.273267f, 0.000000f, -0.961938f,
    0.162460f, 0.262866f, -0.951057f,
    0.433889f, 0.259892f, -0.862669f,
    -0.162460f, 0.262866f, -0.951057f,
    0.000000f, 0.525731f, -0.850651f,
    -0.160622f, 0.702046f, -0.693780f,
    0.160622f, 0.702046f, -0.693780f,
    -0.273267f, 0.000000f, -0.961938f,
    -0.433889f, 0.259892f, -0.862669f,
    0.433889f, -0.259892f, -0.862669f,
    0.162460f, -0.262866f, -0.951057f,
    0.000000f, -0.525731f, -0.850651f,
    -0.162460f, -0.262866f, -0.951057f,
    -0.433889f, -0.259892f, -0.862669f,
    0.160622f, -0.702046f, -0.693780f,
    -0.160622f, -0.702046f, -0.693780f,
    0.862669f, 0.433889f, 0.259892f,
    0.951057f, 0.162460f, 0.262866f,
    0.961938f, 0.273267f, 0.000000f,
    0.850651f, 0.000000f, 0.525731f,
    0.951057f, -0.162460f, 0.262866f,
    0.862669f, -0.433889f, 0.259892f,
    0.961938f, -0.273267f, 0.000000f,
    0.693780f, 0.160622f, 0.702046f,
    0.693780f, -0.160622f, 0.702046f,
    0.951057f, 0.162460f, -0.262866f,
    0.862669f, 0.433889f, -0.259892f,
    0.951057f, -0.162460f, -0.262866f,
    0.850651f, 0.000000f, -0.525731f,
    0.693780f, -0.160622f, -0.702046f,
    0.693780f, 0.160622f, -0.702046f,
    0.862669f, -0.433889f, -0.259892f,
    -0.862669f, -0.433889f, 0.259892f,
    -0.951057f, -0.162460f, 0.262866f,
    -0.961938f, -0.273267f, 0.000000f,
    -0.850651f, 0.000000f, 0.525731f,
    -0.951057f, 0.162460f, 0.262866f,
    -0.862669f, 0.433889f, 0.259892f,
    -0.961938f, 0.273267f, 0.000000f,
    -0.693780f, -0.160622f, 0.702046f,
    -0.693780f, 0.160622f, 0.702046f,
    -0.951057f, -0.162460f, -0.262866f,
    -0.862669f, -0.433889f, -0.259892f,
    -0.951057f, 0.162460f, -0.262866f,
    -0.850651f, 0.000000f, -0.525731f,
    -0.693780f, 0.160622f, -0.702046f,
    -0.693780f, -0.160622f, -0.702046f,
    -0.862669f, 0.433889f, -0.259892f,
    0.259892f, 0.862669f, 0.433889f,
    0.262866f, 0.951057f, 0.162460f,
    0.000000f, 0.961938f, 0.273267f,
    0.525731f, 0.850651f, 0.000000f,
    0.262866f, 0.951057f, -0.162460f,
    0.259892f, 0.862669f, -0.433889f,
    0.000000f, 0.961938f, -0.273267f,
    0.702046f, 0.693780f, 0.160622f,
    0.702046f, 0.693780f, -0.160622f,
    -0.262866f, 0.951057f, 0.162460f,
    -0.259892f, 0.862669f, 0.433889f,
    -0.262866f, 0.951057f, -0.162460f,
    -0.525731f, 0.850651f, 0.000000f,
    -0.702046f, 0.693780f, -0.160622f,
    -0.702046f, 0.693780f, 0.160622f,
    -0.259892f, 0.862669f, -0.433889f,
    0.000000f, -0.961938f, 0.273267f,
    0.262866f, -0.951057f, 0.162460f,
    0.259892f, -0.862669f, 0.433889f,
    0.262866f, -0.951057f, -0.162460f,
    0.525731f, -0.850651f, 0.000000f,
    0.702046f, -0.693780f, -0.160622f,
    0.702046f, -0.693780f, 0.160622f,
    0.000000f, -0.961938f, -0.273267f,
    0.259892f, -0.862669f, -0.433889f,
    -0.259892f, -0.862669f, 0.433889f,
    -0.262866f, -0.951057f, 0.162460f,
    -0.525731f, -0.850651f, 0.000000f,
    -0.262866f, -0.951057f, -0.162460f,
    -0.259892f, -0.862669f, -0.433889f,
    -0.702046f, -0.693780f, 0.160622f,
    -0.702046f, -0.693780f, -0.160622f,
    0.425325f, 0.688191f, 0.587785f,
    0.587785f, 0.425325f, 0.688191f,
    0.688191f, 0.587785f, 0.425325f,
    0.425325f, 0.688191f, -0.587785f,
    0.688191f, 0.587785f, -0.425325f,
    0.587785f, 0.425325f, -0.688191f,
    0.587785f, -0.425325f, 0.688191f,
    0.425325f, -0.688191f, 0.587785f,
    0.688191f, -0.587785f, 0.425325f,
    0.587785f, -0.425325f, -0.688191f,
    0.688191f, -0.587785f, -0.425325f,
    0.425325f, -0.688191f, -0.587785f,
    -0.587785f, 0.425325f, 0.688191f,
    -0.425325f, 0.688191f, 0.587785f,
    -0.688191f, 0.587785f, 0.425325f,
    -0.587785f, 0.425325f, -0.688191f,
    -0.688191f, 0.587785f, -0.425325f,
    -0.425325f, 0.688191f, -0.587785f,
    -0.587785f, -0.425325f, 0.688191f,
    -0.688191f, -0.587785f, 0.425325f,
    -0.425325f, -0.688191f, 0.587785f,
    -0.587785f, -0.425325f, -0.688191f,
    -0.425325f, -0.688191f, -0.587785f,
    -0.688191f, -0.587785f, -0.425325f
};

//////////////////////////////////////////////////////////////////////
// dane indeksw wierzchokw trjktw
//////////////////////////////////////////////////////////////////////
GLuint sphereMidIndices[SPHERE_MID_INDICES_COUNT * 3]=
{
    4, 42, 44,
    44, 42, 43,
    44, 43, 14,
    42, 12, 43,
    14, 43, 46,
    46, 43, 45,
    46, 45, 13,
    43, 12, 45,
    14, 46, 48,
    48, 46, 47,
    48, 47, 7,
    46, 13, 47,
    12, 49, 45,
    45, 49, 50,
    45, 50, 13,
    49, 8, 50,
    4, 44, 52,
    52, 44, 51,
    52, 51, 16,
    44, 14, 51,
    16, 51, 54,
    54, 51, 53,
    54, 53, 15,
    51, 14, 53,
    16, 54, 56,
    56, 54, 55,
    56, 55, 9,
    54, 15, 55,
    14, 48, 53,
    53, 48, 57,
    53, 57, 15,
    48, 7, 57,
    5, 58, 60,
    60, 58, 59,
    60, 59, 19,
    58, 17, 59,
    19, 59, 62,
    62, 59, 61,
    62, 61, 18,
    59, 17, 61,
    19, 62, 64,
    64, 62, 63,
    64, 63, 11,
    62, 18, 63,
    17, 65, 61,
    61, 65, 66,
    61, 66, 18,
    65, 6, 66,
    5, 67, 58,
    58, 67, 68,
    58, 68, 17,
    67, 20, 68,
    17, 68, 70,
    70, 68, 69,
    70, 69, 21,
    68, 20, 69,
    17, 70, 65,
    65, 70, 71,
    65, 71, 6,
    70, 21, 71,
    20, 72, 69,
    69, 72, 73,
    69, 73, 21,
    72, 10, 73,
    0, 74, 76,
    76, 74, 75,
    76, 75, 24,
    74, 22, 75,
    24, 75, 78,
    78, 75, 77,
    78, 77, 23,
    75, 22, 77,
    24, 78, 80,
    80, 78, 79,
    80, 79, 3,
    78, 23, 79,
    22, 81, 77,
    77, 81, 82,
    77, 82, 23,
    81, 4, 82,
    0, 76, 84,
    84, 76, 83,
    84, 83, 26,
    76, 24, 83,
    26, 83, 86,
    86, 83, 85,
    86, 85, 25,
    83, 24, 85,
    26, 86, 88,
    88, 86, 87,
    88, 87, 5,
    86, 25, 87,
    24, 80, 85,
    85, 80, 89,
    85, 89, 25,
    80, 3, 89,
    2, 90, 92,
    92, 90, 91,
    92, 91, 29,
    90, 27, 91,
    29, 91, 94,
    94, 91, 93,
    94, 93, 28,
    91, 27, 93,
    29, 94, 96,
    96, 94, 95,
    96, 95, 1,
    94, 28, 95,
    27, 97, 93,
    93, 97, 98,
    93, 98, 28,
    97, 7, 98,
    2, 92, 100,
    100, 92, 99,
    100, 99, 31,
    92, 29, 99,
    31, 99, 102,
    102, 99, 101,
    102, 101, 30,
    99, 29, 101,
    31, 102, 104,
    104, 102, 103,
    104, 103, 6,
    102, 30, 103,
    29, 96, 101,
    101, 96, 105,
    101, 105, 30,
    96, 1, 105,
    8, 106, 108,
    108, 106, 107,
    108, 107, 34,
    106, 32, 107,
    34, 107, 110,
    110, 107, 109,
    110, 109, 33,
    107, 32, 109,
    34, 110, 112,
    112, 110, 111,
    112, 111, 11,
    110, 33, 111,
    32, 113, 109,
    109, 113, 114,
    109, 114, 33,
    113, 0, 114,
    8, 108, 116,
    116, 108, 115,
    116, 115, 36,
    108, 34, 115,
    36, 115, 118,
    118, 115, 117,
    118, 117, 35,
    115, 34, 117,
    36, 118, 120,
    120, 118, 119,
    120, 119, 1,
    118, 35, 119,
    34, 112, 117,
    117, 112, 121,
    117, 121, 35,
    112, 11, 121,
    9, 122, 124,
    124, 122, 123,
    124, 123, 39,
    122, 37, 123,
    39, 123, 126,
    126, 123, 125,
    126, 125, 38,
    123, 37, 125,
    39, 126, 128,
    128, 126, 127,
    128, 127, 3,
    126, 38, 127,
    37, 129, 125,
    125, 129, 130,
    125, 130, 38,
    129, 10, 130,
    9, 131, 122,
    122, 131, 132,
    122, 132, 37,
    131, 40, 132,
    37, 132, 134,
    134, 132, 133,
    134, 133, 41,
    132, 40, 133,
    37, 134, 129,
    129, 134, 135,
    129, 135, 10,
    134, 41, 135,
    40, 136, 133,
    133, 136, 137,
    133, 137, 41,
    136, 2, 137,
    8, 49, 106,
    106, 49, 138,
    106, 138, 32,
    49, 12, 138,
    32, 138, 140,
    140, 138, 139,
    140, 139, 22,
    138, 12, 139,
    32, 140, 113,
    113, 140, 74,
    113, 74, 0,
    140, 22, 74,
    12, 42, 139,
    139, 42, 81,
    139, 81, 22,
    42, 4, 81,
    11, 111, 64,
    64, 111, 141,
    64, 141, 19,
    111, 33, 141,
    19, 141, 143,
    143, 141, 142,
    143, 142, 26,
    141, 33, 142,
    19, 143, 60,
    60, 143, 88,
    60, 88, 5,
    143, 26, 88,
    33, 114, 142,
    142, 114, 84,
    142, 84, 26,
    114, 0, 84,
    4, 52, 82,
    82, 52, 144,
    82, 144, 23,
    52, 16, 144,
    23, 144, 146,
    146, 144, 145,
    146, 145, 39,
    144, 16, 145,
    23, 146, 79,
    79, 146, 128,
    79, 128, 3,
    146, 39, 128,
    16, 56, 145,
    145, 56, 124,
    145, 124, 39,
    56, 9, 124,
    5, 87, 67,
    67, 87, 147,
    67, 147, 20,
    87, 25, 147,
    20, 147, 149,
    149, 147, 148,
    149, 148, 38,
    147, 25, 148,
    20, 149, 72,
    72, 149, 130,
    72, 130, 10,
    149, 38, 130,
    25, 89, 148,
    148, 89, 127,
    148, 127, 38,
    89, 3, 127,
    7, 47, 98,
    98, 47, 150,
    98, 150, 28,
    47, 13, 150,
    28, 150, 152,
    152, 150, 151,
    152, 151, 36,
    150, 13, 151,
    28, 152, 95,
    95, 152, 120,
    95, 120, 1,
    152, 36, 120,
    13, 50, 151,
    151, 50, 116,
    151, 116, 36,
    50, 8, 116,
    6, 103, 66,
    66, 103, 153,
    66, 153, 18,
    103, 30, 153,
    18, 153, 155,
    155, 153, 154,
    155, 154, 35,
    153, 30, 154,
    18, 155, 63,
    63, 155, 121,
    63, 121, 11,
    155, 35, 121,
    30, 105, 154,
    154, 105, 119,
    154, 119, 35,
    105, 1, 119,
    7, 97, 57,
    57, 97, 156,
    57, 156, 15,
    97, 27, 156,
    15, 156, 158,
    158, 156, 157,
    158, 157, 40,
    156, 27, 157,
    15, 158, 55,
    55, 158, 131,
    55, 131, 9,
    158, 40, 131,
    27, 90, 157,
    157, 90, 136,
    157, 136, 40,
    90, 2, 136,
    6, 71, 104,
    104, 71, 159,
    104, 159, 31,
    71, 21, 159,
    31, 159, 161,
    161, 159, 160,
    161, 160, 41,
    159, 21, 160,
    31, 161, 100,
    100, 161, 137,
    100, 137, 2,
    161, 41, 137,
    21, 73, 160,
    160, 73, 135,
    160, 135, 41,
    73, 10, 135,
};

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw i zarazem wektorw normalnych
//////////////////////////////////////////////////////////////////////
GLfloat sphereHighPositionNormal[SPHERE_HIGH_VERTEX_COUNT * 3] =
{
    0.850651f, 0.525731f, 0.000000f,
    -0.850651f, 0.525731f, 0.000000f,
    -0.850651f, -0.525731f, 0.000000f,
    0.850651f, -0.525731f, 0.000000f,
    0.525731f, 0.000000f, 0.850651f,
    0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, 0.850651f,
    0.000000f, 0.850651f, 0.525731f,
    0.000000f, -0.850651f, 0.525731f,
    0.000000f, -0.850651f, -0.525731f,
    0.000000f, 0.850651f, -0.525731f,
    0.309017f, 0.500000f, 0.809017f,
    -0.309017f, 0.500000f, 0.809017f,
    0.000000f, 0.000000f, 1.000000f,
    -0.309017f, -0.500000f, 0.809017f,
    0.309017f, -0.500000f, 0.809017f,
    0.000000f, 0.000000f, -1.000000f,
    -0.309017f, 0.500000f, -0.809017f,
    0.309017f, 0.500000f, -0.809017f,
    0.309017f, -0.500000f, -0.809017f,
    -0.309017f, -0.500000f, -0.809017f,
    0.809017f, 0.309017f, 0.500000f,
    0.809017f, -0.309017f, 0.500000f,
    1.000000f, 0.000000f, 0.000000f,
    0.809017f, -0.309017f, -0.500000f,
    0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, 0.500000f,
    -0.809017f, 0.309017f, 0.500000f,
    -1.000000f, 0.000000f, 0.000000f,
    -0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, -0.500000f,
    0.500000f, 0.809017f, 0.309017f,
    0.500000f, 0.809017f, -0.309017f,
    0.000000f, 1.000000f, 0.000000f,
    -0.500000f, 0.809017f, -0.309017f,
    -0.500000f, 0.809017f, 0.309017f,
    0.000000f, -1.000000f, 0.000000f,
    0.500000f, -0.809017f, -0.309017f,
    0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, -0.309017f,
    0.433889f, 0.259892f, 0.862669f,
    0.162460f, 0.262866f, 0.951057f,
    0.273267f, 0.000000f, 0.961938f,
    0.000000f, 0.525731f, 0.850651f,
    -0.162460f, 0.262866f, 0.951057f,
    -0.433889f, 0.259892f, 0.862669f,
    -0.273267f, 0.000000f, 0.961938f,
    0.160622f, 0.702046f, 0.693780f,
    -0.160622f, 0.702046f, 0.693780f,
    0.162460f, -0.262866f, 0.951057f,
    0.433889f, -0.259892f, 0.862669f,
    -0.162460f, -0.262866f, 0.951057f,
    0.000000f, -0.525731f, 0.850651f,
    -0.160622f, -0.702046f, 0.693780f,
    0.160622f, -0.702046f, 0.693780f,
    -0.433889f, -0.259892f, 0.862669f,
    0.273267f, 0.000000f, -0.961938f,
    0.162460f, 0.262866f, -0.951057f,
    0.433889f, 0.259892f, -0.862669f,
    -0.162460f, 0.262866f, -0.951057f,
    0.000000f, 0.525731f, -0.850651f,
    -0.160622f, 0.702046f, -0.693780f,
    0.160622f, 0.702046f, -0.693780f,
    -0.273267f, 0.000000f, -0.961938f,
    -0.433889f, 0.259892f, -0.862669f,
    0.433889f, -0.259892f, -0.862669f,
    0.162460f, -0.262866f, -0.951057f,
    0.000000f, -0.525731f, -0.850651f,
    -0.162460f, -0.262866f, -0.951057f,
    -0.433889f, -0.259892f, -0.862669f,
    0.160622f, -0.702046f, -0.693780f,
    -0.160622f, -0.702046f, -0.693780f,
    0.862669f, 0.433889f, 0.259892f,
    0.951057f, 0.162460f, 0.262866f,
    0.961938f, 0.273267f, 0.000000f,
    0.850651f, 0.000000f, 0.525731f,
    0.951057f, -0.162460f, 0.262866f,
    0.862669f, -0.433889f, 0.259892f,
    0.961938f, -0.273267f, 0.000000f,
    0.693780f, 0.160622f, 0.702046f,
    0.693780f, -0.160622f, 0.702046f,
    0.951057f, 0.162460f, -0.262866f,
    0.862669f, 0.433889f, -0.259892f,
    0.951057f, -0.162460f, -0.262866f,
    0.850651f, 0.000000f, -0.525731f,
    0.693780f, -0.160622f, -0.702046f,
    0.693780f, 0.160622f, -0.702046f,
    0.862669f, -0.433889f, -0.259892f,
    -0.862669f, -0.433889f, 0.259892f,
    -0.951057f, -0.162460f, 0.262866f,
    -0.961938f, -0.273267f, 0.000000f,
    -0.850651f, 0.000000f, 0.525731f,
    -0.951057f, 0.162460f, 0.262866f,
    -0.862669f, 0.433889f, 0.259892f,
    -0.961938f, 0.273267f, 0.000000f,
    -0.693780f, -0.160622f, 0.702046f,
    -0.693780f, 0.160622f, 0.702046f,
    -0.951057f, -0.162460f, -0.262866f,
    -0.862669f, -0.433889f, -0.259892f,
    -0.951057f, 0.162460f, -0.262866f,
    -0.850651f, 0.000000f, -0.525731f,
    -0.693780f, 0.160622f, -0.702046f,
    -0.693780f, -0.160622f, -0.702046f,
    -0.862669f, 0.433889f, -0.259892f,
    0.259892f, 0.862669f, 0.433889f,
    0.262866f, 0.951057f, 0.162460f,
    0.000000f, 0.961938f, 0.273267f,
    0.525731f, 0.850651f, 0.000000f,
    0.262866f, 0.951057f, -0.162460f,
    0.259892f, 0.862669f, -0.433889f,
    0.000000f, 0.961938f, -0.273267f,
    0.702046f, 0.693780f, 0.160622f,
    0.702046f, 0.693780f, -0.160622f,
    -0.262866f, 0.951057f, 0.162460f,
    -0.259892f, 0.862669f, 0.433889f,
    -0.262866f, 0.951057f, -0.162460f,
    -0.525731f, 0.850651f, 0.000000f,
    -0.702046f, 0.693780f, -0.160622f,
    -0.702046f, 0.693780f, 0.160622f,
    -0.259892f, 0.862669f, -0.433889f,
    0.000000f, -0.961938f, 0.273267f,
    0.262866f, -0.951057f, 0.162460f,
    0.259892f, -0.862669f, 0.433889f,
    0.262866f, -0.951057f, -0.162460f,
    0.525731f, -0.850651f, 0.000000f,
    0.702046f, -0.693780f, -0.160622f,
    0.702046f, -0.693780f, 0.160622f,
    0.000000f, -0.961938f, -0.273267f,
    0.259892f, -0.862669f, -0.433889f,
    -0.259892f, -0.862669f, 0.433889f,
    -0.262866f, -0.951057f, 0.162460f,
    -0.525731f, -0.850651f, 0.000000f,
    -0.262866f, -0.951057f, -0.162460f,
    -0.259892f, -0.862669f, -0.433889f,
    -0.702046f, -0.693780f, 0.160622f,
    -0.702046f, -0.693780f, -0.160622f,
    0.425325f, 0.688191f, 0.587785f,
    0.587785f, 0.425325f, 0.688191f,
    0.688191f, 0.587785f, 0.425325f,
    0.425325f, 0.688191f, -0.587785f,
    0.688191f, 0.587785f, -0.425325f,
    0.587785f, 0.425325f, -0.688191f,
    0.587785f, -0.425325f, 0.688191f,
    0.425325f, -0.688191f, 0.587785f,
    0.688191f, -0.587785f, 0.425325f,
    0.587785f, -0.425325f, -0.688191f,
    0.688191f, -0.587785f, -0.425325f,
    0.425325f, -0.688191f, -0.587785f,
    -0.587785f, 0.425325f, 0.688191f,
    -0.425325f, 0.688191f, 0.587785f,
    -0.688191f, 0.587785f, 0.425325f,
    -0.587785f, 0.425325f, -0.688191f,
    -0.688191f, 0.587785f, -0.425325f,
    -0.425325f, 0.688191f, -0.587785f,
    -0.587785f, -0.425325f, 0.688191f,
    -0.688191f, -0.587785f, 0.425325f,
    -0.425325f, -0.688191f, 0.587785f,
    -0.587785f, -0.425325f, -0.688191f,
    -0.425325f, -0.688191f, -0.587785f,
    -0.688191f, -0.587785f, -0.425325f,
    0.484442f, 0.131200f, 0.864929f,
    0.358229f, 0.131655f, 0.924305f,
    0.403355f, 0.000000f, 0.915043f,
    0.301259f, 0.264083f, 0.916244f,
    0.220117f, 0.132792f, 0.966393f,
    0.082242f, 0.133071f, 0.987688f,
    0.137952f, 0.000000f, 0.990439f,
    0.375039f, 0.383614f, 0.843911f,
    0.238677f, 0.386187f, 0.891006f,
    0.000000f, 0.266405f, 0.963861f,
    -0.082242f, 0.133071f, 0.987688f,
    0.082324f, 0.399607f, 0.912982f,
    -0.082324f, 0.399607f, 0.912982f,
    -0.156434f, 0.519258f, 0.840178f,
    -0.238677f, 0.386187f, 0.891006f,
    0.156434f, 0.519258f, 0.840178f,
    -0.220117f, 0.132792f, 0.966393f,
    -0.137952f, 0.000000f, 0.990439f,
    -0.301259f, 0.264083f, 0.916244f,
    -0.358229f, 0.131655f, 0.924305f,
    -0.484442f, 0.131200f, 0.864929f,
    -0.403355f, 0.000000f, 0.915043f,
    -0.375039f, 0.383614f, 0.843911f,
    0.237086f, 0.606825f, 0.758652f,
    0.081142f, 0.620240f, 0.780204f,
    0.000000f, 0.711282f, 0.702907f,
    -0.081142f, 0.620240f, 0.780204f,
    -0.237086f, 0.606825f, 0.758652f,
    0.081086f, 0.783843f, 0.615642f,
    -0.081086f, 0.783843f, 0.615642f,
    0.358229f, -0.131655f, 0.924305f,
    0.484442f, -0.131200f, 0.864929f,
    0.220117f, -0.132792f, 0.966393f,
    0.301259f, -0.264083f, 0.916244f,
    0.238677f, -0.386187f, 0.891006f,
    0.375039f, -0.383614f, 0.843911f,
    0.082242f, -0.133071f, 0.987688f,
    0.082324f, -0.399607f, 0.912982f,
    0.156434f, -0.519258f, 0.840178f,
    0.000000f, -0.266405f, 0.963861f,
    -0.082324f, -0.399607f, 0.912982f,
    -0.238677f, -0.386187f, 0.891006f,
    -0.156434f, -0.519258f, 0.840178f,
    -0.082242f, -0.133071f, 0.987688f,
    0.081142f, -0.620240f, 0.780204f,
    0.237086f, -0.606825f, 0.758652f,
    -0.081142f, -0.620240f, 0.780204f,
    0.000000f, -0.711282f, 0.702907f,
    -0.081086f, -0.783843f, 0.615642f,
    0.081086f, -0.783843f, 0.615642f,
    -0.237086f, -0.606825f, 0.758652f,
    -0.220117f, -0.132792f, 0.966393f,
    -0.358229f, -0.131655f, 0.924305f,
    -0.301259f, -0.264083f, 0.916244f,
    -0.375039f, -0.383614f, 0.843911f,
    -0.484442f, -0.131200f, 0.864929f,
    0.403355f, 0.000000f, -0.915043f,
    0.358229f, 0.131655f, -0.924305f,
    0.484442f, 0.131200f, -0.864929f,
    0.220117f, 0.132792f, -0.966393f,
    0.301259f, 0.264083f, -0.916244f,
    0.238677f, 0.386187f, -0.891006f,
    0.375039f, 0.383614f, -0.843911f,
    0.137952f, 0.000000f, -0.990439f,
    0.082242f, 0.133071f, -0.987688f,
    0.082324f, 0.399607f, -0.912982f,
    0.156434f, 0.519258f, -0.840178f,
    0.000000f, 0.266405f, -0.963861f,
    -0.082324f, 0.399607f, -0.912982f,
    -0.238677f, 0.386187f, -0.891006f,
    -0.156434f, 0.519258f, -0.840178f,
    -0.082242f, 0.133071f, -0.987688f,
    0.081142f, 0.620240f, -0.780204f,
    0.237086f, 0.606825f, -0.758652f,
    -0.081142f, 0.620240f, -0.780204f,
    0.000000f, 0.711282f, -0.702907f,
    -0.081086f, 0.783843f, -0.615642f,
    0.081086f, 0.783843f, -0.615642f,
    -0.237086f, 0.606825f, -0.758652f,
    -0.137952f, 0.000000f, -0.990439f,
    -0.220117f, 0.132792f, -0.966393f,
    -0.358229f, 0.131655f, -0.924305f,
    -0.301259f, 0.264083f, -0.916244f,
    -0.375039f, 0.383614f, -0.843911f,
    -0.403355f, 0.000000f, -0.915043f,
    -0.484442f, 0.131200f, -0.864929f,
    0.484442f, -0.131200f, -0.864929f,
    0.358229f, -0.131655f, -0.924305f,
    0.301259f, -0.264083f, -0.916244f,
    0.220117f, -0.132792f, -0.966393f,
    0.082242f, -0.133071f, -0.987688f,
    0.375039f, -0.383614f, -0.843911f,
    0.238677f, -0.386187f, -0.891006f,
    0.000000f, -0.266405f, -0.963861f,
    -0.082242f, -0.133071f, -0.987688f,
    0.082324f, -0.399607f, -0.912982f,
    -0.082324f, -0.399607f, -0.912982f,
    -0.156434f, -0.519258f, -0.840178f,
    -0.238677f, -0.386187f, -0.891006f,
    0.156434f, -0.519258f, -0.840178f,
    -0.220117f, -0.132792f, -0.966393f,
    -0.301259f, -0.264083f, -0.916244f,
    -0.358229f, -0.131655f, -0.924305f,
    -0.484442f, -0.131200f, -0.864929f,
    -0.375039f, -0.383614f, -0.843911f,
    0.237086f, -0.606825f, -0.758652f,
    0.081142f, -0.620240f, -0.780204f,
    0.000000f, -0.711282f, -0.702907f,
    -0.081142f, -0.620240f, -0.780204f,
    -0.237086f, -0.606825f, -0.758652f,
    0.081086f, -0.783843f, -0.615642f,
    -0.081086f, -0.783843f, -0.615642f,
    0.864929f, 0.484442f, 0.131200f,
    0.924305f, 0.358229f, 0.131655f,
    0.915043f, 0.403355f, 0.000000f,
    0.916244f, 0.301259f, 0.264083f,
    0.966393f, 0.220117f, 0.132792f,
    0.987688f, 0.082242f, 0.133071f,
    0.990439f, 0.137952f, 0.000000f,
    0.843911f, 0.375039f, 0.383614f,
    0.891006f, 0.238677f, 0.386187f,
    0.963861f, 0.000000f, 0.266405f,
    0.987688f, -0.082242f, 0.133071f,
    0.912982f, 0.082324f, 0.399607f,
    0.912982f, -0.082324f, 0.399607f,
    0.840178f, -0.156434f, 0.519258f,
    0.891006f, -0.238677f, 0.386187f,
    0.840178f, 0.156434f, 0.519258f,
    0.966393f, -0.220117f, 0.132792f,
    0.990439f, -0.137952f, 0.000000f,
    0.916244f, -0.301259f, 0.264083f,
    0.924305f, -0.358229f, 0.131655f,
    0.864929f, -0.484442f, 0.131200f,
    0.915043f, -0.403355f, 0.000000f,
    0.843911f, -0.375039f, 0.383614f,
    0.758652f, 0.237086f, 0.606825f,
    0.780204f, 0.081142f, 0.620240f,
    0.702907f, 0.000000f, 0.711282f,
    0.780204f, -0.081142f, 0.620240f,
    0.758652f, -0.237086f, 0.606825f,
    0.615642f, 0.081086f, 0.783843f,
    0.615642f, -0.081086f, 0.783843f,
    0.924305f, 0.358229f, -0.131655f,
    0.864929f, 0.484442f, -0.131200f,
    0.966393f, 0.220117f, -0.132792f,
    0.916244f, 0.301259f, -0.264083f,
    0.891006f, 0.238677f, -0.386187f,
    0.843911f, 0.375039f, -0.383614f,
    0.987688f, 0.082242f, -0.133071f,
    0.912982f, 0.082324f, -0.399607f,
    0.840178f, 0.156434f, -0.519258f,
    0.963861f, 0.000000f, -0.266405f,
    0.912982f, -0.082324f, -0.399607f,
    0.891006f, -0.238677f, -0.386187f,
    0.840178f, -0.156434f, -0.519258f,
    0.987688f, -0.082242f, -0.133071f,
    0.780204f, 0.081142f, -0.620240f,
    0.758652f, 0.237086f, -0.606825f,
    0.780204f, -0.081142f, -0.620240f,
    0.702907f, 0.000000f, -0.711282f,
    0.615642f, -0.081086f, -0.783843f,
    0.615642f, 0.081086f, -0.783843f,
    0.758652f, -0.237086f, -0.606825f,
    0.966393f, -0.220117f, -0.132792f,
    0.924305f, -0.358229f, -0.131655f,
    0.916244f, -0.301259f, -0.264083f,
    0.843911f, -0.375039f, -0.383614f,
    0.864929f, -0.484442f, -0.131200f,
    -0.864929f, -0.484442f, 0.131200f,
    -0.924305f, -0.358229f, 0.131655f,
    -0.915043f, -0.403355f, 0.000000f,
    -0.916244f, -0.301259f, 0.264083f,
    -0.966393f, -0.220117f, 0.132792f,
    -0.987688f, -0.082242f, 0.133071f,
    -0.990439f, -0.137952f, 0.000000f,
    -0.843911f, -0.375039f, 0.383614f,
    -0.891006f, -0.238677f, 0.386187f,
    -0.963861f, 0.000000f, 0.266405f,
    -0.987688f, 0.082242f, 0.133071f,
    -0.912982f, -0.082324f, 0.399607f,
    -0.912982f, 0.082324f, 0.399607f,
    -0.840178f, 0.156434f, 0.519258f,
    -0.891006f, 0.238677f, 0.386187f,
    -0.840178f, -0.156434f, 0.519258f,
    -0.966393f, 0.220117f, 0.132792f,
    -0.990439f, 0.137952f, 0.000000f,
    -0.916244f, 0.301259f, 0.264083f,
    -0.924305f, 0.358229f, 0.131655f,
    -0.864929f, 0.484442f, 0.131200f,
    -0.915043f, 0.403355f, 0.000000f,
    -0.843911f, 0.375039f, 0.383614f,
    -0.758652f, -0.237086f, 0.606825f,
    -0.780204f, -0.081142f, 0.620240f,
    -0.702907f, 0.000000f, 0.711282f,
    -0.780204f, 0.081142f, 0.620240f,
    -0.758652f, 0.237086f, 0.606825f,
    -0.615642f, -0.081086f, 0.783843f,
    -0.615642f, 0.081086f, 0.783843f,
    -0.924305f, -0.358229f, -0.131655f,
    -0.864929f, -0.484442f, -0.131200f,
    -0.966393f, -0.220117f, -0.132792f,
    -0.916244f, -0.301259f, -0.264083f,
    -0.891006f, -0.238677f, -0.386187f,
    -0.843911f, -0.375039f, -0.383614f,
    -0.987688f, -0.082242f, -0.133071f,
    -0.912982f, -0.082324f, -0.399607f,
    -0.840178f, -0.156434f, -0.519258f,
    -0.963861f, 0.000000f, -0.266405f,
    -0.912982f, 0.082324f, -0.399607f,
    -0.891006f, 0.238677f, -0.386187f,
    -0.840178f, 0.156434f, -0.519258f,
    -0.987688f, 0.082242f, -0.133071f,
    -0.780204f, -0.081142f, -0.620240f,
    -0.758652f, -0.237086f, -0.606825f,
    -0.780204f, 0.081142f, -0.620240f,
    -0.702907f, 0.000000f, -0.711282f,
    -0.615642f, 0.081086f, -0.783843f,
    -0.615642f, -0.081086f, -0.783843f,
    -0.758652f, 0.237086f, -0.606825f,
    -0.966393f, 0.220117f, -0.132792f,
    -0.924305f, 0.358229f, -0.131655f,
    -0.916244f, 0.301259f, -0.264083f,
    -0.843911f, 0.375039f, -0.383614f,
    -0.864929f, 0.484442f, -0.131200f,
    0.131200f, 0.864929f, 0.484442f,
    0.131655f, 0.924305f, 0.358229f,
    0.000000f, 0.915043f, 0.403355f,
    0.264083f, 0.916244f, 0.301259f,
    0.132792f, 0.966393f, 0.220117f,
    0.133071f, 0.987688f, 0.082242f,
    0.000000f, 0.990439f, 0.137952f,
    0.383614f, 0.843911f, 0.375039f,
    0.386187f, 0.891006f, 0.238677f,
    0.266405f, 0.963861f, 0.000000f,
    0.133071f, 0.987688f, -0.082242f,
    0.399607f, 0.912982f, 0.082324f,
    0.399607f, 0.912982f, -0.082324f,
    0.519258f, 0.840178f, -0.156434f,
    0.386187f, 0.891006f, -0.238677f,
    0.519258f, 0.840178f, 0.156434f,
    0.132792f, 0.966393f, -0.220117f,
    0.000000f, 0.990439f, -0.137952f,
    0.264083f, 0.916244f, -0.301259f,
    0.131655f, 0.924305f, -0.358229f,
    0.131200f, 0.864929f, -0.484442f,
    0.000000f, 0.915043f, -0.403355f,
    0.383614f, 0.843911f, -0.375039f,
    0.606825f, 0.758652f, 0.237086f,
    0.620240f, 0.780204f, 0.081142f,
    0.711282f, 0.702907f, 0.000000f,
    0.620240f, 0.780204f, -0.081142f,
    0.606825f, 0.758652f, -0.237086f,
    0.783843f, 0.615642f, 0.081086f,
    0.783843f, 0.615642f, -0.081086f,
    -0.131655f, 0.924305f, 0.358229f,
    -0.131200f, 0.864929f, 0.484442f,
    -0.132792f, 0.966393f, 0.220117f,
    -0.264083f, 0.916244f, 0.301259f,
    -0.386187f, 0.891006f, 0.238677f,
    -0.383614f, 0.843911f, 0.375039f,
    -0.133071f, 0.987688f, 0.082242f,
    -0.399607f, 0.912982f, 0.082324f,
    -0.519258f, 0.840178f, 0.156434f,
    -0.266405f, 0.963861f, 0.000000f,
    -0.399607f, 0.912982f, -0.082324f,
    -0.386187f, 0.891006f, -0.238677f,
    -0.519258f, 0.840178f, -0.156434f,
    -0.133071f, 0.987688f, -0.082242f,
    -0.620240f, 0.780204f, 0.081142f,
    -0.606825f, 0.758652f, 0.237086f,
    -0.620240f, 0.780204f, -0.081142f,
    -0.711282f, 0.702907f, 0.000000f,
    -0.783843f, 0.615642f, -0.081086f,
    -0.783843f, 0.615642f, 0.081086f,
    -0.606825f, 0.758652f, -0.237086f,
    -0.132792f, 0.966393f, -0.220117f,
    -0.131655f, 0.924305f, -0.358229f,
    -0.264083f, 0.916244f, -0.301259f,
    -0.383614f, 0.843911f, -0.375039f,
    -0.131200f, 0.864929f, -0.484442f,
    0.000000f, -0.915043f, 0.403355f,
    0.131655f, -0.924305f, 0.358229f,
    0.131200f, -0.864929f, 0.484442f,
    0.132792f, -0.966393f, 0.220117f,
    0.264083f, -0.916244f, 0.301259f,
    0.386187f, -0.891006f, 0.238677f,
    0.383614f, -0.843911f, 0.375039f,
    0.000000f, -0.990439f, 0.137952f,
    0.133071f, -0.987688f, 0.082242f,
    0.399607f, -0.912982f, 0.082324f,
    0.519258f, -0.840178f, 0.156434f,
    0.266405f, -0.963861f, 0.000000f,
    0.399607f, -0.912982f, -0.082324f,
    0.386187f, -0.891006f, -0.238677f,
    0.519258f, -0.840178f, -0.156434f,
    0.133071f, -0.987688f, -0.082242f,
    0.620240f, -0.780204f, 0.081142f,
    0.606825f, -0.758652f, 0.237086f,
    0.620240f, -0.780204f, -0.081142f,
    0.711282f, -0.702907f, 0.000000f,
    0.783843f, -0.615642f, -0.081086f,
    0.783843f, -0.615642f, 0.081086f,
    0.606825f, -0.758652f, -0.237086f,
    0.000000f, -0.990439f, -0.137952f,
    0.132792f, -0.966393f, -0.220117f,
    0.131655f, -0.924305f, -0.358229f,
    0.264083f, -0.916244f, -0.301259f,
    0.383614f, -0.843911f, -0.375039f,
    0.000000f, -0.915043f, -0.403355f,
    0.131200f, -0.864929f, -0.484442f,
    -0.131200f, -0.864929f, 0.484442f,
    -0.131655f, -0.924305f, 0.358229f,
    -0.264083f, -0.916244f, 0.301259f,
    -0.132792f, -0.966393f, 0.220117f,
    -0.133071f, -0.987688f, 0.082242f,
    -0.383614f, -0.843911f, 0.375039f,
    -0.386187f, -0.891006f, 0.238677f,
    -0.266405f, -0.963861f, 0.000000f,
    -0.133071f, -0.987688f, -0.082242f,
    -0.399607f, -0.912982f, 0.082324f,
    -0.399607f, -0.912982f, -0.082324f,
    -0.519258f, -0.840178f, -0.156434f,
    -0.386187f, -0.891006f, -0.238677f,
    -0.519258f, -0.840178f, 0.156434f,
    -0.132792f, -0.966393f, -0.220117f,
    -0.264083f, -0.916244f, -0.301259f,
    -0.131655f, -0.924305f, -0.358229f,
    -0.131200f, -0.864929f, -0.484442f,
    -0.383614f, -0.843911f, -0.375039f,
    -0.606825f, -0.758652f, 0.237086f,
    -0.620240f, -0.780204f, 0.081142f,
    -0.711282f, -0.702907f, 0.000000f,
    -0.620240f, -0.780204f, -0.081142f,
    -0.606825f, -0.758652f, -0.237086f,
    -0.783843f, -0.615642f, 0.081086f,
    -0.783843f, -0.615642f, -0.081086f,
    0.213023f, 0.792649f, 0.571252f,
    0.296005f, 0.702310f, 0.647412f,
    0.346153f, 0.783452f, 0.516122f,
    0.468430f, 0.757935f, 0.453990f,
    0.371748f, 0.601501f, 0.707107f,
    0.564254f, 0.646578f, 0.513375f,
    0.601501f, 0.707107f, 0.371748f,
    0.513375f, 0.564254f, 0.646578f,
    0.646578f, 0.513375f, 0.564254f,
    0.707107f, 0.371748f, 0.601501f,
    0.757935f, 0.453990f, 0.468430f,
    0.453990f, 0.468430f, 0.757935f,
    0.702310f, 0.647412f, 0.296005f,
    0.783452f, 0.516122f, 0.346153f,
    0.792649f, 0.571252f, 0.213023f,
    0.516122f, 0.346153f, 0.783452f,
    0.571252f, 0.213023f, 0.792649f,
    0.647412f, 0.296005f, 0.702310f,
    0.213023f, 0.792649f, -0.571252f,
    0.346153f, 0.783452f, -0.516122f,
    0.296005f, 0.702310f, -0.647412f,
    0.371748f, 0.601501f, -0.707107f,
    0.468430f, 0.757935f, -0.453990f,
    0.513375f, 0.564254f, -0.646578f,
    0.453990f, 0.468430f, -0.757935f,
    0.564254f, 0.646578f, -0.513375f,
    0.646578f, 0.513375f, -0.564254f,
    0.757935f, 0.453990f, -0.468430f,
    0.707107f, 0.371748f, -0.601501f,
    0.601501f, 0.707107f, -0.371748f,
    0.516122f, 0.346153f, -0.783452f,
    0.647412f, 0.296005f, -0.702310f,
    0.571252f, 0.213023f, -0.792649f,
    0.702310f, 0.647412f, -0.296005f,
    0.792649f, 0.571252f, -0.213023f,
    0.783452f, 0.516122f, -0.346153f,
    0.571252f, -0.213023f, 0.792649f,
    0.516122f, -0.346153f, 0.783452f,
    0.647412f, -0.296005f, 0.702310f,
    0.707107f, -0.371748f, 0.601501f,
    0.453990f, -0.468430f, 0.757935f,
    0.646578f, -0.513375f, 0.564254f,
    0.757935f, -0.453990f, 0.468430f,
    0.513375f, -0.564254f, 0.646578f,
    0.564254f, -0.646578f, 0.513375f,
    0.468430f, -0.757935f, 0.453990f,
    0.601501f, -0.707107f, 0.371748f,
    0.371748f, -0.601501f, 0.707107f,
    0.783452f, -0.516122f, 0.346153f,
    0.702310f, -0.647412f, 0.296005f,
    0.792649f, -0.571252f, 0.213023f,
    0.296005f, -0.702310f, 0.647412f,
    0.213023f, -0.792649f, 0.571252f,
    0.346153f, -0.783452f, 0.516122f,
    0.571252f, -0.213023f, -0.792649f,
    0.647412f, -0.296005f, -0.702310f,
    0.516122f, -0.346153f, -0.783452f,
    0.453990f, -0.468430f, -0.757935f,
    0.707107f, -0.371748f, -0.601501f,
    0.513375f, -0.564254f, -0.646578f,
    0.371748f, -0.601501f, -0.707107f,
    0.646578f, -0.513375f, -0.564254f,
    0.564254f, -0.646578f, -0.513375f,
    0.601501f, -0.707107f, -0.371748f,
    0.468430f, -0.757935f, -0.453990f,
    0.757935f, -0.453990f, -0.468430f,
    0.296005f, -0.702310f, -0.647412f,
    0.346153f, -0.783452f, -0.516122f,
    0.213023f, -0.792649f, -0.571252f,
    0.783452f, -0.516122f, -0.346153f,
    0.792649f, -0.571252f, -0.213023f,
    0.702310f, -0.647412f, -0.296005f,
    -0.571252f, 0.213023f, 0.792649f,
    -0.516122f, 0.346153f, 0.783452f,
    -0.647412f, 0.296005f, 0.702310f,
    -0.707107f, 0.371748f, 0.601501f,
    -0.453990f, 0.468430f, 0.757935f,
    -0.646578f, 0.513375f, 0.564254f,
    -0.757935f, 0.453990f, 0.468430f,
    -0.513375f, 0.564254f, 0.646578f,
    -0.564254f, 0.646578f, 0.513375f,
    -0.468430f, 0.757935f, 0.453990f,
    -0.601501f, 0.707107f, 0.371748f,
    -0.371748f, 0.601501f, 0.707107f,
    -0.783452f, 0.516122f, 0.346153f,
    -0.702310f, 0.647412f, 0.296005f,
    -0.792649f, 0.571252f, 0.213023f,
    -0.296005f, 0.702310f, 0.647412f,
    -0.213023f, 0.792649f, 0.571252f,
    -0.346153f, 0.783452f, 0.516122f,
    -0.571252f, 0.213023f, -0.792649f,
    -0.647412f, 0.296005f, -0.702310f,
    -0.516122f, 0.346153f, -0.783452f,
    -0.453990f, 0.468430f, -0.757935f,
    -0.707107f, 0.371748f, -0.601501f,
    -0.513375f, 0.564254f, -0.646578f,
    -0.371748f, 0.601501f, -0.707107f,
    -0.646578f, 0.513375f, -0.564254f,
    -0.564254f, 0.646578f, -0.513375f,
    -0.601501f, 0.707107f, -0.371748f,
    -0.468430f, 0.757935f, -0.453990f,
    -0.757935f, 0.453990f, -0.468430f,
    -0.296005f, 0.702310f, -0.647412f,
    -0.346153f, 0.783452f, -0.516122f,
    -0.213023f, 0.792649f, -0.571252f,
    -0.783452f, 0.516122f, -0.346153f,
    -0.792649f, 0.571252f, -0.213023f,
    -0.702310f, 0.647412f, -0.296005f,
    -0.571252f, -0.213023f, 0.792649f,
    -0.647412f, -0.296005f, 0.702310f,
    -0.516122f, -0.346153f, 0.783452f,
    -0.453990f, -0.468430f, 0.757935f,
    -0.707107f, -0.371748f, 0.601501f,
    -0.513375f, -0.564254f, 0.646578f,
    -0.371748f, -0.601501f, 0.707107f,
    -0.646578f, -0.513375f, 0.564254f,
    -0.564254f, -0.646578f, 0.513375f,
    -0.601501f, -0.707107f, 0.371748f,
    -0.468430f, -0.757935f, 0.453990f,
    -0.757935f, -0.453990f, 0.468430f,
    -0.296005f, -0.702310f, 0.647412f,
    -0.346153f, -0.783452f, 0.516122f,
    -0.213023f, -0.792649f, 0.571252f,
    -0.783452f, -0.516122f, 0.346153f,
    -0.792649f, -0.571252f, 0.213023f,
    -0.702310f, -0.647412f, 0.296005f,
    -0.571252f, -0.213023f, -0.792649f,
    -0.516122f, -0.346153f, -0.783452f,
    -0.647412f, -0.296005f, -0.702310f,
    -0.707107f, -0.371748f, -0.601501f,
    -0.453990f, -0.468430f, -0.757935f,
    -0.646578f, -0.513375f, -0.564254f,
    -0.757935f, -0.453990f, -0.468430f,
    -0.513375f, -0.564254f, -0.646578f,
    -0.564254f, -0.646578f, -0.513375f,
    -0.468430f, -0.757935f, -0.453990f,
    -0.601501f, -0.707107f, -0.371748f,
    -0.371748f, -0.601501f, -0.707107f,
    -0.783452f, -0.516122f, -0.346153f,
    -0.702310f, -0.647412f, -0.296005f,
    -0.792649f, -0.571252f, -0.213023f,
    -0.296005f, -0.702310f, -0.647412f,
    -0.213023f, -0.792649f, -0.571252f,
    -0.346153f, -0.783452f, -0.516122f
};

//////////////////////////////////////////////////////////////////////
// dane indeksw wierzchokw trjktw
//////////////////////////////////////////////////////////////////////
GLuint sphereHighIndices[SPHERE_HIGH_INDICES_COUNT * 3]=
{
    4, 162, 164,
    164, 162, 163,
    164, 163, 44,
    162, 42, 163,
    44, 163, 166,
    166, 163, 165,
    166, 165, 43,
    163, 42, 165,
    44, 166, 168,
    168, 166, 167,
    168, 167, 14,
    166, 43, 167,
    42, 169, 165,
    165, 169, 170,
    165, 170, 43,
    169, 12, 170,
    14, 167, 172,
    172, 167, 171,
    172, 171, 46,
    167, 43, 171,
    46, 171, 174,
    174, 171, 173,
    174, 173, 45,
    171, 43, 173,
    46, 174, 176,
    176, 174, 175,
    176, 175, 13,
    174, 45, 175,
    43, 170, 173,
    173, 170, 177,
    173, 177, 45,
    170, 12, 177,
    14, 172, 179,
    179, 172, 178,
    179, 178, 48,
    172, 46, 178,
    48, 178, 181,
    181, 178, 180,
    181, 180, 47,
    178, 46, 180,
    48, 181, 183,
    183, 181, 182,
    183, 182, 7,
    181, 47, 182,
    46, 176, 180,
    180, 176, 184,
    180, 184, 47,
    176, 13, 184,
    12, 185, 177,
    177, 185, 186,
    177, 186, 45,
    185, 49, 186,
    45, 186, 188,
    188, 186, 187,
    188, 187, 50,
    186, 49, 187,
    45, 188, 175,
    175, 188, 189,
    175, 189, 13,
    188, 50, 189,
    49, 190, 187,
    187, 190, 191,
    187, 191, 50,
    190, 8, 191,
    4, 164, 193,
    193, 164, 192,
    193, 192, 52,
    164, 44, 192,
    52, 192, 195,
    195, 192, 194,
    195, 194, 51,
    192, 44, 194,
    52, 195, 197,
    197, 195, 196,
    197, 196, 16,
    195, 51, 196,
    44, 168, 194,
    194, 168, 198,
    194, 198, 51,
    168, 14, 198,
    16, 196, 200,
    200, 196, 199,
    200, 199, 54,
    196, 51, 199,
    54, 199, 202,
    202, 199, 201,
    202, 201, 53,
    199, 51, 201,
    54, 202, 204,
    204, 202, 203,
    204, 203, 15,
    202, 53, 203,
    51, 198, 201,
    201, 198, 205,
    201, 205, 53,
    198, 14, 205,
    16, 200, 207,
    207, 200, 206,
    207, 206, 56,
    200, 54, 206,
    56, 206, 209,
    209, 206, 208,
    209, 208, 55,
    206, 54, 208,
    56, 209, 211,
    211, 209, 210,
    211, 210, 9,
    209, 55, 210,
    54, 204, 208,
    208, 204, 212,
    208, 212, 55,
    204, 15, 212,
    14, 179, 205,
    205, 179, 213,
    205, 213, 53,
    179, 48, 213,
    53, 213, 215,
    215, 213, 214,
    215, 214, 57,
    213, 48, 214,
    53, 215, 203,
    203, 215, 216,
    203, 216, 15,
    215, 57, 216,
    48, 183, 214,
    214, 183, 217,
    214, 217, 57,
    183, 7, 217,
    5, 218, 220,
    220, 218, 219,
    220, 219, 60,
    218, 58, 219,
    60, 219, 222,
    222, 219, 221,
    222, 221, 59,
    219, 58, 221,
    60, 222, 224,
    224, 222, 223,
    224, 223, 19,
    222, 59, 223,
    58, 225, 221,
    221, 225, 226,
    221, 226, 59,
    225, 17, 226,
    19, 223, 228,
    228, 223, 227,
    228, 227, 62,
    223, 59, 227,
    62, 227, 230,
    230, 227, 229,
    230, 229, 61,
    227, 59, 229,
    62, 230, 232,
    232, 230, 231,
    232, 231, 18,
    230, 61, 231,
    59, 226, 229,
    229, 226, 233,
    229, 233, 61,
    226, 17, 233,
    19, 228, 235,
    235, 228, 234,
    235, 234, 64,
    228, 62, 234,
    64, 234, 237,
    237, 234, 236,
    237, 236, 63,
    234, 62, 236,
    64, 237, 239,
    239, 237, 238,
    239, 238, 11,
    237, 63, 238,
    62, 232, 236,
    236, 232, 240,
    236, 240, 63,
    232, 18, 240,
    17, 241, 233,
    233, 241, 242,
    233, 242, 61,
    241, 65, 242,
    61, 242, 244,
    244, 242, 243,
    244, 243, 66,
    242, 65, 243,
    61, 244, 231,
    231, 244, 245,
    231, 245, 18,
    244, 66, 245,
    65, 246, 243,
    243, 246, 247,
    243, 247, 66,
    246, 6, 247,
    5, 248, 218,
    218, 248, 249,
    218, 249, 58,
    248, 67, 249,
    58, 249, 251,
    251, 249, 250,
    251, 250, 68,
    249, 67, 250,
    58, 251, 225,
    225, 251, 252,
    225, 252, 17,
    251, 68, 252,
    67, 253, 250,
    250, 253, 254,
    250, 254, 68,
    253, 20, 254,
    17, 252, 256,
    256, 252, 255,
    256, 255, 70,
    252, 68, 255,
    70, 255, 258,
    258, 255, 257,
    258, 257, 69,
    255, 68, 257,
    70, 258, 260,
    260, 258, 259,
    260, 259, 21,
    258, 69, 259,
    68, 254, 257,
    257, 254, 261,
    257, 261, 69,
    254, 20, 261,
    17, 256, 241,
    241, 256, 262,
    241, 262, 65,
    256, 70, 262,
    65, 262, 264,
    264, 262, 263,
    264, 263, 71,
    262, 70, 263,
    65, 264, 246,
    246, 264, 265,
    246, 265, 6,
    264, 71, 265,
    70, 260, 263,
    263, 260, 266,
    263, 266, 71,
    260, 21, 266,
    20, 267, 261,
    261, 267, 268,
    261, 268, 69,
    267, 72, 268,
    69, 268, 270,
    270, 268, 269,
    270, 269, 73,
    268, 72, 269,
    69, 270, 259,
    259, 270, 271,
    259, 271, 21,
    270, 73, 271,
    72, 272, 269,
    269, 272, 273,
    269, 273, 73,
    272, 10, 273,
    0, 274, 276,
    276, 274, 275,
    276, 275, 76,
    274, 74, 275,
    76, 275, 278,
    278, 275, 277,
    278, 277, 75,
    275, 74, 277,
    76, 278, 280,
    280, 278, 279,
    280, 279, 24,
    278, 75, 279,
    74, 281, 277,
    277, 281, 282,
    277, 282, 75,
    281, 22, 282,
    24, 279, 284,
    284, 279, 283,
    284, 283, 78,
    279, 75, 283,
    78, 283, 286,
    286, 283, 285,
    286, 285, 77,
    283, 75, 285,
    78, 286, 288,
    288, 286, 287,
    288, 287, 23,
    286, 77, 287,
    75, 282, 285,
    285, 282, 289,
    285, 289, 77,
    282, 22, 289,
    24, 284, 291,
    291, 284, 290,
    291, 290, 80,
    284, 78, 290,
    80, 290, 293,
    293, 290, 292,
    293, 292, 79,
    290, 78, 292,
    80, 293, 295,
    295, 293, 294,
    295, 294, 3,
    293, 79, 294,
    78, 288, 292,
    292, 288, 296,
    292, 296, 79,
    288, 23, 296,
    22, 297, 289,
    289, 297, 298,
    289, 298, 77,
    297, 81, 298,
    77, 298, 300,
    300, 298, 299,
    300, 299, 82,
    298, 81, 299,
    77, 300, 287,
    287, 300, 301,
    287, 301, 23,
    300, 82, 301,
    81, 302, 299,
    299, 302, 303,
    299, 303, 82,
    302, 4, 303,
    0, 276, 305,
    305, 276, 304,
    305, 304, 84,
    276, 76, 304,
    84, 304, 307,
    307, 304, 306,
    307, 306, 83,
    304, 76, 306,
    84, 307, 309,
    309, 307, 308,
    309, 308, 26,
    307, 83, 308,
    76, 280, 306,
    306, 280, 310,
    306, 310, 83,
    280, 24, 310,
    26, 308, 312,
    312, 308, 311,
    312, 311, 86,
    308, 83, 311,
    86, 311, 314,
    314, 311, 313,
    314, 313, 85,
    311, 83, 313,
    86, 314, 316,
    316, 314, 315,
    316, 315, 25,
    314, 85, 315,
    83, 310, 313,
    313, 310, 317,
    313, 317, 85,
    310, 24, 317,
    26, 312, 319,
    319, 312, 318,
    319, 318, 88,
    312, 86, 318,
    88, 318, 321,
    321, 318, 320,
    321, 320, 87,
    318, 86, 320,
    88, 321, 323,
    323, 321, 322,
    323, 322, 5,
    321, 87, 322,
    86, 316, 320,
    320, 316, 324,
    320, 324, 87,
    316, 25, 324,
    24, 291, 317,
    317, 291, 325,
    317, 325, 85,
    291, 80, 325,
    85, 325, 327,
    327, 325, 326,
    327, 326, 89,
    325, 80, 326,
    85, 327, 315,
    315, 327, 328,
    315, 328, 25,
    327, 89, 328,
    80, 295, 326,
    326, 295, 329,
    326, 329, 89,
    295, 3, 329,
    2, 330, 332,
    332, 330, 331,
    332, 331, 92,
    330, 90, 331,
    92, 331, 334,
    334, 331, 333,
    334, 333, 91,
    331, 90, 333,
    92, 334, 336,
    336, 334, 335,
    336, 335, 29,
    334, 91, 335,
    90, 337, 333,
    333, 337, 338,
    333, 338, 91,
    337, 27, 338,
    29, 335, 340,
    340, 335, 339,
    340, 339, 94,
    335, 91, 339,
    94, 339, 342,
    342, 339, 341,
    342, 341, 93,
    339, 91, 341,
    94, 342, 344,
    344, 342, 343,
    344, 343, 28,
    342, 93, 343,
    91, 338, 341,
    341, 338, 345,
    341, 345, 93,
    338, 27, 345,
    29, 340, 347,
    347, 340, 346,
    347, 346, 96,
    340, 94, 346,
    96, 346, 349,
    349, 346, 348,
    349, 348, 95,
    346, 94, 348,
    96, 349, 351,
    351, 349, 350,
    351, 350, 1,
    349, 95, 350,
    94, 344, 348,
    348, 344, 352,
    348, 352, 95,
    344, 28, 352,
    27, 353, 345,
    345, 353, 354,
    345, 354, 93,
    353, 97, 354,
    93, 354, 356,
    356, 354, 355,
    356, 355, 98,
    354, 97, 355,
    93, 356, 343,
    343, 356, 357,
    343, 357, 28,
    356, 98, 357,
    97, 358, 355,
    355, 358, 359,
    355, 359, 98,
    358, 7, 359,
    2, 332, 361,
    361, 332, 360,
    361, 360, 100,
    332, 92, 360,
    100, 360, 363,
    363, 360, 362,
    363, 362, 99,
    360, 92, 362,
    100, 363, 365,
    365, 363, 364,
    365, 364, 31,
    363, 99, 364,
    92, 336, 362,
    362, 336, 366,
    362, 366, 99,
    336, 29, 366,
    31, 364, 368,
    368, 364, 367,
    368, 367, 102,
    364, 99, 367,
    102, 367, 370,
    370, 367, 369,
    370, 369, 101,
    367, 99, 369,
    102, 370, 372,
    372, 370, 371,
    372, 371, 30,
    370, 101, 371,
    99, 366, 369,
    369, 366, 373,
    369, 373, 101,
    366, 29, 373,
    31, 368, 375,
    375, 368, 374,
    375, 374, 104,
    368, 102, 374,
    104, 374, 377,
    377, 374, 376,
    377, 376, 103,
    374, 102, 376,
    104, 377, 379,
    379, 377, 378,
    379, 378, 6,
    377, 103, 378,
    102, 372, 376,
    376, 372, 380,
    376, 380, 103,
    372, 30, 380,
    29, 347, 373,
    373, 347, 381,
    373, 381, 101,
    347, 96, 381,
    101, 381, 383,
    383, 381, 382,
    383, 382, 105,
    381, 96, 382,
    101, 383, 371,
    371, 383, 384,
    371, 384, 30,
    383, 105, 384,
    96, 351, 382,
    382, 351, 385,
    382, 385, 105,
    351, 1, 385,
    8, 386, 388,
    388, 386, 387,
    388, 387, 108,
    386, 106, 387,
    108, 387, 390,
    390, 387, 389,
    390, 389, 107,
    387, 106, 389,
    108, 390, 392,
    392, 390, 391,
    392, 391, 34,
    390, 107, 391,
    106, 393, 389,
    389, 393, 394,
    389, 394, 107,
    393, 32, 394,
    34, 391, 396,
    396, 391, 395,
    396, 395, 110,
    391, 107, 395,
    110, 395, 398,
    398, 395, 397,
    398, 397, 109,
    395, 107, 397,
    110, 398, 400,
    400, 398, 399,
    400, 399, 33,
    398, 109, 399,
    107, 394, 397,
    397, 394, 401,
    397, 401, 109,
    394, 32, 401,
    34, 396, 403,
    403, 396, 402,
    403, 402, 112,
    396, 110, 402,
    112, 402, 405,
    405, 402, 404,
    405, 404, 111,
    402, 110, 404,
    112, 405, 407,
    407, 405, 406,
    407, 406, 11,
    405, 111, 406,
    110, 400, 404,
    404, 400, 408,
    404, 408, 111,
    400, 33, 408,
    32, 409, 401,
    401, 409, 410,
    401, 410, 109,
    409, 113, 410,
    109, 410, 412,
    412, 410, 411,
    412, 411, 114,
    410, 113, 411,
    109, 412, 399,
    399, 412, 413,
    399, 413, 33,
    412, 114, 413,
    113, 414, 411,
    411, 414, 415,
    411, 415, 114,
    414, 0, 415,
    8, 388, 417,
    417, 388, 416,
    417, 416, 116,
    388, 108, 416,
    116, 416, 419,
    419, 416, 418,
    419, 418, 115,
    416, 108, 418,
    116, 419, 421,
    421, 419, 420,
    421, 420, 36,
    419, 115, 420,
    108, 392, 418,
    418, 392, 422,
    418, 422, 115,
    392, 34, 422,
    36, 420, 424,
    424, 420, 423,
    424, 423, 118,
    420, 115, 423,
    118, 423, 426,
    426, 423, 425,
    426, 425, 117,
    423, 115, 425,
    118, 426, 428,
    428, 426, 427,
    428, 427, 35,
    426, 117, 427,
    115, 422, 425,
    425, 422, 429,
    425, 429, 117,
    422, 34, 429,
    36, 424, 431,
    431, 424, 430,
    431, 430, 120,
    424, 118, 430,
    120, 430, 433,
    433, 430, 432,
    433, 432, 119,
    430, 118, 432,
    120, 433, 435,
    435, 433, 434,
    435, 434, 1,
    433, 119, 434,
    118, 428, 432,
    432, 428, 436,
    432, 436, 119,
    428, 35, 436,
    34, 403, 429,
    429, 403, 437,
    429, 437, 117,
    403, 112, 437,
    117, 437, 439,
    439, 437, 438,
    439, 438, 121,
    437, 112, 438,
    117, 439, 427,
    427, 439, 440,
    427, 440, 35,
    439, 121, 440,
    112, 407, 438,
    438, 407, 441,
    438, 441, 121,
    407, 11, 441,
    9, 442, 444,
    444, 442, 443,
    444, 443, 124,
    442, 122, 443,
    124, 443, 446,
    446, 443, 445,
    446, 445, 123,
    443, 122, 445,
    124, 446, 448,
    448, 446, 447,
    448, 447, 39,
    446, 123, 447,
    122, 449, 445,
    445, 449, 450,
    445, 450, 123,
    449, 37, 450,
    39, 447, 452,
    452, 447, 451,
    452, 451, 126,
    447, 123, 451,
    126, 451, 454,
    454, 451, 453,
    454, 453, 125,
    451, 123, 453,
    126, 454, 456,
    456, 454, 455,
    456, 455, 38,
    454, 125, 455,
    123, 450, 453,
    453, 450, 457,
    453, 457, 125,
    450, 37, 457,
    39, 452, 459,
    459, 452, 458,
    459, 458, 128,
    452, 126, 458,
    128, 458, 461,
    461, 458, 460,
    461, 460, 127,
    458, 126, 460,
    128, 461, 463,
    463, 461, 462,
    463, 462, 3,
    461, 127, 462,
    126, 456, 460,
    460, 456, 464,
    460, 464, 127,
    456, 38, 464,
    37, 465, 457,
    457, 465, 466,
    457, 466, 125,
    465, 129, 466,
    125, 466, 468,
    468, 466, 467,
    468, 467, 130,
    466, 129, 467,
    125, 468, 455,
    455, 468, 469,
    455, 469, 38,
    468, 130, 469,
    129, 470, 467,
    467, 470, 471,
    467, 471, 130,
    470, 10, 471,
    9, 472, 442,
    442, 472, 473,
    442, 473, 122,
    472, 131, 473,
    122, 473, 475,
    475, 473, 474,
    475, 474, 132,
    473, 131, 474,
    122, 475, 449,
    449, 475, 476,
    449, 476, 37,
    475, 132, 476,
    131, 477, 474,
    474, 477, 478,
    474, 478, 132,
    477, 40, 478,
    37, 476, 480,
    480, 476, 479,
    480, 479, 134,
    476, 132, 479,
    134, 479, 482,
    482, 479, 481,
    482, 481, 133,
    479, 132, 481,
    134, 482, 484,
    484, 482, 483,
    484, 483, 41,
    482, 133, 483,
    132, 478, 481,
    481, 478, 485,
    481, 485, 133,
    478, 40, 485,
    37, 480, 465,
    465, 480, 486,
    465, 486, 129,
    480, 134, 486,
    129, 486, 488,
    488, 486, 487,
    488, 487, 135,
    486, 134, 487,
    129, 488, 470,
    470, 488, 489,
    470, 489, 10,
    488, 135, 489,
    134, 484, 487,
    487, 484, 490,
    487, 490, 135,
    484, 41, 490,
    40, 491, 485,
    485, 491, 492,
    485, 492, 133,
    491, 136, 492,
    133, 492, 494,
    494, 492, 493,
    494, 493, 137,
    492, 136, 493,
    133, 494, 483,
    483, 494, 495,
    483, 495, 41,
    494, 137, 495,
    136, 496, 493,
    493, 496, 497,
    493, 497, 137,
    496, 2, 497,
    8, 190, 386,
    386, 190, 498,
    386, 498, 106,
    190, 49, 498,
    106, 498, 500,
    500, 498, 499,
    500, 499, 138,
    498, 49, 499,
    106, 500, 393,
    393, 500, 501,
    393, 501, 32,
    500, 138, 501,
    49, 185, 499,
    499, 185, 502,
    499, 502, 138,
    185, 12, 502,
    32, 501, 504,
    504, 501, 503,
    504, 503, 140,
    501, 138, 503,
    140, 503, 506,
    506, 503, 505,
    506, 505, 139,
    503, 138, 505,
    140, 506, 508,
    508, 506, 507,
    508, 507, 22,
    506, 139, 507,
    138, 502, 505,
    505, 502, 509,
    505, 509, 139,
    502, 12, 509,
    32, 504, 409,
    409, 504, 510,
    409, 510, 113,
    504, 140, 510,
    113, 510, 512,
    512, 510, 511,
    512, 511, 74,
    510, 140, 511,
    113, 512, 414,
    414, 512, 274,
    414, 274, 0,
    512, 74, 274,
    140, 508, 511,
    511, 508, 281,
    511, 281, 74,
    508, 22, 281,
    12, 169, 509,
    509, 169, 513,
    509, 513, 139,
    169, 42, 513,
    139, 513, 515,
    515, 513, 514,
    515, 514, 81,
    513, 42, 514,
    139, 515, 507,
    507, 515, 297,
    507, 297, 22,
    515, 81, 297,
    42, 162, 514,
    514, 162, 302,
    514, 302, 81,
    162, 4, 302,
    11, 406, 239,
    239, 406, 516,
    239, 516, 64,
    406, 111, 516,
    64, 516, 518,
    518, 516, 517,
    518, 517, 141,
    516, 111, 517,
    64, 518, 235,
    235, 518, 519,
    235, 519, 19,
    518, 141, 519,
    111, 408, 517,
    517, 408, 520,
    517, 520, 141,
    408, 33, 520,
    19, 519, 522,
    522, 519, 521,
    522, 521, 143,
    519, 141, 521,
    143, 521, 524,
    524, 521, 523,
    524, 523, 142,
    521, 141, 523,
    143, 524, 526,
    526, 524, 525,
    526, 525, 26,
    524, 142, 525,
    141, 520, 523,
    523, 520, 527,
    523, 527, 142,
    520, 33, 527,
    19, 522, 224,
    224, 522, 528,
    224, 528, 60,
    522, 143, 528,
    60, 528, 530,
    530, 528, 529,
    530, 529, 88,
    528, 143, 529,
    60, 530, 220,
    220, 530, 323,
    220, 323, 5,
    530, 88, 323,
    143, 526, 529,
    529, 526, 319,
    529, 319, 88,
    526, 26, 319,
    33, 413, 527,
    527, 413, 531,
    527, 531, 142,
    413, 114, 531,
    142, 531, 533,
    533, 531, 532,
    533, 532, 84,
    531, 114, 532,
    142, 533, 525,
    525, 533, 309,
    525, 309, 26,
    533, 84, 309,
    114, 415, 532,
    532, 415, 305,
    532, 305, 84,
    415, 0, 305,
    4, 193, 303,
    303, 193, 534,
    303, 534, 82,
    193, 52, 534,
    82, 534, 536,
    536, 534, 535,
    536, 535, 144,
    534, 52, 535,
    82, 536, 301,
    301, 536, 537,
    301, 537, 23,
    536, 144, 537,
    52, 197, 535,
    535, 197, 538,
    535, 538, 144,
    197, 16, 538,
    23, 537, 540,
    540, 537, 539,
    540, 539, 146,
    537, 144, 539,
    146, 539, 542,
    542, 539, 541,
    542, 541, 145,
    539, 144, 541,
    146, 542, 544,
    544, 542, 543,
    544, 543, 39,
    542, 145, 543,
    144, 538, 541,
    541, 538, 545,
    541, 545, 145,
    538, 16, 545,
    23, 540, 296,
    296, 540, 546,
    296, 546, 79,
    540, 146, 546,
    79, 546, 548,
    548, 546, 547,
    548, 547, 128,
    546, 146, 547,
    79, 548, 294,
    294, 548, 463,
    294, 463, 3,
    548, 128, 463,
    146, 544, 547,
    547, 544, 459,
    547, 459, 128,
    544, 39, 459,
    16, 207, 545,
    545, 207, 549,
    545, 549, 145,
    207, 56, 549,
    145, 549, 551,
    551, 549, 550,
    551, 550, 124,
    549, 56, 550,
    145, 551, 543,
    543, 551, 448,
    543, 448, 39,
    551, 124, 448,
    56, 211, 550,
    550, 211, 444,
    550, 444, 124,
    211, 9, 444,
    5, 322, 248,
    248, 322, 552,
    248, 552, 67,
    322, 87, 552,
    67, 552, 554,
    554, 552, 553,
    554, 553, 147,
    552, 87, 553,
    67, 554, 253,
    253, 554, 555,
    253, 555, 20,
    554, 147, 555,
    87, 324, 553,
    553, 324, 556,
    553, 556, 147,
    324, 25, 556,
    20, 555, 558,
    558, 555, 557,
    558, 557, 149,
    555, 147, 557,
    149, 557, 560,
    560, 557, 559,
    560, 559, 148,
    557, 147, 559,
    149, 560, 562,
    562, 560, 561,
    562, 561, 38,
    560, 148, 561,
    147, 556, 559,
    559, 556, 563,
    559, 563, 148,
    556, 25, 563,
    20, 558, 267,
    267, 558, 564,
    267, 564, 72,
    558, 149, 564,
    72, 564, 566,
    566, 564, 565,
    566, 565, 130,
    564, 149, 565,
    72, 566, 272,
    272, 566, 471,
    272, 471, 10,
    566, 130, 471,
    149, 562, 565,
    565, 562, 469,
    565, 469, 130,
    562, 38, 469,
    25, 328, 563,
    563, 328, 567,
    563, 567, 148,
    328, 89, 567,
    148, 567, 569,
    569, 567, 568,
    569, 568, 127,
    567, 89, 568,
    148, 569, 561,
    561, 569, 464,
    561, 464, 38,
    569, 127, 464,
    89, 329, 568,
    568, 329, 462,
    568, 462, 127,
    329, 3, 462,
    7, 182, 359,
    359, 182, 570,
    359, 570, 98,
    182, 47, 570,
    98, 570, 572,
    572, 570, 571,
    572, 571, 150,
    570, 47, 571,
    98, 572, 357,
    357, 572, 573,
    357, 573, 28,
    572, 150, 573,
    47, 184, 571,
    571, 184, 574,
    571, 574, 150,
    184, 13, 574,
    28, 573, 576,
    576, 573, 575,
    576, 575, 152,
    573, 150, 575,
    152, 575, 578,
    578, 575, 577,
    578, 577, 151,
    575, 150, 577,
    152, 578, 580,
    580, 578, 579,
    580, 579, 36,
    578, 151, 579,
    150, 574, 577,
    577, 574, 581,
    577, 581, 151,
    574, 13, 581,
    28, 576, 352,
    352, 576, 582,
    352, 582, 95,
    576, 152, 582,
    95, 582, 584,
    584, 582, 583,
    584, 583, 120,
    582, 152, 583,
    95, 584, 350,
    350, 584, 435,
    350, 435, 1,
    584, 120, 435,
    152, 580, 583,
    583, 580, 431,
    583, 431, 120,
    580, 36, 431,
    13, 189, 581,
    581, 189, 585,
    581, 585, 151,
    189, 50, 585,
    151, 585, 587,
    587, 585, 586,
    587, 586, 116,
    585, 50, 586,
    151, 587, 579,
    579, 587, 421,
    579, 421, 36,
    587, 116, 421,
    50, 191, 586,
    586, 191, 417,
    586, 417, 116,
    191, 8, 417,
    6, 378, 247,
    247, 378, 588,
    247, 588, 66,
    378, 103, 588,
    66, 588, 590,
    590, 588, 589,
    590, 589, 153,
    588, 103, 589,
    66, 590, 245,
    245, 590, 591,
    245, 591, 18,
    590, 153, 591,
    103, 380, 589,
    589, 380, 592,
    589, 592, 153,
    380, 30, 592,
    18, 591, 594,
    594, 591, 593,
    594, 593, 155,
    591, 153, 593,
    155, 593, 596,
    596, 593, 595,
    596, 595, 154,
    593, 153, 595,
    155, 596, 598,
    598, 596, 597,
    598, 597, 35,
    596, 154, 597,
    153, 592, 595,
    595, 592, 599,
    595, 599, 154,
    592, 30, 599,
    18, 594, 240,
    240, 594, 600,
    240, 600, 63,
    594, 155, 600,
    63, 600, 602,
    602, 600, 601,
    602, 601, 121,
    600, 155, 601,
    63, 602, 238,
    238, 602, 441,
    238, 441, 11,
    602, 121, 441,
    155, 598, 601,
    601, 598, 440,
    601, 440, 121,
    598, 35, 440,
    30, 384, 599,
    599, 384, 603,
    599, 603, 154,
    384, 105, 603,
    154, 603, 605,
    605, 603, 604,
    605, 604, 119,
    603, 105, 604,
    154, 605, 597,
    597, 605, 436,
    597, 436, 35,
    605, 119, 436,
    105, 385, 604,
    604, 385, 434,
    604, 434, 119,
    385, 1, 434,
    7, 358, 217,
    217, 358, 606,
    217, 606, 57,
    358, 97, 606,
    57, 606, 608,
    608, 606, 607,
    608, 607, 156,
    606, 97, 607,
    57, 608, 216,
    216, 608, 609,
    216, 609, 15,
    608, 156, 609,
    97, 353, 607,
    607, 353, 610,
    607, 610, 156,
    353, 27, 610,
    15, 609, 612,
    612, 609, 611,
    612, 611, 158,
    609, 156, 611,
    158, 611, 614,
    614, 611, 613,
    614, 613, 157,
    611, 156, 613,
    158, 614, 616,
    616, 614, 615,
    616, 615, 40,
    614, 157, 615,
    156, 610, 613,
    613, 610, 617,
    613, 617, 157,
    610, 27, 617,
    15, 612, 212,
    212, 612, 618,
    212, 618, 55,
    612, 158, 618,
    55, 618, 620,
    620, 618, 619,
    620, 619, 131,
    618, 158, 619,
    55, 620, 210,
    210, 620, 472,
    210, 472, 9,
    620, 131, 472,
    158, 616, 619,
    619, 616, 477,
    619, 477, 131,
    616, 40, 477,
    27, 337, 617,
    617, 337, 621,
    617, 621, 157,
    337, 90, 621,
    157, 621, 623,
    623, 621, 622,
    623, 622, 136,
    621, 90, 622,
    157, 623, 615,
    615, 623, 491,
    615, 491, 40,
    623, 136, 491,
    90, 330, 622,
    622, 330, 496,
    622, 496, 136,
    330, 2, 496,
    6, 265, 379,
    379, 265, 624,
    379, 624, 104,
    265, 71, 624,
    104, 624, 626,
    626, 624, 625,
    626, 625, 159,
    624, 71, 625,
    104, 626, 375,
    375, 626, 627,
    375, 627, 31,
    626, 159, 627,
    71, 266, 625,
    625, 266, 628,
    625, 628, 159,
    266, 21, 628,
    31, 627, 630,
    630, 627, 629,
    630, 629, 161,
    627, 159, 629,
    161, 629, 632,
    632, 629, 631,
    632, 631, 160,
    629, 159, 631,
    161, 632, 634,
    634, 632, 633,
    634, 633, 41,
    632, 160, 633,
    159, 628, 631,
    631, 628, 635,
    631, 635, 160,
    628, 21, 635,
    31, 630, 365,
    365, 630, 636,
    365, 636, 100,
    630, 161, 636,
    100, 636, 638,
    638, 636, 637,
    638, 637, 137,
    636, 161, 637,
    100, 638, 361,
    361, 638, 497,
    361, 497, 2,
    638, 137, 497,
    161, 634, 637,
    637, 634, 495,
    637, 495, 137,
    634, 41, 495,
    21, 271, 635,
    635, 271, 639,
    635, 639, 160,
    271, 73, 639,
    160, 639, 641,
    641, 639, 640,
    641, 640, 135,
    639, 73, 640,
    160, 641, 633,
    633, 641, 490,
    633, 490, 41,
    641, 135, 490,
    73, 273, 640,
    640, 273, 489,
    640, 489, 135,
    273, 10, 489
};

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw i zarazem wektorw normalnych
//////////////////////////////////////////////////////////////////////
GLfloat sphereVeryHighPositionNormal[SPHERE_VERY_HIGH_VERTEX_COUNT * 3] =
{
    0.850651f, 0.525731f, 0.000000f,
    -0.850651f, 0.525731f, 0.000000f,
    -0.850651f, -0.525731f, 0.000000f,
    0.850651f, -0.525731f, 0.000000f,
    0.525731f, 0.000000f, 0.850651f,
    0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, -0.850651f,
    -0.525731f, 0.000000f, 0.850651f,
    0.000000f, 0.850651f, 0.525731f,
    0.000000f, -0.850651f, 0.525731f,
    0.000000f, -0.850651f, -0.525731f,
    0.000000f, 0.850651f, -0.525731f,
    0.309017f, 0.500000f, 0.809017f,
    -0.309017f, 0.500000f, 0.809017f,
    0.000000f, 0.000000f, 1.000000f,
    -0.309017f, -0.500000f, 0.809017f,
    0.309017f, -0.500000f, 0.809017f,
    0.000000f, 0.000000f, -1.000000f,
    -0.309017f, 0.500000f, -0.809017f,
    0.309017f, 0.500000f, -0.809017f,
    0.309017f, -0.500000f, -0.809017f,
    -0.309017f, -0.500000f, -0.809017f,
    0.809017f, 0.309017f, 0.500000f,
    0.809017f, -0.309017f, 0.500000f,
    1.000000f, 0.000000f, 0.000000f,
    0.809017f, -0.309017f, -0.500000f,
    0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, 0.500000f,
    -0.809017f, 0.309017f, 0.500000f,
    -1.000000f, 0.000000f, 0.000000f,
    -0.809017f, 0.309017f, -0.500000f,
    -0.809017f, -0.309017f, -0.500000f,
    0.500000f, 0.809017f, 0.309017f,
    0.500000f, 0.809017f, -0.309017f,
    0.000000f, 1.000000f, 0.000000f,
    -0.500000f, 0.809017f, -0.309017f,
    -0.500000f, 0.809017f, 0.309017f,
    0.000000f, -1.000000f, 0.000000f,
    0.500000f, -0.809017f, -0.309017f,
    0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, 0.309017f,
    -0.500000f, -0.809017f, -0.309017f,
    0.433889f, 0.259892f, 0.862669f,
    0.162460f, 0.262866f, 0.951057f,
    0.273267f, 0.000000f, 0.961938f,
    0.000000f, 0.525731f, 0.850651f,
    -0.162460f, 0.262866f, 0.951057f,
    -0.433889f, 0.259892f, 0.862669f,
    -0.273267f, 0.000000f, 0.961938f,
    0.160622f, 0.702046f, 0.693780f,
    -0.160622f, 0.702046f, 0.693780f,
    0.162460f, -0.262866f, 0.951057f,
    0.433889f, -0.259892f, 0.862669f,
    -0.162460f, -0.262866f, 0.951057f,
    0.000000f, -0.525731f, 0.850651f,
    -0.160622f, -0.702046f, 0.693780f,
    0.160622f, -0.702046f, 0.693780f,
    -0.433889f, -0.259892f, 0.862669f,
    0.273267f, 0.000000f, -0.961938f,
    0.162460f, 0.262866f, -0.951057f,
    0.433889f, 0.259892f, -0.862669f,
    -0.162460f, 0.262866f, -0.951057f,
    0.000000f, 0.525731f, -0.850651f,
    -0.160622f, 0.702046f, -0.693780f,
    0.160622f, 0.702046f, -0.693780f,
    -0.273267f, 0.000000f, -0.961938f,
    -0.433889f, 0.259892f, -0.862669f,
    0.433889f, -0.259892f, -0.862669f,
    0.162460f, -0.262866f, -0.951057f,
    0.000000f, -0.525731f, -0.850651f,
    -0.162460f, -0.262866f, -0.951057f,
    -0.433889f, -0.259892f, -0.862669f,
    0.160622f, -0.702046f, -0.693780f,
    -0.160622f, -0.702046f, -0.693780f,
    0.862669f, 0.433889f, 0.259892f,
    0.951057f, 0.162460f, 0.262866f,
    0.961938f, 0.273267f, 0.000000f,
    0.850651f, 0.000000f, 0.525731f,
    0.951057f, -0.162460f, 0.262866f,
    0.862669f, -0.433889f, 0.259892f,
    0.961938f, -0.273267f, 0.000000f,
    0.693780f, 0.160622f, 0.702046f,
    0.693780f, -0.160622f, 0.702046f,
    0.951057f, 0.162460f, -0.262866f,
    0.862669f, 0.433889f, -0.259892f,
    0.951057f, -0.162460f, -0.262866f,
    0.850651f, 0.000000f, -0.525731f,
    0.693780f, -0.160622f, -0.702046f,
    0.693780f, 0.160622f, -0.702046f,
    0.862669f, -0.433889f, -0.259892f,
    -0.862669f, -0.433889f, 0.259892f,
    -0.951057f, -0.162460f, 0.262866f,
    -0.961938f, -0.273267f, 0.000000f,
    -0.850651f, 0.000000f, 0.525731f,
    -0.951057f, 0.162460f, 0.262866f,
    -0.862669f, 0.433889f, 0.259892f,
    -0.961938f, 0.273267f, 0.000000f,
    -0.693780f, -0.160622f, 0.702046f,
    -0.693780f, 0.160622f, 0.702046f,
    -0.951057f, -0.162460f, -0.262866f,
    -0.862669f, -0.433889f, -0.259892f,
    -0.951057f, 0.162460f, -0.262866f,
    -0.850651f, 0.000000f, -0.525731f,
    -0.693780f, 0.160622f, -0.702046f,
    -0.693780f, -0.160622f, -0.702046f,
    -0.862669f, 0.433889f, -0.259892f,
    0.259892f, 0.862669f, 0.433889f,
    0.262866f, 0.951057f, 0.162460f,
    0.000000f, 0.961938f, 0.273267f,
    0.525731f, 0.850651f, 0.000000f,
    0.262866f, 0.951057f, -0.162460f,
    0.259892f, 0.862669f, -0.433889f,
    0.000000f, 0.961938f, -0.273267f,
    0.702046f, 0.693780f, 0.160622f,
    0.702046f, 0.693780f, -0.160622f,
    -0.262866f, 0.951057f, 0.162460f,
    -0.259892f, 0.862669f, 0.433889f,
    -0.262866f, 0.951057f, -0.162460f,
    -0.525731f, 0.850651f, 0.000000f,
    -0.702046f, 0.693780f, -0.160622f,
    -0.702046f, 0.693780f, 0.160622f,
    -0.259892f, 0.862669f, -0.433889f,
    0.000000f, -0.961938f, 0.273267f,
    0.262866f, -0.951057f, 0.162460f,
    0.259892f, -0.862669f, 0.433889f,
    0.262866f, -0.951057f, -0.162460f,
    0.525731f, -0.850651f, 0.000000f,
    0.702046f, -0.693780f, -0.160622f,
    0.702046f, -0.693780f, 0.160622f,
    0.000000f, -0.961938f, -0.273267f,
    0.259892f, -0.862669f, -0.433889f,
    -0.259892f, -0.862669f, 0.433889f,
    -0.262866f, -0.951057f, 0.162460f,
    -0.525731f, -0.850651f, 0.000000f,
    -0.262866f, -0.951057f, -0.162460f,
    -0.259892f, -0.862669f, -0.433889f,
    -0.702046f, -0.693780f, 0.160622f,
    -0.702046f, -0.693780f, -0.160622f,
    0.425325f, 0.688191f, 0.587785f,
    0.587785f, 0.425325f, 0.688191f,
    0.688191f, 0.587785f, 0.425325f,
    0.425325f, 0.688191f, -0.587785f,
    0.688191f, 0.587785f, -0.425325f,
    0.587785f, 0.425325f, -0.688191f,
    0.587785f, -0.425325f, 0.688191f,
    0.425325f, -0.688191f, 0.587785f,
    0.688191f, -0.587785f, 0.425325f,
    0.587785f, -0.425325f, -0.688191f,
    0.688191f, -0.587785f, -0.425325f,
    0.425325f, -0.688191f, -0.587785f,
    -0.587785f, 0.425325f, 0.688191f,
    -0.425325f, 0.688191f, 0.587785f,
    -0.688191f, 0.587785f, 0.425325f,
    -0.587785f, 0.425325f, -0.688191f,
    -0.688191f, 0.587785f, -0.425325f,
    -0.425325f, 0.688191f, -0.587785f,
    -0.587785f, -0.425325f, 0.688191f,
    -0.688191f, -0.587785f, 0.425325f,
    -0.425325f, -0.688191f, 0.587785f,
    -0.587785f, -0.425325f, -0.688191f,
    -0.425325f, -0.688191f, -0.587785f,
    -0.688191f, -0.587785f, -0.425325f,
    0.484442f, 0.131200f, 0.864929f,
    0.358229f, 0.131655f, 0.924305f,
    0.403355f, 0.000000f, 0.915043f,
    0.301259f, 0.264083f, 0.916244f,
    0.220117f, 0.132792f, 0.966393f,
    0.082242f, 0.133071f, 0.987688f,
    0.137952f, 0.000000f, 0.990439f,
    0.375039f, 0.383614f, 0.843911f,
    0.238677f, 0.386187f, 0.891006f,
    0.000000f, 0.266405f, 0.963861f,
    -0.082242f, 0.133071f, 0.987688f,
    0.082324f, 0.399607f, 0.912982f,
    -0.082324f, 0.399607f, 0.912982f,
    -0.156434f, 0.519258f, 0.840178f,
    -0.238677f, 0.386187f, 0.891006f,
    0.156434f, 0.519258f, 0.840178f,
    -0.220117f, 0.132792f, 0.966393f,
    -0.137952f, 0.000000f, 0.990439f,
    -0.301259f, 0.264083f, 0.916244f,
    -0.358229f, 0.131655f, 0.924305f,
    -0.484442f, 0.131200f, 0.864929f,
    -0.403355f, 0.000000f, 0.915043f,
    -0.375039f, 0.383614f, 0.843911f,
    0.237086f, 0.606825f, 0.758652f,
    0.081142f, 0.620240f, 0.780204f,
    0.000000f, 0.711282f, 0.702907f,
    -0.081142f, 0.620240f, 0.780204f,
    -0.237086f, 0.606825f, 0.758652f,
    0.081086f, 0.783843f, 0.615642f,
    -0.081086f, 0.783843f, 0.615642f,
    0.358229f, -0.131655f, 0.924305f,
    0.484442f, -0.131200f, 0.864929f,
    0.220117f, -0.132792f, 0.966393f,
    0.301259f, -0.264083f, 0.916244f,
    0.238677f, -0.386187f, 0.891006f,
    0.375039f, -0.383614f, 0.843911f,
    0.082242f, -0.133071f, 0.987688f,
    0.082324f, -0.399607f, 0.912982f,
    0.156434f, -0.519258f, 0.840178f,
    0.000000f, -0.266405f, 0.963861f,
    -0.082324f, -0.399607f, 0.912982f,
    -0.238677f, -0.386187f, 0.891006f,
    -0.156434f, -0.519258f, 0.840178f,
    -0.082242f, -0.133071f, 0.987688f,
    0.081142f, -0.620240f, 0.780204f,
    0.237086f, -0.606825f, 0.758652f,
    -0.081142f, -0.620240f, 0.780204f,
    0.000000f, -0.711282f, 0.702907f,
    -0.081086f, -0.783843f, 0.615642f,
    0.081086f, -0.783843f, 0.615642f,
    -0.237086f, -0.606825f, 0.758652f,
    -0.220117f, -0.132792f, 0.966393f,
    -0.358229f, -0.131655f, 0.924305f,
    -0.301259f, -0.264083f, 0.916244f,
    -0.375039f, -0.383614f, 0.843911f,
    -0.484442f, -0.131200f, 0.864929f,
    0.403355f, 0.000000f, -0.915043f,
    0.358229f, 0.131655f, -0.924305f,
    0.484442f, 0.131200f, -0.864929f,
    0.220117f, 0.132792f, -0.966393f,
    0.301259f, 0.264083f, -0.916244f,
    0.238677f, 0.386187f, -0.891006f,
    0.375039f, 0.383614f, -0.843911f,
    0.137952f, 0.000000f, -0.990439f,
    0.082242f, 0.133071f, -0.987688f,
    0.082324f, 0.399607f, -0.912982f,
    0.156434f, 0.519258f, -0.840178f,
    0.000000f, 0.266405f, -0.963861f,
    -0.082324f, 0.399607f, -0.912982f,
    -0.238677f, 0.386187f, -0.891006f,
    -0.156434f, 0.519258f, -0.840178f,
    -0.082242f, 0.133071f, -0.987688f,
    0.081142f, 0.620240f, -0.780204f,
    0.237086f, 0.606825f, -0.758652f,
    -0.081142f, 0.620240f, -0.780204f,
    0.000000f, 0.711282f, -0.702907f,
    -0.081086f, 0.783843f, -0.615642f,
    0.081086f, 0.783843f, -0.615642f,
    -0.237086f, 0.606825f, -0.758652f,
    -0.137952f, 0.000000f, -0.990439f,
    -0.220117f, 0.132792f, -0.966393f,
    -0.358229f, 0.131655f, -0.924305f,
    -0.301259f, 0.264083f, -0.916244f,
    -0.375039f, 0.383614f, -0.843911f,
    -0.403355f, 0.000000f, -0.915043f,
    -0.484442f, 0.131200f, -0.864929f,
    0.484442f, -0.131200f, -0.864929f,
    0.358229f, -0.131655f, -0.924305f,
    0.301259f, -0.264083f, -0.916244f,
    0.220117f, -0.132792f, -0.966393f,
    0.082242f, -0.133071f, -0.987688f,
    0.375039f, -0.383614f, -0.843911f,
    0.238677f, -0.386187f, -0.891006f,
    0.000000f, -0.266405f, -0.963861f,
    -0.082242f, -0.133071f, -0.987688f,
    0.082324f, -0.399607f, -0.912982f,
    -0.082324f, -0.399607f, -0.912982f,
    -0.156434f, -0.519258f, -0.840178f,
    -0.238677f, -0.386187f, -0.891006f,
    0.156434f, -0.519258f, -0.840178f,
    -0.220117f, -0.132792f, -0.966393f,
    -0.301259f, -0.264083f, -0.916244f,
    -0.358229f, -0.131655f, -0.924305f,
    -0.484442f, -0.131200f, -0.864929f,
    -0.375039f, -0.383614f, -0.843911f,
    0.237086f, -0.606825f, -0.758652f,
    0.081142f, -0.620240f, -0.780204f,
    0.000000f, -0.711282f, -0.702907f,
    -0.081142f, -0.620240f, -0.780204f,
    -0.237086f, -0.606825f, -0.758652f,
    0.081086f, -0.783843f, -0.615642f,
    -0.081086f, -0.783843f, -0.615642f,
    0.864929f, 0.484442f, 0.131200f,
    0.924305f, 0.358229f, 0.131655f,
    0.915043f, 0.403355f, 0.000000f,
    0.916244f, 0.301259f, 0.264083f,
    0.966393f, 0.220117f, 0.132792f,
    0.987688f, 0.082242f, 0.133071f,
    0.990439f, 0.137952f, 0.000000f,
    0.843911f, 0.375039f, 0.383614f,
    0.891006f, 0.238677f, 0.386187f,
    0.963861f, 0.000000f, 0.266405f,
    0.987688f, -0.082242f, 0.133071f,
    0.912982f, 0.082324f, 0.399607f,
    0.912982f, -0.082324f, 0.399607f,
    0.840178f, -0.156434f, 0.519258f,
    0.891006f, -0.238677f, 0.386187f,
    0.840178f, 0.156434f, 0.519258f,
    0.966393f, -0.220117f, 0.132792f,
    0.990439f, -0.137952f, 0.000000f,
    0.916244f, -0.301259f, 0.264083f,
    0.924305f, -0.358229f, 0.131655f,
    0.864929f, -0.484442f, 0.131200f,
    0.915043f, -0.403355f, 0.000000f,
    0.843911f, -0.375039f, 0.383614f,
    0.758652f, 0.237086f, 0.606825f,
    0.780204f, 0.081142f, 0.620240f,
    0.702907f, 0.000000f, 0.711282f,
    0.780204f, -0.081142f, 0.620240f,
    0.758652f, -0.237086f, 0.606825f,
    0.615642f, 0.081086f, 0.783843f,
    0.615642f, -0.081086f, 0.783843f,
    0.924305f, 0.358229f, -0.131655f,
    0.864929f, 0.484442f, -0.131200f,
    0.966393f, 0.220117f, -0.132792f,
    0.916244f, 0.301259f, -0.264083f,
    0.891006f, 0.238677f, -0.386187f,
    0.843911f, 0.375039f, -0.383614f,
    0.987688f, 0.082242f, -0.133071f,
    0.912982f, 0.082324f, -0.399607f,
    0.840178f, 0.156434f, -0.519258f,
    0.963861f, 0.000000f, -0.266405f,
    0.912982f, -0.082324f, -0.399607f,
    0.891006f, -0.238677f, -0.386187f,
    0.840178f, -0.156434f, -0.519258f,
    0.987688f, -0.082242f, -0.133071f,
    0.780204f, 0.081142f, -0.620240f,
    0.758652f, 0.237086f, -0.606825f,
    0.780204f, -0.081142f, -0.620240f,
    0.702907f, 0.000000f, -0.711282f,
    0.615642f, -0.081086f, -0.783843f,
    0.615642f, 0.081086f, -0.783843f,
    0.758652f, -0.237086f, -0.606825f,
    0.966393f, -0.220117f, -0.132792f,
    0.924305f, -0.358229f, -0.131655f,
    0.916244f, -0.301259f, -0.264083f,
    0.843911f, -0.375039f, -0.383614f,
    0.864929f, -0.484442f, -0.131200f,
    -0.864929f, -0.484442f, 0.131200f,
    -0.924305f, -0.358229f, 0.131655f,
    -0.915043f, -0.403355f, 0.000000f,
    -0.916244f, -0.301259f, 0.264083f,
    -0.966393f, -0.220117f, 0.132792f,
    -0.987688f, -0.082242f, 0.133071f,
    -0.990439f, -0.137952f, 0.000000f,
    -0.843911f, -0.375039f, 0.383614f,
    -0.891006f, -0.238677f, 0.386187f,
    -0.963861f, 0.000000f, 0.266405f,
    -0.987688f, 0.082242f, 0.133071f,
    -0.912982f, -0.082324f, 0.399607f,
    -0.912982f, 0.082324f, 0.399607f,
    -0.840178f, 0.156434f, 0.519258f,
    -0.891006f, 0.238677f, 0.386187f,
    -0.840178f, -0.156434f, 0.519258f,
    -0.966393f, 0.220117f, 0.132792f,
    -0.990439f, 0.137952f, 0.000000f,
    -0.916244f, 0.301259f, 0.264083f,
    -0.924305f, 0.358229f, 0.131655f,
    -0.864929f, 0.484442f, 0.131200f,
    -0.915043f, 0.403355f, 0.000000f,
    -0.843911f, 0.375039f, 0.383614f,
    -0.758652f, -0.237086f, 0.606825f,
    -0.780204f, -0.081142f, 0.620240f,
    -0.702907f, 0.000000f, 0.711282f,
    -0.780204f, 0.081142f, 0.620240f,
    -0.758652f, 0.237086f, 0.606825f,
    -0.615642f, -0.081086f, 0.783843f,
    -0.615642f, 0.081086f, 0.783843f,
    -0.924305f, -0.358229f, -0.131655f,
    -0.864929f, -0.484442f, -0.131200f,
    -0.966393f, -0.220117f, -0.132792f,
    -0.916244f, -0.301259f, -0.264083f,
    -0.891006f, -0.238677f, -0.386187f,
    -0.843911f, -0.375039f, -0.383614f,
    -0.987688f, -0.082242f, -0.133071f,
    -0.912982f, -0.082324f, -0.399607f,
    -0.840178f, -0.156434f, -0.519258f,
    -0.963861f, 0.000000f, -0.266405f,
    -0.912982f, 0.082324f, -0.399607f,
    -0.891006f, 0.238677f, -0.386187f,
    -0.840178f, 0.156434f, -0.519258f,
    -0.987688f, 0.082242f, -0.133071f,
    -0.780204f, -0.081142f, -0.620240f,
    -0.758652f, -0.237086f, -0.606825f,
    -0.780204f, 0.081142f, -0.620240f,
    -0.702907f, 0.000000f, -0.711282f,
    -0.615642f, 0.081086f, -0.783843f,
    -0.615642f, -0.081086f, -0.783843f,
    -0.758652f, 0.237086f, -0.606825f,
    -0.966393f, 0.220117f, -0.132792f,
    -0.924305f, 0.358229f, -0.131655f,
    -0.916244f, 0.301259f, -0.264083f,
    -0.843911f, 0.375039f, -0.383614f,
    -0.864929f, 0.484442f, -0.131200f,
    0.131200f, 0.864929f, 0.484442f,
    0.131655f, 0.924305f, 0.358229f,
    0.000000f, 0.915043f, 0.403355f,
    0.264083f, 0.916244f, 0.301259f,
    0.132792f, 0.966393f, 0.220117f,
    0.133071f, 0.987688f, 0.082242f,
    0.000000f, 0.990439f, 0.137952f,
    0.383614f, 0.843911f, 0.375039f,
    0.386187f, 0.891006f, 0.238677f,
    0.266405f, 0.963861f, 0.000000f,
    0.133071f, 0.987688f, -0.082242f,
    0.399607f, 0.912982f, 0.082324f,
    0.399607f, 0.912982f, -0.082324f,
    0.519258f, 0.840178f, -0.156434f,
    0.386187f, 0.891006f, -0.238677f,
    0.519258f, 0.840178f, 0.156434f,
    0.132792f, 0.966393f, -0.220117f,
    0.000000f, 0.990439f, -0.137952f,
    0.264083f, 0.916244f, -0.301259f,
    0.131655f, 0.924305f, -0.358229f,
    0.131200f, 0.864929f, -0.484442f,
    0.000000f, 0.915043f, -0.403355f,
    0.383614f, 0.843911f, -0.375039f,
    0.606825f, 0.758652f, 0.237086f,
    0.620240f, 0.780204f, 0.081142f,
    0.711282f, 0.702907f, 0.000000f,
    0.620240f, 0.780204f, -0.081142f,
    0.606825f, 0.758652f, -0.237086f,
    0.783843f, 0.615642f, 0.081086f,
    0.783843f, 0.615642f, -0.081086f,
    -0.131655f, 0.924305f, 0.358229f,
    -0.131200f, 0.864929f, 0.484442f,
    -0.132792f, 0.966393f, 0.220117f,
    -0.264083f, 0.916244f, 0.301259f,
    -0.386187f, 0.891006f, 0.238677f,
    -0.383614f, 0.843911f, 0.375039f,
    -0.133071f, 0.987688f, 0.082242f,
    -0.399607f, 0.912982f, 0.082324f,
    -0.519258f, 0.840178f, 0.156434f,
    -0.266405f, 0.963861f, 0.000000f,
    -0.399607f, 0.912982f, -0.082324f,
    -0.386187f, 0.891006f, -0.238677f,
    -0.519258f, 0.840178f, -0.156434f,
    -0.133071f, 0.987688f, -0.082242f,
    -0.620240f, 0.780204f, 0.081142f,
    -0.606825f, 0.758652f, 0.237086f,
    -0.620240f, 0.780204f, -0.081142f,
    -0.711282f, 0.702907f, 0.000000f,
    -0.783843f, 0.615642f, -0.081086f,
    -0.783843f, 0.615642f, 0.081086f,
    -0.606825f, 0.758652f, -0.237086f,
    -0.132792f, 0.966393f, -0.220117f,
    -0.131655f, 0.924305f, -0.358229f,
    -0.264083f, 0.916244f, -0.301259f,
    -0.383614f, 0.843911f, -0.375039f,
    -0.131200f, 0.864929f, -0.484442f,
    0.000000f, -0.915043f, 0.403355f,
    0.131655f, -0.924305f, 0.358229f,
    0.131200f, -0.864929f, 0.484442f,
    0.132792f, -0.966393f, 0.220117f,
    0.264083f, -0.916244f, 0.301259f,
    0.386187f, -0.891006f, 0.238677f,
    0.383614f, -0.843911f, 0.375039f,
    0.000000f, -0.990439f, 0.137952f,
    0.133071f, -0.987688f, 0.082242f,
    0.399607f, -0.912982f, 0.082324f,
    0.519258f, -0.840178f, 0.156434f,
    0.266405f, -0.963861f, 0.000000f,
    0.399607f, -0.912982f, -0.082324f,
    0.386187f, -0.891006f, -0.238677f,
    0.519258f, -0.840178f, -0.156434f,
    0.133071f, -0.987688f, -0.082242f,
    0.620240f, -0.780204f, 0.081142f,
    0.606825f, -0.758652f, 0.237086f,
    0.620240f, -0.780204f, -0.081142f,
    0.711282f, -0.702907f, 0.000000f,
    0.783843f, -0.615642f, -0.081086f,
    0.783843f, -0.615642f, 0.081086f,
    0.606825f, -0.758652f, -0.237086f,
    0.000000f, -0.990439f, -0.137952f,
    0.132792f, -0.966393f, -0.220117f,
    0.131655f, -0.924305f, -0.358229f,
    0.264083f, -0.916244f, -0.301259f,
    0.383614f, -0.843911f, -0.375039f,
    0.000000f, -0.915043f, -0.403355f,
    0.131200f, -0.864929f, -0.484442f,
    -0.131200f, -0.864929f, 0.484442f,
    -0.131655f, -0.924305f, 0.358229f,
    -0.264083f, -0.916244f, 0.301259f,
    -0.132792f, -0.966393f, 0.220117f,
    -0.133071f, -0.987688f, 0.082242f,
    -0.383614f, -0.843911f, 0.375039f,
    -0.386187f, -0.891006f, 0.238677f,
    -0.266405f, -0.963861f, 0.000000f,
    -0.133071f, -0.987688f, -0.082242f,
    -0.399607f, -0.912982f, 0.082324f,
    -0.399607f, -0.912982f, -0.082324f,
    -0.519258f, -0.840178f, -0.156434f,
    -0.386187f, -0.891006f, -0.238677f,
    -0.519258f, -0.840178f, 0.156434f,
    -0.132792f, -0.966393f, -0.220117f,
    -0.264083f, -0.916244f, -0.301259f,
    -0.131655f, -0.924305f, -0.358229f,
    -0.131200f, -0.864929f, -0.484442f,
    -0.383614f, -0.843911f, -0.375039f,
    -0.606825f, -0.758652f, 0.237086f,
    -0.620240f, -0.780204f, 0.081142f,
    -0.711282f, -0.702907f, 0.000000f,
    -0.620240f, -0.780204f, -0.081142f,
    -0.606825f, -0.758652f, -0.237086f,
    -0.783843f, -0.615642f, 0.081086f,
    -0.783843f, -0.615642f, -0.081086f,
    0.213023f, 0.792649f, 0.571252f,
    0.296005f, 0.702310f, 0.647412f,
    0.346153f, 0.783452f, 0.516122f,
    0.468430f, 0.757935f, 0.453990f,
    0.371748f, 0.601501f, 0.707107f,
    0.564254f, 0.646578f, 0.513375f,
    0.601501f, 0.707107f, 0.371748f,
    0.513375f, 0.564254f, 0.646578f,
    0.646578f, 0.513375f, 0.564254f,
    0.707107f, 0.371748f, 0.601501f,
    0.757935f, 0.453990f, 0.468430f,
    0.453990f, 0.468430f, 0.757935f,
    0.702310f, 0.647412f, 0.296005f,
    0.783452f, 0.516122f, 0.346153f,
    0.792649f, 0.571252f, 0.213023f,
    0.516122f, 0.346153f, 0.783452f,
    0.571252f, 0.213023f, 0.792649f,
    0.647412f, 0.296005f, 0.702310f,
    0.213023f, 0.792649f, -0.571252f,
    0.346153f, 0.783452f, -0.516122f,
    0.296005f, 0.702310f, -0.647412f,
    0.371748f, 0.601501f, -0.707107f,
    0.468430f, 0.757935f, -0.453990f,
    0.513375f, 0.564254f, -0.646578f,
    0.453990f, 0.468430f, -0.757935f,
    0.564254f, 0.646578f, -0.513375f,
    0.646578f, 0.513375f, -0.564254f,
    0.757935f, 0.453990f, -0.468430f,
    0.707107f, 0.371748f, -0.601501f,
    0.601501f, 0.707107f, -0.371748f,
    0.516122f, 0.346153f, -0.783452f,
    0.647412f, 0.296005f, -0.702310f,
    0.571252f, 0.213023f, -0.792649f,
    0.702310f, 0.647412f, -0.296005f,
    0.792649f, 0.571252f, -0.213023f,
    0.783452f, 0.516122f, -0.346153f,
    0.571252f, -0.213023f, 0.792649f,
    0.516122f, -0.346153f, 0.783452f,
    0.647412f, -0.296005f, 0.702310f,
    0.707107f, -0.371748f, 0.601501f,
    0.453990f, -0.468430f, 0.757935f,
    0.646578f, -0.513375f, 0.564254f,
    0.757935f, -0.453990f, 0.468430f,
    0.513375f, -0.564254f, 0.646578f,
    0.564254f, -0.646578f, 0.513375f,
    0.468430f, -0.757935f, 0.453990f,
    0.601501f, -0.707107f, 0.371748f,
    0.371748f, -0.601501f, 0.707107f,
    0.783452f, -0.516122f, 0.346153f,
    0.702310f, -0.647412f, 0.296005f,
    0.792649f, -0.571252f, 0.213023f,
    0.296005f, -0.702310f, 0.647412f,
    0.213023f, -0.792649f, 0.571252f,
    0.346153f, -0.783452f, 0.516122f,
    0.571252f, -0.213023f, -0.792649f,
    0.647412f, -0.296005f, -0.702310f,
    0.516122f, -0.346153f, -0.783452f,
    0.453990f, -0.468430f, -0.757935f,
    0.707107f, -0.371748f, -0.601501f,
    0.513375f, -0.564254f, -0.646578f,
    0.371748f, -0.601501f, -0.707107f,
    0.646578f, -0.513375f, -0.564254f,
    0.564254f, -0.646578f, -0.513375f,
    0.601501f, -0.707107f, -0.371748f,
    0.468430f, -0.757935f, -0.453990f,
    0.757935f, -0.453990f, -0.468430f,
    0.296005f, -0.702310f, -0.647412f,
    0.346153f, -0.783452f, -0.516122f,
    0.213023f, -0.792649f, -0.571252f,
    0.783452f, -0.516122f, -0.346153f,
    0.792649f, -0.571252f, -0.213023f,
    0.702310f, -0.647412f, -0.296005f,
    -0.571252f, 0.213023f, 0.792649f,
    -0.516122f, 0.346153f, 0.783452f,
    -0.647412f, 0.296005f, 0.702310f,
    -0.707107f, 0.371748f, 0.601501f,
    -0.453990f, 0.468430f, 0.757935f,
    -0.646578f, 0.513375f, 0.564254f,
    -0.757935f, 0.453990f, 0.468430f,
    -0.513375f, 0.564254f, 0.646578f,
    -0.564254f, 0.646578f, 0.513375f,
    -0.468430f, 0.757935f, 0.453990f,
    -0.601501f, 0.707107f, 0.371748f,
    -0.371748f, 0.601501f, 0.707107f,
    -0.783452f, 0.516122f, 0.346153f,
    -0.702310f, 0.647412f, 0.296005f,
    -0.792649f, 0.571252f, 0.213023f,
    -0.296005f, 0.702310f, 0.647412f,
    -0.213023f, 0.792649f, 0.571252f,
    -0.346153f, 0.783452f, 0.516122f,
    -0.571252f, 0.213023f, -0.792649f,
    -0.647412f, 0.296005f, -0.702310f,
    -0.516122f, 0.346153f, -0.783452f,
    -0.453990f, 0.468430f, -0.757935f,
    -0.707107f, 0.371748f, -0.601501f,
    -0.513375f, 0.564254f, -0.646578f,
    -0.371748f, 0.601501f, -0.707107f,
    -0.646578f, 0.513375f, -0.564254f,
    -0.564254f, 0.646578f, -0.513375f,
    -0.601501f, 0.707107f, -0.371748f,
    -0.468430f, 0.757935f, -0.453990f,
    -0.757935f, 0.453990f, -0.468430f,
    -0.296005f, 0.702310f, -0.647412f,
    -0.346153f, 0.783452f, -0.516122f,
    -0.213023f, 0.792649f, -0.571252f,
    -0.783452f, 0.516122f, -0.346153f,
    -0.792649f, 0.571252f, -0.213023f,
    -0.702310f, 0.647412f, -0.296005f,
    -0.571252f, -0.213023f, 0.792649f,
    -0.647412f, -0.296005f, 0.702310f,
    -0.516122f, -0.346153f, 0.783452f,
    -0.453990f, -0.468430f, 0.757935f,
    -0.707107f, -0.371748f, 0.601501f,
    -0.513375f, -0.564254f, 0.646578f,
    -0.371748f, -0.601501f, 0.707107f,
    -0.646578f, -0.513375f, 0.564254f,
    -0.564254f, -0.646578f, 0.513375f,
    -0.601501f, -0.707107f, 0.371748f,
    -0.468430f, -0.757935f, 0.453990f,
    -0.757935f, -0.453990f, 0.468430f,
    -0.296005f, -0.702310f, 0.647412f,
    -0.346153f, -0.783452f, 0.516122f,
    -0.213023f, -0.792649f, 0.571252f,
    -0.783452f, -0.516122f, 0.346153f,
    -0.792649f, -0.571252f, 0.213023f,
    -0.702310f, -0.647412f, 0.296005f,
    -0.571252f, -0.213023f, -0.792649f,
    -0.516122f, -0.346153f, -0.783452f,
    -0.647412f, -0.296005f, -0.702310f,
    -0.707107f, -0.371748f, -0.601501f,
    -0.453990f, -0.468430f, -0.757935f,
    -0.646578f, -0.513375f, -0.564254f,
    -0.757935f, -0.453990f, -0.468430f,
    -0.513375f, -0.564254f, -0.646578f,
    -0.564254f, -0.646578f, -0.513375f,
    -0.468430f, -0.757935f, -0.453990f,
    -0.601501f, -0.707107f, -0.371748f,
    -0.371748f, -0.601501f, -0.707107f,
    -0.783452f, -0.516122f, -0.346153f,
    -0.702310f, -0.647412f, -0.296005f,
    -0.792649f, -0.571252f, -0.213023f,
    -0.296005f, -0.702310f, -0.647412f,
    -0.213023f, -0.792649f, -0.571252f,
    -0.346153f, -0.783452f, -0.516122f,
    0.506298f, 0.065758f, 0.859848f,
    0.445365f, 0.065817f, 0.892927f,
    0.465658f, 0.000000f, 0.884965f,
    0.422364f, 0.131749f, 0.896801f,
    0.381722f, 0.065988f, 0.921919f,
    0.316778f, 0.066042f, 0.946198f,
    0.339123f, 0.000000f, 0.940742f,
    0.460267f, 0.196015f, 0.865871f,
    0.397351f, 0.196412f, 0.896401f,
    0.289929f, 0.132570f, 0.947822f,
    0.247326f, 0.066567f, 0.966643f,
    0.330606f, 0.198387f, 0.922682f,
    0.261550f, 0.199094f, 0.944433f,
    0.232455f, 0.264151f, 0.936050f,
    0.191780f, 0.198337f, 0.961188f,
    0.368518f, 0.262661f, 0.891742f,
    0.179596f, 0.066604f, 0.981483f,
    0.206103f, 0.000000f, 0.978530f,
    0.151549f, 0.133256f, 0.979426f,
    0.110385f, 0.066709f, 0.991648f,
    0.041248f, 0.066741f, 0.996917f,
    0.069142f, 0.000000f, 0.997607f,
    0.122729f, 0.198580f, 0.972370f,
    0.405434f, 0.322525f, 0.855337f,
    0.339209f, 0.324864f, 0.882837f,
    0.307659f, 0.385906f, 0.869725f,
    0.270627f, 0.325929f, 0.905832f,
    0.201189f, 0.325530f, 0.923879f,
    0.342848f, 0.442867f, 0.828447f,
    0.274694f, 0.444464f, 0.852640f,
    0.000000f, 0.133523f, 0.991046f,
    -0.041248f, 0.066741f, 0.996917f,
    0.041251f, 0.200368f, 0.978852f,
    -0.041251f, 0.200368f, 0.978852f,
    -0.081501f, 0.265518f, 0.960655f,
    -0.122729f, 0.198580f, 0.972370f,
    0.081501f, 0.265518f, 0.960655f,
    -0.041302f, 0.334140f, 0.941618f,
    -0.122800f, 0.332342f, 0.935130f,
    0.041302f, 0.334140f, 0.941618f,
    0.000000f, 0.400968f, 0.916092f,
    0.041299f, 0.464213f, 0.884760f,
    -0.041299f, 0.464213f, 0.884760f,
    0.122800f, 0.332342f, 0.935130f,
    -0.161006f, 0.394136f, 0.904839f,
    -0.201189f, 0.325530f, 0.923879f,
    -0.119755f, 0.460882f, 0.879344f,
    -0.198227f, 0.454262f, 0.868535f,
    -0.233445f, 0.511205f, 0.827147f,
    -0.274694f, 0.444464f, 0.852640f,
    -0.078459f, 0.524110f, 0.848029f,
    0.161006f, 0.394136f, 0.904839f,
    0.198227f, 0.454262f, 0.868535f,
    0.119755f, 0.460882f, 0.879344f,
    0.078459f, 0.524110f, 0.848029f,
    0.233445f, 0.511205f, 0.827147f,
    -0.110385f, 0.066709f, 0.991648f,
    -0.069142f, 0.000000f, 0.997607f,
    -0.151549f, 0.133256f, 0.979426f,
    -0.179596f, 0.066604f, 0.981483f,
    -0.247326f, 0.066567f, 0.966643f,
    -0.206103f, 0.000000f, 0.978530f,
    -0.191780f, 0.198337f, 0.961188f,
    -0.289929f, 0.132570f, 0.947822f,
    -0.316778f, 0.066042f, 0.946198f,
    -0.261550f, 0.199094f, 0.944433f,
    -0.330606f, 0.198387f, 0.922682f,
    -0.368518f, 0.262661f, 0.891742f,
    -0.397351f, 0.196412f, 0.896401f,
    -0.232455f, 0.264151f, 0.936050f,
    -0.381722f, 0.065988f, 0.921919f,
    -0.339123f, 0.000000f, 0.940742f,
    -0.422364f, 0.131749f, 0.896801f,
    -0.445365f, 0.065817f, 0.892927f,
    -0.506298f, 0.065758f, 0.859848f,
    -0.465658f, 0.000000f, 0.884965f,
    -0.460267f, 0.196015f, 0.865871f,
    -0.270627f, 0.325929f, 0.905832f,
    -0.307659f, 0.385906f, 0.869725f,
    -0.339209f, 0.324864f, 0.882837f,
    -0.405434f, 0.322525f, 0.855337f,
    -0.342848f, 0.442867f, 0.828447f,
    0.273707f, 0.554740f, 0.785715f,
    0.197274f, 0.564513f, 0.801504f,
    0.159613f, 0.615456f, 0.771841f,
    0.119078f, 0.571140f, 0.812169f,
    0.040675f, 0.574458f, 0.817523f,
    0.199331f, 0.656006f, 0.727958f,
    0.121193f, 0.662842f, 0.738886f,
    0.000000f, 0.622292f, 0.782786f,
    -0.040675f, 0.574458f, 0.817523f,
    0.040677f, 0.667502f, 0.743496f,
    -0.040677f, 0.667502f, 0.743496f,
    -0.080573f, 0.708969f, 0.700622f,
    -0.121193f, 0.662842f, 0.738886f,
    0.080573f, 0.708969f, 0.700622f,
    -0.119078f, 0.571140f, 0.812169f,
    -0.159613f, 0.615456f, 0.771841f,
    -0.197274f, 0.564513f, 0.801504f,
    -0.273707f, 0.554740f, 0.785715f,
    -0.199331f, 0.656006f, 0.727958f,
    0.121144f, 0.744727f, 0.656282f,
    0.040642f, 0.749387f, 0.660884f,
    0.000000f, 0.786433f, 0.617676f,
    -0.040642f, 0.749387f, 0.660884f,
    -0.121144f, 0.744727f, 0.656282f,
    0.040640f, 0.819207f, 0.572056f,
    -0.040640f, 0.819207f, 0.572056f,
    0.445365f, -0.065817f, 0.892927f,
    0.506298f, -0.065758f, 0.859848f,
    0.381722f, -0.065988f, 0.921919f,
    0.422364f, -0.131749f, 0.896801f,
    0.397351f, -0.196412f, 0.896401f,
    0.460267f, -0.196015f, 0.865871f,
    0.316778f, -0.066042f, 0.946198f,
    0.330606f, -0.198387f, 0.922682f,
    0.368518f, -0.262661f, 0.891742f,
    0.289929f, -0.132570f, 0.947822f,
    0.261550f, -0.199094f, 0.944433f,
    0.191780f, -0.198337f, 0.961188f,
    0.232455f, -0.264151f, 0.936050f,
    0.247326f, -0.066567f, 0.966643f,
    0.339209f, -0.324864f, 0.882837f,
    0.405434f, -0.322525f, 0.855337f,
    0.270627f, -0.325929f, 0.905832f,
    0.307659f, -0.385906f, 0.869725f,
    0.274694f, -0.444464f, 0.852640f,
    0.342848f, -0.442867f, 0.828447f,
    0.201189f, -0.325530f, 0.923879f,
    0.179596f, -0.066604f, 0.981483f,
    0.110385f, -0.066709f, 0.991648f,
    0.151549f, -0.133256f, 0.979426f,
    0.122729f, -0.198580f, 0.972370f,
    0.041248f, -0.066741f, 0.996917f,
    0.198227f, -0.454262f, 0.868535f,
    0.233445f, -0.511205f, 0.827147f,
    0.161006f, -0.394136f, 0.904839f,
    0.119755f, -0.460882f, 0.879344f,
    0.041299f, -0.464213f, 0.884760f,
    0.078459f, -0.524110f, 0.848029f,
    0.122800f, -0.332342f, 0.935130f,
    0.000000f, -0.400968f, 0.916092f,
    -0.041299f, -0.464213f, 0.884760f,
    0.041302f, -0.334140f, 0.941618f,
    -0.041302f, -0.334140f, 0.941618f,
    -0.081501f, -0.265518f, 0.960655f,
    -0.122800f, -0.332342f, 0.935130f,
    0.081501f, -0.265518f, 0.960655f,
    -0.119755f, -0.460882f, 0.879344f,
    -0.078459f, -0.524110f, 0.848029f,
    -0.161006f, -0.394136f, 0.904839f,
    -0.198227f, -0.454262f, 0.868535f,
    -0.274694f, -0.444464f, 0.852640f,
    -0.233445f, -0.511205f, 0.827147f,
    -0.201189f, -0.325530f, 0.923879f,
    0.041251f, -0.200368f, 0.978852f,
    0.000000f, -0.133523f, 0.991046f,
    -0.041251f, -0.200368f, 0.978852f,
    -0.122729f, -0.198580f, 0.972370f,
    -0.041248f, -0.066741f, 0.996917f,
    0.197274f, -0.564513f, 0.801504f,
    0.273707f, -0.554740f, 0.785715f,
    0.119078f, -0.571140f, 0.812169f,
    0.159613f, -0.615456f, 0.771841f,
    0.121193f, -0.662842f, 0.738886f,
    0.199331f, -0.656006f, 0.727958f,
    0.040675f, -0.574458f, 0.817523f,
    0.040677f, -0.667502f, 0.743496f,
    0.080573f, -0.708969f, 0.700622f,
    0.000000f, -0.622292f, 0.782786f,
    -0.040677f, -0.667502f, 0.743496f,
    -0.121193f, -0.662842f, 0.738886f,
    -0.080573f, -0.708969f, 0.700622f,
    -0.040675f, -0.574458f, 0.817523f,
    0.040642f, -0.749387f, 0.660884f,
    0.121144f, -0.744727f, 0.656282f,
    -0.040642f, -0.749387f, 0.660884f,
    0.000000f, -0.786433f, 0.617676f,
    -0.040640f, -0.819207f, 0.572056f,
    0.040640f, -0.819207f, 0.572056f,
    -0.121144f, -0.744727f, 0.656282f,
    -0.119078f, -0.571140f, 0.812169f,
    -0.197274f, -0.564513f, 0.801504f,
    -0.159613f, -0.615456f, 0.771841f,
    -0.199331f, -0.656006f, 0.727958f,
    -0.273707f, -0.554740f, 0.785715f,
    -0.110385f, -0.066709f, 0.991648f,
    -0.179596f, -0.066604f, 0.981483f,
    -0.151549f, -0.133256f, 0.979426f,
    -0.191780f, -0.198337f, 0.961188f,
    -0.247326f, -0.066567f, 0.966643f,
    -0.261550f, -0.199094f, 0.944433f,
    -0.232455f, -0.264151f, 0.936050f,
    -0.289929f, -0.132570f, 0.947822f,
    -0.330606f, -0.198387f, 0.922682f,
    -0.397351f, -0.196412f, 0.896401f,
    -0.368518f, -0.262661f, 0.891742f,
    -0.316778f, -0.066042f, 0.946198f,
    -0.270627f, -0.325929f, 0.905832f,
    -0.339209f, -0.324864f, 0.882837f,
    -0.307659f, -0.385906f, 0.869725f,
    -0.342848f, -0.442867f, 0.828447f,
    -0.405434f, -0.322525f, 0.855337f,
    -0.381722f, -0.065988f, 0.921919f,
    -0.445365f, -0.065817f, 0.892927f,
    -0.422364f, -0.131749f, 0.896801f,
    -0.460267f, -0.196015f, 0.865871f,
    -0.506298f, -0.065758f, 0.859848f,
    0.465658f, 0.000000f, -0.884965f,
    0.445365f, 0.065817f, -0.892927f,
    0.506298f, 0.065758f, -0.859848f,
    0.381722f, 0.065988f, -0.921919f,
    0.422364f, 0.131749f, -0.896801f,
    0.397351f, 0.196412f, -0.896401f,
    0.460267f, 0.196015f, -0.865871f,
    0.339123f, 0.000000f, -0.940742f,
    0.316778f, 0.066042f, -0.946198f,
    0.330606f, 0.198387f, -0.922682f,
    0.368518f, 0.262661f, -0.891742f,
    0.289929f, 0.132570f, -0.947822f,
    0.261550f, 0.199094f, -0.944433f,
    0.191780f, 0.198337f, -0.961188f,
    0.232455f, 0.264151f, -0.936050f,
    0.247326f, 0.066567f, -0.966643f,
    0.339209f, 0.324864f, -0.882837f,
    0.405434f, 0.322525f, -0.855337f,
    0.270627f, 0.325929f, -0.905832f,
    0.307659f, 0.385906f, -0.869725f,
    0.274694f, 0.444464f, -0.852640f,
    0.342848f, 0.442867f, -0.828447f,
    0.201189f, 0.325530f, -0.923879f,
    0.206103f, 0.000000f, -0.978530f,
    0.179596f, 0.066604f, -0.981483f,
    0.110385f, 0.066709f, -0.991648f,
    0.151549f, 0.133256f, -0.979426f,
    0.122729f, 0.198580f, -0.972370f,
    0.069142f, 0.000000f, -0.997607f,
    0.041248f, 0.066741f, -0.996917f,
    0.198227f, 0.454262f, -0.868535f,
    0.233445f, 0.511205f, -0.827147f,
    0.161006f, 0.394136f, -0.904839f,
    0.119755f, 0.460882f, -0.879344f,
    0.041299f, 0.464213f, -0.884760f,
    0.078459f, 0.524110f, -0.848029f,
    0.122800f, 0.332342f, -0.935130f,
    0.000000f, 0.400968f, -0.916092f,
    -0.041299f, 0.464213f, -0.884760f,
    0.041302f, 0.334140f, -0.941618f,
    -0.041302f, 0.334140f, -0.941618f,
    -0.081501f, 0.265518f, -0.960655f,
    -0.122800f, 0.332342f, -0.935130f,
    0.081501f, 0.265518f, -0.960655f,
    -0.119755f, 0.460882f, -0.879344f,
    -0.078459f, 0.524110f, -0.848029f,
    -0.161006f, 0.394136f, -0.904839f,
    -0.198227f, 0.454262f, -0.868535f,
    -0.274694f, 0.444464f, -0.852640f,
    -0.233445f, 0.511205f, -0.827147f,
    -0.201189f, 0.325530f, -0.923879f,
    0.041251f, 0.200368f, -0.978852f,
    0.000000f, 0.133523f, -0.991046f,
    -0.041251f, 0.200368f, -0.978852f,
    -0.122729f, 0.198580f, -0.972370f,
    -0.041248f, 0.066741f, -0.996917f,
    0.197274f, 0.564513f, -0.801504f,
    0.273707f, 0.554740f, -0.785715f,
    0.119078f, 0.571140f, -0.812169f,
    0.159613f, 0.615456f, -0.771841f,
    0.121193f, 0.662842f, -0.738886f,
    0.199331f, 0.656006f, -0.727958f,
    0.040675f, 0.574458f, -0.817523f,
    0.040677f, 0.667502f, -0.743496f,
    0.080573f, 0.708969f, -0.700622f,
    0.000000f, 0.622292f, -0.782786f,
    -0.040677f, 0.667502f, -0.743496f,
    -0.121193f, 0.662842f, -0.738886f,
    -0.080573f, 0.708969f, -0.700622f,
    -0.040675f, 0.574458f, -0.817523f,
    0.040642f, 0.749387f, -0.660884f,
    0.121144f, 0.744727f, -0.656282f,
    -0.040642f, 0.749387f, -0.660884f,
    0.000000f, 0.786433f, -0.617676f,
    -0.040640f, 0.819207f, -0.572056f,
    0.040640f, 0.819207f, -0.572056f,
    -0.121144f, 0.744727f, -0.656282f,
    -0.119078f, 0.571140f, -0.812169f,
    -0.197274f, 0.564513f, -0.801504f,
    -0.159613f, 0.615456f, -0.771841f,
    -0.199331f, 0.656006f, -0.727958f,
    -0.273707f, 0.554740f, -0.785715f,
    -0.069142f, 0.000000f, -0.997607f,
    -0.110385f, 0.066709f, -0.991648f,
    -0.179596f, 0.066604f, -0.981483f,
    -0.151549f, 0.133256f, -0.979426f,
    -0.191780f, 0.198337f, -0.961188f,
    -0.206103f, 0.000000f, -0.978530f,
    -0.247326f, 0.066567f, -0.966643f,
    -0.261550f, 0.199094f, -0.944433f,
    -0.232455f, 0.264151f, -0.936050f,
    -0.289929f, 0.132570f, -0.947822f,
    -0.330606f, 0.198387f, -0.922682f,
    -0.397351f, 0.196412f, -0.896401f,
    -0.368518f, 0.262661f, -0.891742f,
    -0.316778f, 0.066042f, -0.946198f,
    -0.270627f, 0.325929f, -0.905832f,
    -0.339209f, 0.324864f, -0.882837f,
    -0.307659f, 0.385906f, -0.869725f,
    -0.342848f, 0.442867f, -0.828447f,
    -0.405434f, 0.322525f, -0.855337f,
    -0.339123f, 0.000000f, -0.940742f,
    -0.381722f, 0.065988f, -0.921919f,
    -0.445365f, 0.065817f, -0.892927f,
    -0.422364f, 0.131749f, -0.896801f,
    -0.460267f, 0.196015f, -0.865871f,
    -0.465658f, 0.000000f, -0.884965f,
    -0.506298f, 0.065758f, -0.859848f,
    0.506298f, -0.065758f, -0.859848f,
    0.445365f, -0.065817f, -0.892927f,
    0.422364f, -0.131749f, -0.896801f,
    0.381722f, -0.065988f, -0.921919f,
    0.316778f, -0.066042f, -0.946198f,
    0.460267f, -0.196015f, -0.865871f,
    0.397351f, -0.196412f, -0.896401f,
    0.289929f, -0.132570f, -0.947822f,
    0.247326f, -0.066567f, -0.966643f,
    0.330606f, -0.198387f, -0.922682f,
    0.261550f, -0.199094f, -0.944433f,
    0.232455f, -0.264151f, -0.936050f,
    0.191780f, -0.198337f, -0.961188f,
    0.368518f, -0.262661f, -0.891742f,
    0.179596f, -0.066604f, -0.981483f,
    0.151549f, -0.133256f, -0.979426f,
    0.110385f, -0.066709f, -0.991648f,
    0.041248f, -0.066741f, -0.996917f,
    0.122729f, -0.198580f, -0.972370f,
    0.405434f, -0.322525f, -0.855337f,
    0.339209f, -0.324864f, -0.882837f,
    0.307659f, -0.385906f, -0.869725f,
    0.270627f, -0.325929f, -0.905832f,
    0.201189f, -0.325530f, -0.923879f,
    0.342848f, -0.442867f, -0.828447f,
    0.274694f, -0.444464f, -0.852640f,
    0.000000f, -0.133523f, -0.991046f,
    -0.041248f, -0.066741f, -0.996917f,
    0.041251f, -0.200368f, -0.978852f,
    -0.041251f, -0.200368f, -0.978852f,
    -0.081501f, -0.265518f, -0.960655f,
    -0.122729f, -0.198580f, -0.972370f,
    0.081501f, -0.265518f, -0.960655f,
    -0.041302f, -0.334140f, -0.941618f,
    -0.122800f, -0.332342f, -0.935130f,
    0.041302f, -0.334140f, -0.941618f,
    0.000000f, -0.400968f, -0.916092f,
    0.041299f, -0.464213f, -0.884760f,
    -0.041299f, -0.464213f, -0.884760f,
    0.122800f, -0.332342f, -0.935130f,
    -0.161006f, -0.394136f, -0.904839f,
    -0.201189f, -0.325530f, -0.923879f,
    -0.119755f, -0.460882f, -0.879344f,
    -0.198227f, -0.454262f, -0.868535f,
    -0.233445f, -0.511205f, -0.827147f,
    -0.274694f, -0.444464f, -0.852640f,
    -0.078459f, -0.524110f, -0.848029f,
    0.161006f, -0.394136f, -0.904839f,
    0.198227f, -0.454262f, -0.868535f,
    0.119755f, -0.460882f, -0.879344f,
    0.078459f, -0.524110f, -0.848029f,
    0.233445f, -0.511205f, -0.827147f,
    -0.110385f, -0.066709f, -0.991648f,
    -0.151549f, -0.133256f, -0.979426f,
    -0.179596f, -0.066604f, -0.981483f,
    -0.247326f, -0.066567f, -0.966643f,
    -0.191780f, -0.198337f, -0.961188f,
    -0.289929f, -0.132570f, -0.947822f,
    -0.316778f, -0.066042f, -0.946198f,
    -0.261550f, -0.199094f, -0.944433f,
    -0.330606f, -0.198387f, -0.922682f,
    -0.368518f, -0.262661f, -0.891742f,
    -0.397351f, -0.196412f, -0.896401f,
    -0.232455f, -0.264151f, -0.936050f,
    -0.381722f, -0.065988f, -0.921919f,
    -0.422364f, -0.131749f, -0.896801f,
    -0.445365f, -0.065817f, -0.892927f,
    -0.506298f, -0.065758f, -0.859848f,
    -0.460267f, -0.196015f, -0.865871f,
    -0.270627f, -0.325929f, -0.905832f,
    -0.307659f, -0.385906f, -0.869725f,
    -0.339209f, -0.324864f, -0.882837f,
    -0.405434f, -0.322525f, -0.855337f,
    -0.342848f, -0.442867f, -0.828447f,
    0.273707f, -0.554740f, -0.785715f,
    0.197274f, -0.564513f, -0.801504f,
    0.159613f, -0.615456f, -0.771841f,
    0.119078f, -0.571140f, -0.812169f,
    0.040675f, -0.574458f, -0.817523f,
    0.199331f, -0.656006f, -0.727958f,
    0.121193f, -0.662842f, -0.738886f,
    0.000000f, -0.622292f, -0.782786f,
    -0.040675f, -0.574458f, -0.817523f,
    0.040677f, -0.667502f, -0.743496f,
    -0.040677f, -0.667502f, -0.743496f,
    -0.080573f, -0.708969f, -0.700622f,
    -0.121193f, -0.662842f, -0.738886f,
    0.080573f, -0.708969f, -0.700622f,
    -0.119078f, -0.571140f, -0.812169f,
    -0.159613f, -0.615456f, -0.771841f,
    -0.197274f, -0.564513f, -0.801504f,
    -0.273707f, -0.554740f, -0.785715f,
    -0.199331f, -0.656006f, -0.727958f,
    0.121144f, -0.744727f, -0.656282f,
    0.040642f, -0.749387f, -0.660884f,
    0.000000f, -0.786433f, -0.617676f,
    -0.040642f, -0.749387f, -0.660884f,
    -0.121144f, -0.744727f, -0.656282f,
    0.040640f, -0.819207f, -0.572056f,
    -0.040640f, -0.819207f, -0.572056f,
    0.859848f, 0.506298f, 0.065758f,
    0.892927f, 0.445365f, 0.065817f,
    0.884965f, 0.465658f, 0.000000f,
    0.896801f, 0.422364f, 0.131749f,
    0.921919f, 0.381722f, 0.065988f,
    0.946198f, 0.316778f, 0.066042f,
    0.940742f, 0.339123f, 0.000000f,
    0.865871f, 0.460267f, 0.196015f,
    0.896401f, 0.397351f, 0.196412f,
    0.947822f, 0.289929f, 0.132570f,
    0.966643f, 0.247326f, 0.066567f,
    0.922682f, 0.330606f, 0.198387f,
    0.944433f, 0.261550f, 0.199094f,
    0.936050f, 0.232455f, 0.264151f,
    0.961188f, 0.191780f, 0.198337f,
    0.891742f, 0.368518f, 0.262661f,
    0.981483f, 0.179596f, 0.066604f,
    0.978530f, 0.206103f, 0.000000f,
    0.979426f, 0.151549f, 0.133256f,
    0.991648f, 0.110385f, 0.066709f,
    0.996917f, 0.041248f, 0.066741f,
    0.997607f, 0.069142f, 0.000000f,
    0.972370f, 0.122729f, 0.198580f,
    0.855337f, 0.405434f, 0.322525f,
    0.882837f, 0.339209f, 0.324864f,
    0.869725f, 0.307659f, 0.385906f,
    0.905832f, 0.270627f, 0.325929f,
    0.923879f, 0.201189f, 0.325530f,
    0.828447f, 0.342848f, 0.442867f,
    0.852640f, 0.274694f, 0.444464f,
    0.991046f, 0.000000f, 0.133523f,
    0.996917f, -0.041248f, 0.066741f,
    0.978852f, 0.041251f, 0.200368f,
    0.978852f, -0.041251f, 0.200368f,
    0.960655f, -0.081501f, 0.265518f,
    0.972370f, -0.122729f, 0.198580f,
    0.960655f, 0.081501f, 0.265518f,
    0.941618f, -0.041302f, 0.334140f,
    0.935130f, -0.122800f, 0.332342f,
    0.941618f, 0.041302f, 0.334140f,
    0.916092f, 0.000000f, 0.400968f,
    0.884760f, 0.041299f, 0.464213f,
    0.884760f, -0.041299f, 0.464213f,
    0.935130f, 0.122800f, 0.332342f,
    0.904839f, -0.161006f, 0.394136f,
    0.923879f, -0.201189f, 0.325530f,
    0.879344f, -0.119755f, 0.460882f,
    0.868535f, -0.198227f, 0.454262f,
    0.827147f, -0.233445f, 0.511205f,
    0.852640f, -0.274694f, 0.444464f,
    0.848029f, -0.078459f, 0.524110f,
    0.904839f, 0.161006f, 0.394136f,
    0.868535f, 0.198227f, 0.454262f,
    0.879344f, 0.119755f, 0.460882f,
    0.848029f, 0.078459f, 0.524110f,
    0.827147f, 0.233445f, 0.511205f,
    0.991648f, -0.110385f, 0.066709f,
    0.997607f, -0.069142f, 0.000000f,
    0.979426f, -0.151549f, 0.133256f,
    0.981483f, -0.179596f, 0.066604f,
    0.966643f, -0.247326f, 0.066567f,
    0.978530f, -0.206103f, 0.000000f,
    0.961188f, -0.191780f, 0.198337f,
    0.947822f, -0.289929f, 0.132570f,
    0.946198f, -0.316778f, 0.066042f,
    0.944433f, -0.261550f, 0.199094f,
    0.922682f, -0.330606f, 0.198387f,
    0.891742f, -0.368518f, 0.262661f,
    0.896401f, -0.397351f, 0.196412f,
    0.936050f, -0.232455f, 0.264151f,
    0.921919f, -0.381722f, 0.065988f,
    0.940742f, -0.339123f, 0.000000f,
    0.896801f, -0.422364f, 0.131749f,
    0.892927f, -0.445365f, 0.065817f,
    0.859848f, -0.506298f, 0.065758f,
    0.884965f, -0.465658f, 0.000000f,
    0.865871f, -0.460267f, 0.196015f,
    0.905832f, -0.270627f, 0.325929f,
    0.869725f, -0.307659f, 0.385906f,
    0.882837f, -0.339209f, 0.324864f,
    0.855337f, -0.405434f, 0.322525f,
    0.828447f, -0.342848f, 0.442867f,
    0.785715f, 0.273707f, 0.554740f,
    0.801504f, 0.197274f, 0.564513f,
    0.771841f, 0.159613f, 0.615456f,
    0.812169f, 0.119078f, 0.571140f,
    0.817523f, 0.040675f, 0.574458f,
    0.727958f, 0.199331f, 0.656006f,
    0.738886f, 0.121193f, 0.662842f,
    0.782786f, 0.000000f, 0.622292f,
    0.817523f, -0.040675f, 0.574458f,
    0.743496f, 0.040677f, 0.667502f,
    0.743496f, -0.040677f, 0.667502f,
    0.700622f, -0.080573f, 0.708969f,
    0.738886f, -0.121193f, 0.662842f,
    0.700622f, 0.080573f, 0.708969f,
    0.812169f, -0.119078f, 0.571140f,
    0.771841f, -0.159613f, 0.615456f,
    0.801504f, -0.197274f, 0.564513f,
    0.785715f, -0.273707f, 0.554740f,
    0.727958f, -0.199331f, 0.656006f,
    0.656282f, 0.121144f, 0.744727f,
    0.660884f, 0.040642f, 0.749387f,
    0.617676f, 0.000000f, 0.786433f,
    0.660884f, -0.040642f, 0.749387f,
    0.656282f, -0.121144f, 0.744727f,
    0.572056f, 0.040640f, 0.819207f,
    0.572056f, -0.040640f, 0.819207f,
    0.892927f, 0.445365f, -0.065817f,
    0.859848f, 0.506298f, -0.065758f,
    0.921919f, 0.381722f, -0.065988f,
    0.896801f, 0.422364f, -0.131749f,
    0.896401f, 0.397351f, -0.196412f,
    0.865871f, 0.460267f, -0.196015f,
    0.946198f, 0.316778f, -0.066042f,
    0.922682f, 0.330606f, -0.198387f,
    0.891742f, 0.368518f, -0.262661f,
    0.947822f, 0.289929f, -0.132570f,
    0.944433f, 0.261550f, -0.199094f,
    0.961188f, 0.191780f, -0.198337f,
    0.936050f, 0.232455f, -0.264151f,
    0.966643f, 0.247326f, -0.066567f,
    0.882837f, 0.339209f, -0.324864f,
    0.855337f, 0.405434f, -0.322525f,
    0.905832f, 0.270627f, -0.325929f,
    0.869725f, 0.307659f, -0.385906f,
    0.852640f, 0.274694f, -0.444464f,
    0.828447f, 0.342848f, -0.442867f,
    0.923879f, 0.201189f, -0.325530f,
    0.981483f, 0.179596f, -0.066604f,
    0.991648f, 0.110385f, -0.066709f,
    0.979426f, 0.151549f, -0.133256f,
    0.972370f, 0.122729f, -0.198580f,
    0.996917f, 0.041248f, -0.066741f,
    0.868535f, 0.198227f, -0.454262f,
    0.827147f, 0.233445f, -0.511205f,
    0.904839f, 0.161006f, -0.394136f,
    0.879344f, 0.119755f, -0.460882f,
    0.884760f, 0.041299f, -0.464213f,
    0.848029f, 0.078459f, -0.524110f,
    0.935130f, 0.122800f, -0.332342f,
    0.916092f, 0.000000f, -0.400968f,
    0.884760f, -0.041299f, -0.464213f,
    0.941618f, 0.041302f, -0.334140f,
    0.941618f, -0.041302f, -0.334140f,
    0.960655f, -0.081501f, -0.265518f,
    0.935130f, -0.122800f, -0.332342f,
    0.960655f, 0.081501f, -0.265518f,
    0.879344f, -0.119755f, -0.460882f,
    0.848029f, -0.078459f, -0.524110f,
    0.904839f, -0.161006f, -0.394136f,
    0.868535f, -0.198227f, -0.454262f,
    0.852640f, -0.274694f, -0.444464f,
    0.827147f, -0.233445f, -0.511205f,
    0.923879f, -0.201189f, -0.325530f,
    0.978852f, 0.041251f, -0.200368f,
    0.991046f, 0.000000f, -0.133523f,
    0.978852f, -0.041251f, -0.200368f,
    0.972370f, -0.122729f, -0.198580f,
    0.996917f, -0.041248f, -0.066741f,
    0.801504f, 0.197274f, -0.564513f,
    0.785715f, 0.273707f, -0.554740f,
    0.812169f, 0.119078f, -0.571140f,
    0.771841f, 0.159613f, -0.615456f,
    0.738886f, 0.121193f, -0.662842f,
    0.727958f, 0.199331f, -0.656006f,
    0.817523f, 0.040675f, -0.574458f,
    0.743496f, 0.040677f, -0.667502f,
    0.700622f, 0.080573f, -0.708969f,
    0.782786f, 0.000000f, -0.622292f,
    0.743496f, -0.040677f, -0.667502f,
    0.738886f, -0.121193f, -0.662842f,
    0.700622f, -0.080573f, -0.708969f,
    0.817523f, -0.040675f, -0.574458f,
    0.660884f, 0.040642f, -0.749387f,
    0.656282f, 0.121144f, -0.744727f,
    0.660884f, -0.040642f, -0.749387f,
    0.617676f, 0.000000f, -0.786433f,
    0.572056f, -0.040640f, -0.819207f,
    0.572056f, 0.040640f, -0.819207f,
    0.656282f, -0.121144f, -0.744727f,
    0.812169f, -0.119078f, -0.571140f,
    0.801504f, -0.197274f, -0.564513f,
    0.771841f, -0.159613f, -0.615456f,
    0.727958f, -0.199331f, -0.656006f,
    0.785715f, -0.273707f, -0.554740f,
    0.991648f, -0.110385f, -0.066709f,
    0.981483f, -0.179596f, -0.066604f,
    0.979426f, -0.151549f, -0.133256f,
    0.961188f, -0.191780f, -0.198337f,
    0.966643f, -0.247326f, -0.066567f,
    0.944433f, -0.261550f, -0.199094f,
    0.936050f, -0.232455f, -0.264151f,
    0.947822f, -0.289929f, -0.132570f,
    0.922682f, -0.330606f, -0.198387f,
    0.896401f, -0.397351f, -0.196412f,
    0.891742f, -0.368518f, -0.262661f,
    0.946198f, -0.316778f, -0.066042f,
    0.905832f, -0.270627f, -0.325929f,
    0.882837f, -0.339209f, -0.324864f,
    0.869725f, -0.307659f, -0.385906f,
    0.828447f, -0.342848f, -0.442867f,
    0.855337f, -0.405434f, -0.322525f,
    0.921919f, -0.381722f, -0.065988f,
    0.892927f, -0.445365f, -0.065817f,
    0.896801f, -0.422364f, -0.131749f,
    0.865871f, -0.460267f, -0.196015f,
    0.859848f, -0.506298f, -0.065758f,
    -0.859848f, -0.506298f, 0.065758f,
    -0.892927f, -0.445365f, 0.065817f,
    -0.884965f, -0.465658f, 0.000000f,
    -0.896801f, -0.422364f, 0.131749f,
    -0.921919f, -0.381722f, 0.065988f,
    -0.946198f, -0.316778f, 0.066042f,
    -0.940742f, -0.339123f, 0.000000f,
    -0.865871f, -0.460267f, 0.196015f,
    -0.896401f, -0.397351f, 0.196412f,
    -0.947822f, -0.289929f, 0.132570f,
    -0.966643f, -0.247326f, 0.066567f,
    -0.922682f, -0.330606f, 0.198387f,
    -0.944433f, -0.261550f, 0.199094f,
    -0.936050f, -0.232455f, 0.264151f,
    -0.961188f, -0.191780f, 0.198337f,
    -0.891742f, -0.368518f, 0.262661f,
    -0.981483f, -0.179596f, 0.066604f,
    -0.978530f, -0.206103f, 0.000000f,
    -0.979426f, -0.151549f, 0.133256f,
    -0.991648f, -0.110385f, 0.066709f,
    -0.996917f, -0.041248f, 0.066741f,
    -0.997607f, -0.069142f, 0.000000f,
    -0.972370f, -0.122729f, 0.198580f,
    -0.855337f, -0.405434f, 0.322525f,
    -0.882837f, -0.339209f, 0.324864f,
    -0.869725f, -0.307659f, 0.385906f,
    -0.905832f, -0.270627f, 0.325929f,
    -0.923879f, -0.201189f, 0.325530f,
    -0.828447f, -0.342848f, 0.442867f,
    -0.852640f, -0.274694f, 0.444464f,
    -0.991046f, 0.000000f, 0.133523f,
    -0.996917f, 0.041248f, 0.066741f,
    -0.978852f, -0.041251f, 0.200368f,
    -0.978852f, 0.041251f, 0.200368f,
    -0.960655f, 0.081501f, 0.265518f,
    -0.972370f, 0.122729f, 0.198580f,
    -0.960655f, -0.081501f, 0.265518f,
    -0.941618f, 0.041302f, 0.334140f,
    -0.935130f, 0.122800f, 0.332342f,
    -0.941618f, -0.041302f, 0.334140f,
    -0.916092f, 0.000000f, 0.400968f,
    -0.884760f, -0.041299f, 0.464213f,
    -0.884760f, 0.041299f, 0.464213f,
    -0.935130f, -0.122800f, 0.332342f,
    -0.904839f, 0.161006f, 0.394136f,
    -0.923879f, 0.201189f, 0.325530f,
    -0.879344f, 0.119755f, 0.460882f,
    -0.868535f, 0.198227f, 0.454262f,
    -0.827147f, 0.233445f, 0.511205f,
    -0.852640f, 0.274694f, 0.444464f,
    -0.848029f, 0.078459f, 0.524110f,
    -0.904839f, -0.161006f, 0.394136f,
    -0.868535f, -0.198227f, 0.454262f,
    -0.879344f, -0.119755f, 0.460882f,
    -0.848029f, -0.078459f, 0.524110f,
    -0.827147f, -0.233445f, 0.511205f,
    -0.991648f, 0.110385f, 0.066709f,
    -0.997607f, 0.069142f, 0.000000f,
    -0.979426f, 0.151549f, 0.133256f,
    -0.981483f, 0.179596f, 0.066604f,
    -0.966643f, 0.247326f, 0.066567f,
    -0.978530f, 0.206103f, 0.000000f,
    -0.961188f, 0.191780f, 0.198337f,
    -0.947822f, 0.289929f, 0.132570f,
    -0.946198f, 0.316778f, 0.066042f,
    -0.944433f, 0.261550f, 0.199094f,
    -0.922682f, 0.330606f, 0.198387f,
    -0.891742f, 0.368518f, 0.262661f,
    -0.896401f, 0.397351f, 0.196412f,
    -0.936050f, 0.232455f, 0.264151f,
    -0.921919f, 0.381722f, 0.065988f,
    -0.940742f, 0.339123f, 0.000000f,
    -0.896801f, 0.422364f, 0.131749f,
    -0.892927f, 0.445365f, 0.065817f,
    -0.859848f, 0.506298f, 0.065758f,
    -0.884965f, 0.465658f, 0.000000f,
    -0.865871f, 0.460267f, 0.196015f,
    -0.905832f, 0.270627f, 0.325929f,
    -0.869725f, 0.307659f, 0.385906f,
    -0.882837f, 0.339209f, 0.324864f,
    -0.855337f, 0.405434f, 0.322525f,
    -0.828447f, 0.342848f, 0.442867f,
    -0.785715f, -0.273707f, 0.554740f,
    -0.801504f, -0.197274f, 0.564513f,
    -0.771841f, -0.159613f, 0.615456f,
    -0.812169f, -0.119078f, 0.571140f,
    -0.817523f, -0.040675f, 0.574458f,
    -0.727958f, -0.199331f, 0.656006f,
    -0.738886f, -0.121193f, 0.662842f,
    -0.782786f, 0.000000f, 0.622292f,
    -0.817523f, 0.040675f, 0.574458f,
    -0.743496f, -0.040677f, 0.667502f,
    -0.743496f, 0.040677f, 0.667502f,
    -0.700622f, 0.080573f, 0.708969f,
    -0.738886f, 0.121193f, 0.662842f,
    -0.700622f, -0.080573f, 0.708969f,
    -0.812169f, 0.119078f, 0.571140f,
    -0.771841f, 0.159613f, 0.615456f,
    -0.801504f, 0.197274f, 0.564513f,
    -0.785715f, 0.273707f, 0.554740f,
    -0.727958f, 0.199331f, 0.656006f,
    -0.656282f, -0.121144f, 0.744727f,
    -0.660884f, -0.040642f, 0.749387f,
    -0.617676f, 0.000000f, 0.786433f,
    -0.660884f, 0.040642f, 0.749387f,
    -0.656282f, 0.121144f, 0.744727f,
    -0.572056f, -0.040640f, 0.819207f,
    -0.572056f, 0.040640f, 0.819207f,
    -0.892927f, -0.445365f, -0.065817f,
    -0.859848f, -0.506298f, -0.065758f,
    -0.921919f, -0.381722f, -0.065988f,
    -0.896801f, -0.422364f, -0.131749f,
    -0.896401f, -0.397351f, -0.196412f,
    -0.865871f, -0.460267f, -0.196015f,
    -0.946198f, -0.316778f, -0.066042f,
    -0.922682f, -0.330606f, -0.198387f,
    -0.891742f, -0.368518f, -0.262661f,
    -0.947822f, -0.289929f, -0.132570f,
    -0.944433f, -0.261550f, -0.199094f,
    -0.961188f, -0.191780f, -0.198337f,
    -0.936050f, -0.232455f, -0.264151f,
    -0.966643f, -0.247326f, -0.066567f,
    -0.882837f, -0.339209f, -0.324864f,
    -0.855337f, -0.405434f, -0.322525f,
    -0.905832f, -0.270627f, -0.325929f,
    -0.869725f, -0.307659f, -0.385906f,
    -0.852640f, -0.274694f, -0.444464f,
    -0.828447f, -0.342848f, -0.442867f,
    -0.923879f, -0.201189f, -0.325530f,
    -0.981483f, -0.179596f, -0.066604f,
    -0.991648f, -0.110385f, -0.066709f,
    -0.979426f, -0.151549f, -0.133256f,
    -0.972370f, -0.122729f, -0.198580f,
    -0.996917f, -0.041248f, -0.066741f,
    -0.868535f, -0.198227f, -0.454262f,
    -0.827147f, -0.233445f, -0.511205f,
    -0.904839f, -0.161006f, -0.394136f,
    -0.879344f, -0.119755f, -0.460882f,
    -0.884760f, -0.041299f, -0.464213f,
    -0.848029f, -0.078459f, -0.524110f,
    -0.935130f, -0.122800f, -0.332342f,
    -0.916092f, 0.000000f, -0.400968f,
    -0.884760f, 0.041299f, -0.464213f,
    -0.941618f, -0.041302f, -0.334140f,
    -0.941618f, 0.041302f, -0.334140f,
    -0.960655f, 0.081501f, -0.265518f,
    -0.935130f, 0.122800f, -0.332342f,
    -0.960655f, -0.081501f, -0.265518f,
    -0.879344f, 0.119755f, -0.460882f,
    -0.848029f, 0.078459f, -0.524110f,
    -0.904839f, 0.161006f, -0.394136f,
    -0.868535f, 0.198227f, -0.454262f,
    -0.852640f, 0.274694f, -0.444464f,
    -0.827147f, 0.233445f, -0.511205f,
    -0.923879f, 0.201189f, -0.325530f,
    -0.978852f, -0.041251f, -0.200368f,
    -0.991046f, 0.000000f, -0.133523f,
    -0.978852f, 0.041251f, -0.200368f,
    -0.972370f, 0.122729f, -0.198580f,
    -0.996917f, 0.041248f, -0.066741f,
    -0.801504f, -0.197274f, -0.564513f,
    -0.785715f, -0.273707f, -0.554740f,
    -0.812169f, -0.119078f, -0.571140f,
    -0.771841f, -0.159613f, -0.615456f,
    -0.738886f, -0.121193f, -0.662842f,
    -0.727958f, -0.199331f, -0.656006f,
    -0.817523f, -0.040675f, -0.574458f,
    -0.743496f, -0.040677f, -0.667502f,
    -0.700622f, -0.080573f, -0.708969f,
    -0.782786f, 0.000000f, -0.622292f,
    -0.743496f, 0.040677f, -0.667502f,
    -0.738886f, 0.121193f, -0.662842f,
    -0.700622f, 0.080573f, -0.708969f,
    -0.817523f, 0.040675f, -0.574458f,
    -0.660884f, -0.040642f, -0.749387f,
    -0.656282f, -0.121144f, -0.744727f,
    -0.660884f, 0.040642f, -0.749387f,
    -0.617676f, 0.000000f, -0.786433f,
    -0.572056f, 0.040640f, -0.819207f,
    -0.572056f, -0.040640f, -0.819207f,
    -0.656282f, 0.121144f, -0.744727f,
    -0.812169f, 0.119078f, -0.571140f,
    -0.801504f, 0.197274f, -0.564513f,
    -0.771841f, 0.159613f, -0.615456f,
    -0.727958f, 0.199331f, -0.656006f,
    -0.785715f, 0.273707f, -0.554740f,
    -0.991648f, 0.110385f, -0.066709f,
    -0.981483f, 0.179596f, -0.066604f,
    -0.979426f, 0.151549f, -0.133256f,
    -0.961188f, 0.191780f, -0.198337f,
    -0.966643f, 0.247326f, -0.066567f,
    -0.944433f, 0.261550f, -0.199094f,
    -0.936050f, 0.232455f, -0.264151f,
    -0.947822f, 0.289929f, -0.132570f,
    -0.922682f, 0.330606f, -0.198387f,
    -0.896401f, 0.397351f, -0.196412f,
    -0.891742f, 0.368518f, -0.262661f,
    -0.946198f, 0.316778f, -0.066042f,
    -0.905832f, 0.270627f, -0.325929f,
    -0.882837f, 0.339209f, -0.324864f,
    -0.869725f, 0.307659f, -0.385906f,
    -0.828447f, 0.342848f, -0.442867f,
    -0.855337f, 0.405434f, -0.322525f,
    -0.921919f, 0.381722f, -0.065988f,
    -0.892927f, 0.445365f, -0.065817f,
    -0.896801f, 0.422364f, -0.131749f,
    -0.865871f, 0.460267f, -0.196015f,
    -0.859848f, 0.506298f, -0.065758f,
    0.065758f, 0.859848f, 0.506298f,
    0.065817f, 0.892927f, 0.445365f,
    0.000000f, 0.884965f, 0.465658f,
    0.131749f, 0.896801f, 0.422364f,
    0.065988f, 0.921919f, 0.381722f,
    0.066042f, 0.946198f, 0.316778f,
    0.000000f, 0.940742f, 0.339123f,
    0.196015f, 0.865871f, 0.460267f,
    0.196412f, 0.896401f, 0.397351f,
    0.132570f, 0.947822f, 0.289929f,
    0.066567f, 0.966643f, 0.247326f,
    0.198387f, 0.922682f, 0.330606f,
    0.199094f, 0.944433f, 0.261550f,
    0.264151f, 0.936050f, 0.232455f,
    0.198337f, 0.961188f, 0.191780f,
    0.262661f, 0.891742f, 0.368518f,
    0.066604f, 0.981483f, 0.179596f,
    0.000000f, 0.978530f, 0.206103f,
    0.133256f, 0.979426f, 0.151549f,
    0.066709f, 0.991648f, 0.110385f,
    0.066741f, 0.996917f, 0.041248f,
    0.000000f, 0.997607f, 0.069142f,
    0.198580f, 0.972370f, 0.122729f,
    0.322525f, 0.855337f, 0.405434f,
    0.324864f, 0.882837f, 0.339209f,
    0.385906f, 0.869725f, 0.307659f,
    0.325929f, 0.905832f, 0.270627f,
    0.325530f, 0.923879f, 0.201189f,
    0.442867f, 0.828447f, 0.342848f,
    0.444464f, 0.852640f, 0.274694f,
    0.133523f, 0.991046f, 0.000000f,
    0.066741f, 0.996917f, -0.041248f,
    0.200368f, 0.978852f, 0.041251f,
    0.200368f, 0.978852f, -0.041251f,
    0.265518f, 0.960655f, -0.081501f,
    0.198580f, 0.972370f, -0.122729f,
    0.265518f, 0.960655f, 0.081501f,
    0.334140f, 0.941618f, -0.041302f,
    0.332342f, 0.935130f, -0.122800f,
    0.334140f, 0.941618f, 0.041302f,
    0.400968f, 0.916092f, 0.000000f,
    0.464213f, 0.884760f, 0.041299f,
    0.464213f, 0.884760f, -0.041299f,
    0.332342f, 0.935130f, 0.122800f,
    0.394136f, 0.904839f, -0.161006f,
    0.325530f, 0.923879f, -0.201189f,
    0.460882f, 0.879344f, -0.119755f,
    0.454262f, 0.868535f, -0.198227f,
    0.511205f, 0.827147f, -0.233445f,
    0.444464f, 0.852640f, -0.274694f,
    0.524110f, 0.848029f, -0.078459f,
    0.394136f, 0.904839f, 0.161006f,
    0.454262f, 0.868535f, 0.198227f,
    0.460882f, 0.879344f, 0.119755f,
    0.524110f, 0.848029f, 0.078459f,
    0.511205f, 0.827147f, 0.233445f,
    0.066709f, 0.991648f, -0.110385f,
    0.000000f, 0.997607f, -0.069142f,
    0.133256f, 0.979426f, -0.151549f,
    0.066604f, 0.981483f, -0.179596f,
    0.066567f, 0.966643f, -0.247326f,
    0.000000f, 0.978530f, -0.206103f,
    0.198337f, 0.961188f, -0.191780f,
    0.132570f, 0.947822f, -0.289929f,
    0.066042f, 0.946198f, -0.316778f,
    0.199094f, 0.944433f, -0.261550f,
    0.198387f, 0.922682f, -0.330606f,
    0.262661f, 0.891742f, -0.368518f,
    0.196412f, 0.896401f, -0.397351f,
    0.264151f, 0.936050f, -0.232455f,
    0.065988f, 0.921919f, -0.381722f,
    0.000000f, 0.940742f, -0.339123f,
    0.131749f, 0.896801f, -0.422364f,
    0.065817f, 0.892927f, -0.445365f,
    0.065758f, 0.859848f, -0.506298f,
    0.000000f, 0.884965f, -0.465658f,
    0.196015f, 0.865871f, -0.460267f,
    0.325929f, 0.905832f, -0.270627f,
    0.385906f, 0.869725f, -0.307659f,
    0.324864f, 0.882837f, -0.339209f,
    0.322525f, 0.855337f, -0.405434f,
    0.442867f, 0.828447f, -0.342848f,
    0.554740f, 0.785715f, 0.273707f,
    0.564513f, 0.801504f, 0.197274f,
    0.615456f, 0.771841f, 0.159613f,
    0.571140f, 0.812169f, 0.119078f,
    0.574458f, 0.817523f, 0.040675f,
    0.656006f, 0.727958f, 0.199331f,
    0.662842f, 0.738886f, 0.121193f,
    0.622292f, 0.782786f, 0.000000f,
    0.574458f, 0.817523f, -0.040675f,
    0.667502f, 0.743496f, 0.040677f,
    0.667502f, 0.743496f, -0.040677f,
    0.708969f, 0.700622f, -0.080573f,
    0.662842f, 0.738886f, -0.121193f,
    0.708969f, 0.700622f, 0.080573f,
    0.571140f, 0.812169f, -0.119078f,
    0.615456f, 0.771841f, -0.159613f,
    0.564513f, 0.801504f, -0.197274f,
    0.554740f, 0.785715f, -0.273707f,
    0.656006f, 0.727958f, -0.199331f,
    0.744727f, 0.656282f, 0.121144f,
    0.749387f, 0.660884f, 0.040642f,
    0.786433f, 0.617676f, 0.000000f,
    0.749387f, 0.660884f, -0.040642f,
    0.744727f, 0.656282f, -0.121144f,
    0.819207f, 0.572056f, 0.040640f,
    0.819207f, 0.572056f, -0.040640f,
    -0.065817f, 0.892927f, 0.445365f,
    -0.065758f, 0.859848f, 0.506298f,
    -0.065988f, 0.921919f, 0.381722f,
    -0.131749f, 0.896801f, 0.422364f,
    -0.196412f, 0.896401f, 0.397351f,
    -0.196015f, 0.865871f, 0.460267f,
    -0.066042f, 0.946198f, 0.316778f,
    -0.198387f, 0.922682f, 0.330606f,
    -0.262661f, 0.891742f, 0.368518f,
    -0.132570f, 0.947822f, 0.289929f,
    -0.199094f, 0.944433f, 0.261550f,
    -0.198337f, 0.961188f, 0.191780f,
    -0.264151f, 0.936050f, 0.232455f,
    -0.066567f, 0.966643f, 0.247326f,
    -0.324864f, 0.882837f, 0.339209f,
    -0.322525f, 0.855337f, 0.405434f,
    -0.325929f, 0.905832f, 0.270627f,
    -0.385906f, 0.869725f, 0.307659f,
    -0.444464f, 0.852640f, 0.274694f,
    -0.442867f, 0.828447f, 0.342848f,
    -0.325530f, 0.923879f, 0.201189f,
    -0.066604f, 0.981483f, 0.179596f,
    -0.066709f, 0.991648f, 0.110385f,
    -0.133256f, 0.979426f, 0.151549f,
    -0.198580f, 0.972370f, 0.122729f,
    -0.066741f, 0.996917f, 0.041248f,
    -0.454262f, 0.868535f, 0.198227f,
    -0.511205f, 0.827147f, 0.233445f,
    -0.394136f, 0.904839f, 0.161006f,
    -0.460882f, 0.879344f, 0.119755f,
    -0.464213f, 0.884760f, 0.041299f,
    -0.524110f, 0.848029f, 0.078459f,
    -0.332342f, 0.935130f, 0.122800f,
    -0.400968f, 0.916092f, 0.000000f,
    -0.464213f, 0.884760f, -0.041299f,
    -0.334140f, 0.941618f, 0.041302f,
    -0.334140f, 0.941618f, -0.041302f,
    -0.265518f, 0.960655f, -0.081501f,
    -0.332342f, 0.935130f, -0.122800f,
    -0.265518f, 0.960655f, 0.081501f,
    -0.460882f, 0.879344f, -0.119755f,
    -0.524110f, 0.848029f, -0.078459f,
    -0.394136f, 0.904839f, -0.161006f,
    -0.454262f, 0.868535f, -0.198227f,
    -0.444464f, 0.852640f, -0.274694f,
    -0.511205f, 0.827147f, -0.233445f,
    -0.325530f, 0.923879f, -0.201189f,
    -0.200368f, 0.978852f, 0.041251f,
    -0.133523f, 0.991046f, 0.000000f,
    -0.200368f, 0.978852f, -0.041251f,
    -0.198580f, 0.972370f, -0.122729f,
    -0.066741f, 0.996917f, -0.041248f,
    -0.564513f, 0.801504f, 0.197274f,
    -0.554740f, 0.785715f, 0.273707f,
    -0.571140f, 0.812169f, 0.119078f,
    -0.615456f, 0.771841f, 0.159613f,
    -0.662842f, 0.738886f, 0.121193f,
    -0.656006f, 0.727958f, 0.199331f,
    -0.574458f, 0.817523f, 0.040675f,
    -0.667502f, 0.743496f, 0.040677f,
    -0.708969f, 0.700622f, 0.080573f,
    -0.622292f, 0.782786f, 0.000000f,
    -0.667502f, 0.743496f, -0.040677f,
    -0.662842f, 0.738886f, -0.121193f,
    -0.708969f, 0.700622f, -0.080573f,
    -0.574458f, 0.817523f, -0.040675f,
    -0.749387f, 0.660884f, 0.040642f,
    -0.744727f, 0.656282f, 0.121144f,
    -0.749387f, 0.660884f, -0.040642f,
    -0.786433f, 0.617676f, 0.000000f,
    -0.819207f, 0.572056f, -0.040640f,
    -0.819207f, 0.572056f, 0.040640f,
    -0.744727f, 0.656282f, -0.121144f,
    -0.571140f, 0.812169f, -0.119078f,
    -0.564513f, 0.801504f, -0.197274f,
    -0.615456f, 0.771841f, -0.159613f,
    -0.656006f, 0.727958f, -0.199331f,
    -0.554740f, 0.785715f, -0.273707f,
    -0.066709f, 0.991648f, -0.110385f,
    -0.066604f, 0.981483f, -0.179596f,
    -0.133256f, 0.979426f, -0.151549f,
    -0.198337f, 0.961188f, -0.191780f,
    -0.066567f, 0.966643f, -0.247326f,
    -0.199094f, 0.944433f, -0.261550f,
    -0.264151f, 0.936050f, -0.232455f,
    -0.132570f, 0.947822f, -0.289929f,
    -0.198387f, 0.922682f, -0.330606f,
    -0.196412f, 0.896401f, -0.397351f,
    -0.262661f, 0.891742f, -0.368518f,
    -0.066042f, 0.946198f, -0.316778f,
    -0.325929f, 0.905832f, -0.270627f,
    -0.324864f, 0.882837f, -0.339209f,
    -0.385906f, 0.869725f, -0.307659f,
    -0.442867f, 0.828447f, -0.342848f,
    -0.322525f, 0.855337f, -0.405434f,
    -0.065988f, 0.921919f, -0.381722f,
    -0.065817f, 0.892927f, -0.445365f,
    -0.131749f, 0.896801f, -0.422364f,
    -0.196015f, 0.865871f, -0.460267f,
    -0.065758f, 0.859848f, -0.506298f,
    0.000000f, -0.884965f, 0.465658f,
    0.065817f, -0.892927f, 0.445365f,
    0.065758f, -0.859848f, 0.506298f,
    0.065988f, -0.921919f, 0.381722f,
    0.131749f, -0.896801f, 0.422364f,
    0.196412f, -0.896401f, 0.397351f,
    0.196015f, -0.865871f, 0.460267f,
    0.000000f, -0.940742f, 0.339123f,
    0.066042f, -0.946198f, 0.316778f,
    0.198387f, -0.922682f, 0.330606f,
    0.262661f, -0.891742f, 0.368518f,
    0.132570f, -0.947822f, 0.289929f,
    0.199094f, -0.944433f, 0.261550f,
    0.198337f, -0.961188f, 0.191780f,
    0.264151f, -0.936050f, 0.232455f,
    0.066567f, -0.966643f, 0.247326f,
    0.324864f, -0.882837f, 0.339209f,
    0.322525f, -0.855337f, 0.405434f,
    0.325929f, -0.905832f, 0.270627f,
    0.385906f, -0.869725f, 0.307659f,
    0.444464f, -0.852640f, 0.274694f,
    0.442867f, -0.828447f, 0.342848f,
    0.325530f, -0.923879f, 0.201189f,
    0.000000f, -0.978530f, 0.206103f,
    0.066604f, -0.981483f, 0.179596f,
    0.066709f, -0.991648f, 0.110385f,
    0.133256f, -0.979426f, 0.151549f,
    0.198580f, -0.972370f, 0.122729f,
    0.000000f, -0.997607f, 0.069142f,
    0.066741f, -0.996917f, 0.041248f,
    0.454262f, -0.868535f, 0.198227f,
    0.511205f, -0.827147f, 0.233445f,
    0.394136f, -0.904839f, 0.161006f,
    0.460882f, -0.879344f, 0.119755f,
    0.464213f, -0.884760f, 0.041299f,
    0.524110f, -0.848029f, 0.078459f,
    0.332342f, -0.935130f, 0.122800f,
    0.400968f, -0.916092f, 0.000000f,
    0.464213f, -0.884760f, -0.041299f,
    0.334140f, -0.941618f, 0.041302f,
    0.334140f, -0.941618f, -0.041302f,
    0.265518f, -0.960655f, -0.081501f,
    0.332342f, -0.935130f, -0.122800f,
    0.265518f, -0.960655f, 0.081501f,
    0.460882f, -0.879344f, -0.119755f,
    0.524110f, -0.848029f, -0.078459f,
    0.394136f, -0.904839f, -0.161006f,
    0.454262f, -0.868535f, -0.198227f,
    0.444464f, -0.852640f, -0.274694f,
    0.511205f, -0.827147f, -0.233445f,
    0.325530f, -0.923879f, -0.201189f,
    0.200368f, -0.978852f, 0.041251f,
    0.133523f, -0.991046f, 0.000000f,
    0.200368f, -0.978852f, -0.041251f,
    0.198580f, -0.972370f, -0.122729f,
    0.066741f, -0.996917f, -0.041248f,
    0.564513f, -0.801504f, 0.197274f,
    0.554740f, -0.785715f, 0.273707f,
    0.571140f, -0.812169f, 0.119078f,
    0.615456f, -0.771841f, 0.159613f,
    0.662842f, -0.738886f, 0.121193f,
    0.656006f, -0.727958f, 0.199331f,
    0.574458f, -0.817523f, 0.040675f,
    0.667502f, -0.743496f, 0.040677f,
    0.708969f, -0.700622f, 0.080573f,
    0.622292f, -0.782786f, 0.000000f,
    0.667502f, -0.743496f, -0.040677f,
    0.662842f, -0.738886f, -0.121193f,
    0.708969f, -0.700622f, -0.080573f,
    0.574458f, -0.817523f, -0.040675f,
    0.749387f, -0.660884f, 0.040642f,
    0.744727f, -0.656282f, 0.121144f,
    0.749387f, -0.660884f, -0.040642f,
    0.786433f, -0.617676f, 0.000000f,
    0.819207f, -0.572056f, -0.040640f,
    0.819207f, -0.572056f, 0.040640f,
    0.744727f, -0.656282f, -0.121144f,
    0.571140f, -0.812169f, -0.119078f,
    0.564513f, -0.801504f, -0.197274f,
    0.615456f, -0.771841f, -0.159613f,
    0.656006f, -0.727958f, -0.199331f,
    0.554740f, -0.785715f, -0.273707f,
    0.000000f, -0.997607f, -0.069142f,
    0.066709f, -0.991648f, -0.110385f,
    0.066604f, -0.981483f, -0.179596f,
    0.133256f, -0.979426f, -0.151549f,
    0.198337f, -0.961188f, -0.191780f,
    0.000000f, -0.978530f, -0.206103f,
    0.066567f, -0.966643f, -0.247326f,
    0.199094f, -0.944433f, -0.261550f,
    0.264151f, -0.936050f, -0.232455f,
    0.132570f, -0.947822f, -0.289929f,
    0.198387f, -0.922682f, -0.330606f,
    0.196412f, -0.896401f, -0.397351f,
    0.262661f, -0.891742f, -0.368518f,
    0.066042f, -0.946198f, -0.316778f,
    0.325929f, -0.905832f, -0.270627f,
    0.324864f, -0.882837f, -0.339209f,
    0.385906f, -0.869725f, -0.307659f,
    0.442867f, -0.828447f, -0.342848f,
    0.322525f, -0.855337f, -0.405434f,
    0.000000f, -0.940742f, -0.339123f,
    0.065988f, -0.921919f, -0.381722f,
    0.065817f, -0.892927f, -0.445365f,
    0.131749f, -0.896801f, -0.422364f,
    0.196015f, -0.865871f, -0.460267f,
    0.000000f, -0.884965f, -0.465658f,
    0.065758f, -0.859848f, -0.506298f,
    -0.065758f, -0.859848f, 0.506298f,
    -0.065817f, -0.892927f, 0.445365f,
    -0.131749f, -0.896801f, 0.422364f,
    -0.065988f, -0.921919f, 0.381722f,
    -0.066042f, -0.946198f, 0.316778f,
    -0.196015f, -0.865871f, 0.460267f,
    -0.196412f, -0.896401f, 0.397351f,
    -0.132570f, -0.947822f, 0.289929f,
    -0.066567f, -0.966643f, 0.247326f,
    -0.198387f, -0.922682f, 0.330606f,
    -0.199094f, -0.944433f, 0.261550f,
    -0.264151f, -0.936050f, 0.232455f,
    -0.198337f, -0.961188f, 0.191780f,
    -0.262661f, -0.891742f, 0.368518f,
    -0.066604f, -0.981483f, 0.179596f,
    -0.133256f, -0.979426f, 0.151549f,
    -0.066709f, -0.991648f, 0.110385f,
    -0.066741f, -0.996917f, 0.041248f,
    -0.198580f, -0.972370f, 0.122729f,
    -0.322525f, -0.855337f, 0.405434f,
    -0.324864f, -0.882837f, 0.339209f,
    -0.385906f, -0.869725f, 0.307659f,
    -0.325929f, -0.905832f, 0.270627f,
    -0.325530f, -0.923879f, 0.201189f,
    -0.442867f, -0.828447f, 0.342848f,
    -0.444464f, -0.852640f, 0.274694f,
    -0.133523f, -0.991046f, 0.000000f,
    -0.066741f, -0.996917f, -0.041248f,
    -0.200368f, -0.978852f, 0.041251f,
    -0.200368f, -0.978852f, -0.041251f,
    -0.265518f, -0.960655f, -0.081501f,
    -0.198580f, -0.972370f, -0.122729f,
    -0.265518f, -0.960655f, 0.081501f,
    -0.334140f, -0.941618f, -0.041302f,
    -0.332342f, -0.935130f, -0.122800f,
    -0.334140f, -0.941618f, 0.041302f,
    -0.400968f, -0.916092f, 0.000000f,
    -0.464213f, -0.884760f, 0.041299f,
    -0.464213f, -0.884760f, -0.041299f,
    -0.332342f, -0.935130f, 0.122800f,
    -0.394136f, -0.904839f, -0.161006f,
    -0.325530f, -0.923879f, -0.201189f,
    -0.460882f, -0.879344f, -0.119755f,
    -0.454262f, -0.868535f, -0.198227f,
    -0.511205f, -0.827147f, -0.233445f,
    -0.444464f, -0.852640f, -0.274694f,
    -0.524110f, -0.848029f, -0.078459f,
    -0.394136f, -0.904839f, 0.161006f,
    -0.454262f, -0.868535f, 0.198227f,
    -0.460882f, -0.879344f, 0.119755f,
    -0.524110f, -0.848029f, 0.078459f,
    -0.511205f, -0.827147f, 0.233445f,
    -0.066709f, -0.991648f, -0.110385f,
    -0.133256f, -0.979426f, -0.151549f,
    -0.066604f, -0.981483f, -0.179596f,
    -0.066567f, -0.966643f, -0.247326f,
    -0.198337f, -0.961188f, -0.191780f,
    -0.132570f, -0.947822f, -0.289929f,
    -0.066042f, -0.946198f, -0.316778f,
    -0.199094f, -0.944433f, -0.261550f,
    -0.198387f, -0.922682f, -0.330606f,
    -0.262661f, -0.891742f, -0.368518f,
    -0.196412f, -0.896401f, -0.397351f,
    -0.264151f, -0.936050f, -0.232455f,
    -0.065988f, -0.921919f, -0.381722f,
    -0.131749f, -0.896801f, -0.422364f,
    -0.065817f, -0.892927f, -0.445365f,
    -0.065758f, -0.859848f, -0.506298f,
    -0.196015f, -0.865871f, -0.460267f,
    -0.325929f, -0.905832f, -0.270627f,
    -0.385906f, -0.869725f, -0.307659f,
    -0.324864f, -0.882837f, -0.339209f,
    -0.322525f, -0.855337f, -0.405434f,
    -0.442867f, -0.828447f, -0.342848f,
    -0.554740f, -0.785715f, 0.273707f,
    -0.564513f, -0.801504f, 0.197274f,
    -0.615456f, -0.771841f, 0.159613f,
    -0.571140f, -0.812169f, 0.119078f,
    -0.574458f, -0.817523f, 0.040675f,
    -0.656006f, -0.727958f, 0.199331f,
    -0.662842f, -0.738886f, 0.121193f,
    -0.622292f, -0.782786f, 0.000000f,
    -0.574458f, -0.817523f, -0.040675f,
    -0.667502f, -0.743496f, 0.040677f,
    -0.667502f, -0.743496f, -0.040677f,
    -0.708969f, -0.700622f, -0.080573f,
    -0.662842f, -0.738886f, -0.121193f,
    -0.708969f, -0.700622f, 0.080573f,
    -0.571140f, -0.812169f, -0.119078f,
    -0.615456f, -0.771841f, -0.159613f,
    -0.564513f, -0.801504f, -0.197274f,
    -0.554740f, -0.785715f, -0.273707f,
    -0.656006f, -0.727958f, -0.199331f,
    -0.744727f, -0.656282f, 0.121144f,
    -0.749387f, -0.660884f, 0.040642f,
    -0.786433f, -0.617676f, 0.000000f,
    -0.749387f, -0.660884f, -0.040642f,
    -0.744727f, -0.656282f, -0.121144f,
    -0.819207f, -0.572056f, 0.040640f,
    -0.819207f, -0.572056f, -0.040640f,
    0.106494f, 0.827110f, 0.551859f,
    0.147414f, 0.790170f, 0.594895f,
    0.172532f, 0.830812f, 0.529135f,
    0.237229f, 0.830359f, 0.504209f,
    0.187432f, 0.749786f, 0.634579f,
    0.280319f, 0.790112f, 0.545109f,
    0.303801f, 0.825175f, 0.476226f,
    0.255180f, 0.749435f, 0.610926f,
    0.322141f, 0.745339f, 0.583691f,
    0.361592f, 0.697037f, 0.619186f,
    0.386730f, 0.737712f, 0.553372f,
    0.228900f, 0.703983f, 0.672319f,
    0.366027f, 0.816233f, 0.446977f,
    0.408286f, 0.772575f, 0.486240f,
    0.427135f, 0.803016f, 0.415597f,
    0.485712f, 0.785899f, 0.382683f,
    0.448259f, 0.725299f, 0.522499f,
    0.267381f, 0.656620f, 0.705236f,
    0.305212f, 0.605742f, 0.734794f,
    0.334692f, 0.653497f, 0.678913f,
    0.399769f, 0.646840f, 0.649448f,
    0.341435f, 0.552453f, 0.760406f,
    0.536784f, 0.735011f, 0.414273f,
    0.552453f, 0.760406f, 0.341435f,
    0.517970f, 0.704471f, 0.485208f,
    0.584716f, 0.678977f, 0.443957f,
    0.628313f, 0.619242f, 0.470917f,
    0.646840f, 0.649448f, 0.399769f,
    0.496441f, 0.669612f, 0.552418f,
    0.607478f, 0.581952f, 0.540650f,
    0.669612f, 0.552418f, 0.496441f,
    0.540650f, 0.607478f, 0.581952f,
    0.581952f, 0.540650f, 0.607478f,
    0.552418f, 0.496441f, 0.669612f,
    0.619242f, 0.470917f, 0.628313f,
    0.470917f, 0.628313f, 0.619242f,
    0.704471f, 0.485208f, 0.517970f,
    0.725299f, 0.522499f, 0.448259f,
    0.678977f, 0.443957f, 0.584716f,
    0.735011f, 0.414273f, 0.536784f,
    0.760406f, 0.341435f, 0.552453f,
    0.785899f, 0.382683f, 0.485712f,
    0.649448f, 0.399769f, 0.646840f,
    0.443957f, 0.584716f, 0.678977f,
    0.414273f, 0.536784f, 0.735011f,
    0.485208f, 0.517970f, 0.704471f,
    0.522499f, 0.448259f, 0.725299f,
    0.382683f, 0.485712f, 0.785899f,
    0.605742f, 0.734794f, 0.305212f,
    0.653497f, 0.678913f, 0.334692f,
    0.656620f, 0.705236f, 0.267381f,
    0.703983f, 0.672319f, 0.228900f,
    0.697037f, 0.619186f, 0.361592f,
    0.749435f, 0.610926f, 0.255180f,
    0.749786f, 0.634579f, 0.187432f,
    0.745339f, 0.583691f, 0.322141f,
    0.790112f, 0.545109f, 0.280319f,
    0.825175f, 0.476226f, 0.303801f,
    0.830359f, 0.504209f, 0.237229f,
    0.737712f, 0.553372f, 0.386730f,
    0.790170f, 0.594895f, 0.147414f,
    0.830812f, 0.529135f, 0.172532f,
    0.827110f, 0.551859f, 0.106494f,
    0.772575f, 0.486240f, 0.408286f,
    0.803016f, 0.415597f, 0.427135f,
    0.816233f, 0.446977f, 0.366027f,
    0.415597f, 0.427135f, 0.803016f,
    0.446977f, 0.366027f, 0.816233f,
    0.486240f, 0.408286f, 0.772575f,
    0.553372f, 0.386730f, 0.737712f,
    0.476226f, 0.303801f, 0.825175f,
    0.583691f, 0.322141f, 0.745339f,
    0.619186f, 0.361592f, 0.697037f,
    0.545109f, 0.280319f, 0.790112f,
    0.610926f, 0.255180f, 0.749435f,
    0.634579f, 0.187432f, 0.749786f,
    0.672319f, 0.228900f, 0.703983f,
    0.504209f, 0.237229f, 0.830359f,
    0.678913f, 0.334692f, 0.653497f,
    0.705236f, 0.267381f, 0.656620f,
    0.734794f, 0.305212f, 0.605742f,
    0.529135f, 0.172532f, 0.830812f,
    0.551859f, 0.106494f, 0.827110f,
    0.594895f, 0.147414f, 0.790170f,
    0.106494f, 0.827110f, -0.551859f,
    0.172532f, 0.830812f, -0.529135f,
    0.147414f, 0.790170f, -0.594895f,
    0.187432f, 0.749786f, -0.634579f,
    0.237229f, 0.830359f, -0.504209f,
    0.255180f, 0.749435f, -0.610926f,
    0.228900f, 0.703983f, -0.672319f,
    0.280319f, 0.790112f, -0.545109f,
    0.322141f, 0.745339f, -0.583691f,
    0.386730f, 0.737712f, -0.553372f,
    0.361592f, 0.697037f, -0.619186f,
    0.303801f, 0.825175f, -0.476226f,
    0.267381f, 0.656620f, -0.705236f,
    0.334692f, 0.653497f, -0.678913f,
    0.305212f, 0.605742f, -0.734794f,
    0.341435f, 0.552453f, -0.760406f,
    0.399769f, 0.646840f, -0.649448f,
    0.366027f, 0.816233f, -0.446977f,
    0.427135f, 0.803016f, -0.415597f,
    0.408286f, 0.772575f, -0.486240f,
    0.448259f, 0.725299f, -0.522499f,
    0.485712f, 0.785899f, -0.382683f,
    0.414273f, 0.536784f, -0.735011f,
    0.382683f, 0.485712f, -0.785899f,
    0.443957f, 0.584716f, -0.678977f,
    0.485208f, 0.517970f, -0.704471f,
    0.552418f, 0.496441f, -0.669612f,
    0.522499f, 0.448259f, -0.725299f,
    0.470917f, 0.628313f, -0.619242f,
    0.581952f, 0.540650f, -0.607478f,
    0.619242f, 0.470917f, -0.628313f,
    0.540650f, 0.607478f, -0.581952f,
    0.607478f, 0.581952f, -0.540650f,
    0.628313f, 0.619242f, -0.470917f,
    0.669612f, 0.552418f, -0.496441f,
    0.496441f, 0.669612f, -0.552418f,
    0.678977f, 0.443957f, -0.584716f,
    0.649448f, 0.399769f, -0.646840f,
    0.704471f, 0.485208f, -0.517970f,
    0.735011f, 0.414273f, -0.536784f,
    0.785899f, 0.382683f, -0.485712f,
    0.760406f, 0.341435f, -0.552453f,
    0.725299f, 0.522499f, -0.448259f,
    0.517970f, 0.704471f, -0.485208f,
    0.536784f, 0.735011f, -0.414273f,
    0.584716f, 0.678977f, -0.443957f,
    0.646840f, 0.649448f, -0.399769f,
    0.552453f, 0.760406f, -0.341435f,
    0.415597f, 0.427135f, -0.803016f,
    0.486240f, 0.408286f, -0.772575f,
    0.446977f, 0.366027f, -0.816233f,
    0.476226f, 0.303801f, -0.825175f,
    0.553372f, 0.386730f, -0.737712f,
    0.545109f, 0.280319f, -0.790112f,
    0.504209f, 0.237229f, -0.830359f,
    0.583691f, 0.322141f, -0.745339f,
    0.610926f, 0.255180f, -0.749435f,
    0.672319f, 0.228900f, -0.703983f,
    0.634579f, 0.187432f, -0.749786f,
    0.619186f, 0.361592f, -0.697037f,
    0.529135f, 0.172532f, -0.830812f,
    0.594895f, 0.147414f, -0.790170f,
    0.551859f, 0.106494f, -0.827110f,
    0.678913f, 0.334692f, -0.653497f,
    0.734794f, 0.305212f, -0.605742f,
    0.705236f, 0.267381f, -0.656620f,
    0.605742f, 0.734794f, -0.305212f,
    0.656620f, 0.705236f, -0.267381f,
    0.653497f, 0.678913f, -0.334692f,
    0.697037f, 0.619186f, -0.361592f,
    0.703983f, 0.672319f, -0.228900f,
    0.745339f, 0.583691f, -0.322141f,
    0.737712f, 0.553372f, -0.386730f,
    0.749435f, 0.610926f, -0.255180f,
    0.790112f, 0.545109f, -0.280319f,
    0.830359f, 0.504209f, -0.237229f,
    0.825175f, 0.476226f, -0.303801f,
    0.749786f, 0.634579f, -0.187432f,
    0.772575f, 0.486240f, -0.408286f,
    0.816233f, 0.446977f, -0.366027f,
    0.803016f, 0.415597f, -0.427135f,
    0.790170f, 0.594895f, -0.147414f,
    0.827110f, 0.551859f, -0.106494f,
    0.830812f, 0.529135f, -0.172532f,
    0.551859f, -0.106494f, 0.827110f,
    0.529135f, -0.172532f, 0.830812f,
    0.594895f, -0.147414f, 0.790170f,
    0.634579f, -0.187432f, 0.749786f,
    0.504209f, -0.237229f, 0.830359f,
    0.610926f, -0.255180f, 0.749435f,
    0.672319f, -0.228900f, 0.703983f,
    0.545109f, -0.280319f, 0.790112f,
    0.583691f, -0.322141f, 0.745339f,
    0.553372f, -0.386730f, 0.737712f,
    0.619186f, -0.361592f, 0.697037f,
    0.476226f, -0.303801f, 0.825175f,
    0.705236f, -0.267381f, 0.656620f,
    0.678913f, -0.334692f, 0.653497f,
    0.734794f, -0.305212f, 0.605742f,
    0.760406f, -0.341435f, 0.552453f,
    0.649448f, -0.399769f, 0.646840f,
    0.446977f, -0.366027f, 0.816233f,
    0.415597f, -0.427135f, 0.803016f,
    0.486240f, -0.408286f, 0.772575f,
    0.522499f, -0.448259f, 0.725299f,
    0.382683f, -0.485712f, 0.785899f,
    0.735011f, -0.414273f, 0.536784f,
    0.785899f, -0.382683f, 0.485712f,
    0.678977f, -0.443957f, 0.584716f,
    0.704471f, -0.485208f, 0.517970f,
    0.669612f, -0.552418f, 0.496441f,
    0.725299f, -0.522499f, 0.448259f,
    0.619242f, -0.470917f, 0.628313f,
    0.607478f, -0.581952f, 0.540650f,
    0.628313f, -0.619242f, 0.470917f,
    0.581952f, -0.540650f, 0.607478f,
    0.540650f, -0.607478f, 0.581952f,
    0.470917f, -0.628313f, 0.619242f,
    0.496441f, -0.669612f, 0.552418f,
    0.552418f, -0.496441f, 0.669612f,
    0.584716f, -0.678977f, 0.443957f,
    0.646840f, -0.649448f, 0.399769f,
    0.517970f, -0.704471f, 0.485208f,
    0.536784f, -0.735011f, 0.414273f,
    0.485712f, -0.785899f, 0.382683f,
    0.552453f, -0.760406f, 0.341435f,
    0.448259f, -0.725299f, 0.522499f,
    0.485208f, -0.517970f, 0.704471f,
    0.414273f, -0.536784f, 0.735011f,
    0.443957f, -0.584716f, 0.678977f,
    0.399769f, -0.646840f, 0.649448f,
    0.341435f, -0.552453f, 0.760406f,
    0.803016f, -0.415597f, 0.427135f,
    0.772575f, -0.486240f, 0.408286f,
    0.816233f, -0.446977f, 0.366027f,
    0.825175f, -0.476226f, 0.303801f,
    0.737712f, -0.553372f, 0.386730f,
    0.790112f, -0.545109f, 0.280319f,
    0.830359f, -0.504209f, 0.237229f,
    0.745339f, -0.583691f, 0.322141f,
    0.749435f, -0.610926f, 0.255180f,
    0.703983f, -0.672319f, 0.228900f,
    0.749786f, -0.634579f, 0.187432f,
    0.697037f, -0.619186f, 0.361592f,
    0.830812f, -0.529135f, 0.172532f,
    0.790170f, -0.594895f, 0.147414f,
    0.827110f, -0.551859f, 0.106494f,
    0.653497f, -0.678913f, 0.334692f,
    0.605742f, -0.734794f, 0.305212f,
    0.656620f, -0.705236f, 0.267381f,
    0.305212f, -0.605742f, 0.734794f,
    0.267381f, -0.656620f, 0.705236f,
    0.334692f, -0.653497f, 0.678913f,
    0.361592f, -0.697037f, 0.619186f,
    0.228900f, -0.703983f, 0.672319f,
    0.322141f, -0.745339f, 0.583691f,
    0.386730f, -0.737712f, 0.553372f,
    0.255180f, -0.749435f, 0.610926f,
    0.280319f, -0.790112f, 0.545109f,
    0.237229f, -0.830359f, 0.504209f,
    0.303801f, -0.825175f, 0.476226f,
    0.187432f, -0.749786f, 0.634579f,
    0.408286f, -0.772575f, 0.486240f,
    0.366027f, -0.816233f, 0.446977f,
    0.427135f, -0.803016f, 0.415597f,
    0.147414f, -0.790170f, 0.594895f,
    0.106494f, -0.827110f, 0.551859f,
    0.172532f, -0.830812f, 0.529135f,
    0.551859f, -0.106494f, -0.827110f,
    0.594895f, -0.147414f, -0.790170f,
    0.529135f, -0.172532f, -0.830812f,
    0.504209f, -0.237229f, -0.830359f,
    0.634579f, -0.187432f, -0.749786f,
    0.545109f, -0.280319f, -0.790112f,
    0.476226f, -0.303801f, -0.825175f,
    0.610926f, -0.255180f, -0.749435f,
    0.583691f, -0.322141f, -0.745339f,
    0.619186f, -0.361592f, -0.697037f,
    0.553372f, -0.386730f, -0.737712f,
    0.672319f, -0.228900f, -0.703983f,
    0.446977f, -0.366027f, -0.816233f,
    0.486240f, -0.408286f, -0.772575f,
    0.415597f, -0.427135f, -0.803016f,
    0.382683f, -0.485712f, -0.785899f,
    0.522499f, -0.448259f, -0.725299f,
    0.705236f, -0.267381f, -0.656620f,
    0.734794f, -0.305212f, -0.605742f,
    0.678913f, -0.334692f, -0.653497f,
    0.649448f, -0.399769f, -0.646840f,
    0.760406f, -0.341435f, -0.552453f,
    0.414273f, -0.536784f, -0.735011f,
    0.341435f, -0.552453f, -0.760406f,
    0.485208f, -0.517970f, -0.704471f,
    0.443957f, -0.584716f, -0.678977f,
    0.470917f, -0.628313f, -0.619242f,
    0.399769f, -0.646840f, -0.649448f,
    0.552418f, -0.496441f, -0.669612f,
    0.540650f, -0.607478f, -0.581952f,
    0.496441f, -0.669612f, -0.552418f,
    0.581952f, -0.540650f, -0.607478f,
    0.607478f, -0.581952f, -0.540650f,
    0.669612f, -0.552418f, -0.496441f,
    0.628313f, -0.619242f, -0.470917f,
    0.619242f, -0.470917f, -0.628313f,
    0.517970f, -0.704471f, -0.485208f,
    0.448259f, -0.725299f, -0.522499f,
    0.584716f, -0.678977f, -0.443957f,
    0.536784f, -0.735011f, -0.414273f,
    0.552453f, -0.760406f, -0.341435f,
    0.485712f, -0.785899f, -0.382683f,
    0.646840f, -0.649448f, -0.399769f,
    0.678977f, -0.443957f, -0.584716f,
    0.735011f, -0.414273f, -0.536784f,
    0.704471f, -0.485208f, -0.517970f,
    0.725299f, -0.522499f, -0.448259f,
    0.785899f, -0.382683f, -0.485712f,
    0.305212f, -0.605742f, -0.734794f,
    0.334692f, -0.653497f, -0.678913f,
    0.267381f, -0.656620f, -0.705236f,
    0.228900f, -0.703983f, -0.672319f,
    0.361592f, -0.697037f, -0.619186f,
    0.255180f, -0.749435f, -0.610926f,
    0.187432f, -0.749786f, -0.634579f,
    0.322141f, -0.745339f, -0.583691f,
    0.280319f, -0.790112f, -0.545109f,
    0.303801f, -0.825175f, -0.476226f,
    0.237229f, -0.830359f, -0.504209f,
    0.386730f, -0.737712f, -0.553372f,
    0.147414f, -0.790170f, -0.594895f,
    0.172532f, -0.830812f, -0.529135f,
    0.106494f, -0.827110f, -0.551859f,
    0.408286f, -0.772575f, -0.486240f,
    0.427135f, -0.803016f, -0.415597f,
    0.366027f, -0.816233f, -0.446977f,
    0.803016f, -0.415597f, -0.427135f,
    0.816233f, -0.446977f, -0.366027f,
    0.772575f, -0.486240f, -0.408286f,
    0.737712f, -0.553372f, -0.386730f,
    0.825175f, -0.476226f, -0.303801f,
    0.745339f, -0.583691f, -0.322141f,
    0.697037f, -0.619186f, -0.361592f,
    0.790112f, -0.545109f, -0.280319f,
    0.749435f, -0.610926f, -0.255180f,
    0.749786f, -0.634579f, -0.187432f,
    0.703983f, -0.672319f, -0.228900f,
    0.830359f, -0.504209f, -0.237229f,
    0.653497f, -0.678913f, -0.334692f,
    0.656620f, -0.705236f, -0.267381f,
    0.605742f, -0.734794f, -0.305212f,
    0.830812f, -0.529135f, -0.172532f,
    0.827110f, -0.551859f, -0.106494f,
    0.790170f, -0.594895f, -0.147414f,
    -0.551859f, 0.106494f, 0.827110f,
    -0.529135f, 0.172532f, 0.830812f,
    -0.594895f, 0.147414f, 0.790170f,
    -0.634579f, 0.187432f, 0.749786f,
    -0.504209f, 0.237229f, 0.830359f,
    -0.610926f, 0.255180f, 0.749435f,
    -0.672319f, 0.228900f, 0.703983f,
    -0.545109f, 0.280319f, 0.790112f,
    -0.583691f, 0.322141f, 0.745339f,
    -0.553372f, 0.386730f, 0.737712f,
    -0.619186f, 0.361592f, 0.697037f,
    -0.476226f, 0.303801f, 0.825175f,
    -0.705236f, 0.267381f, 0.656620f,
    -0.678913f, 0.334692f, 0.653497f,
    -0.734794f, 0.305212f, 0.605742f,
    -0.760406f, 0.341435f, 0.552453f,
    -0.649448f, 0.399769f, 0.646840f,
    -0.446977f, 0.366027f, 0.816233f,
    -0.415597f, 0.427135f, 0.803016f,
    -0.486240f, 0.408286f, 0.772575f,
    -0.522499f, 0.448259f, 0.725299f,
    -0.382683f, 0.485712f, 0.785899f,
    -0.735011f, 0.414273f, 0.536784f,
    -0.785899f, 0.382683f, 0.485712f,
    -0.678977f, 0.443957f, 0.584716f,
    -0.704471f, 0.485208f, 0.517970f,
    -0.669612f, 0.552418f, 0.496441f,
    -0.725299f, 0.522499f, 0.448259f,
    -0.619242f, 0.470917f, 0.628313f,
    -0.607478f, 0.581952f, 0.540650f,
    -0.628313f, 0.619242f, 0.470917f,
    -0.581952f, 0.540650f, 0.607478f,
    -0.540650f, 0.607478f, 0.581952f,
    -0.470917f, 0.628313f, 0.619242f,
    -0.496441f, 0.669612f, 0.552418f,
    -0.552418f, 0.496441f, 0.669612f,
    -0.584716f, 0.678977f, 0.443957f,
    -0.646840f, 0.649448f, 0.399769f,
    -0.517970f, 0.704471f, 0.485208f,
    -0.536784f, 0.735011f, 0.414273f,
    -0.485712f, 0.785899f, 0.382683f,
    -0.552453f, 0.760406f, 0.341435f,
    -0.448259f, 0.725299f, 0.522499f,
    -0.485208f, 0.517970f, 0.704471f,
    -0.414273f, 0.536784f, 0.735011f,
    -0.443957f, 0.584716f, 0.678977f,
    -0.399769f, 0.646840f, 0.649448f,
    -0.341435f, 0.552453f, 0.760406f,
    -0.803016f, 0.415597f, 0.427135f,
    -0.772575f, 0.486240f, 0.408286f,
    -0.816233f, 0.446977f, 0.366027f,
    -0.825175f, 0.476226f, 0.303801f,
    -0.737712f, 0.553372f, 0.386730f,
    -0.790112f, 0.545109f, 0.280319f,
    -0.830359f, 0.504209f, 0.237229f,
    -0.745339f, 0.583691f, 0.322141f,
    -0.749435f, 0.610926f, 0.255180f,
    -0.703983f, 0.672319f, 0.228900f,
    -0.749786f, 0.634579f, 0.187432f,
    -0.697037f, 0.619186f, 0.361592f,
    -0.830812f, 0.529135f, 0.172532f,
    -0.790170f, 0.594895f, 0.147414f,
    -0.827110f, 0.551859f, 0.106494f,
    -0.653497f, 0.678913f, 0.334692f,
    -0.605742f, 0.734794f, 0.305212f,
    -0.656620f, 0.705236f, 0.267381f,
    -0.305212f, 0.605742f, 0.734794f,
    -0.267381f, 0.656620f, 0.705236f,
    -0.334692f, 0.653497f, 0.678913f,
    -0.361592f, 0.697037f, 0.619186f,
    -0.228900f, 0.703983f, 0.672319f,
    -0.322141f, 0.745339f, 0.583691f,
    -0.386730f, 0.737712f, 0.553372f,
    -0.255180f, 0.749435f, 0.610926f,
    -0.280319f, 0.790112f, 0.545109f,
    -0.237229f, 0.830359f, 0.504209f,
    -0.303801f, 0.825175f, 0.476226f,
    -0.187432f, 0.749786f, 0.634579f,
    -0.408286f, 0.772575f, 0.486240f,
    -0.366027f, 0.816233f, 0.446977f,
    -0.427135f, 0.803016f, 0.415597f,
    -0.147414f, 0.790170f, 0.594895f,
    -0.106494f, 0.827110f, 0.551859f,
    -0.172532f, 0.830812f, 0.529135f,
    -0.551859f, 0.106494f, -0.827110f,
    -0.594895f, 0.147414f, -0.790170f,
    -0.529135f, 0.172532f, -0.830812f,
    -0.504209f, 0.237229f, -0.830359f,
    -0.634579f, 0.187432f, -0.749786f,
    -0.545109f, 0.280319f, -0.790112f,
    -0.476226f, 0.303801f, -0.825175f,
    -0.610926f, 0.255180f, -0.749435f,
    -0.583691f, 0.322141f, -0.745339f,
    -0.619186f, 0.361592f, -0.697037f,
    -0.553372f, 0.386730f, -0.737712f,
    -0.672319f, 0.228900f, -0.703983f,
    -0.446977f, 0.366027f, -0.816233f,
    -0.486240f, 0.408286f, -0.772575f,
    -0.415597f, 0.427135f, -0.803016f,
    -0.382683f, 0.485712f, -0.785899f,
    -0.522499f, 0.448259f, -0.725299f,
    -0.705236f, 0.267381f, -0.656620f,
    -0.734794f, 0.305212f, -0.605742f,
    -0.678913f, 0.334692f, -0.653497f,
    -0.649448f, 0.399769f, -0.646840f,
    -0.760406f, 0.341435f, -0.552453f,
    -0.414273f, 0.536784f, -0.735011f,
    -0.341435f, 0.552453f, -0.760406f,
    -0.485208f, 0.517970f, -0.704471f,
    -0.443957f, 0.584716f, -0.678977f,
    -0.470917f, 0.628313f, -0.619242f,
    -0.399769f, 0.646840f, -0.649448f,
    -0.552418f, 0.496441f, -0.669612f,
    -0.540650f, 0.607478f, -0.581952f,
    -0.496441f, 0.669612f, -0.552418f,
    -0.581952f, 0.540650f, -0.607478f,
    -0.607478f, 0.581952f, -0.540650f,
    -0.669612f, 0.552418f, -0.496441f,
    -0.628313f, 0.619242f, -0.470917f,
    -0.619242f, 0.470917f, -0.628313f,
    -0.517970f, 0.704471f, -0.485208f,
    -0.448259f, 0.725299f, -0.522499f,
    -0.584716f, 0.678977f, -0.443957f,
    -0.536784f, 0.735011f, -0.414273f,
    -0.552453f, 0.760406f, -0.341435f,
    -0.485712f, 0.785899f, -0.382683f,
    -0.646840f, 0.649448f, -0.399769f,
    -0.678977f, 0.443957f, -0.584716f,
    -0.735011f, 0.414273f, -0.536784f,
    -0.704471f, 0.485208f, -0.517970f,
    -0.725299f, 0.522499f, -0.448259f,
    -0.785899f, 0.382683f, -0.485712f,
    -0.305212f, 0.605742f, -0.734794f,
    -0.334692f, 0.653497f, -0.678913f,
    -0.267381f, 0.656620f, -0.705236f,
    -0.228900f, 0.703983f, -0.672319f,
    -0.361592f, 0.697037f, -0.619186f,
    -0.255180f, 0.749435f, -0.610926f,
    -0.187432f, 0.749786f, -0.634579f,
    -0.322141f, 0.745339f, -0.583691f,
    -0.280319f, 0.790112f, -0.545109f,
    -0.303801f, 0.825175f, -0.476226f,
    -0.237229f, 0.830359f, -0.504209f,
    -0.386730f, 0.737712f, -0.553372f,
    -0.147414f, 0.790170f, -0.594895f,
    -0.172532f, 0.830812f, -0.529135f,
    -0.106494f, 0.827110f, -0.551859f,
    -0.408286f, 0.772575f, -0.486240f,
    -0.427135f, 0.803016f, -0.415597f,
    -0.366027f, 0.816233f, -0.446977f,
    -0.803016f, 0.415597f, -0.427135f,
    -0.816233f, 0.446977f, -0.366027f,
    -0.772575f, 0.486240f, -0.408286f,
    -0.737712f, 0.553372f, -0.386730f,
    -0.825175f, 0.476226f, -0.303801f,
    -0.745339f, 0.583691f, -0.322141f,
    -0.697037f, 0.619186f, -0.361592f,
    -0.790112f, 0.545109f, -0.280319f,
    -0.749435f, 0.610926f, -0.255180f,
    -0.749786f, 0.634579f, -0.187432f,
    -0.703983f, 0.672319f, -0.228900f,
    -0.830359f, 0.504209f, -0.237229f,
    -0.653497f, 0.678913f, -0.334692f,
    -0.656620f, 0.705236f, -0.267381f,
    -0.605742f, 0.734794f, -0.305212f,
    -0.830812f, 0.529135f, -0.172532f,
    -0.827110f, 0.551859f, -0.106494f,
    -0.790170f, 0.594895f, -0.147414f,
    -0.551859f, -0.106494f, 0.827110f,
    -0.594895f, -0.147414f, 0.790170f,
    -0.529135f, -0.172532f, 0.830812f,
    -0.504209f, -0.237229f, 0.830359f,
    -0.634579f, -0.187432f, 0.749786f,
    -0.545109f, -0.280319f, 0.790112f,
    -0.476226f, -0.303801f, 0.825175f,
    -0.610926f, -0.255180f, 0.749435f,
    -0.583691f, -0.322141f, 0.745339f,
    -0.619186f, -0.361592f, 0.697037f,
    -0.553372f, -0.386730f, 0.737712f,
    -0.672319f, -0.228900f, 0.703983f,
    -0.446977f, -0.366027f, 0.816233f,
    -0.486240f, -0.408286f, 0.772575f,
    -0.415597f, -0.427135f, 0.803016f,
    -0.382683f, -0.485712f, 0.785899f,
    -0.522499f, -0.448259f, 0.725299f,
    -0.705236f, -0.267381f, 0.656620f,
    -0.734794f, -0.305212f, 0.605742f,
    -0.678913f, -0.334692f, 0.653497f,
    -0.649448f, -0.399769f, 0.646840f,
    -0.760406f, -0.341435f, 0.552453f,
    -0.414273f, -0.536784f, 0.735011f,
    -0.341435f, -0.552453f, 0.760406f,
    -0.485208f, -0.517970f, 0.704471f,
    -0.443957f, -0.584716f, 0.678977f,
    -0.470917f, -0.628313f, 0.619242f,
    -0.399769f, -0.646840f, 0.649448f,
    -0.552418f, -0.496441f, 0.669612f,
    -0.540650f, -0.607478f, 0.581952f,
    -0.496441f, -0.669612f, 0.552418f,
    -0.581952f, -0.540650f, 0.607478f,
    -0.607478f, -0.581952f, 0.540650f,
    -0.669612f, -0.552418f, 0.496441f,
    -0.628313f, -0.619242f, 0.470917f,
    -0.619242f, -0.470917f, 0.628313f,
    -0.517970f, -0.704471f, 0.485208f,
    -0.448259f, -0.725299f, 0.522499f,
    -0.584716f, -0.678977f, 0.443957f,
    -0.536784f, -0.735011f, 0.414273f,
    -0.552453f, -0.760406f, 0.341435f,
    -0.485712f, -0.785899f, 0.382683f,
    -0.646840f, -0.649448f, 0.399769f,
    -0.678977f, -0.443957f, 0.584716f,
    -0.735011f, -0.414273f, 0.536784f,
    -0.704471f, -0.485208f, 0.517970f,
    -0.725299f, -0.522499f, 0.448259f,
    -0.785899f, -0.382683f, 0.485712f,
    -0.305212f, -0.605742f, 0.734794f,
    -0.334692f, -0.653497f, 0.678913f,
    -0.267381f, -0.656620f, 0.705236f,
    -0.228900f, -0.703983f, 0.672319f,
    -0.361592f, -0.697037f, 0.619186f,
    -0.255180f, -0.749435f, 0.610926f,
    -0.187432f, -0.749786f, 0.634579f,
    -0.322141f, -0.745339f, 0.583691f,
    -0.280319f, -0.790112f, 0.545109f,
    -0.303801f, -0.825175f, 0.476226f,
    -0.237229f, -0.830359f, 0.504209f,
    -0.386730f, -0.737712f, 0.553372f,
    -0.147414f, -0.790170f, 0.594895f,
    -0.172532f, -0.830812f, 0.529135f,
    -0.106494f, -0.827110f, 0.551859f,
    -0.408286f, -0.772575f, 0.486240f,
    -0.427135f, -0.803016f, 0.415597f,
    -0.366027f, -0.816233f, 0.446977f,
    -0.803016f, -0.415597f, 0.427135f,
    -0.816233f, -0.446977f, 0.366027f,
    -0.772575f, -0.486240f, 0.408286f,
    -0.737712f, -0.553372f, 0.386730f,
    -0.825175f, -0.476226f, 0.303801f,
    -0.745339f, -0.583691f, 0.322141f,
    -0.697037f, -0.619186f, 0.361592f,
    -0.790112f, -0.545109f, 0.280319f,
    -0.749435f, -0.610926f, 0.255180f,
    -0.749786f, -0.634579f, 0.187432f,
    -0.703983f, -0.672319f, 0.228900f,
    -0.830359f, -0.504209f, 0.237229f,
    -0.653497f, -0.678913f, 0.334692f,
    -0.656620f, -0.705236f, 0.267381f,
    -0.605742f, -0.734794f, 0.305212f,
    -0.830812f, -0.529135f, 0.172532f,
    -0.827110f, -0.551859f, 0.106494f,
    -0.790170f, -0.594895f, 0.147414f,
    -0.551859f, -0.106494f, -0.827110f,
    -0.529135f, -0.172532f, -0.830812f,
    -0.594895f, -0.147414f, -0.790170f,
    -0.634579f, -0.187432f, -0.749786f,
    -0.504209f, -0.237229f, -0.830359f,
    -0.610926f, -0.255180f, -0.749435f,
    -0.672319f, -0.228900f, -0.703983f,
    -0.545109f, -0.280319f, -0.790112f,
    -0.583691f, -0.322141f, -0.745339f,
    -0.553372f, -0.386730f, -0.737712f,
    -0.619186f, -0.361592f, -0.697037f,
    -0.476226f, -0.303801f, -0.825175f,
    -0.705236f, -0.267381f, -0.656620f,
    -0.678913f, -0.334692f, -0.653497f,
    -0.734794f, -0.305212f, -0.605742f,
    -0.760406f, -0.341435f, -0.552453f,
    -0.649448f, -0.399769f, -0.646840f,
    -0.446977f, -0.366027f, -0.816233f,
    -0.415597f, -0.427135f, -0.803016f,
    -0.486240f, -0.408286f, -0.772575f,
    -0.522499f, -0.448259f, -0.725299f,
    -0.382683f, -0.485712f, -0.785899f,
    -0.735011f, -0.414273f, -0.536784f,
    -0.785899f, -0.382683f, -0.485712f,
    -0.678977f, -0.443957f, -0.584716f,
    -0.704471f, -0.485208f, -0.517970f,
    -0.669612f, -0.552418f, -0.496441f,
    -0.725299f, -0.522499f, -0.448259f,
    -0.619242f, -0.470917f, -0.628313f,
    -0.607478f, -0.581952f, -0.540650f,
    -0.628313f, -0.619242f, -0.470917f,
    -0.581952f, -0.540650f, -0.607478f,
    -0.540650f, -0.607478f, -0.581952f,
    -0.470917f, -0.628313f, -0.619242f,
    -0.496441f, -0.669612f, -0.552418f,
    -0.552418f, -0.496441f, -0.669612f,
    -0.584716f, -0.678977f, -0.443957f,
    -0.646840f, -0.649448f, -0.399769f,
    -0.517970f, -0.704471f, -0.485208f,
    -0.536784f, -0.735011f, -0.414273f,
    -0.485712f, -0.785899f, -0.382683f,
    -0.552453f, -0.760406f, -0.341435f,
    -0.448259f, -0.725299f, -0.522499f,
    -0.485208f, -0.517970f, -0.704471f,
    -0.414273f, -0.536784f, -0.735011f,
    -0.443957f, -0.584716f, -0.678977f,
    -0.399769f, -0.646840f, -0.649448f,
    -0.341435f, -0.552453f, -0.760406f,
    -0.803016f, -0.415597f, -0.427135f,
    -0.772575f, -0.486240f, -0.408286f,
    -0.816233f, -0.446977f, -0.366027f,
    -0.825175f, -0.476226f, -0.303801f,
    -0.737712f, -0.553372f, -0.386730f,
    -0.790112f, -0.545109f, -0.280319f,
    -0.830359f, -0.504209f, -0.237229f,
    -0.745339f, -0.583691f, -0.322141f,
    -0.749435f, -0.610926f, -0.255180f,
    -0.703983f, -0.672319f, -0.228900f,
    -0.749786f, -0.634579f, -0.187432f,
    -0.697037f, -0.619186f, -0.361592f,
    -0.830812f, -0.529135f, -0.172532f,
    -0.790170f, -0.594895f, -0.147414f,
    -0.827110f, -0.551859f, -0.106494f,
    -0.653497f, -0.678913f, -0.334692f,
    -0.605742f, -0.734794f, -0.305212f,
    -0.656620f, -0.705236f, -0.267381f,
    -0.305212f, -0.605742f, -0.734794f,
    -0.267381f, -0.656620f, -0.705236f,
    -0.334692f, -0.653497f, -0.678913f,
    -0.361592f, -0.697037f, -0.619186f,
    -0.228900f, -0.703983f, -0.672319f,
    -0.322141f, -0.745339f, -0.583691f,
    -0.386730f, -0.737712f, -0.553372f,
    -0.255180f, -0.749435f, -0.610926f,
    -0.280319f, -0.790112f, -0.545109f,
    -0.237229f, -0.830359f, -0.504209f,
    -0.303801f, -0.825175f, -0.476226f,
    -0.187432f, -0.749786f, -0.634579f,
    -0.408286f, -0.772575f, -0.486240f,
    -0.366027f, -0.816233f, -0.446977f,
    -0.427135f, -0.803016f, -0.415597f,
    -0.147414f, -0.790170f, -0.594895f,
    -0.106494f, -0.827110f, -0.551859f,
    -0.172532f, -0.830812f, -0.529135f
};

//////////////////////////////////////////////////////////////////////
// dane indeksw wierzchokw trjktw
//////////////////////////////////////////////////////////////////////
GLuint sphereVeryHighIndices[SPHERE_VERY_HIGH_INDICES_COUNT * 3]=
{
    4, 642, 644,
    644, 642, 643,
    644, 643, 164,
    642, 162, 643,
    164, 643, 646,
    646, 643, 645,
    646, 645, 163,
    643, 162, 645,
    164, 646, 648,
    648, 646, 647,
    648, 647, 44,
    646, 163, 647,
    162, 649, 645,
    645, 649, 650,
    645, 650, 163,
    649, 42, 650,
    44, 647, 652,
    652, 647, 651,
    652, 651, 166,
    647, 163, 651,
    166, 651, 654,
    654, 651, 653,
    654, 653, 165,
    651, 163, 653,
    166, 654, 656,
    656, 654, 655,
    656, 655, 43,
    654, 165, 655,
    163, 650, 653,
    653, 650, 657,
    653, 657, 165,
    650, 42, 657,
    44, 652, 659,
    659, 652, 658,
    659, 658, 168,
    652, 166, 658,
    168, 658, 661,
    661, 658, 660,
    661, 660, 167,
    658, 166, 660,
    168, 661, 663,
    663, 661, 662,
    663, 662, 14,
    661, 167, 662,
    166, 656, 660,
    660, 656, 664,
    660, 664, 167,
    656, 43, 664,
    42, 665, 657,
    657, 665, 666,
    657, 666, 165,
    665, 169, 666,
    165, 666, 668,
    668, 666, 667,
    668, 667, 170,
    666, 169, 667,
    165, 668, 655,
    655, 668, 669,
    655, 669, 43,
    668, 170, 669,
    169, 670, 667,
    667, 670, 671,
    667, 671, 170,
    670, 12, 671,
    14, 662, 673,
    673, 662, 672,
    673, 672, 172,
    662, 167, 672,
    172, 672, 675,
    675, 672, 674,
    675, 674, 171,
    672, 167, 674,
    172, 675, 677,
    677, 675, 676,
    677, 676, 46,
    675, 171, 676,
    167, 664, 674,
    674, 664, 678,
    674, 678, 171,
    664, 43, 678,
    46, 676, 680,
    680, 676, 679,
    680, 679, 174,
    676, 171, 679,
    174, 679, 682,
    682, 679, 681,
    682, 681, 173,
    679, 171, 681,
    174, 682, 684,
    684, 682, 683,
    684, 683, 45,
    682, 173, 683,
    171, 678, 681,
    681, 678, 685,
    681, 685, 173,
    678, 43, 685,
    46, 680, 687,
    687, 680, 686,
    687, 686, 176,
    680, 174, 686,
    176, 686, 689,
    689, 686, 688,
    689, 688, 175,
    686, 174, 688,
    176, 689, 691,
    691, 689, 690,
    691, 690, 13,
    689, 175, 690,
    174, 684, 688,
    688, 684, 692,
    688, 692, 175,
    684, 45, 692,
    43, 669, 685,
    685, 669, 693,
    685, 693, 173,
    669, 170, 693,
    173, 693, 695,
    695, 693, 694,
    695, 694, 177,
    693, 170, 694,
    173, 695, 683,
    683, 695, 696,
    683, 696, 45,
    695, 177, 696,
    170, 671, 694,
    694, 671, 697,
    694, 697, 177,
    671, 12, 697,
    14, 673, 699,
    699, 673, 698,
    699, 698, 179,
    673, 172, 698,
    179, 698, 701,
    701, 698, 700,
    701, 700, 178,
    698, 172, 700,
    179, 701, 703,
    703, 701, 702,
    703, 702, 48,
    701, 178, 702,
    172, 677, 700,
    700, 677, 704,
    700, 704, 178,
    677, 46, 704,
    48, 702, 706,
    706, 702, 705,
    706, 705, 181,
    702, 178, 705,
    181, 705, 708,
    708, 705, 707,
    708, 707, 180,
    705, 178, 707,
    181, 708, 710,
    710, 708, 709,
    710, 709, 47,
    708, 180, 709,
    178, 704, 707,
    707, 704, 711,
    707, 711, 180,
    704, 46, 711,
    48, 706, 713,
    713, 706, 712,
    713, 712, 183,
    706, 181, 712,
    183, 712, 715,
    715, 712, 714,
    715, 714, 182,
    712, 181, 714,
    183, 715, 717,
    717, 715, 716,
    717, 716, 7,
    715, 182, 716,
    181, 710, 714,
    714, 710, 718,
    714, 718, 182,
    710, 47, 718,
    46, 687, 711,
    711, 687, 719,
    711, 719, 180,
    687, 176, 719,
    180, 719, 721,
    721, 719, 720,
    721, 720, 184,
    719, 176, 720,
    180, 721, 709,
    709, 721, 722,
    709, 722, 47,
    721, 184, 722,
    176, 691, 720,
    720, 691, 723,
    720, 723, 184,
    691, 13, 723,
    12, 724, 697,
    697, 724, 725,
    697, 725, 177,
    724, 185, 725,
    177, 725, 727,
    727, 725, 726,
    727, 726, 186,
    725, 185, 726,
    177, 727, 696,
    696, 727, 728,
    696, 728, 45,
    727, 186, 728,
    185, 729, 726,
    726, 729, 730,
    726, 730, 186,
    729, 49, 730,
    45, 728, 732,
    732, 728, 731,
    732, 731, 188,
    728, 186, 731,
    188, 731, 734,
    734, 731, 733,
    734, 733, 187,
    731, 186, 733,
    188, 734, 736,
    736, 734, 735,
    736, 735, 50,
    734, 187, 735,
    186, 730, 733,
    733, 730, 737,
    733, 737, 187,
    730, 49, 737,
    45, 732, 692,
    692, 732, 738,
    692, 738, 175,
    732, 188, 738,
    175, 738, 740,
    740, 738, 739,
    740, 739, 189,
    738, 188, 739,
    175, 740, 690,
    690, 740, 741,
    690, 741, 13,
    740, 189, 741,
    188, 736, 739,
    739, 736, 742,
    739, 742, 189,
    736, 50, 742,
    49, 743, 737,
    737, 743, 744,
    737, 744, 187,
    743, 190, 744,
    187, 744, 746,
    746, 744, 745,
    746, 745, 191,
    744, 190, 745,
    187, 746, 735,
    735, 746, 747,
    735, 747, 50,
    746, 191, 747,
    190, 748, 745,
    745, 748, 749,
    745, 749, 191,
    748, 8, 749,
    4, 644, 751,
    751, 644, 750,
    751, 750, 193,
    644, 164, 750,
    193, 750, 753,
    753, 750, 752,
    753, 752, 192,
    750, 164, 752,
    193, 753, 755,
    755, 753, 754,
    755, 754, 52,
    753, 192, 754,
    164, 648, 752,
    752, 648, 756,
    752, 756, 192,
    648, 44, 756,
    52, 754, 758,
    758, 754, 757,
    758, 757, 195,
    754, 192, 757,
    195, 757, 760,
    760, 757, 759,
    760, 759, 194,
    757, 192, 759,
    195, 760, 762,
    762, 760, 761,
    762, 761, 51,
    760, 194, 761,
    192, 756, 759,
    759, 756, 763,
    759, 763, 194,
    756, 44, 763,
    52, 758, 765,
    765, 758, 764,
    765, 764, 197,
    758, 195, 764,
    197, 764, 767,
    767, 764, 766,
    767, 766, 196,
    764, 195, 766,
    197, 767, 769,
    769, 767, 768,
    769, 768, 16,
    767, 196, 768,
    195, 762, 766,
    766, 762, 770,
    766, 770, 196,
    762, 51, 770,
    44, 659, 763,
    763, 659, 771,
    763, 771, 194,
    659, 168, 771,
    194, 771, 773,
    773, 771, 772,
    773, 772, 198,
    771, 168, 772,
    194, 773, 761,
    761, 773, 774,
    761, 774, 51,
    773, 198, 774,
    168, 663, 772,
    772, 663, 775,
    772, 775, 198,
    663, 14, 775,
    16, 768, 777,
    777, 768, 776,
    777, 776, 200,
    768, 196, 776,
    200, 776, 779,
    779, 776, 778,
    779, 778, 199,
    776, 196, 778,
    200, 779, 781,
    781, 779, 780,
    781, 780, 54,
    779, 199, 780,
    196, 770, 778,
    778, 770, 782,
    778, 782, 199,
    770, 51, 782,
    54, 780, 784,
    784, 780, 783,
    784, 783, 202,
    780, 199, 783,
    202, 783, 786,
    786, 783, 785,
    786, 785, 201,
    783, 199, 785,
    202, 786, 788,
    788, 786, 787,
    788, 787, 53,
    786, 201, 787,
    199, 782, 785,
    785, 782, 789,
    785, 789, 201,
    782, 51, 789,
    54, 784, 791,
    791, 784, 790,
    791, 790, 204,
    784, 202, 790,
    204, 790, 793,
    793, 790, 792,
    793, 792, 203,
    790, 202, 792,
    204, 793, 795,
    795, 793, 794,
    795, 794, 15,
    793, 203, 794,
    202, 788, 792,
    792, 788, 796,
    792, 796, 203,
    788, 53, 796,
    51, 774, 789,
    789, 774, 797,
    789, 797, 201,
    774, 198, 797,
    201, 797, 799,
    799, 797, 798,
    799, 798, 205,
    797, 198, 798,
    201, 799, 787,
    787, 799, 800,
    787, 800, 53,
    799, 205, 800,
    198, 775, 798,
    798, 775, 801,
    798, 801, 205,
    775, 14, 801,
    16, 777, 803,
    803, 777, 802,
    803, 802, 207,
    777, 200, 802,
    207, 802, 805,
    805, 802, 804,
    805, 804, 206,
    802, 200, 804,
    207, 805, 807,
    807, 805, 806,
    807, 806, 56,
    805, 206, 806,
    200, 781, 804,
    804, 781, 808,
    804, 808, 206,
    781, 54, 808,
    56, 806, 810,
    810, 806, 809,
    810, 809, 209,
    806, 206, 809,
    209, 809, 812,
    812, 809, 811,
    812, 811, 208,
    809, 206, 811,
    209, 812, 814,
    814, 812, 813,
    814, 813, 55,
    812, 208, 813,
    206, 808, 811,
    811, 808, 815,
    811, 815, 208,
    808, 54, 815,
    56, 810, 817,
    817, 810, 816,
    817, 816, 211,
    810, 209, 816,
    211, 816, 819,
    819, 816, 818,
    819, 818, 210,
    816, 209, 818,
    211, 819, 821,
    821, 819, 820,
    821, 820, 9,
    819, 210, 820,
    209, 814, 818,
    818, 814, 822,
    818, 822, 210,
    814, 55, 822,
    54, 791, 815,
    815, 791, 823,
    815, 823, 208,
    791, 204, 823,
    208, 823, 825,
    825, 823, 824,
    825, 824, 212,
    823, 204, 824,
    208, 825, 813,
    813, 825, 826,
    813, 826, 55,
    825, 212, 826,
    204, 795, 824,
    824, 795, 827,
    824, 827, 212,
    795, 15, 827,
    14, 699, 801,
    801, 699, 828,
    801, 828, 205,
    699, 179, 828,
    205, 828, 830,
    830, 828, 829,
    830, 829, 213,
    828, 179, 829,
    205, 830, 800,
    800, 830, 831,
    800, 831, 53,
    830, 213, 831,
    179, 703, 829,
    829, 703, 832,
    829, 832, 213,
    703, 48, 832,
    53, 831, 834,
    834, 831, 833,
    834, 833, 215,
    831, 213, 833,
    215, 833, 836,
    836, 833, 835,
    836, 835, 214,
    833, 213, 835,
    215, 836, 838,
    838, 836, 837,
    838, 837, 57,
    836, 214, 837,
    213, 832, 835,
    835, 832, 839,
    835, 839, 214,
    832, 48, 839,
    53, 834, 796,
    796, 834, 840,
    796, 840, 203,
    834, 215, 840,
    203, 840, 842,
    842, 840, 841,
    842, 841, 216,
    840, 215, 841,
    203, 842, 794,
    794, 842, 843,
    794, 843, 15,
    842, 216, 843,
    215, 838, 841,
    841, 838, 844,
    841, 844, 216,
    838, 57, 844,
    48, 713, 839,
    839, 713, 845,
    839, 845, 214,
    713, 183, 845,
    214, 845, 847,
    847, 845, 846,
    847, 846, 217,
    845, 183, 846,
    214, 847, 837,
    837, 847, 848,
    837, 848, 57,
    847, 217, 848,
    183, 717, 846,
    846, 717, 849,
    846, 849, 217,
    717, 7, 849,
    5, 850, 852,
    852, 850, 851,
    852, 851, 220,
    850, 218, 851,
    220, 851, 854,
    854, 851, 853,
    854, 853, 219,
    851, 218, 853,
    220, 854, 856,
    856, 854, 855,
    856, 855, 60,
    854, 219, 855,
    218, 857, 853,
    853, 857, 858,
    853, 858, 219,
    857, 58, 858,
    60, 855, 860,
    860, 855, 859,
    860, 859, 222,
    855, 219, 859,
    222, 859, 862,
    862, 859, 861,
    862, 861, 221,
    859, 219, 861,
    222, 862, 864,
    864, 862, 863,
    864, 863, 59,
    862, 221, 863,
    219, 858, 861,
    861, 858, 865,
    861, 865, 221,
    858, 58, 865,
    60, 860, 867,
    867, 860, 866,
    867, 866, 224,
    860, 222, 866,
    224, 866, 869,
    869, 866, 868,
    869, 868, 223,
    866, 222, 868,
    224, 869, 871,
    871, 869, 870,
    871, 870, 19,
    869, 223, 870,
    222, 864, 868,
    868, 864, 872,
    868, 872, 223,
    864, 59, 872,
    58, 873, 865,
    865, 873, 874,
    865, 874, 221,
    873, 225, 874,
    221, 874, 876,
    876, 874, 875,
    876, 875, 226,
    874, 225, 875,
    221, 876, 863,
    863, 876, 877,
    863, 877, 59,
    876, 226, 877,
    225, 878, 875,
    875, 878, 879,
    875, 879, 226,
    878, 17, 879,
    19, 870, 881,
    881, 870, 880,
    881, 880, 228,
    870, 223, 880,
    228, 880, 883,
    883, 880, 882,
    883, 882, 227,
    880, 223, 882,
    228, 883, 885,
    885, 883, 884,
    885, 884, 62,
    883, 227, 884,
    223, 872, 882,
    882, 872, 886,
    882, 886, 227,
    872, 59, 886,
    62, 884, 888,
    888, 884, 887,
    888, 887, 230,
    884, 227, 887,
    230, 887, 890,
    890, 887, 889,
    890, 889, 229,
    887, 227, 889,
    230, 890, 892,
    892, 890, 891,
    892, 891, 61,
    890, 229, 891,
    227, 886, 889,
    889, 886, 893,
    889, 893, 229,
    886, 59, 893,
    62, 888, 895,
    895, 888, 894,
    895, 894, 232,
    888, 230, 894,
    232, 894, 897,
    897, 894, 896,
    897, 896, 231,
    894, 230, 896,
    232, 897, 899,
    899, 897, 898,
    899, 898, 18,
    897, 231, 898,
    230, 892, 896,
    896, 892, 900,
    896, 900, 231,
    892, 61, 900,
    59, 877, 893,
    893, 877, 901,
    893, 901, 229,
    877, 226, 901,
    229, 901, 903,
    903, 901, 902,
    903, 902, 233,
    901, 226, 902,
    229, 903, 891,
    891, 903, 904,
    891, 904, 61,
    903, 233, 904,
    226, 879, 902,
    902, 879, 905,
    902, 905, 233,
    879, 17, 905,
    19, 881, 907,
    907, 881, 906,
    907, 906, 235,
    881, 228, 906,
    235, 906, 909,
    909, 906, 908,
    909, 908, 234,
    906, 228, 908,
    235, 909, 911,
    911, 909, 910,
    911, 910, 64,
    909, 234, 910,
    228, 885, 908,
    908, 885, 912,
    908, 912, 234,
    885, 62, 912,
    64, 910, 914,
    914, 910, 913,
    914, 913, 237,
    910, 234, 913,
    237, 913, 916,
    916, 913, 915,
    916, 915, 236,
    913, 234, 915,
    237, 916, 918,
    918, 916, 917,
    918, 917, 63,
    916, 236, 917,
    234, 912, 915,
    915, 912, 919,
    915, 919, 236,
    912, 62, 919,
    64, 914, 921,
    921, 914, 920,
    921, 920, 239,
    914, 237, 920,
    239, 920, 923,
    923, 920, 922,
    923, 922, 238,
    920, 237, 922,
    239, 923, 925,
    925, 923, 924,
    925, 924, 11,
    923, 238, 924,
    237, 918, 922,
    922, 918, 926,
    922, 926, 238,
    918, 63, 926,
    62, 895, 919,
    919, 895, 927,
    919, 927, 236,
    895, 232, 927,
    236, 927, 929,
    929, 927, 928,
    929, 928, 240,
    927, 232, 928,
    236, 929, 917,
    917, 929, 930,
    917, 930, 63,
    929, 240, 930,
    232, 899, 928,
    928, 899, 931,
    928, 931, 240,
    899, 18, 931,
    17, 932, 905,
    905, 932, 933,
    905, 933, 233,
    932, 241, 933,
    233, 933, 935,
    935, 933, 934,
    935, 934, 242,
    933, 241, 934,
    233, 935, 904,
    904, 935, 936,
    904, 936, 61,
    935, 242, 936,
    241, 937, 934,
    934, 937, 938,
    934, 938, 242,
    937, 65, 938,
    61, 936, 940,
    940, 936, 939,
    940, 939, 244,
    936, 242, 939,
    244, 939, 942,
    942, 939, 941,
    942, 941, 243,
    939, 242, 941,
    244, 942, 944,
    944, 942, 943,
    944, 943, 66,
    942, 243, 943,
    242, 938, 941,
    941, 938, 945,
    941, 945, 243,
    938, 65, 945,
    61, 940, 900,
    900, 940, 946,
    900, 946, 231,
    940, 244, 946,
    231, 946, 948,
    948, 946, 947,
    948, 947, 245,
    946, 244, 947,
    231, 948, 898,
    898, 948, 949,
    898, 949, 18,
    948, 245, 949,
    244, 944, 947,
    947, 944, 950,
    947, 950, 245,
    944, 66, 950,
    65, 951, 945,
    945, 951, 952,
    945, 952, 243,
    951, 246, 952,
    243, 952, 954,
    954, 952, 953,
    954, 953, 247,
    952, 246, 953,
    243, 954, 943,
    943, 954, 955,
    943, 955, 66,
    954, 247, 955,
    246, 956, 953,
    953, 956, 957,
    953, 957, 247,
    956, 6, 957,
    5, 958, 850,
    850, 958, 959,
    850, 959, 218,
    958, 248, 959,
    218, 959, 961,
    961, 959, 960,
    961, 960, 249,
    959, 248, 960,
    218, 961, 857,
    857, 961, 962,
    857, 962, 58,
    961, 249, 962,
    248, 963, 960,
    960, 963, 964,
    960, 964, 249,
    963, 67, 964,
    58, 962, 966,
    966, 962, 965,
    966, 965, 251,
    962, 249, 965,
    251, 965, 968,
    968, 965, 967,
    968, 967, 250,
    965, 249, 967,
    251, 968, 970,
    970, 968, 969,
    970, 969, 68,
    968, 250, 969,
    249, 964, 967,
    967, 964, 971,
    967, 971, 250,
    964, 67, 971,
    58, 966, 873,
    873, 966, 972,
    873, 972, 225,
    966, 251, 972,
    225, 972, 974,
    974, 972, 973,
    974, 973, 252,
    972, 251, 973,
    225, 974, 878,
    878, 974, 975,
    878, 975, 17,
    974, 252, 975,
    251, 970, 973,
    973, 970, 976,
    973, 976, 252,
    970, 68, 976,
    67, 977, 971,
    971, 977, 978,
    971, 978, 250,
    977, 253, 978,
    250, 978, 980,
    980, 978, 979,
    980, 979, 254,
    978, 253, 979,
    250, 980, 969,
    969, 980, 981,
    969, 981, 68,
    980, 254, 981,
    253, 982, 979,
    979, 982, 983,
    979, 983, 254,
    982, 20, 983,
    17, 975, 985,
    985, 975, 984,
    985, 984, 256,
    975, 252, 984,
    256, 984, 987,
    987, 984, 986,
    987, 986, 255,
    984, 252, 986,
    256, 987, 989,
    989, 987, 988,
    989, 988, 70,
    987, 255, 988,
    252, 976, 986,
    986, 976, 990,
    986, 990, 255,
    976, 68, 990,
    70, 988, 992,
    992, 988, 991,
    992, 991, 258,
    988, 255, 991,
    258, 991, 994,
    994, 991, 993,
    994, 993, 257,
    991, 255, 993,
    258, 994, 996,
    996, 994, 995,
    996, 995, 69,
    994, 257, 995,
    255, 990, 993,
    993, 990, 997,
    993, 997, 257,
    990, 68, 997,
    70, 992, 999,
    999, 992, 998,
    999, 998, 260,
    992, 258, 998,
    260, 998, 1001,
    1001, 998, 1000,
    1001, 1000, 259,
    998, 258, 1000,
    260, 1001, 1003,
    1003, 1001, 1002,
    1003, 1002, 21,
    1001, 259, 1002,
    258, 996, 1000,
    1000, 996, 1004,
    1000, 1004, 259,
    996, 69, 1004,
    68, 981, 997,
    997, 981, 1005,
    997, 1005, 257,
    981, 254, 1005,
    257, 1005, 1007,
    1007, 1005, 1006,
    1007, 1006, 261,
    1005, 254, 1006,
    257, 1007, 995,
    995, 1007, 1008,
    995, 1008, 69,
    1007, 261, 1008,
    254, 983, 1006,
    1006, 983, 1009,
    1006, 1009, 261,
    983, 20, 1009,
    17, 985, 932,
    932, 985, 1010,
    932, 1010, 241,
    985, 256, 1010,
    241, 1010, 1012,
    1012, 1010, 1011,
    1012, 1011, 262,
    1010, 256, 1011,
    241, 1012, 937,
    937, 1012, 1013,
    937, 1013, 65,
    1012, 262, 1013,
    256, 989, 1011,
    1011, 989, 1014,
    1011, 1014, 262,
    989, 70, 1014,
    65, 1013, 1016,
    1016, 1013, 1015,
    1016, 1015, 264,
    1013, 262, 1015,
    264, 1015, 1018,
    1018, 1015, 1017,
    1018, 1017, 263,
    1015, 262, 1017,
    264, 1018, 1020,
    1020, 1018, 1019,
    1020, 1019, 71,
    1018, 263, 1019,
    262, 1014, 1017,
    1017, 1014, 1021,
    1017, 1021, 263,
    1014, 70, 1021,
    65, 1016, 951,
    951, 1016, 1022,
    951, 1022, 246,
    1016, 264, 1022,
    246, 1022, 1024,
    1024, 1022, 1023,
    1024, 1023, 265,
    1022, 264, 1023,
    246, 1024, 956,
    956, 1024, 1025,
    956, 1025, 6,
    1024, 265, 1025,
    264, 1020, 1023,
    1023, 1020, 1026,
    1023, 1026, 265,
    1020, 71, 1026,
    70, 999, 1021,
    1021, 999, 1027,
    1021, 1027, 263,
    999, 260, 1027,
    263, 1027, 1029,
    1029, 1027, 1028,
    1029, 1028, 266,
    1027, 260, 1028,
    263, 1029, 1019,
    1019, 1029, 1030,
    1019, 1030, 71,
    1029, 266, 1030,
    260, 1003, 1028,
    1028, 1003, 1031,
    1028, 1031, 266,
    1003, 21, 1031,
    20, 1032, 1009,
    1009, 1032, 1033,
    1009, 1033, 261,
    1032, 267, 1033,
    261, 1033, 1035,
    1035, 1033, 1034,
    1035, 1034, 268,
    1033, 267, 1034,
    261, 1035, 1008,
    1008, 1035, 1036,
    1008, 1036, 69,
    1035, 268, 1036,
    267, 1037, 1034,
    1034, 1037, 1038,
    1034, 1038, 268,
    1037, 72, 1038,
    69, 1036, 1040,
    1040, 1036, 1039,
    1040, 1039, 270,
    1036, 268, 1039,
    270, 1039, 1042,
    1042, 1039, 1041,
    1042, 1041, 269,
    1039, 268, 1041,
    270, 1042, 1044,
    1044, 1042, 1043,
    1044, 1043, 73,
    1042, 269, 1043,
    268, 1038, 1041,
    1041, 1038, 1045,
    1041, 1045, 269,
    1038, 72, 1045,
    69, 1040, 1004,
    1004, 1040, 1046,
    1004, 1046, 259,
    1040, 270, 1046,
    259, 1046, 1048,
    1048, 1046, 1047,
    1048, 1047, 271,
    1046, 270, 1047,
    259, 1048, 1002,
    1002, 1048, 1049,
    1002, 1049, 21,
    1048, 271, 1049,
    270, 1044, 1047,
    1047, 1044, 1050,
    1047, 1050, 271,
    1044, 73, 1050,
    72, 1051, 1045,
    1045, 1051, 1052,
    1045, 1052, 269,
    1051, 272, 1052,
    269, 1052, 1054,
    1054, 1052, 1053,
    1054, 1053, 273,
    1052, 272, 1053,
    269, 1054, 1043,
    1043, 1054, 1055,
    1043, 1055, 73,
    1054, 273, 1055,
    272, 1056, 1053,
    1053, 1056, 1057,
    1053, 1057, 273,
    1056, 10, 1057,
    0, 1058, 1060,
    1060, 1058, 1059,
    1060, 1059, 276,
    1058, 274, 1059,
    276, 1059, 1062,
    1062, 1059, 1061,
    1062, 1061, 275,
    1059, 274, 1061,
    276, 1062, 1064,
    1064, 1062, 1063,
    1064, 1063, 76,
    1062, 275, 1063,
    274, 1065, 1061,
    1061, 1065, 1066,
    1061, 1066, 275,
    1065, 74, 1066,
    76, 1063, 1068,
    1068, 1063, 1067,
    1068, 1067, 278,
    1063, 275, 1067,
    278, 1067, 1070,
    1070, 1067, 1069,
    1070, 1069, 277,
    1067, 275, 1069,
    278, 1070, 1072,
    1072, 1070, 1071,
    1072, 1071, 75,
    1070, 277, 1071,
    275, 1066, 1069,
    1069, 1066, 1073,
    1069, 1073, 277,
    1066, 74, 1073,
    76, 1068, 1075,
    1075, 1068, 1074,
    1075, 1074, 280,
    1068, 278, 1074,
    280, 1074, 1077,
    1077, 1074, 1076,
    1077, 1076, 279,
    1074, 278, 1076,
    280, 1077, 1079,
    1079, 1077, 1078,
    1079, 1078, 24,
    1077, 279, 1078,
    278, 1072, 1076,
    1076, 1072, 1080,
    1076, 1080, 279,
    1072, 75, 1080,
    74, 1081, 1073,
    1073, 1081, 1082,
    1073, 1082, 277,
    1081, 281, 1082,
    277, 1082, 1084,
    1084, 1082, 1083,
    1084, 1083, 282,
    1082, 281, 1083,
    277, 1084, 1071,
    1071, 1084, 1085,
    1071, 1085, 75,
    1084, 282, 1085,
    281, 1086, 1083,
    1083, 1086, 1087,
    1083, 1087, 282,
    1086, 22, 1087,
    24, 1078, 1089,
    1089, 1078, 1088,
    1089, 1088, 284,
    1078, 279, 1088,
    284, 1088, 1091,
    1091, 1088, 1090,
    1091, 1090, 283,
    1088, 279, 1090,
    284, 1091, 1093,
    1093, 1091, 1092,
    1093, 1092, 78,
    1091, 283, 1092,
    279, 1080, 1090,
    1090, 1080, 1094,
    1090, 1094, 283,
    1080, 75, 1094,
    78, 1092, 1096,
    1096, 1092, 1095,
    1096, 1095, 286,
    1092, 283, 1095,
    286, 1095, 1098,
    1098, 1095, 1097,
    1098, 1097, 285,
    1095, 283, 1097,
    286, 1098, 1100,
    1100, 1098, 1099,
    1100, 1099, 77,
    1098, 285, 1099,
    283, 1094, 1097,
    1097, 1094, 1101,
    1097, 1101, 285,
    1094, 75, 1101,
    78, 1096, 1103,
    1103, 1096, 1102,
    1103, 1102, 288,
    1096, 286, 1102,
    288, 1102, 1105,
    1105, 1102, 1104,
    1105, 1104, 287,
    1102, 286, 1104,
    288, 1105, 1107,
    1107, 1105, 1106,
    1107, 1106, 23,
    1105, 287, 1106,
    286, 1100, 1104,
    1104, 1100, 1108,
    1104, 1108, 287,
    1100, 77, 1108,
    75, 1085, 1101,
    1101, 1085, 1109,
    1101, 1109, 285,
    1085, 282, 1109,
    285, 1109, 1111,
    1111, 1109, 1110,
    1111, 1110, 289,
    1109, 282, 1110,
    285, 1111, 1099,
    1099, 1111, 1112,
    1099, 1112, 77,
    1111, 289, 1112,
    282, 1087, 1110,
    1110, 1087, 1113,
    1110, 1113, 289,
    1087, 22, 1113,
    24, 1089, 1115,
    1115, 1089, 1114,
    1115, 1114, 291,
    1089, 284, 1114,
    291, 1114, 1117,
    1117, 1114, 1116,
    1117, 1116, 290,
    1114, 284, 1116,
    291, 1117, 1119,
    1119, 1117, 1118,
    1119, 1118, 80,
    1117, 290, 1118,
    284, 1093, 1116,
    1116, 1093, 1120,
    1116, 1120, 290,
    1093, 78, 1120,
    80, 1118, 1122,
    1122, 1118, 1121,
    1122, 1121, 293,
    1118, 290, 1121,
    293, 1121, 1124,
    1124, 1121, 1123,
    1124, 1123, 292,
    1121, 290, 1123,
    293, 1124, 1126,
    1126, 1124, 1125,
    1126, 1125, 79,
    1124, 292, 1125,
    290, 1120, 1123,
    1123, 1120, 1127,
    1123, 1127, 292,
    1120, 78, 1127,
    80, 1122, 1129,
    1129, 1122, 1128,
    1129, 1128, 295,
    1122, 293, 1128,
    295, 1128, 1131,
    1131, 1128, 1130,
    1131, 1130, 294,
    1128, 293, 1130,
    295, 1131, 1133,
    1133, 1131, 1132,
    1133, 1132, 3,
    1131, 294, 1132,
    293, 1126, 1130,
    1130, 1126, 1134,
    1130, 1134, 294,
    1126, 79, 1134,
    78, 1103, 1127,
    1127, 1103, 1135,
    1127, 1135, 292,
    1103, 288, 1135,
    292, 1135, 1137,
    1137, 1135, 1136,
    1137, 1136, 296,
    1135, 288, 1136,
    292, 1137, 1125,
    1125, 1137, 1138,
    1125, 1138, 79,
    1137, 296, 1138,
    288, 1107, 1136,
    1136, 1107, 1139,
    1136, 1139, 296,
    1107, 23, 1139,
    22, 1140, 1113,
    1113, 1140, 1141,
    1113, 1141, 289,
    1140, 297, 1141,
    289, 1141, 1143,
    1143, 1141, 1142,
    1143, 1142, 298,
    1141, 297, 1142,
    289, 1143, 1112,
    1112, 1143, 1144,
    1112, 1144, 77,
    1143, 298, 1144,
    297, 1145, 1142,
    1142, 1145, 1146,
    1142, 1146, 298,
    1145, 81, 1146,
    77, 1144, 1148,
    1148, 1144, 1147,
    1148, 1147, 300,
    1144, 298, 1147,
    300, 1147, 1150,
    1150, 1147, 1149,
    1150, 1149, 299,
    1147, 298, 1149,
    300, 1150, 1152,
    1152, 1150, 1151,
    1152, 1151, 82,
    1150, 299, 1151,
    298, 1146, 1149,
    1149, 1146, 1153,
    1149, 1153, 299,
    1146, 81, 1153,
    77, 1148, 1108,
    1108, 1148, 1154,
    1108, 1154, 287,
    1148, 300, 1154,
    287, 1154, 1156,
    1156, 1154, 1155,
    1156, 1155, 301,
    1154, 300, 1155,
    287, 1156, 1106,
    1106, 1156, 1157,
    1106, 1157, 23,
    1156, 301, 1157,
    300, 1152, 1155,
    1155, 1152, 1158,
    1155, 1158, 301,
    1152, 82, 1158,
    81, 1159, 1153,
    1153, 1159, 1160,
    1153, 1160, 299,
    1159, 302, 1160,
    299, 1160, 1162,
    1162, 1160, 1161,
    1162, 1161, 303,
    1160, 302, 1161,
    299, 1162, 1151,
    1151, 1162, 1163,
    1151, 1163, 82,
    1162, 303, 1163,
    302, 1164, 1161,
    1161, 1164, 1165,
    1161, 1165, 303,
    1164, 4, 1165,
    0, 1060, 1167,
    1167, 1060, 1166,
    1167, 1166, 305,
    1060, 276, 1166,
    305, 1166, 1169,
    1169, 1166, 1168,
    1169, 1168, 304,
    1166, 276, 1168,
    305, 1169, 1171,
    1171, 1169, 1170,
    1171, 1170, 84,
    1169, 304, 1170,
    276, 1064, 1168,
    1168, 1064, 1172,
    1168, 1172, 304,
    1064, 76, 1172,
    84, 1170, 1174,
    1174, 1170, 1173,
    1174, 1173, 307,
    1170, 304, 1173,
    307, 1173, 1176,
    1176, 1173, 1175,
    1176, 1175, 306,
    1173, 304, 1175,
    307, 1176, 1178,
    1178, 1176, 1177,
    1178, 1177, 83,
    1176, 306, 1177,
    304, 1172, 1175,
    1175, 1172, 1179,
    1175, 1179, 306,
    1172, 76, 1179,
    84, 1174, 1181,
    1181, 1174, 1180,
    1181, 1180, 309,
    1174, 307, 1180,
    309, 1180, 1183,
    1183, 1180, 1182,
    1183, 1182, 308,
    1180, 307, 1182,
    309, 1183, 1185,
    1185, 1183, 1184,
    1185, 1184, 26,
    1183, 308, 1184,
    307, 1178, 1182,
    1182, 1178, 1186,
    1182, 1186, 308,
    1178, 83, 1186,
    76, 1075, 1179,
    1179, 1075, 1187,
    1179, 1187, 306,
    1075, 280, 1187,
    306, 1187, 1189,
    1189, 1187, 1188,
    1189, 1188, 310,
    1187, 280, 1188,
    306, 1189, 1177,
    1177, 1189, 1190,
    1177, 1190, 83,
    1189, 310, 1190,
    280, 1079, 1188,
    1188, 1079, 1191,
    1188, 1191, 310,
    1079, 24, 1191,
    26, 1184, 1193,
    1193, 1184, 1192,
    1193, 1192, 312,
    1184, 308, 1192,
    312, 1192, 1195,
    1195, 1192, 1194,
    1195, 1194, 311,
    1192, 308, 1194,
    312, 1195, 1197,
    1197, 1195, 1196,
    1197, 1196, 86,
    1195, 311, 1196,
    308, 1186, 1194,
    1194, 1186, 1198,
    1194, 1198, 311,
    1186, 83, 1198,
    86, 1196, 1200,
    1200, 1196, 1199,
    1200, 1199, 314,
    1196, 311, 1199,
    314, 1199, 1202,
    1202, 1199, 1201,
    1202, 1201, 313,
    1199, 311, 1201,
    314, 1202, 1204,
    1204, 1202, 1203,
    1204, 1203, 85,
    1202, 313, 1203,
    311, 1198, 1201,
    1201, 1198, 1205,
    1201, 1205, 313,
    1198, 83, 1205,
    86, 1200, 1207,
    1207, 1200, 1206,
    1207, 1206, 316,
    1200, 314, 1206,
    316, 1206, 1209,
    1209, 1206, 1208,
    1209, 1208, 315,
    1206, 314, 1208,
    316, 1209, 1211,
    1211, 1209, 1210,
    1211, 1210, 25,
    1209, 315, 1210,
    314, 1204, 1208,
    1208, 1204, 1212,
    1208, 1212, 315,
    1204, 85, 1212,
    83, 1190, 1205,
    1205, 1190, 1213,
    1205, 1213, 313,
    1190, 310, 1213,
    313, 1213, 1215,
    1215, 1213, 1214,
    1215, 1214, 317,
    1213, 310, 1214,
    313, 1215, 1203,
    1203, 1215, 1216,
    1203, 1216, 85,
    1215, 317, 1216,
    310, 1191, 1214,
    1214, 1191, 1217,
    1214, 1217, 317,
    1191, 24, 1217,
    26, 1193, 1219,
    1219, 1193, 1218,
    1219, 1218, 319,
    1193, 312, 1218,
    319, 1218, 1221,
    1221, 1218, 1220,
    1221, 1220, 318,
    1218, 312, 1220,
    319, 1221, 1223,
    1223, 1221, 1222,
    1223, 1222, 88,
    1221, 318, 1222,
    312, 1197, 1220,
    1220, 1197, 1224,
    1220, 1224, 318,
    1197, 86, 1224,
    88, 1222, 1226,
    1226, 1222, 1225,
    1226, 1225, 321,
    1222, 318, 1225,
    321, 1225, 1228,
    1228, 1225, 1227,
    1228, 1227, 320,
    1225, 318, 1227,
    321, 1228, 1230,
    1230, 1228, 1229,
    1230, 1229, 87,
    1228, 320, 1229,
    318, 1224, 1227,
    1227, 1224, 1231,
    1227, 1231, 320,
    1224, 86, 1231,
    88, 1226, 1233,
    1233, 1226, 1232,
    1233, 1232, 323,
    1226, 321, 1232,
    323, 1232, 1235,
    1235, 1232, 1234,
    1235, 1234, 322,
    1232, 321, 1234,
    323, 1235, 1237,
    1237, 1235, 1236,
    1237, 1236, 5,
    1235, 322, 1236,
    321, 1230, 1234,
    1234, 1230, 1238,
    1234, 1238, 322,
    1230, 87, 1238,
    86, 1207, 1231,
    1231, 1207, 1239,
    1231, 1239, 320,
    1207, 316, 1239,
    320, 1239, 1241,
    1241, 1239, 1240,
    1241, 1240, 324,
    1239, 316, 1240,
    320, 1241, 1229,
    1229, 1241, 1242,
    1229, 1242, 87,
    1241, 324, 1242,
    316, 1211, 1240,
    1240, 1211, 1243,
    1240, 1243, 324,
    1211, 25, 1243,
    24, 1115, 1217,
    1217, 1115, 1244,
    1217, 1244, 317,
    1115, 291, 1244,
    317, 1244, 1246,
    1246, 1244, 1245,
    1246, 1245, 325,
    1244, 291, 1245,
    317, 1246, 1216,
    1216, 1246, 1247,
    1216, 1247, 85,
    1246, 325, 1247,
    291, 1119, 1245,
    1245, 1119, 1248,
    1245, 1248, 325,
    1119, 80, 1248,
    85, 1247, 1250,
    1250, 1247, 1249,
    1250, 1249, 327,
    1247, 325, 1249,
    327, 1249, 1252,
    1252, 1249, 1251,
    1252, 1251, 326,
    1249, 325, 1251,
    327, 1252, 1254,
    1254, 1252, 1253,
    1254, 1253, 89,
    1252, 326, 1253,
    325, 1248, 1251,
    1251, 1248, 1255,
    1251, 1255, 326,
    1248, 80, 1255,
    85, 1250, 1212,
    1212, 1250, 1256,
    1212, 1256, 315,
    1250, 327, 1256,
    315, 1256, 1258,
    1258, 1256, 1257,
    1258, 1257, 328,
    1256, 327, 1257,
    315, 1258, 1210,
    1210, 1258, 1259,
    1210, 1259, 25,
    1258, 328, 1259,
    327, 1254, 1257,
    1257, 1254, 1260,
    1257, 1260, 328,
    1254, 89, 1260,
    80, 1129, 1255,
    1255, 1129, 1261,
    1255, 1261, 326,
    1129, 295, 1261,
    326, 1261, 1263,
    1263, 1261, 1262,
    1263, 1262, 329,
    1261, 295, 1262,
    326, 1263, 1253,
    1253, 1263, 1264,
    1253, 1264, 89,
    1263, 329, 1264,
    295, 1133, 1262,
    1262, 1133, 1265,
    1262, 1265, 329,
    1133, 3, 1265,
    2, 1266, 1268,
    1268, 1266, 1267,
    1268, 1267, 332,
    1266, 330, 1267,
    332, 1267, 1270,
    1270, 1267, 1269,
    1270, 1269, 331,
    1267, 330, 1269,
    332, 1270, 1272,
    1272, 1270, 1271,
    1272, 1271, 92,
    1270, 331, 1271,
    330, 1273, 1269,
    1269, 1273, 1274,
    1269, 1274, 331,
    1273, 90, 1274,
    92, 1271, 1276,
    1276, 1271, 1275,
    1276, 1275, 334,
    1271, 331, 1275,
    334, 1275, 1278,
    1278, 1275, 1277,
    1278, 1277, 333,
    1275, 331, 1277,
    334, 1278, 1280,
    1280, 1278, 1279,
    1280, 1279, 91,
    1278, 333, 1279,
    331, 1274, 1277,
    1277, 1274, 1281,
    1277, 1281, 333,
    1274, 90, 1281,
    92, 1276, 1283,
    1283, 1276, 1282,
    1283, 1282, 336,
    1276, 334, 1282,
    336, 1282, 1285,
    1285, 1282, 1284,
    1285, 1284, 335,
    1282, 334, 1284,
    336, 1285, 1287,
    1287, 1285, 1286,
    1287, 1286, 29,
    1285, 335, 1286,
    334, 1280, 1284,
    1284, 1280, 1288,
    1284, 1288, 335,
    1280, 91, 1288,
    90, 1289, 1281,
    1281, 1289, 1290,
    1281, 1290, 333,
    1289, 337, 1290,
    333, 1290, 1292,
    1292, 1290, 1291,
    1292, 1291, 338,
    1290, 337, 1291,
    333, 1292, 1279,
    1279, 1292, 1293,
    1279, 1293, 91,
    1292, 338, 1293,
    337, 1294, 1291,
    1291, 1294, 1295,
    1291, 1295, 338,
    1294, 27, 1295,
    29, 1286, 1297,
    1297, 1286, 1296,
    1297, 1296, 340,
    1286, 335, 1296,
    340, 1296, 1299,
    1299, 1296, 1298,
    1299, 1298, 339,
    1296, 335, 1298,
    340, 1299, 1301,
    1301, 1299, 1300,
    1301, 1300, 94,
    1299, 339, 1300,
    335, 1288, 1298,
    1298, 1288, 1302,
    1298, 1302, 339,
    1288, 91, 1302,
    94, 1300, 1304,
    1304, 1300, 1303,
    1304, 1303, 342,
    1300, 339, 1303,
    342, 1303, 1306,
    1306, 1303, 1305,
    1306, 1305, 341,
    1303, 339, 1305,
    342, 1306, 1308,
    1308, 1306, 1307,
    1308, 1307, 93,
    1306, 341, 1307,
    339, 1302, 1305,
    1305, 1302, 1309,
    1305, 1309, 341,
    1302, 91, 1309,
    94, 1304, 1311,
    1311, 1304, 1310,
    1311, 1310, 344,
    1304, 342, 1310,
    344, 1310, 1313,
    1313, 1310, 1312,
    1313, 1312, 343,
    1310, 342, 1312,
    344, 1313, 1315,
    1315, 1313, 1314,
    1315, 1314, 28,
    1313, 343, 1314,
    342, 1308, 1312,
    1312, 1308, 1316,
    1312, 1316, 343,
    1308, 93, 1316,
    91, 1293, 1309,
    1309, 1293, 1317,
    1309, 1317, 341,
    1293, 338, 1317,
    341, 1317, 1319,
    1319, 1317, 1318,
    1319, 1318, 345,
    1317, 338, 1318,
    341, 1319, 1307,
    1307, 1319, 1320,
    1307, 1320, 93,
    1319, 345, 1320,
    338, 1295, 1318,
    1318, 1295, 1321,
    1318, 1321, 345,
    1295, 27, 1321,
    29, 1297, 1323,
    1323, 1297, 1322,
    1323, 1322, 347,
    1297, 340, 1322,
    347, 1322, 1325,
    1325, 1322, 1324,
    1325, 1324, 346,
    1322, 340, 1324,
    347, 1325, 1327,
    1327, 1325, 1326,
    1327, 1326, 96,
    1325, 346, 1326,
    340, 1301, 1324,
    1324, 1301, 1328,
    1324, 1328, 346,
    1301, 94, 1328,
    96, 1326, 1330,
    1330, 1326, 1329,
    1330, 1329, 349,
    1326, 346, 1329,
    349, 1329, 1332,
    1332, 1329, 1331,
    1332, 1331, 348,
    1329, 346, 1331,
    349, 1332, 1334,
    1334, 1332, 1333,
    1334, 1333, 95,
    1332, 348, 1333,
    346, 1328, 1331,
    1331, 1328, 1335,
    1331, 1335, 348,
    1328, 94, 1335,
    96, 1330, 1337,
    1337, 1330, 1336,
    1337, 1336, 351,
    1330, 349, 1336,
    351, 1336, 1339,
    1339, 1336, 1338,
    1339, 1338, 350,
    1336, 349, 1338,
    351, 1339, 1341,
    1341, 1339, 1340,
    1341, 1340, 1,
    1339, 350, 1340,
    349, 1334, 1338,
    1338, 1334, 1342,
    1338, 1342, 350,
    1334, 95, 1342,
    94, 1311, 1335,
    1335, 1311, 1343,
    1335, 1343, 348,
    1311, 344, 1343,
    348, 1343, 1345,
    1345, 1343, 1344,
    1345, 1344, 352,
    1343, 344, 1344,
    348, 1345, 1333,
    1333, 1345, 1346,
    1333, 1346, 95,
    1345, 352, 1346,
    344, 1315, 1344,
    1344, 1315, 1347,
    1344, 1347, 352,
    1315, 28, 1347,
    27, 1348, 1321,
    1321, 1348, 1349,
    1321, 1349, 345,
    1348, 353, 1349,
    345, 1349, 1351,
    1351, 1349, 1350,
    1351, 1350, 354,
    1349, 353, 1350,
    345, 1351, 1320,
    1320, 1351, 1352,
    1320, 1352, 93,
    1351, 354, 1352,
    353, 1353, 1350,
    1350, 1353, 1354,
    1350, 1354, 354,
    1353, 97, 1354,
    93, 1352, 1356,
    1356, 1352, 1355,
    1356, 1355, 356,
    1352, 354, 1355,
    356, 1355, 1358,
    1358, 1355, 1357,
    1358, 1357, 355,
    1355, 354, 1357,
    356, 1358, 1360,
    1360, 1358, 1359,
    1360, 1359, 98,
    1358, 355, 1359,
    354, 1354, 1357,
    1357, 1354, 1361,
    1357, 1361, 355,
    1354, 97, 1361,
    93, 1356, 1316,
    1316, 1356, 1362,
    1316, 1362, 343,
    1356, 356, 1362,
    343, 1362, 1364,
    1364, 1362, 1363,
    1364, 1363, 357,
    1362, 356, 1363,
    343, 1364, 1314,
    1314, 1364, 1365,
    1314, 1365, 28,
    1364, 357, 1365,
    356, 1360, 1363,
    1363, 1360, 1366,
    1363, 1366, 357,
    1360, 98, 1366,
    97, 1367, 1361,
    1361, 1367, 1368,
    1361, 1368, 355,
    1367, 358, 1368,
    355, 1368, 1370,
    1370, 1368, 1369,
    1370, 1369, 359,
    1368, 358, 1369,
    355, 1370, 1359,
    1359, 1370, 1371,
    1359, 1371, 98,
    1370, 359, 1371,
    358, 1372, 1369,
    1369, 1372, 1373,
    1369, 1373, 359,
    1372, 7, 1373,
    2, 1268, 1375,
    1375, 1268, 1374,
    1375, 1374, 361,
    1268, 332, 1374,
    361, 1374, 1377,
    1377, 1374, 1376,
    1377, 1376, 360,
    1374, 332, 1376,
    361, 1377, 1379,
    1379, 1377, 1378,
    1379, 1378, 100,
    1377, 360, 1378,
    332, 1272, 1376,
    1376, 1272, 1380,
    1376, 1380, 360,
    1272, 92, 1380,
    100, 1378, 1382,
    1382, 1378, 1381,
    1382, 1381, 363,
    1378, 360, 1381,
    363, 1381, 1384,
    1384, 1381, 1383,
    1384, 1383, 362,
    1381, 360, 1383,
    363, 1384, 1386,
    1386, 1384, 1385,
    1386, 1385, 99,
    1384, 362, 1385,
    360, 1380, 1383,
    1383, 1380, 1387,
    1383, 1387, 362,
    1380, 92, 1387,
    100, 1382, 1389,
    1389, 1382, 1388,
    1389, 1388, 365,
    1382, 363, 1388,
    365, 1388, 1391,
    1391, 1388, 1390,
    1391, 1390, 364,
    1388, 363, 1390,
    365, 1391, 1393,
    1393, 1391, 1392,
    1393, 1392, 31,
    1391, 364, 1392,
    363, 1386, 1390,
    1390, 1386, 1394,
    1390, 1394, 364,
    1386, 99, 1394,
    92, 1283, 1387,
    1387, 1283, 1395,
    1387, 1395, 362,
    1283, 336, 1395,
    362, 1395, 1397,
    1397, 1395, 1396,
    1397, 1396, 366,
    1395, 336, 1396,
    362, 1397, 1385,
    1385, 1397, 1398,
    1385, 1398, 99,
    1397, 366, 1398,
    336, 1287, 1396,
    1396, 1287, 1399,
    1396, 1399, 366,
    1287, 29, 1399,
    31, 1392, 1401,
    1401, 1392, 1400,
    1401, 1400, 368,
    1392, 364, 1400,
    368, 1400, 1403,
    1403, 1400, 1402,
    1403, 1402, 367,
    1400, 364, 1402,
    368, 1403, 1405,
    1405, 1403, 1404,
    1405, 1404, 102,
    1403, 367, 1404,
    364, 1394, 1402,
    1402, 1394, 1406,
    1402, 1406, 367,
    1394, 99, 1406,
    102, 1404, 1408,
    1408, 1404, 1407,
    1408, 1407, 370,
    1404, 367, 1407,
    370, 1407, 1410,
    1410, 1407, 1409,
    1410, 1409, 369,
    1407, 367, 1409,
    370, 1410, 1412,
    1412, 1410, 1411,
    1412, 1411, 101,
    1410, 369, 1411,
    367, 1406, 1409,
    1409, 1406, 1413,
    1409, 1413, 369,
    1406, 99, 1413,
    102, 1408, 1415,
    1415, 1408, 1414,
    1415, 1414, 372,
    1408, 370, 1414,
    372, 1414, 1417,
    1417, 1414, 1416,
    1417, 1416, 371,
    1414, 370, 1416,
    372, 1417, 1419,
    1419, 1417, 1418,
    1419, 1418, 30,
    1417, 371, 1418,
    370, 1412, 1416,
    1416, 1412, 1420,
    1416, 1420, 371,
    1412, 101, 1420,
    99, 1398, 1413,
    1413, 1398, 1421,
    1413, 1421, 369,
    1398, 366, 1421,
    369, 1421, 1423,
    1423, 1421, 1422,
    1423, 1422, 373,
    1421, 366, 1422,
    369, 1423, 1411,
    1411, 1423, 1424,
    1411, 1424, 101,
    1423, 373, 1424,
    366, 1399, 1422,
    1422, 1399, 1425,
    1422, 1425, 373,
    1399, 29, 1425,
    31, 1401, 1427,
    1427, 1401, 1426,
    1427, 1426, 375,
    1401, 368, 1426,
    375, 1426, 1429,
    1429, 1426, 1428,
    1429, 1428, 374,
    1426, 368, 1428,
    375, 1429, 1431,
    1431, 1429, 1430,
    1431, 1430, 104,
    1429, 374, 1430,
    368, 1405, 1428,
    1428, 1405, 1432,
    1428, 1432, 374,
    1405, 102, 1432,
    104, 1430, 1434,
    1434, 1430, 1433,
    1434, 1433, 377,
    1430, 374, 1433,
    377, 1433, 1436,
    1436, 1433, 1435,
    1436, 1435, 376,
    1433, 374, 1435,
    377, 1436, 1438,
    1438, 1436, 1437,
    1438, 1437, 103,
    1436, 376, 1437,
    374, 1432, 1435,
    1435, 1432, 1439,
    1435, 1439, 376,
    1432, 102, 1439,
    104, 1434, 1441,
    1441, 1434, 1440,
    1441, 1440, 379,
    1434, 377, 1440,
    379, 1440, 1443,
    1443, 1440, 1442,
    1443, 1442, 378,
    1440, 377, 1442,
    379, 1443, 1445,
    1445, 1443, 1444,
    1445, 1444, 6,
    1443, 378, 1444,
    377, 1438, 1442,
    1442, 1438, 1446,
    1442, 1446, 378,
    1438, 103, 1446,
    102, 1415, 1439,
    1439, 1415, 1447,
    1439, 1447, 376,
    1415, 372, 1447,
    376, 1447, 1449,
    1449, 1447, 1448,
    1449, 1448, 380,
    1447, 372, 1448,
    376, 1449, 1437,
    1437, 1449, 1450,
    1437, 1450, 103,
    1449, 380, 1450,
    372, 1419, 1448,
    1448, 1419, 1451,
    1448, 1451, 380,
    1419, 30, 1451,
    29, 1323, 1425,
    1425, 1323, 1452,
    1425, 1452, 373,
    1323, 347, 1452,
    373, 1452, 1454,
    1454, 1452, 1453,
    1454, 1453, 381,
    1452, 347, 1453,
    373, 1454, 1424,
    1424, 1454, 1455,
    1424, 1455, 101,
    1454, 381, 1455,
    347, 1327, 1453,
    1453, 1327, 1456,
    1453, 1456, 381,
    1327, 96, 1456,
    101, 1455, 1458,
    1458, 1455, 1457,
    1458, 1457, 383,
    1455, 381, 1457,
    383, 1457, 1460,
    1460, 1457, 1459,
    1460, 1459, 382,
    1457, 381, 1459,
    383, 1460, 1462,
    1462, 1460, 1461,
    1462, 1461, 105,
    1460, 382, 1461,
    381, 1456, 1459,
    1459, 1456, 1463,
    1459, 1463, 382,
    1456, 96, 1463,
    101, 1458, 1420,
    1420, 1458, 1464,
    1420, 1464, 371,
    1458, 383, 1464,
    371, 1464, 1466,
    1466, 1464, 1465,
    1466, 1465, 384,
    1464, 383, 1465,
    371, 1466, 1418,
    1418, 1466, 1467,
    1418, 1467, 30,
    1466, 384, 1467,
    383, 1462, 1465,
    1465, 1462, 1468,
    1465, 1468, 384,
    1462, 105, 1468,
    96, 1337, 1463,
    1463, 1337, 1469,
    1463, 1469, 382,
    1337, 351, 1469,
    382, 1469, 1471,
    1471, 1469, 1470,
    1471, 1470, 385,
    1469, 351, 1470,
    382, 1471, 1461,
    1461, 1471, 1472,
    1461, 1472, 105,
    1471, 385, 1472,
    351, 1341, 1470,
    1470, 1341, 1473,
    1470, 1473, 385,
    1341, 1, 1473,
    8, 1474, 1476,
    1476, 1474, 1475,
    1476, 1475, 388,
    1474, 386, 1475,
    388, 1475, 1478,
    1478, 1475, 1477,
    1478, 1477, 387,
    1475, 386, 1477,
    388, 1478, 1480,
    1480, 1478, 1479,
    1480, 1479, 108,
    1478, 387, 1479,
    386, 1481, 1477,
    1477, 1481, 1482,
    1477, 1482, 387,
    1481, 106, 1482,
    108, 1479, 1484,
    1484, 1479, 1483,
    1484, 1483, 390,
    1479, 387, 1483,
    390, 1483, 1486,
    1486, 1483, 1485,
    1486, 1485, 389,
    1483, 387, 1485,
    390, 1486, 1488,
    1488, 1486, 1487,
    1488, 1487, 107,
    1486, 389, 1487,
    387, 1482, 1485,
    1485, 1482, 1489,
    1485, 1489, 389,
    1482, 106, 1489,
    108, 1484, 1491,
    1491, 1484, 1490,
    1491, 1490, 392,
    1484, 390, 1490,
    392, 1490, 1493,
    1493, 1490, 1492,
    1493, 1492, 391,
    1490, 390, 1492,
    392, 1493, 1495,
    1495, 1493, 1494,
    1495, 1494, 34,
    1493, 391, 1494,
    390, 1488, 1492,
    1492, 1488, 1496,
    1492, 1496, 391,
    1488, 107, 1496,
    106, 1497, 1489,
    1489, 1497, 1498,
    1489, 1498, 389,
    1497, 393, 1498,
    389, 1498, 1500,
    1500, 1498, 1499,
    1500, 1499, 394,
    1498, 393, 1499,
    389, 1500, 1487,
    1487, 1500, 1501,
    1487, 1501, 107,
    1500, 394, 1501,
    393, 1502, 1499,
    1499, 1502, 1503,
    1499, 1503, 394,
    1502, 32, 1503,
    34, 1494, 1505,
    1505, 1494, 1504,
    1505, 1504, 396,
    1494, 391, 1504,
    396, 1504, 1507,
    1507, 1504, 1506,
    1507, 1506, 395,
    1504, 391, 1506,
    396, 1507, 1509,
    1509, 1507, 1508,
    1509, 1508, 110,
    1507, 395, 1508,
    391, 1496, 1506,
    1506, 1496, 1510,
    1506, 1510, 395,
    1496, 107, 1510,
    110, 1508, 1512,
    1512, 1508, 1511,
    1512, 1511, 398,
    1508, 395, 1511,
    398, 1511, 1514,
    1514, 1511, 1513,
    1514, 1513, 397,
    1511, 395, 1513,
    398, 1514, 1516,
    1516, 1514, 1515,
    1516, 1515, 109,
    1514, 397, 1515,
    395, 1510, 1513,
    1513, 1510, 1517,
    1513, 1517, 397,
    1510, 107, 1517,
    110, 1512, 1519,
    1519, 1512, 1518,
    1519, 1518, 400,
    1512, 398, 1518,
    400, 1518, 1521,
    1521, 1518, 1520,
    1521, 1520, 399,
    1518, 398, 1520,
    400, 1521, 1523,
    1523, 1521, 1522,
    1523, 1522, 33,
    1521, 399, 1522,
    398, 1516, 1520,
    1520, 1516, 1524,
    1520, 1524, 399,
    1516, 109, 1524,
    107, 1501, 1517,
    1517, 1501, 1525,
    1517, 1525, 397,
    1501, 394, 1525,
    397, 1525, 1527,
    1527, 1525, 1526,
    1527, 1526, 401,
    1525, 394, 1526,
    397, 1527, 1515,
    1515, 1527, 1528,
    1515, 1528, 109,
    1527, 401, 1528,
    394, 1503, 1526,
    1526, 1503, 1529,
    1526, 1529, 401,
    1503, 32, 1529,
    34, 1505, 1531,
    1531, 1505, 1530,
    1531, 1530, 403,
    1505, 396, 1530,
    403, 1530, 1533,
    1533, 1530, 1532,
    1533, 1532, 402,
    1530, 396, 1532,
    403, 1533, 1535,
    1535, 1533, 1534,
    1535, 1534, 112,
    1533, 402, 1534,
    396, 1509, 1532,
    1532, 1509, 1536,
    1532, 1536, 402,
    1509, 110, 1536,
    112, 1534, 1538,
    1538, 1534, 1537,
    1538, 1537, 405,
    1534, 402, 1537,
    405, 1537, 1540,
    1540, 1537, 1539,
    1540, 1539, 404,
    1537, 402, 1539,
    405, 1540, 1542,
    1542, 1540, 1541,
    1542, 1541, 111,
    1540, 404, 1541,
    402, 1536, 1539,
    1539, 1536, 1543,
    1539, 1543, 404,
    1536, 110, 1543,
    112, 1538, 1545,
    1545, 1538, 1544,
    1545, 1544, 407,
    1538, 405, 1544,
    407, 1544, 1547,
    1547, 1544, 1546,
    1547, 1546, 406,
    1544, 405, 1546,
    407, 1547, 1549,
    1549, 1547, 1548,
    1549, 1548, 11,
    1547, 406, 1548,
    405, 1542, 1546,
    1546, 1542, 1550,
    1546, 1550, 406,
    1542, 111, 1550,
    110, 1519, 1543,
    1543, 1519, 1551,
    1543, 1551, 404,
    1519, 400, 1551,
    404, 1551, 1553,
    1553, 1551, 1552,
    1553, 1552, 408,
    1551, 400, 1552,
    404, 1553, 1541,
    1541, 1553, 1554,
    1541, 1554, 111,
    1553, 408, 1554,
    400, 1523, 1552,
    1552, 1523, 1555,
    1552, 1555, 408,
    1523, 33, 1555,
    32, 1556, 1529,
    1529, 1556, 1557,
    1529, 1557, 401,
    1556, 409, 1557,
    401, 1557, 1559,
    1559, 1557, 1558,
    1559, 1558, 410,
    1557, 409, 1558,
    401, 1559, 1528,
    1528, 1559, 1560,
    1528, 1560, 109,
    1559, 410, 1560,
    409, 1561, 1558,
    1558, 1561, 1562,
    1558, 1562, 410,
    1561, 113, 1562,
    109, 1560, 1564,
    1564, 1560, 1563,
    1564, 1563, 412,
    1560, 410, 1563,
    412, 1563, 1566,
    1566, 1563, 1565,
    1566, 1565, 411,
    1563, 410, 1565,
    412, 1566, 1568,
    1568, 1566, 1567,
    1568, 1567, 114,
    1566, 411, 1567,
    410, 1562, 1565,
    1565, 1562, 1569,
    1565, 1569, 411,
    1562, 113, 1569,
    109, 1564, 1524,
    1524, 1564, 1570,
    1524, 1570, 399,
    1564, 412, 1570,
    399, 1570, 1572,
    1572, 1570, 1571,
    1572, 1571, 413,
    1570, 412, 1571,
    399, 1572, 1522,
    1522, 1572, 1573,
    1522, 1573, 33,
    1572, 413, 1573,
    412, 1568, 1571,
    1571, 1568, 1574,
    1571, 1574, 413,
    1568, 114, 1574,
    113, 1575, 1569,
    1569, 1575, 1576,
    1569, 1576, 411,
    1575, 414, 1576,
    411, 1576, 1578,
    1578, 1576, 1577,
    1578, 1577, 415,
    1576, 414, 1577,
    411, 1578, 1567,
    1567, 1578, 1579,
    1567, 1579, 114,
    1578, 415, 1579,
    414, 1580, 1577,
    1577, 1580, 1581,
    1577, 1581, 415,
    1580, 0, 1581,
    8, 1476, 1583,
    1583, 1476, 1582,
    1583, 1582, 417,
    1476, 388, 1582,
    417, 1582, 1585,
    1585, 1582, 1584,
    1585, 1584, 416,
    1582, 388, 1584,
    417, 1585, 1587,
    1587, 1585, 1586,
    1587, 1586, 116,
    1585, 416, 1586,
    388, 1480, 1584,
    1584, 1480, 1588,
    1584, 1588, 416,
    1480, 108, 1588,
    116, 1586, 1590,
    1590, 1586, 1589,
    1590, 1589, 419,
    1586, 416, 1589,
    419, 1589, 1592,
    1592, 1589, 1591,
    1592, 1591, 418,
    1589, 416, 1591,
    419, 1592, 1594,
    1594, 1592, 1593,
    1594, 1593, 115,
    1592, 418, 1593,
    416, 1588, 1591,
    1591, 1588, 1595,
    1591, 1595, 418,
    1588, 108, 1595,
    116, 1590, 1597,
    1597, 1590, 1596,
    1597, 1596, 421,
    1590, 419, 1596,
    421, 1596, 1599,
    1599, 1596, 1598,
    1599, 1598, 420,
    1596, 419, 1598,
    421, 1599, 1601,
    1601, 1599, 1600,
    1601, 1600, 36,
    1599, 420, 1600,
    419, 1594, 1598,
    1598, 1594, 1602,
    1598, 1602, 420,
    1594, 115, 1602,
    108, 1491, 1595,
    1595, 1491, 1603,
    1595, 1603, 418,
    1491, 392, 1603,
    418, 1603, 1605,
    1605, 1603, 1604,
    1605, 1604, 422,
    1603, 392, 1604,
    418, 1605, 1593,
    1593, 1605, 1606,
    1593, 1606, 115,
    1605, 422, 1606,
    392, 1495, 1604,
    1604, 1495, 1607,
    1604, 1607, 422,
    1495, 34, 1607,
    36, 1600, 1609,
    1609, 1600, 1608,
    1609, 1608, 424,
    1600, 420, 1608,
    424, 1608, 1611,
    1611, 1608, 1610,
    1611, 1610, 423,
    1608, 420, 1610,
    424, 1611, 1613,
    1613, 1611, 1612,
    1613, 1612, 118,
    1611, 423, 1612,
    420, 1602, 1610,
    1610, 1602, 1614,
    1610, 1614, 423,
    1602, 115, 1614,
    118, 1612, 1616,
    1616, 1612, 1615,
    1616, 1615, 426,
    1612, 423, 1615,
    426, 1615, 1618,
    1618, 1615, 1617,
    1618, 1617, 425,
    1615, 423, 1617,
    426, 1618, 1620,
    1620, 1618, 1619,
    1620, 1619, 117,
    1618, 425, 1619,
    423, 1614, 1617,
    1617, 1614, 1621,
    1617, 1621, 425,
    1614, 115, 1621,
    118, 1616, 1623,
    1623, 1616, 1622,
    1623, 1622, 428,
    1616, 426, 1622,
    428, 1622, 1625,
    1625, 1622, 1624,
    1625, 1624, 427,
    1622, 426, 1624,
    428, 1625, 1627,
    1627, 1625, 1626,
    1627, 1626, 35,
    1625, 427, 1626,
    426, 1620, 1624,
    1624, 1620, 1628,
    1624, 1628, 427,
    1620, 117, 1628,
    115, 1606, 1621,
    1621, 1606, 1629,
    1621, 1629, 425,
    1606, 422, 1629,
    425, 1629, 1631,
    1631, 1629, 1630,
    1631, 1630, 429,
    1629, 422, 1630,
    425, 1631, 1619,
    1619, 1631, 1632,
    1619, 1632, 117,
    1631, 429, 1632,
    422, 1607, 1630,
    1630, 1607, 1633,
    1630, 1633, 429,
    1607, 34, 1633,
    36, 1609, 1635,
    1635, 1609, 1634,
    1635, 1634, 431,
    1609, 424, 1634,
    431, 1634, 1637,
    1637, 1634, 1636,
    1637, 1636, 430,
    1634, 424, 1636,
    431, 1637, 1639,
    1639, 1637, 1638,
    1639, 1638, 120,
    1637, 430, 1638,
    424, 1613, 1636,
    1636, 1613, 1640,
    1636, 1640, 430,
    1613, 118, 1640,
    120, 1638, 1642,
    1642, 1638, 1641,
    1642, 1641, 433,
    1638, 430, 1641,
    433, 1641, 1644,
    1644, 1641, 1643,
    1644, 1643, 432,
    1641, 430, 1643,
    433, 1644, 1646,
    1646, 1644, 1645,
    1646, 1645, 119,
    1644, 432, 1645,
    430, 1640, 1643,
    1643, 1640, 1647,
    1643, 1647, 432,
    1640, 118, 1647,
    120, 1642, 1649,
    1649, 1642, 1648,
    1649, 1648, 435,
    1642, 433, 1648,
    435, 1648, 1651,
    1651, 1648, 1650,
    1651, 1650, 434,
    1648, 433, 1650,
    435, 1651, 1653,
    1653, 1651, 1652,
    1653, 1652, 1,
    1651, 434, 1652,
    433, 1646, 1650,
    1650, 1646, 1654,
    1650, 1654, 434,
    1646, 119, 1654,
    118, 1623, 1647,
    1647, 1623, 1655,
    1647, 1655, 432,
    1623, 428, 1655,
    432, 1655, 1657,
    1657, 1655, 1656,
    1657, 1656, 436,
    1655, 428, 1656,
    432, 1657, 1645,
    1645, 1657, 1658,
    1645, 1658, 119,
    1657, 436, 1658,
    428, 1627, 1656,
    1656, 1627, 1659,
    1656, 1659, 436,
    1627, 35, 1659,
    34, 1531, 1633,
    1633, 1531, 1660,
    1633, 1660, 429,
    1531, 403, 1660,
    429, 1660, 1662,
    1662, 1660, 1661,
    1662, 1661, 437,
    1660, 403, 1661,
    429, 1662, 1632,
    1632, 1662, 1663,
    1632, 1663, 117,
    1662, 437, 1663,
    403, 1535, 1661,
    1661, 1535, 1664,
    1661, 1664, 437,
    1535, 112, 1664,
    117, 1663, 1666,
    1666, 1663, 1665,
    1666, 1665, 439,
    1663, 437, 1665,
    439, 1665, 1668,
    1668, 1665, 1667,
    1668, 1667, 438,
    1665, 437, 1667,
    439, 1668, 1670,
    1670, 1668, 1669,
    1670, 1669, 121,
    1668, 438, 1669,
    437, 1664, 1667,
    1667, 1664, 1671,
    1667, 1671, 438,
    1664, 112, 1671,
    117, 1666, 1628,
    1628, 1666, 1672,
    1628, 1672, 427,
    1666, 439, 1672,
    427, 1672, 1674,
    1674, 1672, 1673,
    1674, 1673, 440,
    1672, 439, 1673,
    427, 1674, 1626,
    1626, 1674, 1675,
    1626, 1675, 35,
    1674, 440, 1675,
    439, 1670, 1673,
    1673, 1670, 1676,
    1673, 1676, 440,
    1670, 121, 1676,
    112, 1545, 1671,
    1671, 1545, 1677,
    1671, 1677, 438,
    1545, 407, 1677,
    438, 1677, 1679,
    1679, 1677, 1678,
    1679, 1678, 441,
    1677, 407, 1678,
    438, 1679, 1669,
    1669, 1679, 1680,
    1669, 1680, 121,
    1679, 441, 1680,
    407, 1549, 1678,
    1678, 1549, 1681,
    1678, 1681, 441,
    1549, 11, 1681,
    9, 1682, 1684,
    1684, 1682, 1683,
    1684, 1683, 444,
    1682, 442, 1683,
    444, 1683, 1686,
    1686, 1683, 1685,
    1686, 1685, 443,
    1683, 442, 1685,
    444, 1686, 1688,
    1688, 1686, 1687,
    1688, 1687, 124,
    1686, 443, 1687,
    442, 1689, 1685,
    1685, 1689, 1690,
    1685, 1690, 443,
    1689, 122, 1690,
    124, 1687, 1692,
    1692, 1687, 1691,
    1692, 1691, 446,
    1687, 443, 1691,
    446, 1691, 1694,
    1694, 1691, 1693,
    1694, 1693, 445,
    1691, 443, 1693,
    446, 1694, 1696,
    1696, 1694, 1695,
    1696, 1695, 123,
    1694, 445, 1695,
    443, 1690, 1693,
    1693, 1690, 1697,
    1693, 1697, 445,
    1690, 122, 1697,
    124, 1692, 1699,
    1699, 1692, 1698,
    1699, 1698, 448,
    1692, 446, 1698,
    448, 1698, 1701,
    1701, 1698, 1700,
    1701, 1700, 447,
    1698, 446, 1700,
    448, 1701, 1703,
    1703, 1701, 1702,
    1703, 1702, 39,
    1701, 447, 1702,
    446, 1696, 1700,
    1700, 1696, 1704,
    1700, 1704, 447,
    1696, 123, 1704,
    122, 1705, 1697,
    1697, 1705, 1706,
    1697, 1706, 445,
    1705, 449, 1706,
    445, 1706, 1708,
    1708, 1706, 1707,
    1708, 1707, 450,
    1706, 449, 1707,
    445, 1708, 1695,
    1695, 1708, 1709,
    1695, 1709, 123,
    1708, 450, 1709,
    449, 1710, 1707,
    1707, 1710, 1711,
    1707, 1711, 450,
    1710, 37, 1711,
    39, 1702, 1713,
    1713, 1702, 1712,
    1713, 1712, 452,
    1702, 447, 1712,
    452, 1712, 1715,
    1715, 1712, 1714,
    1715, 1714, 451,
    1712, 447, 1714,
    452, 1715, 1717,
    1717, 1715, 1716,
    1717, 1716, 126,
    1715, 451, 1716,
    447, 1704, 1714,
    1714, 1704, 1718,
    1714, 1718, 451,
    1704, 123, 1718,
    126, 1716, 1720,
    1720, 1716, 1719,
    1720, 1719, 454,
    1716, 451, 1719,
    454, 1719, 1722,
    1722, 1719, 1721,
    1722, 1721, 453,
    1719, 451, 1721,
    454, 1722, 1724,
    1724, 1722, 1723,
    1724, 1723, 125,
    1722, 453, 1723,
    451, 1718, 1721,
    1721, 1718, 1725,
    1721, 1725, 453,
    1718, 123, 1725,
    126, 1720, 1727,
    1727, 1720, 1726,
    1727, 1726, 456,
    1720, 454, 1726,
    456, 1726, 1729,
    1729, 1726, 1728,
    1729, 1728, 455,
    1726, 454, 1728,
    456, 1729, 1731,
    1731, 1729, 1730,
    1731, 1730, 38,
    1729, 455, 1730,
    454, 1724, 1728,
    1728, 1724, 1732,
    1728, 1732, 455,
    1724, 125, 1732,
    123, 1709, 1725,
    1725, 1709, 1733,
    1725, 1733, 453,
    1709, 450, 1733,
    453, 1733, 1735,
    1735, 1733, 1734,
    1735, 1734, 457,
    1733, 450, 1734,
    453, 1735, 1723,
    1723, 1735, 1736,
    1723, 1736, 125,
    1735, 457, 1736,
    450, 1711, 1734,
    1734, 1711, 1737,
    1734, 1737, 457,
    1711, 37, 1737,
    39, 1713, 1739,
    1739, 1713, 1738,
    1739, 1738, 459,
    1713, 452, 1738,
    459, 1738, 1741,
    1741, 1738, 1740,
    1741, 1740, 458,
    1738, 452, 1740,
    459, 1741, 1743,
    1743, 1741, 1742,
    1743, 1742, 128,
    1741, 458, 1742,
    452, 1717, 1740,
    1740, 1717, 1744,
    1740, 1744, 458,
    1717, 126, 1744,
    128, 1742, 1746,
    1746, 1742, 1745,
    1746, 1745, 461,
    1742, 458, 1745,
    461, 1745, 1748,
    1748, 1745, 1747,
    1748, 1747, 460,
    1745, 458, 1747,
    461, 1748, 1750,
    1750, 1748, 1749,
    1750, 1749, 127,
    1748, 460, 1749,
    458, 1744, 1747,
    1747, 1744, 1751,
    1747, 1751, 460,
    1744, 126, 1751,
    128, 1746, 1753,
    1753, 1746, 1752,
    1753, 1752, 463,
    1746, 461, 1752,
    463, 1752, 1755,
    1755, 1752, 1754,
    1755, 1754, 462,
    1752, 461, 1754,
    463, 1755, 1757,
    1757, 1755, 1756,
    1757, 1756, 3,
    1755, 462, 1756,
    461, 1750, 1754,
    1754, 1750, 1758,
    1754, 1758, 462,
    1750, 127, 1758,
    126, 1727, 1751,
    1751, 1727, 1759,
    1751, 1759, 460,
    1727, 456, 1759,
    460, 1759, 1761,
    1761, 1759, 1760,
    1761, 1760, 464,
    1759, 456, 1760,
    460, 1761, 1749,
    1749, 1761, 1762,
    1749, 1762, 127,
    1761, 464, 1762,
    456, 1731, 1760,
    1760, 1731, 1763,
    1760, 1763, 464,
    1731, 38, 1763,
    37, 1764, 1737,
    1737, 1764, 1765,
    1737, 1765, 457,
    1764, 465, 1765,
    457, 1765, 1767,
    1767, 1765, 1766,
    1767, 1766, 466,
    1765, 465, 1766,
    457, 1767, 1736,
    1736, 1767, 1768,
    1736, 1768, 125,
    1767, 466, 1768,
    465, 1769, 1766,
    1766, 1769, 1770,
    1766, 1770, 466,
    1769, 129, 1770,
    125, 1768, 1772,
    1772, 1768, 1771,
    1772, 1771, 468,
    1768, 466, 1771,
    468, 1771, 1774,
    1774, 1771, 1773,
    1774, 1773, 467,
    1771, 466, 1773,
    468, 1774, 1776,
    1776, 1774, 1775,
    1776, 1775, 130,
    1774, 467, 1775,
    466, 1770, 1773,
    1773, 1770, 1777,
    1773, 1777, 467,
    1770, 129, 1777,
    125, 1772, 1732,
    1732, 1772, 1778,
    1732, 1778, 455,
    1772, 468, 1778,
    455, 1778, 1780,
    1780, 1778, 1779,
    1780, 1779, 469,
    1778, 468, 1779,
    455, 1780, 1730,
    1730, 1780, 1781,
    1730, 1781, 38,
    1780, 469, 1781,
    468, 1776, 1779,
    1779, 1776, 1782,
    1779, 1782, 469,
    1776, 130, 1782,
    129, 1783, 1777,
    1777, 1783, 1784,
    1777, 1784, 467,
    1783, 470, 1784,
    467, 1784, 1786,
    1786, 1784, 1785,
    1786, 1785, 471,
    1784, 470, 1785,
    467, 1786, 1775,
    1775, 1786, 1787,
    1775, 1787, 130,
    1786, 471, 1787,
    470, 1788, 1785,
    1785, 1788, 1789,
    1785, 1789, 471,
    1788, 10, 1789,
    9, 1790, 1682,
    1682, 1790, 1791,
    1682, 1791, 442,
    1790, 472, 1791,
    442, 1791, 1793,
    1793, 1791, 1792,
    1793, 1792, 473,
    1791, 472, 1792,
    442, 1793, 1689,
    1689, 1793, 1794,
    1689, 1794, 122,
    1793, 473, 1794,
    472, 1795, 1792,
    1792, 1795, 1796,
    1792, 1796, 473,
    1795, 131, 1796,
    122, 1794, 1798,
    1798, 1794, 1797,
    1798, 1797, 475,
    1794, 473, 1797,
    475, 1797, 1800,
    1800, 1797, 1799,
    1800, 1799, 474,
    1797, 473, 1799,
    475, 1800, 1802,
    1802, 1800, 1801,
    1802, 1801, 132,
    1800, 474, 1801,
    473, 1796, 1799,
    1799, 1796, 1803,
    1799, 1803, 474,
    1796, 131, 1803,
    122, 1798, 1705,
    1705, 1798, 1804,
    1705, 1804, 449,
    1798, 475, 1804,
    449, 1804, 1806,
    1806, 1804, 1805,
    1806, 1805, 476,
    1804, 475, 1805,
    449, 1806, 1710,
    1710, 1806, 1807,
    1710, 1807, 37,
    1806, 476, 1807,
    475, 1802, 1805,
    1805, 1802, 1808,
    1805, 1808, 476,
    1802, 132, 1808,
    131, 1809, 1803,
    1803, 1809, 1810,
    1803, 1810, 474,
    1809, 477, 1810,
    474, 1810, 1812,
    1812, 1810, 1811,
    1812, 1811, 478,
    1810, 477, 1811,
    474, 1812, 1801,
    1801, 1812, 1813,
    1801, 1813, 132,
    1812, 478, 1813,
    477, 1814, 1811,
    1811, 1814, 1815,
    1811, 1815, 478,
    1814, 40, 1815,
    37, 1807, 1817,
    1817, 1807, 1816,
    1817, 1816, 480,
    1807, 476, 1816,
    480, 1816, 1819,
    1819, 1816, 1818,
    1819, 1818, 479,
    1816, 476, 1818,
    480, 1819, 1821,
    1821, 1819, 1820,
    1821, 1820, 134,
    1819, 479, 1820,
    476, 1808, 1818,
    1818, 1808, 1822,
    1818, 1822, 479,
    1808, 132, 1822,
    134, 1820, 1824,
    1824, 1820, 1823,
    1824, 1823, 482,
    1820, 479, 1823,
    482, 1823, 1826,
    1826, 1823, 1825,
    1826, 1825, 481,
    1823, 479, 1825,
    482, 1826, 1828,
    1828, 1826, 1827,
    1828, 1827, 133,
    1826, 481, 1827,
    479, 1822, 1825,
    1825, 1822, 1829,
    1825, 1829, 481,
    1822, 132, 1829,
    134, 1824, 1831,
    1831, 1824, 1830,
    1831, 1830, 484,
    1824, 482, 1830,
    484, 1830, 1833,
    1833, 1830, 1832,
    1833, 1832, 483,
    1830, 482, 1832,
    484, 1833, 1835,
    1835, 1833, 1834,
    1835, 1834, 41,
    1833, 483, 1834,
    482, 1828, 1832,
    1832, 1828, 1836,
    1832, 1836, 483,
    1828, 133, 1836,
    132, 1813, 1829,
    1829, 1813, 1837,
    1829, 1837, 481,
    1813, 478, 1837,
    481, 1837, 1839,
    1839, 1837, 1838,
    1839, 1838, 485,
    1837, 478, 1838,
    481, 1839, 1827,
    1827, 1839, 1840,
    1827, 1840, 133,
    1839, 485, 1840,
    478, 1815, 1838,
    1838, 1815, 1841,
    1838, 1841, 485,
    1815, 40, 1841,
    37, 1817, 1764,
    1764, 1817, 1842,
    1764, 1842, 465,
    1817, 480, 1842,
    465, 1842, 1844,
    1844, 1842, 1843,
    1844, 1843, 486,
    1842, 480, 1843,
    465, 1844, 1769,
    1769, 1844, 1845,
    1769, 1845, 129,
    1844, 486, 1845,
    480, 1821, 1843,
    1843, 1821, 1846,
    1843, 1846, 486,
    1821, 134, 1846,
    129, 1845, 1848,
    1848, 1845, 1847,
    1848, 1847, 488,
    1845, 486, 1847,
    488, 1847, 1850,
    1850, 1847, 1849,
    1850, 1849, 487,
    1847, 486, 1849,
    488, 1850, 1852,
    1852, 1850, 1851,
    1852, 1851, 135,
    1850, 487, 1851,
    486, 1846, 1849,
    1849, 1846, 1853,
    1849, 1853, 487,
    1846, 134, 1853,
    129, 1848, 1783,
    1783, 1848, 1854,
    1783, 1854, 470,
    1848, 488, 1854,
    470, 1854, 1856,
    1856, 1854, 1855,
    1856, 1855, 489,
    1854, 488, 1855,
    470, 1856, 1788,
    1788, 1856, 1857,
    1788, 1857, 10,
    1856, 489, 1857,
    488, 1852, 1855,
    1855, 1852, 1858,
    1855, 1858, 489,
    1852, 135, 1858,
    134, 1831, 1853,
    1853, 1831, 1859,
    1853, 1859, 487,
    1831, 484, 1859,
    487, 1859, 1861,
    1861, 1859, 1860,
    1861, 1860, 490,
    1859, 484, 1860,
    487, 1861, 1851,
    1851, 1861, 1862,
    1851, 1862, 135,
    1861, 490, 1862,
    484, 1835, 1860,
    1860, 1835, 1863,
    1860, 1863, 490,
    1835, 41, 1863,
    40, 1864, 1841,
    1841, 1864, 1865,
    1841, 1865, 485,
    1864, 491, 1865,
    485, 1865, 1867,
    1867, 1865, 1866,
    1867, 1866, 492,
    1865, 491, 1866,
    485, 1867, 1840,
    1840, 1867, 1868,
    1840, 1868, 133,
    1867, 492, 1868,
    491, 1869, 1866,
    1866, 1869, 1870,
    1866, 1870, 492,
    1869, 136, 1870,
    133, 1868, 1872,
    1872, 1868, 1871,
    1872, 1871, 494,
    1868, 492, 1871,
    494, 1871, 1874,
    1874, 1871, 1873,
    1874, 1873, 493,
    1871, 492, 1873,
    494, 1874, 1876,
    1876, 1874, 1875,
    1876, 1875, 137,
    1874, 493, 1875,
    492, 1870, 1873,
    1873, 1870, 1877,
    1873, 1877, 493,
    1870, 136, 1877,
    133, 1872, 1836,
    1836, 1872, 1878,
    1836, 1878, 483,
    1872, 494, 1878,
    483, 1878, 1880,
    1880, 1878, 1879,
    1880, 1879, 495,
    1878, 494, 1879,
    483, 1880, 1834,
    1834, 1880, 1881,
    1834, 1881, 41,
    1880, 495, 1881,
    494, 1876, 1879,
    1879, 1876, 1882,
    1879, 1882, 495,
    1876, 137, 1882,
    136, 1883, 1877,
    1877, 1883, 1884,
    1877, 1884, 493,
    1883, 496, 1884,
    493, 1884, 1886,
    1886, 1884, 1885,
    1886, 1885, 497,
    1884, 496, 1885,
    493, 1886, 1875,
    1875, 1886, 1887,
    1875, 1887, 137,
    1886, 497, 1887,
    496, 1888, 1885,
    1885, 1888, 1889,
    1885, 1889, 497,
    1888, 2, 1889,
    8, 748, 1474,
    1474, 748, 1890,
    1474, 1890, 386,
    748, 190, 1890,
    386, 1890, 1892,
    1892, 1890, 1891,
    1892, 1891, 498,
    1890, 190, 1891,
    386, 1892, 1481,
    1481, 1892, 1893,
    1481, 1893, 106,
    1892, 498, 1893,
    190, 743, 1891,
    1891, 743, 1894,
    1891, 1894, 498,
    743, 49, 1894,
    106, 1893, 1896,
    1896, 1893, 1895,
    1896, 1895, 500,
    1893, 498, 1895,
    500, 1895, 1898,
    1898, 1895, 1897,
    1898, 1897, 499,
    1895, 498, 1897,
    500, 1898, 1900,
    1900, 1898, 1899,
    1900, 1899, 138,
    1898, 499, 1899,
    498, 1894, 1897,
    1897, 1894, 1901,
    1897, 1901, 499,
    1894, 49, 1901,
    106, 1896, 1497,
    1497, 1896, 1902,
    1497, 1902, 393,
    1896, 500, 1902,
    393, 1902, 1904,
    1904, 1902, 1903,
    1904, 1903, 501,
    1902, 500, 1903,
    393, 1904, 1502,
    1502, 1904, 1905,
    1502, 1905, 32,
    1904, 501, 1905,
    500, 1900, 1903,
    1903, 1900, 1906,
    1903, 1906, 501,
    1900, 138, 1906,
    49, 729, 1901,
    1901, 729, 1907,
    1901, 1907, 499,
    729, 185, 1907,
    499, 1907, 1909,
    1909, 1907, 1908,
    1909, 1908, 502,
    1907, 185, 1908,
    499, 1909, 1899,
    1899, 1909, 1910,
    1899, 1910, 138,
    1909, 502, 1910,
    185, 724, 1908,
    1908, 724, 1911,
    1908, 1911, 502,
    724, 12, 1911,
    32, 1905, 1913,
    1913, 1905, 1912,
    1913, 1912, 504,
    1905, 501, 1912,
    504, 1912, 1915,
    1915, 1912, 1914,
    1915, 1914, 503,
    1912, 501, 1914,
    504, 1915, 1917,
    1917, 1915, 1916,
    1917, 1916, 140,
    1915, 503, 1916,
    501, 1906, 1914,
    1914, 1906, 1918,
    1914, 1918, 503,
    1906, 138, 1918,
    140, 1916, 1920,
    1920, 1916, 1919,
    1920, 1919, 506,
    1916, 503, 1919,
    506, 1919, 1922,
    1922, 1919, 1921,
    1922, 1921, 505,
    1919, 503, 1921,
    506, 1922, 1924,
    1924, 1922, 1923,
    1924, 1923, 139,
    1922, 505, 1923,
    503, 1918, 1921,
    1921, 1918, 1925,
    1921, 1925, 505,
    1918, 138, 1925,
    140, 1920, 1927,
    1927, 1920, 1926,
    1927, 1926, 508,
    1920, 506, 1926,
    508, 1926, 1929,
    1929, 1926, 1928,
    1929, 1928, 507,
    1926, 506, 1928,
    508, 1929, 1931,
    1931, 1929, 1930,
    1931, 1930, 22,
    1929, 507, 1930,
    506, 1924, 1928,
    1928, 1924, 1932,
    1928, 1932, 507,
    1924, 139, 1932,
    138, 1910, 1925,
    1925, 1910, 1933,
    1925, 1933, 505,
    1910, 502, 1933,
    505, 1933, 1935,
    1935, 1933, 1934,
    1935, 1934, 509,
    1933, 502, 1934,
    505, 1935, 1923,
    1923, 1935, 1936,
    1923, 1936, 139,
    1935, 509, 1936,
    502, 1911, 1934,
    1934, 1911, 1937,
    1934, 1937, 509,
    1911, 12, 1937,
    32, 1913, 1556,
    1556, 1913, 1938,
    1556, 1938, 409,
    1913, 504, 1938,
    409, 1938, 1940,
    1940, 1938, 1939,
    1940, 1939, 510,
    1938, 504, 1939,
    409, 1940, 1561,
    1561, 1940, 1941,
    1561, 1941, 113,
    1940, 510, 1941,
    504, 1917, 1939,
    1939, 1917, 1942,
    1939, 1942, 510,
    1917, 140, 1942,
    113, 1941, 1944,
    1944, 1941, 1943,
    1944, 1943, 512,
    1941, 510, 1943,
    512, 1943, 1946,
    1946, 1943, 1945,
    1946, 1945, 511,
    1943, 510, 1945,
    512, 1946, 1948,
    1948, 1946, 1947,
    1948, 1947, 74,
    1946, 511, 1947,
    510, 1942, 1945,
    1945, 1942, 1949,
    1945, 1949, 511,
    1942, 140, 1949,
    113, 1944, 1575,
    1575, 1944, 1950,
    1575, 1950, 414,
    1944, 512, 1950,
    414, 1950, 1952,
    1952, 1950, 1951,
    1952, 1951, 274,
    1950, 512, 1951,
    414, 1952, 1580,
    1580, 1952, 1058,
    1580, 1058, 0,
    1952, 274, 1058,
    512, 1948, 1951,
    1951, 1948, 1065,
    1951, 1065, 274,
    1948, 74, 1065,
    140, 1927, 1949,
    1949, 1927, 1953,
    1949, 1953, 511,
    1927, 508, 1953,
    511, 1953, 1955,
    1955, 1953, 1954,
    1955, 1954, 281,
    1953, 508, 1954,
    511, 1955, 1947,
    1947, 1955, 1081,
    1947, 1081, 74,
    1955, 281, 1081,
    508, 1931, 1954,
    1954, 1931, 1086,
    1954, 1086, 281,
    1931, 22, 1086,
    12, 670, 1937,
    1937, 670, 1956,
    1937, 1956, 509,
    670, 169, 1956,
    509, 1956, 1958,
    1958, 1956, 1957,
    1958, 1957, 513,
    1956, 169, 1957,
    509, 1958, 1936,
    1936, 1958, 1959,
    1936, 1959, 139,
    1958, 513, 1959,
    169, 665, 1957,
    1957, 665, 1960,
    1957, 1960, 513,
    665, 42, 1960,
    139, 1959, 1962,
    1962, 1959, 1961,
    1962, 1961, 515,
    1959, 513, 1961,
    515, 1961, 1964,
    1964, 1961, 1963,
    1964, 1963, 514,
    1961, 513, 1963,
    515, 1964, 1966,
    1966, 1964, 1965,
    1966, 1965, 81,
    1964, 514, 1965,
    513, 1960, 1963,
    1963, 1960, 1967,
    1963, 1967, 514,
    1960, 42, 1967,
    139, 1962, 1932,
    1932, 1962, 1968,
    1932, 1968, 507,
    1962, 515, 1968,
    507, 1968, 1970,
    1970, 1968, 1969,
    1970, 1969, 297,
    1968, 515, 1969,
    507, 1970, 1930,
    1930, 1970, 1140,
    1930, 1140, 22,
    1970, 297, 1140,
    515, 1966, 1969,
    1969, 1966, 1145,
    1969, 1145, 297,
    1966, 81, 1145,
    42, 649, 1967,
    1967, 649, 1971,
    1967, 1971, 514,
    649, 162, 1971,
    514, 1971, 1973,
    1973, 1971, 1972,
    1973, 1972, 302,
    1971, 162, 1972,
    514, 1973, 1965,
    1965, 1973, 1159,
    1965, 1159, 81,
    1973, 302, 1159,
    162, 642, 1972,
    1972, 642, 1164,
    1972, 1164, 302,
    642, 4, 1164,
    11, 1548, 925,
    925, 1548, 1974,
    925, 1974, 239,
    1548, 406, 1974,
    239, 1974, 1976,
    1976, 1974, 1975,
    1976, 1975, 516,
    1974, 406, 1975,
    239, 1976, 921,
    921, 1976, 1977,
    921, 1977, 64,
    1976, 516, 1977,
    406, 1550, 1975,
    1975, 1550, 1978,
    1975, 1978, 516,
    1550, 111, 1978,
    64, 1977, 1980,
    1980, 1977, 1979,
    1980, 1979, 518,
    1977, 516, 1979,
    518, 1979, 1982,
    1982, 1979, 1981,
    1982, 1981, 517,
    1979, 516, 1981,
    518, 1982, 1984,
    1984, 1982, 1983,
    1984, 1983, 141,
    1982, 517, 1983,
    516, 1978, 1981,
    1981, 1978, 1985,
    1981, 1985, 517,
    1978, 111, 1985,
    64, 1980, 911,
    911, 1980, 1986,
    911, 1986, 235,
    1980, 518, 1986,
    235, 1986, 1988,
    1988, 1986, 1987,
    1988, 1987, 519,
    1986, 518, 1987,
    235, 1988, 907,
    907, 1988, 1989,
    907, 1989, 19,
    1988, 519, 1989,
    518, 1984, 1987,
    1987, 1984, 1990,
    1987, 1990, 519,
    1984, 141, 1990,
    111, 1554, 1985,
    1985, 1554, 1991,
    1985, 1991, 517,
    1554, 408, 1991,
    517, 1991, 1993,
    1993, 1991, 1992,
    1993, 1992, 520,
    1991, 408, 1992,
    517, 1993, 1983,
    1983, 1993, 1994,
    1983, 1994, 141,
    1993, 520, 1994,
    408, 1555, 1992,
    1992, 1555, 1995,
    1992, 1995, 520,
    1555, 33, 1995,
    19, 1989, 1997,
    1997, 1989, 1996,
    1997, 1996, 522,
    1989, 519, 1996,
    522, 1996, 1999,
    1999, 1996, 1998,
    1999, 1998, 521,
    1996, 519, 1998,
    522, 1999, 2001,
    2001, 1999, 2000,
    2001, 2000, 143,
    1999, 521, 2000,
    519, 1990, 1998,
    1998, 1990, 2002,
    1998, 2002, 521,
    1990, 141, 2002,
    143, 2000, 2004,
    2004, 2000, 2003,
    2004, 2003, 524,
    2000, 521, 2003,
    524, 2003, 2006,
    2006, 2003, 2005,
    2006, 2005, 523,
    2003, 521, 2005,
    524, 2006, 2008,
    2008, 2006, 2007,
    2008, 2007, 142,
    2006, 523, 2007,
    521, 2002, 2005,
    2005, 2002, 2009,
    2005, 2009, 523,
    2002, 141, 2009,
    143, 2004, 2011,
    2011, 2004, 2010,
    2011, 2010, 526,
    2004, 524, 2010,
    526, 2010, 2013,
    2013, 2010, 2012,
    2013, 2012, 525,
    2010, 524, 2012,
    526, 2013, 2015,
    2015, 2013, 2014,
    2015, 2014, 26,
    2013, 525, 2014,
    524, 2008, 2012,
    2012, 2008, 2016,
    2012, 2016, 525,
    2008, 142, 2016,
    141, 1994, 2009,
    2009, 1994, 2017,
    2009, 2017, 523,
    1994, 520, 2017,
    523, 2017, 2019,
    2019, 2017, 2018,
    2019, 2018, 527,
    2017, 520, 2018,
    523, 2019, 2007,
    2007, 2019, 2020,
    2007, 2020, 142,
    2019, 527, 2020,
    520, 1995, 2018,
    2018, 1995, 2021,
    2018, 2021, 527,
    1995, 33, 2021,
    19, 1997, 871,
    871, 1997, 2022,
    871, 2022, 224,
    1997, 522, 2022,
    224, 2022, 2024,
    2024, 2022, 2023,
    2024, 2023, 528,
    2022, 522, 2023,
    224, 2024, 867,
    867, 2024, 2025,
    867, 2025, 60,
    2024, 528, 2025,
    522, 2001, 2023,
    2023, 2001, 2026,
    2023, 2026, 528,
    2001, 143, 2026,
    60, 2025, 2028,
    2028, 2025, 2027,
    2028, 2027, 530,
    2025, 528, 2027,
    530, 2027, 2030,
    2030, 2027, 2029,
    2030, 2029, 529,
    2027, 528, 2029,
    530, 2030, 2032,
    2032, 2030, 2031,
    2032, 2031, 88,
    2030, 529, 2031,
    528, 2026, 2029,
    2029, 2026, 2033,
    2029, 2033, 529,
    2026, 143, 2033,
    60, 2028, 856,
    856, 2028, 2034,
    856, 2034, 220,
    2028, 530, 2034,
    220, 2034, 2036,
    2036, 2034, 2035,
    2036, 2035, 323,
    2034, 530, 2035,
    220, 2036, 852,
    852, 2036, 1237,
    852, 1237, 5,
    2036, 323, 1237,
    530, 2032, 2035,
    2035, 2032, 1233,
    2035, 1233, 323,
    2032, 88, 1233,
    143, 2011, 2033,
    2033, 2011, 2037,
    2033, 2037, 529,
    2011, 526, 2037,
    529, 2037, 2039,
    2039, 2037, 2038,
    2039, 2038, 319,
    2037, 526, 2038,
    529, 2039, 2031,
    2031, 2039, 1223,
    2031, 1223, 88,
    2039, 319, 1223,
    526, 2015, 2038,
    2038, 2015, 1219,
    2038, 1219, 319,
    2015, 26, 1219,
    33, 1573, 2021,
    2021, 1573, 2040,
    2021, 2040, 527,
    1573, 413, 2040,
    527, 2040, 2042,
    2042, 2040, 2041,
    2042, 2041, 531,
    2040, 413, 2041,
    527, 2042, 2020,
    2020, 2042, 2043,
    2020, 2043, 142,
    2042, 531, 2043,
    413, 1574, 2041,
    2041, 1574, 2044,
    2041, 2044, 531,
    1574, 114, 2044,
    142, 2043, 2046,
    2046, 2043, 2045,
    2046, 2045, 533,
    2043, 531, 2045,
    533, 2045, 2048,
    2048, 2045, 2047,
    2048, 2047, 532,
    2045, 531, 2047,
    533, 2048, 2050,
    2050, 2048, 2049,
    2050, 2049, 84,
    2048, 532, 2049,
    531, 2044, 2047,
    2047, 2044, 2051,
    2047, 2051, 532,
    2044, 114, 2051,
    142, 2046, 2016,
    2016, 2046, 2052,
    2016, 2052, 525,
    2046, 533, 2052,
    525, 2052, 2054,
    2054, 2052, 2053,
    2054, 2053, 309,
    2052, 533, 2053,
    525, 2054, 2014,
    2014, 2054, 1185,
    2014, 1185, 26,
    2054, 309, 1185,
    533, 2050, 2053,
    2053, 2050, 1181,
    2053, 1181, 309,
    2050, 84, 1181,
    114, 1579, 2051,
    2051, 1579, 2055,
    2051, 2055, 532,
    1579, 415, 2055,
    532, 2055, 2057,
    2057, 2055, 2056,
    2057, 2056, 305,
    2055, 415, 2056,
    532, 2057, 2049,
    2049, 2057, 1171,
    2049, 1171, 84,
    2057, 305, 1171,
    415, 1581, 2056,
    2056, 1581, 1167,
    2056, 1167, 305,
    1581, 0, 1167,
    4, 751, 1165,
    1165, 751, 2058,
    1165, 2058, 303,
    751, 193, 2058,
    303, 2058, 2060,
    2060, 2058, 2059,
    2060, 2059, 534,
    2058, 193, 2059,
    303, 2060, 1163,
    1163, 2060, 2061,
    1163, 2061, 82,
    2060, 534, 2061,
    193, 755, 2059,
    2059, 755, 2062,
    2059, 2062, 534,
    755, 52, 2062,
    82, 2061, 2064,
    2064, 2061, 2063,
    2064, 2063, 536,
    2061, 534, 2063,
    536, 2063, 2066,
    2066, 2063, 2065,
    2066, 2065, 535,
    2063, 534, 2065,
    536, 2066, 2068,
    2068, 2066, 2067,
    2068, 2067, 144,
    2066, 535, 2067,
    534, 2062, 2065,
    2065, 2062, 2069,
    2065, 2069, 535,
    2062, 52, 2069,
    82, 2064, 1158,
    1158, 2064, 2070,
    1158, 2070, 301,
    2064, 536, 2070,
    301, 2070, 2072,
    2072, 2070, 2071,
    2072, 2071, 537,
    2070, 536, 2071,
    301, 2072, 1157,
    1157, 2072, 2073,
    1157, 2073, 23,
    2072, 537, 2073,
    536, 2068, 2071,
    2071, 2068, 2074,
    2071, 2074, 537,
    2068, 144, 2074,
    52, 765, 2069,
    2069, 765, 2075,
    2069, 2075, 535,
    765, 197, 2075,
    535, 2075, 2077,
    2077, 2075, 2076,
    2077, 2076, 538,
    2075, 197, 2076,
    535, 2077, 2067,
    2067, 2077, 2078,
    2067, 2078, 144,
    2077, 538, 2078,
    197, 769, 2076,
    2076, 769, 2079,
    2076, 2079, 538,
    769, 16, 2079,
    23, 2073, 2081,
    2081, 2073, 2080,
    2081, 2080, 540,
    2073, 537, 2080,
    540, 2080, 2083,
    2083, 2080, 2082,
    2083, 2082, 539,
    2080, 537, 2082,
    540, 2083, 2085,
    2085, 2083, 2084,
    2085, 2084, 146,
    2083, 539, 2084,
    537, 2074, 2082,
    2082, 2074, 2086,
    2082, 2086, 539,
    2074, 144, 2086,
    146, 2084, 2088,
    2088, 2084, 2087,
    2088, 2087, 542,
    2084, 539, 2087,
    542, 2087, 2090,
    2090, 2087, 2089,
    2090, 2089, 541,
    2087, 539, 2089,
    542, 2090, 2092,
    2092, 2090, 2091,
    2092, 2091, 145,
    2090, 541, 2091,
    539, 2086, 2089,
    2089, 2086, 2093,
    2089, 2093, 541,
    2086, 144, 2093,
    146, 2088, 2095,
    2095, 2088, 2094,
    2095, 2094, 544,
    2088, 542, 2094,
    544, 2094, 2097,
    2097, 2094, 2096,
    2097, 2096, 543,
    2094, 542, 2096,
    544, 2097, 2099,
    2099, 2097, 2098,
    2099, 2098, 39,
    2097, 543, 2098,
    542, 2092, 2096,
    2096, 2092, 2100,
    2096, 2100, 543,
    2092, 145, 2100,
    144, 2078, 2093,
    2093, 2078, 2101,
    2093, 2101, 541,
    2078, 538, 2101,
    541, 2101, 2103,
    2103, 2101, 2102,
    2103, 2102, 545,
    2101, 538, 2102,
    541, 2103, 2091,
    2091, 2103, 2104,
    2091, 2104, 145,
    2103, 545, 2104,
    538, 2079, 2102,
    2102, 2079, 2105,
    2102, 2105, 545,
    2079, 16, 2105,
    23, 2081, 1139,
    1139, 2081, 2106,
    1139, 2106, 296,
    2081, 540, 2106,
    296, 2106, 2108,
    2108, 2106, 2107,
    2108, 2107, 546,
    2106, 540, 2107,
    296, 2108, 1138,
    1138, 2108, 2109,
    1138, 2109, 79,
    2108, 546, 2109,
    540, 2085, 2107,
    2107, 2085, 2110,
    2107, 2110, 546,
    2085, 146, 2110,
    79, 2109, 2112,
    2112, 2109, 2111,
    2112, 2111, 548,
    2109, 546, 2111,
    548, 2111, 2114,
    2114, 2111, 2113,
    2114, 2113, 547,
    2111, 546, 2113,
    548, 2114, 2116,
    2116, 2114, 2115,
    2116, 2115, 128,
    2114, 547, 2115,
    546, 2110, 2113,
    2113, 2110, 2117,
    2113, 2117, 547,
    2110, 146, 2117,
    79, 2112, 1134,
    1134, 2112, 2118,
    1134, 2118, 294,
    2112, 548, 2118,
    294, 2118, 2120,
    2120, 2118, 2119,
    2120, 2119, 463,
    2118, 548, 2119,
    294, 2120, 1132,
    1132, 2120, 1757,
    1132, 1757, 3,
    2120, 463, 1757,
    548, 2116, 2119,
    2119, 2116, 1753,
    2119, 1753, 463,
    2116, 128, 1753,
    146, 2095, 2117,
    2117, 2095, 2121,
    2117, 2121, 547,
    2095, 544, 2121,
    547, 2121, 2123,
    2123, 2121, 2122,
    2123, 2122, 459,
    2121, 544, 2122,
    547, 2123, 2115,
    2115, 2123, 1743,
    2115, 1743, 128,
    2123, 459, 1743,
    544, 2099, 2122,
    2122, 2099, 1739,
    2122, 1739, 459,
    2099, 39, 1739,
    16, 803, 2105,
    2105, 803, 2124,
    2105, 2124, 545,
    803, 207, 2124,
    545, 2124, 2126,
    2126, 2124, 2125,
    2126, 2125, 549,
    2124, 207, 2125,
    545, 2126, 2104,
    2104, 2126, 2127,
    2104, 2127, 145,
    2126, 549, 2127,
    207, 807, 2125,
    2125, 807, 2128,
    2125, 2128, 549,
    807, 56, 2128,
    145, 2127, 2130,
    2130, 2127, 2129,
    2130, 2129, 551,
    2127, 549, 2129,
    551, 2129, 2132,
    2132, 2129, 2131,
    2132, 2131, 550,
    2129, 549, 2131,
    551, 2132, 2134,
    2134, 2132, 2133,
    2134, 2133, 124,
    2132, 550, 2133,
    549, 2128, 2131,
    2131, 2128, 2135,
    2131, 2135, 550,
    2128, 56, 2135,
    145, 2130, 2100,
    2100, 2130, 2136,
    2100, 2136, 543,
    2130, 551, 2136,
    543, 2136, 2138,
    2138, 2136, 2137,
    2138, 2137, 448,
    2136, 551, 2137,
    543, 2138, 2098,
    2098, 2138, 1703,
    2098, 1703, 39,
    2138, 448, 1703,
    551, 2134, 2137,
    2137, 2134, 1699,
    2137, 1699, 448,
    2134, 124, 1699,
    56, 817, 2135,
    2135, 817, 2139,
    2135, 2139, 550,
    817, 211, 2139,
    550, 2139, 2141,
    2141, 2139, 2140,
    2141, 2140, 444,
    2139, 211, 2140,
    550, 2141, 2133,
    2133, 2141, 1688,
    2133, 1688, 124,
    2141, 444, 1688,
    211, 821, 2140,
    2140, 821, 1684,
    2140, 1684, 444,
    821, 9, 1684,
    5, 1236, 958,
    958, 1236, 2142,
    958, 2142, 248,
    1236, 322, 2142,
    248, 2142, 2144,
    2144, 2142, 2143,
    2144, 2143, 552,
    2142, 322, 2143,
    248, 2144, 963,
    963, 2144, 2145,
    963, 2145, 67,
    2144, 552, 2145,
    322, 1238, 2143,
    2143, 1238, 2146,
    2143, 2146, 552,
    1238, 87, 2146,
    67, 2145, 2148,
    2148, 2145, 2147,
    2148, 2147, 554,
    2145, 552, 2147,
    554, 2147, 2150,
    2150, 2147, 2149,
    2150, 2149, 553,
    2147, 552, 2149,
    554, 2150, 2152,
    2152, 2150, 2151,
    2152, 2151, 147,
    2150, 553, 2151,
    552, 2146, 2149,
    2149, 2146, 2153,
    2149, 2153, 553,
    2146, 87, 2153,
    67, 2148, 977,
    977, 2148, 2154,
    977, 2154, 253,
    2148, 554, 2154,
    253, 2154, 2156,
    2156, 2154, 2155,
    2156, 2155, 555,
    2154, 554, 2155,
    253, 2156, 982,
    982, 2156, 2157,
    982, 2157, 20,
    2156, 555, 2157,
    554, 2152, 2155,
    2155, 2152, 2158,
    2155, 2158, 555,
    2152, 147, 2158,
    87, 1242, 2153,
    2153, 1242, 2159,
    2153, 2159, 553,
    1242, 324, 2159,
    553, 2159, 2161,
    2161, 2159, 2160,
    2161, 2160, 556,
    2159, 324, 2160,
    553, 2161, 2151,
    2151, 2161, 2162,
    2151, 2162, 147,
    2161, 556, 2162,
    324, 1243, 2160,
    2160, 1243, 2163,
    2160, 2163, 556,
    1243, 25, 2163,
    20, 2157, 2165,
    2165, 2157, 2164,
    2165, 2164, 558,
    2157, 555, 2164,
    558, 2164, 2167,
    2167, 2164, 2166,
    2167, 2166, 557,
    2164, 555, 2166,
    558, 2167, 2169,
    2169, 2167, 2168,
    2169, 2168, 149,
    2167, 557, 2168,
    555, 2158, 2166,
    2166, 2158, 2170,
    2166, 2170, 557,
    2158, 147, 2170,
    149, 2168, 2172,
    2172, 2168, 2171,
    2172, 2171, 560,
    2168, 557, 2171,
    560, 2171, 2174,
    2174, 2171, 2173,
    2174, 2173, 559,
    2171, 557, 2173,
    560, 2174, 2176,
    2176, 2174, 2175,
    2176, 2175, 148,
    2174, 559, 2175,
    557, 2170, 2173,
    2173, 2170, 2177,
    2173, 2177, 559,
    2170, 147, 2177,
    149, 2172, 2179,
    2179, 2172, 2178,
    2179, 2178, 562,
    2172, 560, 2178,
    562, 2178, 2181,
    2181, 2178, 2180,
    2181, 2180, 561,
    2178, 560, 2180,
    562, 2181, 2183,
    2183, 2181, 2182,
    2183, 2182, 38,
    2181, 561, 2182,
    560, 2176, 2180,
    2180, 2176, 2184,
    2180, 2184, 561,
    2176, 148, 2184,
    147, 2162, 2177,
    2177, 2162, 2185,
    2177, 2185, 559,
    2162, 556, 2185,
    559, 2185, 2187,
    2187, 2185, 2186,
    2187, 2186, 563,
    2185, 556, 2186,
    559, 2187, 2175,
    2175, 2187, 2188,
    2175, 2188, 148,
    2187, 563, 2188,
    556, 2163, 2186,
    2186, 2163, 2189,
    2186, 2189, 563,
    2163, 25, 2189,
    20, 2165, 1032,
    1032, 2165, 2190,
    1032, 2190, 267,
    2165, 558, 2190,
    267, 2190, 2192,
    2192, 2190, 2191,
    2192, 2191, 564,
    2190, 558, 2191,
    267, 2192, 1037,
    1037, 2192, 2193,
    1037, 2193, 72,
    2192, 564, 2193,
    558, 2169, 2191,
    2191, 2169, 2194,
    2191, 2194, 564,
    2169, 149, 2194,
    72, 2193, 2196,
    2196, 2193, 2195,
    2196, 2195, 566,
    2193, 564, 2195,
    566, 2195, 2198,
    2198, 2195, 2197,
    2198, 2197, 565,
    2195, 564, 2197,
    566, 2198, 2200,
    2200, 2198, 2199,
    2200, 2199, 130,
    2198, 565, 2199,
    564, 2194, 2197,
    2197, 2194, 2201,
    2197, 2201, 565,
    2194, 149, 2201,
    72, 2196, 1051,
    1051, 2196, 2202,
    1051, 2202, 272,
    2196, 566, 2202,
    272, 2202, 2204,
    2204, 2202, 2203,
    2204, 2203, 471,
    2202, 566, 2203,
    272, 2204, 1056,
    1056, 2204, 1789,
    1056, 1789, 10,
    2204, 471, 1789,
    566, 2200, 2203,
    2203, 2200, 1787,
    2203, 1787, 471,
    2200, 130, 1787,
    149, 2179, 2201,
    2201, 2179, 2205,
    2201, 2205, 565,
    2179, 562, 2205,
    565, 2205, 2207,
    2207, 2205, 2206,
    2207, 2206, 469,
    2205, 562, 2206,
    565, 2207, 2199,
    2199, 2207, 1782,
    2199, 1782, 130,
    2207, 469, 1782,
    562, 2183, 2206,
    2206, 2183, 1781,
    2206, 1781, 469,
    2183, 38, 1781,
    25, 1259, 2189,
    2189, 1259, 2208,
    2189, 2208, 563,
    1259, 328, 2208,
    563, 2208, 2210,
    2210, 2208, 2209,
    2210, 2209, 567,
    2208, 328, 2209,
    563, 2210, 2188,
    2188, 2210, 2211,
    2188, 2211, 148,
    2210, 567, 2211,
    328, 1260, 2209,
    2209, 1260, 2212,
    2209, 2212, 567,
    1260, 89, 2212,
    148, 2211, 2214,
    2214, 2211, 2213,
    2214, 2213, 569,
    2211, 567, 2213,
    569, 2213, 2216,
    2216, 2213, 2215,
    2216, 2215, 568,
    2213, 567, 2215,
    569, 2216, 2218,
    2218, 2216, 2217,
    2218, 2217, 127,
    2216, 568, 2217,
    567, 2212, 2215,
    2215, 2212, 2219,
    2215, 2219, 568,
    2212, 89, 2219,
    148, 2214, 2184,
    2184, 2214, 2220,
    2184, 2220, 561,
    2214, 569, 2220,
    561, 2220, 2222,
    2222, 2220, 2221,
    2222, 2221, 464,
    2220, 569, 2221,
    561, 2222, 2182,
    2182, 2222, 1763,
    2182, 1763, 38,
    2222, 464, 1763,
    569, 2218, 2221,
    2221, 2218, 1762,
    2221, 1762, 464,
    2218, 127, 1762,
    89, 1264, 2219,
    2219, 1264, 2223,
    2219, 2223, 568,
    1264, 329, 2223,
    568, 2223, 2225,
    2225, 2223, 2224,
    2225, 2224, 462,
    2223, 329, 2224,
    568, 2225, 2217,
    2217, 2225, 1758,
    2217, 1758, 127,
    2225, 462, 1758,
    329, 1265, 2224,
    2224, 1265, 1756,
    2224, 1756, 462,
    1265, 3, 1756,
    7, 716, 1373,
    1373, 716, 2226,
    1373, 2226, 359,
    716, 182, 2226,
    359, 2226, 2228,
    2228, 2226, 2227,
    2228, 2227, 570,
    2226, 182, 2227,
    359, 2228, 1371,
    1371, 2228, 2229,
    1371, 2229, 98,
    2228, 570, 2229,
    182, 718, 2227,
    2227, 718, 2230,
    2227, 2230, 570,
    718, 47, 2230,
    98, 2229, 2232,
    2232, 2229, 2231,
    2232, 2231, 572,
    2229, 570, 2231,
    572, 2231, 2234,
    2234, 2231, 2233,
    2234, 2233, 571,
    2231, 570, 2233,
    572, 2234, 2236,
    2236, 2234, 2235,
    2236, 2235, 150,
    2234, 571, 2235,
    570, 2230, 2233,
    2233, 2230, 2237,
    2233, 2237, 571,
    2230, 47, 2237,
    98, 2232, 1366,
    1366, 2232, 2238,
    1366, 2238, 357,
    2232, 572, 2238,
    357, 2238, 2240,
    2240, 2238, 2239,
    2240, 2239, 573,
    2238, 572, 2239,
    357, 2240, 1365,
    1365, 2240, 2241,
    1365, 2241, 28,
    2240, 573, 2241,
    572, 2236, 2239,
    2239, 2236, 2242,
    2239, 2242, 573,
    2236, 150, 2242,
    47, 722, 2237,
    2237, 722, 2243,
    2237, 2243, 571,
    722, 184, 2243,
    571, 2243, 2245,
    2245, 2243, 2244,
    2245, 2244, 574,
    2243, 184, 2244,
    571, 2245, 2235,
    2235, 2245, 2246,
    2235, 2246, 150,
    2245, 574, 2246,
    184, 723, 2244,
    2244, 723, 2247,
    2244, 2247, 574,
    723, 13, 2247,
    28, 2241, 2249,
    2249, 2241, 2248,
    2249, 2248, 576,
    2241, 573, 2248,
    576, 2248, 2251,
    2251, 2248, 2250,
    2251, 2250, 575,
    2248, 573, 2250,
    576, 2251, 2253,
    2253, 2251, 2252,
    2253, 2252, 152,
    2251, 575, 2252,
    573, 2242, 2250,
    2250, 2242, 2254,
    2250, 2254, 575,
    2242, 150, 2254,
    152, 2252, 2256,
    2256, 2252, 2255,
    2256, 2255, 578,
    2252, 575, 2255,
    578, 2255, 2258,
    2258, 2255, 2257,
    2258, 2257, 577,
    2255, 575, 2257,
    578, 2258, 2260,
    2260, 2258, 2259,
    2260, 2259, 151,
    2258, 577, 2259,
    575, 2254, 2257,
    2257, 2254, 2261,
    2257, 2261, 577,
    2254, 150, 2261,
    152, 2256, 2263,
    2263, 2256, 2262,
    2263, 2262, 580,
    2256, 578, 2262,
    580, 2262, 2265,
    2265, 2262, 2264,
    2265, 2264, 579,
    2262, 578, 2264,
    580, 2265, 2267,
    2267, 2265, 2266,
    2267, 2266, 36,
    2265, 579, 2266,
    578, 2260, 2264,
    2264, 2260, 2268,
    2264, 2268, 579,
    2260, 151, 2268,
    150, 2246, 2261,
    2261, 2246, 2269,
    2261, 2269, 577,
    2246, 574, 2269,
    577, 2269, 2271,
    2271, 2269, 2270,
    2271, 2270, 581,
    2269, 574, 2270,
    577, 2271, 2259,
    2259, 2271, 2272,
    2259, 2272, 151,
    2271, 581, 2272,
    574, 2247, 2270,
    2270, 2247, 2273,
    2270, 2273, 581,
    2247, 13, 2273,
    28, 2249, 1347,
    1347, 2249, 2274,
    1347, 2274, 352,
    2249, 576, 2274,
    352, 2274, 2276,
    2276, 2274, 2275,
    2276, 2275, 582,
    2274, 576, 2275,
    352, 2276, 1346,
    1346, 2276, 2277,
    1346, 2277, 95,
    2276, 582, 2277,
    576, 2253, 2275,
    2275, 2253, 2278,
    2275, 2278, 582,
    2253, 152, 2278,
    95, 2277, 2280,
    2280, 2277, 2279,
    2280, 2279, 584,
    2277, 582, 2279,
    584, 2279, 2282,
    2282, 2279, 2281,
    2282, 2281, 583,
    2279, 582, 2281,
    584, 2282, 2284,
    2284, 2282, 2283,
    2284, 2283, 120,
    2282, 583, 2283,
    582, 2278, 2281,
    2281, 2278, 2285,
    2281, 2285, 583,
    2278, 152, 2285,
    95, 2280, 1342,
    1342, 2280, 2286,
    1342, 2286, 350,
    2280, 584, 2286,
    350, 2286, 2288,
    2288, 2286, 2287,
    2288, 2287, 435,
    2286, 584, 2287,
    350, 2288, 1340,
    1340, 2288, 1653,
    1340, 1653, 1,
    2288, 435, 1653,
    584, 2284, 2287,
    2287, 2284, 1649,
    2287, 1649, 435,
    2284, 120, 1649,
    152, 2263, 2285,
    2285, 2263, 2289,
    2285, 2289, 583,
    2263, 580, 2289,
    583, 2289, 2291,
    2291, 2289, 2290,
    2291, 2290, 431,
    2289, 580, 2290,
    583, 2291, 2283,
    2283, 2291, 1639,
    2283, 1639, 120,
    2291, 431, 1639,
    580, 2267, 2290,
    2290, 2267, 1635,
    2290, 1635, 431,
    2267, 36, 1635,
    13, 741, 2273,
    2273, 741, 2292,
    2273, 2292, 581,
    741, 189, 2292,
    581, 2292, 2294,
    2294, 2292, 2293,
    2294, 2293, 585,
    2292, 189, 2293,
    581, 2294, 2272,
    2272, 2294, 2295,
    2272, 2295, 151,
    2294, 585, 2295,
    189, 742, 2293,
    2293, 742, 2296,
    2293, 2296, 585,
    742, 50, 2296,
    151, 2295, 2298,
    2298, 2295, 2297,
    2298, 2297, 587,
    2295, 585, 2297,
    587, 2297, 2300,
    2300, 2297, 2299,
    2300, 2299, 586,
    2297, 585, 2299,
    587, 2300, 2302,
    2302, 2300, 2301,
    2302, 2301, 116,
    2300, 586, 2301,
    585, 2296, 2299,
    2299, 2296, 2303,
    2299, 2303, 586,
    2296, 50, 2303,
    151, 2298, 2268,
    2268, 2298, 2304,
    2268, 2304, 579,
    2298, 587, 2304,
    579, 2304, 2306,
    2306, 2304, 2305,
    2306, 2305, 421,
    2304, 587, 2305,
    579, 2306, 2266,
    2266, 2306, 1601,
    2266, 1601, 36,
    2306, 421, 1601,
    587, 2302, 2305,
    2305, 2302, 1597,
    2305, 1597, 421,
    2302, 116, 1597,
    50, 747, 2303,
    2303, 747, 2307,
    2303, 2307, 586,
    747, 191, 2307,
    586, 2307, 2309,
    2309, 2307, 2308,
    2309, 2308, 417,
    2307, 191, 2308,
    586, 2309, 2301,
    2301, 2309, 1587,
    2301, 1587, 116,
    2309, 417, 1587,
    191, 749, 2308,
    2308, 749, 1583,
    2308, 1583, 417,
    749, 8, 1583,
    6, 1444, 957,
    957, 1444, 2310,
    957, 2310, 247,
    1444, 378, 2310,
    247, 2310, 2312,
    2312, 2310, 2311,
    2312, 2311, 588,
    2310, 378, 2311,
    247, 2312, 955,
    955, 2312, 2313,
    955, 2313, 66,
    2312, 588, 2313,
    378, 1446, 2311,
    2311, 1446, 2314,
    2311, 2314, 588,
    1446, 103, 2314,
    66, 2313, 2316,
    2316, 2313, 2315,
    2316, 2315, 590,
    2313, 588, 2315,
    590, 2315, 2318,
    2318, 2315, 2317,
    2318, 2317, 589,
    2315, 588, 2317,
    590, 2318, 2320,
    2320, 2318, 2319,
    2320, 2319, 153,
    2318, 589, 2319,
    588, 2314, 2317,
    2317, 2314, 2321,
    2317, 2321, 589,
    2314, 103, 2321,
    66, 2316, 950,
    950, 2316, 2322,
    950, 2322, 245,
    2316, 590, 2322,
    245, 2322, 2324,
    2324, 2322, 2323,
    2324, 2323, 591,
    2322, 590, 2323,
    245, 2324, 949,
    949, 2324, 2325,
    949, 2325, 18,
    2324, 591, 2325,
    590, 2320, 2323,
    2323, 2320, 2326,
    2323, 2326, 591,
    2320, 153, 2326,
    103, 1450, 2321,
    2321, 1450, 2327,
    2321, 2327, 589,
    1450, 380, 2327,
    589, 2327, 2329,
    2329, 2327, 2328,
    2329, 2328, 592,
    2327, 380, 2328,
    589, 2329, 2319,
    2319, 2329, 2330,
    2319, 2330, 153,
    2329, 592, 2330,
    380, 1451, 2328,
    2328, 1451, 2331,
    2328, 2331, 592,
    1451, 30, 2331,
    18, 2325, 2333,
    2333, 2325, 2332,
    2333, 2332, 594,
    2325, 591, 2332,
    594, 2332, 2335,
    2335, 2332, 2334,
    2335, 2334, 593,
    2332, 591, 2334,
    594, 2335, 2337,
    2337, 2335, 2336,
    2337, 2336, 155,
    2335, 593, 2336,
    591, 2326, 2334,
    2334, 2326, 2338,
    2334, 2338, 593,
    2326, 153, 2338,
    155, 2336, 2340,
    2340, 2336, 2339,
    2340, 2339, 596,
    2336, 593, 2339,
    596, 2339, 2342,
    2342, 2339, 2341,
    2342, 2341, 595,
    2339, 593, 2341,
    596, 2342, 2344,
    2344, 2342, 2343,
    2344, 2343, 154,
    2342, 595, 2343,
    593, 2338, 2341,
    2341, 2338, 2345,
    2341, 2345, 595,
    2338, 153, 2345,
    155, 2340, 2347,
    2347, 2340, 2346,
    2347, 2346, 598,
    2340, 596, 2346,
    598, 2346, 2349,
    2349, 2346, 2348,
    2349, 2348, 597,
    2346, 596, 2348,
    598, 2349, 2351,
    2351, 2349, 2350,
    2351, 2350, 35,
    2349, 597, 2350,
    596, 2344, 2348,
    2348, 2344, 2352,
    2348, 2352, 597,
    2344, 154, 2352,
    153, 2330, 2345,
    2345, 2330, 2353,
    2345, 2353, 595,
    2330, 592, 2353,
    595, 2353, 2355,
    2355, 2353, 2354,
    2355, 2354, 599,
    2353, 592, 2354,
    595, 2355, 2343,
    2343, 2355, 2356,
    2343, 2356, 154,
    2355, 599, 2356,
    592, 2331, 2354,
    2354, 2331, 2357,
    2354, 2357, 599,
    2331, 30, 2357,
    18, 2333, 931,
    931, 2333, 2358,
    931, 2358, 240,
    2333, 594, 2358,
    240, 2358, 2360,
    2360, 2358, 2359,
    2360, 2359, 600,
    2358, 594, 2359,
    240, 2360, 930,
    930, 2360, 2361,
    930, 2361, 63,
    2360, 600, 2361,
    594, 2337, 2359,
    2359, 2337, 2362,
    2359, 2362, 600,
    2337, 155, 2362,
    63, 2361, 2364,
    2364, 2361, 2363,
    2364, 2363, 602,
    2361, 600, 2363,
    602, 2363, 2366,
    2366, 2363, 2365,
    2366, 2365, 601,
    2363, 600, 2365,
    602, 2366, 2368,
    2368, 2366, 2367,
    2368, 2367, 121,
    2366, 601, 2367,
    600, 2362, 2365,
    2365, 2362, 2369,
    2365, 2369, 601,
    2362, 155, 2369,
    63, 2364, 926,
    926, 2364, 2370,
    926, 2370, 238,
    2364, 602, 2370,
    238, 2370, 2372,
    2372, 2370, 2371,
    2372, 2371, 441,
    2370, 602, 2371,
    238, 2372, 924,
    924, 2372, 1681,
    924, 1681, 11,
    2372, 441, 1681,
    602, 2368, 2371,
    2371, 2368, 1680,
    2371, 1680, 441,
    2368, 121, 1680,
    155, 2347, 2369,
    2369, 2347, 2373,
    2369, 2373, 601,
    2347, 598, 2373,
    601, 2373, 2375,
    2375, 2373, 2374,
    2375, 2374, 440,
    2373, 598, 2374,
    601, 2375, 2367,
    2367, 2375, 1676,
    2367, 1676, 121,
    2375, 440, 1676,
    598, 2351, 2374,
    2374, 2351, 1675,
    2374, 1675, 440,
    2351, 35, 1675,
    30, 1467, 2357,
    2357, 1467, 2376,
    2357, 2376, 599,
    1467, 384, 2376,
    599, 2376, 2378,
    2378, 2376, 2377,
    2378, 2377, 603,
    2376, 384, 2377,
    599, 2378, 2356,
    2356, 2378, 2379,
    2356, 2379, 154,
    2378, 603, 2379,
    384, 1468, 2377,
    2377, 1468, 2380,
    2377, 2380, 603,
    1468, 105, 2380,
    154, 2379, 2382,
    2382, 2379, 2381,
    2382, 2381, 605,
    2379, 603, 2381,
    605, 2381, 2384,
    2384, 2381, 2383,
    2384, 2383, 604,
    2381, 603, 2383,
    605, 2384, 2386,
    2386, 2384, 2385,
    2386, 2385, 119,
    2384, 604, 2385,
    603, 2380, 2383,
    2383, 2380, 2387,
    2383, 2387, 604,
    2380, 105, 2387,
    154, 2382, 2352,
    2352, 2382, 2388,
    2352, 2388, 597,
    2382, 605, 2388,
    597, 2388, 2390,
    2390, 2388, 2389,
    2390, 2389, 436,
    2388, 605, 2389,
    597, 2390, 2350,
    2350, 2390, 1659,
    2350, 1659, 35,
    2390, 436, 1659,
    605, 2386, 2389,
    2389, 2386, 1658,
    2389, 1658, 436,
    2386, 119, 1658,
    105, 1472, 2387,
    2387, 1472, 2391,
    2387, 2391, 604,
    1472, 385, 2391,
    604, 2391, 2393,
    2393, 2391, 2392,
    2393, 2392, 434,
    2391, 385, 2392,
    604, 2393, 2385,
    2385, 2393, 1654,
    2385, 1654, 119,
    2393, 434, 1654,
    385, 1473, 2392,
    2392, 1473, 1652,
    2392, 1652, 434,
    1473, 1, 1652,
    7, 1372, 849,
    849, 1372, 2394,
    849, 2394, 217,
    1372, 358, 2394,
    217, 2394, 2396,
    2396, 2394, 2395,
    2396, 2395, 606,
    2394, 358, 2395,
    217, 2396, 848,
    848, 2396, 2397,
    848, 2397, 57,
    2396, 606, 2397,
    358, 1367, 2395,
    2395, 1367, 2398,
    2395, 2398, 606,
    1367, 97, 2398,
    57, 2397, 2400,
    2400, 2397, 2399,
    2400, 2399, 608,
    2397, 606, 2399,
    608, 2399, 2402,
    2402, 2399, 2401,
    2402, 2401, 607,
    2399, 606, 2401,
    608, 2402, 2404,
    2404, 2402, 2403,
    2404, 2403, 156,
    2402, 607, 2403,
    606, 2398, 2401,
    2401, 2398, 2405,
    2401, 2405, 607,
    2398, 97, 2405,
    57, 2400, 844,
    844, 2400, 2406,
    844, 2406, 216,
    2400, 608, 2406,
    216, 2406, 2408,
    2408, 2406, 2407,
    2408, 2407, 609,
    2406, 608, 2407,
    216, 2408, 843,
    843, 2408, 2409,
    843, 2409, 15,
    2408, 609, 2409,
    608, 2404, 2407,
    2407, 2404, 2410,
    2407, 2410, 609,
    2404, 156, 2410,
    97, 1353, 2405,
    2405, 1353, 2411,
    2405, 2411, 607,
    1353, 353, 2411,
    607, 2411, 2413,
    2413, 2411, 2412,
    2413, 2412, 610,
    2411, 353, 2412,
    607, 2413, 2403,
    2403, 2413, 2414,
    2403, 2414, 156,
    2413, 610, 2414,
    353, 1348, 2412,
    2412, 1348, 2415,
    2412, 2415, 610,
    1348, 27, 2415,
    15, 2409, 2417,
    2417, 2409, 2416,
    2417, 2416, 612,
    2409, 609, 2416,
    612, 2416, 2419,
    2419, 2416, 2418,
    2419, 2418, 611,
    2416, 609, 2418,
    612, 2419, 2421,
    2421, 2419, 2420,
    2421, 2420, 158,
    2419, 611, 2420,
    609, 2410, 2418,
    2418, 2410, 2422,
    2418, 2422, 611,
    2410, 156, 2422,
    158, 2420, 2424,
    2424, 2420, 2423,
    2424, 2423, 614,
    2420, 611, 2423,
    614, 2423, 2426,
    2426, 2423, 2425,
    2426, 2425, 613,
    2423, 611, 2425,
    614, 2426, 2428,
    2428, 2426, 2427,
    2428, 2427, 157,
    2426, 613, 2427,
    611, 2422, 2425,
    2425, 2422, 2429,
    2425, 2429, 613,
    2422, 156, 2429,
    158, 2424, 2431,
    2431, 2424, 2430,
    2431, 2430, 616,
    2424, 614, 2430,
    616, 2430, 2433,
    2433, 2430, 2432,
    2433, 2432, 615,
    2430, 614, 2432,
    616, 2433, 2435,
    2435, 2433, 2434,
    2435, 2434, 40,
    2433, 615, 2434,
    614, 2428, 2432,
    2432, 2428, 2436,
    2432, 2436, 615,
    2428, 157, 2436,
    156, 2414, 2429,
    2429, 2414, 2437,
    2429, 2437, 613,
    2414, 610, 2437,
    613, 2437, 2439,
    2439, 2437, 2438,
    2439, 2438, 617,
    2437, 610, 2438,
    613, 2439, 2427,
    2427, 2439, 2440,
    2427, 2440, 157,
    2439, 617, 2440,
    610, 2415, 2438,
    2438, 2415, 2441,
    2438, 2441, 617,
    2415, 27, 2441,
    15, 2417, 827,
    827, 2417, 2442,
    827, 2442, 212,
    2417, 612, 2442,
    212, 2442, 2444,
    2444, 2442, 2443,
    2444, 2443, 618,
    2442, 612, 2443,
    212, 2444, 826,
    826, 2444, 2445,
    826, 2445, 55,
    2444, 618, 2445,
    612, 2421, 2443,
    2443, 2421, 2446,
    2443, 2446, 618,
    2421, 158, 2446,
    55, 2445, 2448,
    2448, 2445, 2447,
    2448, 2447, 620,
    2445, 618, 2447,
    620, 2447, 2450,
    2450, 2447, 2449,
    2450, 2449, 619,
    2447, 618, 2449,
    620, 2450, 2452,
    2452, 2450, 2451,
    2452, 2451, 131,
    2450, 619, 2451,
    618, 2446, 2449,
    2449, 2446, 2453,
    2449, 2453, 619,
    2446, 158, 2453,
    55, 2448, 822,
    822, 2448, 2454,
    822, 2454, 210,
    2448, 620, 2454,
    210, 2454, 2456,
    2456, 2454, 2455,
    2456, 2455, 472,
    2454, 620, 2455,
    210, 2456, 820,
    820, 2456, 1790,
    820, 1790, 9,
    2456, 472, 1790,
    620, 2452, 2455,
    2455, 2452, 1795,
    2455, 1795, 472,
    2452, 131, 1795,
    158, 2431, 2453,
    2453, 2431, 2457,
    2453, 2457, 619,
    2431, 616, 2457,
    619, 2457, 2459,
    2459, 2457, 2458,
    2459, 2458, 477,
    2457, 616, 2458,
    619, 2459, 2451,
    2451, 2459, 1809,
    2451, 1809, 131,
    2459, 477, 1809,
    616, 2435, 2458,
    2458, 2435, 1814,
    2458, 1814, 477,
    2435, 40, 1814,
    27, 1294, 2441,
    2441, 1294, 2460,
    2441, 2460, 617,
    1294, 337, 2460,
    617, 2460, 2462,
    2462, 2460, 2461,
    2462, 2461, 621,
    2460, 337, 2461,
    617, 2462, 2440,
    2440, 2462, 2463,
    2440, 2463, 157,
    2462, 621, 2463,
    337, 1289, 2461,
    2461, 1289, 2464,
    2461, 2464, 621,
    1289, 90, 2464,
    157, 2463, 2466,
    2466, 2463, 2465,
    2466, 2465, 623,
    2463, 621, 2465,
    623, 2465, 2468,
    2468, 2465, 2467,
    2468, 2467, 622,
    2465, 621, 2467,
    623, 2468, 2470,
    2470, 2468, 2469,
    2470, 2469, 136,
    2468, 622, 2469,
    621, 2464, 2467,
    2467, 2464, 2471,
    2467, 2471, 622,
    2464, 90, 2471,
    157, 2466, 2436,
    2436, 2466, 2472,
    2436, 2472, 615,
    2466, 623, 2472,
    615, 2472, 2474,
    2474, 2472, 2473,
    2474, 2473, 491,
    2472, 623, 2473,
    615, 2474, 2434,
    2434, 2474, 1864,
    2434, 1864, 40,
    2474, 491, 1864,
    623, 2470, 2473,
    2473, 2470, 1869,
    2473, 1869, 491,
    2470, 136, 1869,
    90, 1273, 2471,
    2471, 1273, 2475,
    2471, 2475, 622,
    1273, 330, 2475,
    622, 2475, 2477,
    2477, 2475, 2476,
    2477, 2476, 496,
    2475, 330, 2476,
    622, 2477, 2469,
    2469, 2477, 1883,
    2469, 1883, 136,
    2477, 496, 1883,
    330, 1266, 2476,
    2476, 1266, 1888,
    2476, 1888, 496,
    1266, 2, 1888,
    6, 1025, 1445,
    1445, 1025, 2478,
    1445, 2478, 379,
    1025, 265, 2478,
    379, 2478, 2480,
    2480, 2478, 2479,
    2480, 2479, 624,
    2478, 265, 2479,
    379, 2480, 1441,
    1441, 2480, 2481,
    1441, 2481, 104,
    2480, 624, 2481,
    265, 1026, 2479,
    2479, 1026, 2482,
    2479, 2482, 624,
    1026, 71, 2482,
    104, 2481, 2484,
    2484, 2481, 2483,
    2484, 2483, 626,
    2481, 624, 2483,
    626, 2483, 2486,
    2486, 2483, 2485,
    2486, 2485, 625,
    2483, 624, 2485,
    626, 2486, 2488,
    2488, 2486, 2487,
    2488, 2487, 159,
    2486, 625, 2487,
    624, 2482, 2485,
    2485, 2482, 2489,
    2485, 2489, 625,
    2482, 71, 2489,
    104, 2484, 1431,
    1431, 2484, 2490,
    1431, 2490, 375,
    2484, 626, 2490,
    375, 2490, 2492,
    2492, 2490, 2491,
    2492, 2491, 627,
    2490, 626, 2491,
    375, 2492, 1427,
    1427, 2492, 2493,
    1427, 2493, 31,
    2492, 627, 2493,
    626, 2488, 2491,
    2491, 2488, 2494,
    2491, 2494, 627,
    2488, 159, 2494,
    71, 1030, 2489,
    2489, 1030, 2495,
    2489, 2495, 625,
    1030, 266, 2495,
    625, 2495, 2497,
    2497, 2495, 2496,
    2497, 2496, 628,
    2495, 266, 2496,
    625, 2497, 2487,
    2487, 2497, 2498,
    2487, 2498, 159,
    2497, 628, 2498,
    266, 1031, 2496,
    2496, 1031, 2499,
    2496, 2499, 628,
    1031, 21, 2499,
    31, 2493, 2501,
    2501, 2493, 2500,
    2501, 2500, 630,
    2493, 627, 2500,
    630, 2500, 2503,
    2503, 2500, 2502,
    2503, 2502, 629,
    2500, 627, 2502,
    630, 2503, 2505,
    2505, 2503, 2504,
    2505, 2504, 161,
    2503, 629, 2504,
    627, 2494, 2502,
    2502, 2494, 2506,
    2502, 2506, 629,
    2494, 159, 2506,
    161, 2504, 2508,
    2508, 2504, 2507,
    2508, 2507, 632,
    2504, 629, 2507,
    632, 2507, 2510,
    2510, 2507, 2509,
    2510, 2509, 631,
    2507, 629, 2509,
    632, 2510, 2512,
    2512, 2510, 2511,
    2512, 2511, 160,
    2510, 631, 2511,
    629, 2506, 2509,
    2509, 2506, 2513,
    2509, 2513, 631,
    2506, 159, 2513,
    161, 2508, 2515,
    2515, 2508, 2514,
    2515, 2514, 634,
    2508, 632, 2514,
    634, 2514, 2517,
    2517, 2514, 2516,
    2517, 2516, 633,
    2514, 632, 2516,
    634, 2517, 2519,
    2519, 2517, 2518,
    2519, 2518, 41,
    2517, 633, 2518,
    632, 2512, 2516,
    2516, 2512, 2520,
    2516, 2520, 633,
    2512, 160, 2520,
    159, 2498, 2513,
    2513, 2498, 2521,
    2513, 2521, 631,
    2498, 628, 2521,
    631, 2521, 2523,
    2523, 2521, 2522,
    2523, 2522, 635,
    2521, 628, 2522,
    631, 2523, 2511,
    2511, 2523, 2524,
    2511, 2524, 160,
    2523, 635, 2524,
    628, 2499, 2522,
    2522, 2499, 2525,
    2522, 2525, 635,
    2499, 21, 2525,
    31, 2501, 1393,
    1393, 2501, 2526,
    1393, 2526, 365,
    2501, 630, 2526,
    365, 2526, 2528,
    2528, 2526, 2527,
    2528, 2527, 636,
    2526, 630, 2527,
    365, 2528, 1389,
    1389, 2528, 2529,
    1389, 2529, 100,
    2528, 636, 2529,
    630, 2505, 2527,
    2527, 2505, 2530,
    2527, 2530, 636,
    2505, 161, 2530,
    100, 2529, 2532,
    2532, 2529, 2531,
    2532, 2531, 638,
    2529, 636, 2531,
    638, 2531, 2534,
    2534, 2531, 2533,
    2534, 2533, 637,
    2531, 636, 2533,
    638, 2534, 2536,
    2536, 2534, 2535,
    2536, 2535, 137,
    2534, 637, 2535,
    636, 2530, 2533,
    2533, 2530, 2537,
    2533, 2537, 637,
    2530, 161, 2537,
    100, 2532, 1379,
    1379, 2532, 2538,
    1379, 2538, 361,
    2532, 638, 2538,
    361, 2538, 2540,
    2540, 2538, 2539,
    2540, 2539, 497,
    2538, 638, 2539,
    361, 2540, 1375,
    1375, 2540, 1889,
    1375, 1889, 2,
    2540, 497, 1889,
    638, 2536, 2539,
    2539, 2536, 1887,
    2539, 1887, 497,
    2536, 137, 1887,
    161, 2515, 2537,
    2537, 2515, 2541,
    2537, 2541, 637,
    2515, 634, 2541,
    637, 2541, 2543,
    2543, 2541, 2542,
    2543, 2542, 495,
    2541, 634, 2542,
    637, 2543, 2535,
    2535, 2543, 1882,
    2535, 1882, 137,
    2543, 495, 1882,
    634, 2519, 2542,
    2542, 2519, 1881,
    2542, 1881, 495,
    2519, 41, 1881,
    21, 1049, 2525,
    2525, 1049, 2544,
    2525, 2544, 635,
    1049, 271, 2544,
    635, 2544, 2546,
    2546, 2544, 2545,
    2546, 2545, 639,
    2544, 271, 2545,
    635, 2546, 2524,
    2524, 2546, 2547,
    2524, 2547, 160,
    2546, 639, 2547,
    271, 1050, 2545,
    2545, 1050, 2548,
    2545, 2548, 639,
    1050, 73, 2548,
    160, 2547, 2550,
    2550, 2547, 2549,
    2550, 2549, 641,
    2547, 639, 2549,
    641, 2549, 2552,
    2552, 2549, 2551,
    2552, 2551, 640,
    2549, 639, 2551,
    641, 2552, 2554,
    2554, 2552, 2553,
    2554, 2553, 135,
    2552, 640, 2553,
    639, 2548, 2551,
    2551, 2548, 2555,
    2551, 2555, 640,
    2548, 73, 2555,
    160, 2550, 2520,
    2520, 2550, 2556,
    2520, 2556, 633,
    2550, 641, 2556,
    633, 2556, 2558,
    2558, 2556, 2557,
    2558, 2557, 490,
    2556, 641, 2557,
    633, 2558, 2518,
    2518, 2558, 1863,
    2518, 1863, 41,
    2558, 490, 1863,
    641, 2554, 2557,
    2557, 2554, 1862,
    2557, 1862, 490,
    2554, 135, 1862,
    73, 1055, 2555,
    2555, 1055, 2559,
    2555, 2559, 640,
    1055, 273, 2559,
    640, 2559, 2561,
    2561, 2559, 2560,
    2561, 2560, 489,
    2559, 273, 2560,
    640, 2561, 2553,
    2553, 2561, 1858,
    2553, 1858, 135,
    2561, 489, 1858,
    273, 1057, 2560,
    2560, 1057, 1857,
    2560, 1857, 489,
    1057, 10, 1857
};

#endif // __SPHERE__H__

