//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.30
//////////////////////////////////////////////////////////////////////
#version 430

//////////////////////////////////////////////////////////////////////
// definicje numerw pooenia zmiennych jednorodnych
// i powizania uchwytw tekstur
//////////////////////////////////////////////////////////////////////
#define AMBIENT         0
#define DIFFUSE         1
#define SPECULAR        2
#define SHININESS       3
#define HEIGHT          4
#define NORMAL          5
#define ENVIRONMENT_MAP 6
#define TEXTURE_LOC     4

//////////////////////////////////////////////////////////////////////
// tablica znacznikw materiaw zawartych w teksturze
//////////////////////////////////////////////////////////////////////
layout( location = TEXTURE_LOC ) uniform bool textures[6] =
        bool[6]( false, false, false, false, false, false );

//////////////////////////////////////////////////////////////////////
// uchwyt tekstury 2D
// mapa wektorw normalnych
//////////////////////////////////////////////////////////////////////
layout( binding = NORMAL ) uniform sampler2D texNormal;

//////////////////////////////////////////////////////////////////////
// uchwyt tekstury szeciennej
// mapa otoczenia (rodowiska)
//////////////////////////////////////////////////////////////////////
layout( binding = ENVIRONMENT_MAP ) uniform samplerCube texEnvironmentMap;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
in vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
in vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora stycznego
//////////////////////////////////////////////////////////////////////
in vec3 inoutTangent;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora bistycznego
//////////////////////////////////////////////////////////////////////
in vec3 inoutBitangent;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// macierz modelu-widoku do oblicze odbicia
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewMatrix;

//////////////////////////////////////////////////////////////////////
// macierz przeksztacenia wektora normalnego do oblicze odbicia
//////////////////////////////////////////////////////////////////////
uniform mat3 normalMatrix;

//////////////////////////////////////////////////////////////////////
// wsprzdne pooenia obserwatora
//////////////////////////////////////////////////////////////////////
uniform vec3 eye;

//////////////////////////////////////////////////////////////////////
// wspczynnik refrakcji
//////////////////////////////////////////////////////////////////////
uniform float eta = 0.9;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // normalizacja wektora normalnego zalena od strony wielokta
    vec3 normalVec = gl_FrontFacing ? normalize( inoutNormal ) : -normalize( inoutNormal );

    // obliczenia zwizane z mapowaniem nierwnoci
    if( textures[NORMAL] )
    {
        // obliczenie macierzy przeksztacenia
        vec3 tangent = normalize( inoutTangent );
        vec3 bitangent = normalize( inoutBitangent );
        mat3 TBN = mat3( tangent, bitangent, normalVec );

        // rekonstrukcja skadowej z wektora normalnego z mapy wektorw normalnych
        vec3 bumpNormal;
        bumpNormal.rg = texture( texNormal, inoutTexCoord ).xy;
        bumpNormal.rg = 2.0 * bumpNormal.rg - 1.0;
        bumpNormal.b = 0.5 * (sqrt( 1.0 - dot( bumpNormal.rg, bumpNormal.rg ) ) + 1.0);

        // przeksztacenie wektora normalnego do ukadu wsprzdnych obiektu
        normalVec = TBN * bumpNormal;
    }

    // przeksztacenie wsprzdnych wierzchoka do ukadu obserwatora
    vec3 positionWorld = vec3( modelViewMatrix * vec4( inoutPosition, 1.0 ) );

    // wektor padajcy (znormalizowany)
    vec3 incidentVec = normalize( positionWorld - eye );

    // przeksztacenie do ukadu obserwatora i normalizacja wektora normalnego
    vec3 normalWorld = normalize( normalMatrix * normalVec );

    // wektory refrakcji
    vec3 refractVecR = refract( incidentVec, normalWorld, eta + 0.004 );
    vec3 refractVecG = refract( incidentVec, normalWorld, eta + 0.002 );
    vec3 refractVecB = refract( incidentVec, normalWorld, eta + 0.000 );

    // prbkowanie tekstury szeciennej - dyspersja
    outColor = vec4( texture( texEnvironmentMap, refractVecR ).r,
                     texture( texEnvironmentMap, refractVecG ).g,
                     texture( texEnvironmentMap, refractVecB ).b, 1.0 );
}
