//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw w wyjciowym pacie wierzchokw
//////////////////////////////////////////////////////////////////////
layout( vertices = 3 ) out;

//////////////////////////////////////////////////////////////////////
// poziomy teselacji
//////////////////////////////////////////////////////////////////////
uniform vec3 tessLevelOuter;
uniform float tessLevelInner;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // parametry teselacji zapisywane tylko w pierwszym wywoaniu shadera
    if( gl_InvocationID == 0 )
    {
        gl_TessLevelOuter[0] = tessLevelOuter[0];
        gl_TessLevelOuter[1] = tessLevelOuter[1];
        gl_TessLevelOuter[2] = tessLevelOuter[2];
        gl_TessLevelInner[0] = tessLevelInner;
    }

    // kopiowanie wybranego standardowego atrybutu wierzchoka
    gl_out[gl_InvocationID].gl_Position = gl_in[gl_InvocationID].gl_Position;
}
