//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// parametry teselacji
//////////////////////////////////////////////////////////////////////
layout( triangles, equal_spacing, ccw ) in;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In[];

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} Out;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wsprzdne barycentryczne wierzchoka prymitywu
    float u = gl_TessCoord[0];
    float v = gl_TessCoord[1];
    float w = gl_TessCoord[2];   // w = 1 - u - v;

    // interpolacja liniowa wsprzdnych wierzchoka
    Out.position = u * In[0].position.xyz + v * In[1].position.xyz + w * In[2].position.xyz;

    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * vec4( Out.position, 1.0 );

    // interpolacja liniowa wektora normalnego
    Out.normal = normalize( u * In[0].normal + v * In[1].normal + w * In[2].normal );
}
