//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry materiau
//////////////////////////////////////////////////////////////////////
struct MaterialParameters
{
    vec4 ambient;       // wspczynnik odbicia wiata otoczenia; oznaczenie Ma
    vec4 diffuse;       // wspczynnik odbicia wiata rozproszonego; oznaczenie Md
    vec4 specular;      // wspczynnik odbicia wiata zwierciadlanego; oznaczenie Ms
    float shininess;    // wykadnik wspczynnika funkcji rozbysku;
                        // zakres wartoci <0;128>; oznaczenie Msh
};

//////////////////////////////////////////////////////////////////////
// prototypy funkcji
//////////////////////////////////////////////////////////////////////
MaterialParameters GetMaterial( const int material );
vec4 BlinnPhongLight( const int light, const vec3 normal, const vec3 position,
                        const vec4 ambient, const vec4 diffuse,
                        const vec4 specular, const float shininess );

//////////////////////////////////////////////////////////////////////
// uchwyt tekstury 2D
//////////////////////////////////////////////////////////////////////
uniform sampler2D tex;

//////////////////////////////////////////////////////////////////////
// interpolowany wektor normalny
//////////////////////////////////////////////////////////////////////
in vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
in vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

void main()
{
    // pobranie wybranego materiau
    #define MTL_BRIGHT_WHITE        18  // jasny biay
    MaterialParameters mat = GetMaterial( MTL_BRIGHT_WHITE );

    // normalizacja wektora normalnego zalena od strony wielokta
    vec3 normal = gl_FrontFacing ? normalize( inoutNormal ) : -normalize( inoutNormal );

    // kolor fragmentu
    outColor = BlinnPhongLight( 0, normal, inoutPosition, mat.ambient, mat.diffuse, mat.specular, mat.shininess );

    // prbkowanie tekstury i mieszanie z danymi owietlenia
    outColor *= texture( tex, inoutTexCoord );
}
