//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <sstream>
#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateZ;
extern GLfloat scale;
extern GLboolean alphaToCoverage;
extern GLboolean colorBlend;
extern GLboolean alphaTest;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // test skadowej alfa
    ALPHA_TEST_TRUE,
    ALPHA_TEST_FALSE,

    // mieszanie kolorw
    COLOR_BLEND_TRUE,
    COLOR_BLEND_FALSE,

    // zastpowanie wartoci pokrycia prbki skadow alfa
    SAMPLE_ALPHA_TO_COVERAGE_TRUE,
    SAMPLE_ALPHA_TO_COVERAGE_FALSE,

    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // test skadowej alfa
        case ALPHA_TEST_TRUE:
            alphaTest = GL_TRUE;
            break;
        case ALPHA_TEST_FALSE:
            alphaTest = GL_FALSE;
            break;

        // mieszanie kolorw
        case COLOR_BLEND_TRUE:
            colorBlend = GL_TRUE;
            break;
        case COLOR_BLEND_FALSE:
            colorBlend = GL_FALSE;
            break;

        // zastpowanie wartoci pokrycia prbki skadow alfa
        case SAMPLE_ALPHA_TO_COVERAGE_TRUE:
            alphaToCoverage = GL_TRUE;
            break;
        case SAMPLE_ALPHA_TO_COVERAGE_FALSE:
            alphaToCoverage = GL_FALSE;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // a
        case 'A':
        case 'a':
            translateX += 0.1f;
            break;
        // w
        case 'W':
        case 'w':
            translateZ += 0.1f;
            break;
        // s
        case 'S':
        case 's':
            translateZ -= 0.1f;
            break;
        // d
        case 'D':
        case 'd':
            translateX -= 0.1f;
            break;
        // z
        case 'Z':
        case 'z':
            alphaTest = !alphaTest;
            break;
        // x
        case 'X':
        case 'x':
            colorBlend = !colorBlend;
            break;
        // c
        case 'C':
        case 'c':
            alphaToCoverage = !alphaToCoverage;
            break;
        // klawisz +
        case '+':
            scale += 0.03f;
            break;
        // klawisz -
        case '-':
            if( scale > 0.03f ) scale -= 0.03f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // pobranie liczby prbek z linii polece programu
    int samples = 4;
    if( argc > 1 )
        std::istringstream( argv[1] ) >> samples;

    // ustawienie liczby prbek w wieloprbkowaniu
    glutSetOption( GLUT_MULTISAMPLE, samples );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_ALPHA | GLUT_DEPTH | GLUT_MULTISAMPLE );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "Wieloprbkowanie z alfa" );
#else
    glutCreateWindow( "Wieloprobkowanie z alfa" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - Test skadowej alfa
    int menuAlphaTest = glutCreateMenu( Menu );
    glutAddMenuEntry( "wlaczony", ALPHA_TEST_TRUE );
    glutAddMenuEntry( "wylaczony", ALPHA_TEST_FALSE );

    // utworzenie podmenu - Mieszanie kolorw
    int menuColorBlend = glutCreateMenu( Menu );
    glutAddMenuEntry( "wlaczone", COLOR_BLEND_TRUE );
    glutAddMenuEntry( "wylaczone", COLOR_BLEND_FALSE );

    // utworzenie podmenu - Zastpowanie wartoci pokrycia prbki skadow alfa
    int menuAlphaToCoverage = glutCreateMenu( Menu );
    glutAddMenuEntry( "wlaczone", SAMPLE_ALPHA_TO_COVERAGE_TRUE );
    glutAddMenuEntry( "wylaczone", SAMPLE_ALPHA_TO_COVERAGE_FALSE );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "Test skladowej alfa", menuAlphaTest );
    glutAddSubMenu( "Mieszanie kolorow", menuColorBlend );
    glutAddSubMenu( "Zastepowanie wartosci pokrycia probki skladowa alfa", menuAlphaToCoverage );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
