//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.10
//////////////////////////////////////////////////////////////////////
#version 410

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw prymitywu wejciowego i wyjciowego
//////////////////////////////////////////////////////////////////////
#define MAX_VERTICES 3

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy
//////////////////////////////////////////////////////////////////////
layout( triangles ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy
//////////////////////////////////////////////////////////////////////
layout( triangle_strip, max_vertices = MAX_VERTICES ) out;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// tablica blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In[MAX_VERTICES];

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} Out;

void main ()
{
    // generowanie kolejnych wierzchokw prymitywu
    for( int v = 0; v < gl_in.length(); v++ )
    {
        // standardowe przeksztacenie wsprzdnych wierzchokw
        gl_Position = modelViewProjectionMatrix * In[v].position;

        // warstwa obszaru renderingu
        gl_ViewportIndex = 1;

        // atrybuty wierzchoka
        Out.position = In[v].position.xyz;
        Out.normal = In[v].normal;
        EmitVertex();
    }

    // koniec prymitywu
    EndPrimitive();
}
