//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry materiau
//////////////////////////////////////////////////////////////////////
struct MaterialParameters
{
    vec4 ambient;       // wspczynnik odbicia wiata otoczenia; oznaczenie Ma
    vec4 diffuse;       // wspczynnik odbicia wiata rozproszonego; oznaczenie Md
    vec4 specular;      // wspczynnik odbicia wiata zwierciadlanego; oznaczenie Ms
    float shininess;    // wykadnik wspczynnika funkcji rozbysku;
                        // zakres wartoci <0;128>; oznaczenie Msh
};

//////////////////////////////////////////////////////////////////////
// prototypy funkcji
//////////////////////////////////////////////////////////////////////
MaterialParameters GetMaterial( const int material );
vec4 BlinnPhongLight( const int light, const vec3 normal, const vec3 position,
                        const vec4 ambient, const vec4 diffuse,
                        const vec4 specular, const float shininess );

//////////////////////////////////////////////////////////////////////
// wybrany materia
//////////////////////////////////////////////////////////////////////
uniform int material;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// macierz modelu-widoku
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewMatrix;

//////////////////////////////////////////////////////////////////////
// macierz przeksztacenia wektora normalnego
//////////////////////////////////////////////////////////////////////
uniform mat3 normalMatrix;

//////////////////////////////////////////////////////////////////////
// numery pooenia poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define NORMAL   1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// interpolowany kolor wierzchoka przedniej i tylnej strony wielokta
//////////////////////////////////////////////////////////////////////
out vec4 inoutFrontColor;
out vec4 inoutBackColor;

void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * inPosition;

    // przeksztacenie i normalizacja wektora normalnego
    vec3 normal = normalize( normalMatrix * inNormal );

    // przeksztacenie wsprzdnych wierzchoka do ukadu obserwatora
    vec3 position = vec3( modelViewMatrix * inPosition );

    // pobranie wybranego materiau
    MaterialParameters mat = GetMaterial( material );

    // interpolowany kolor wierzchoka przedniej i tylnej strony wielokta
    inoutFrontColor = BlinnPhongLight( 0, normal, position, mat.ambient, mat.diffuse, mat.specular, mat.shininess );
    inoutBackColor = BlinnPhongLight( 0, -normal, position, mat.ambient, mat.diffuse, mat.specular, mat.shininess );
}
