//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#ifndef __TEXT__H__
#define __TEXT__H__

#include <string>
#include <glm/glm.hpp>

//////////////////////////////////////////////////////////////////////
// inicjacja mechanizmw uywanych podczas renderingu tekstu
//////////////////////////////////////////////////////////////////////
void InitDrawText();

//////////////////////////////////////////////////////////////////////
// funkcja rysujca napis w wybranym miejscu
// x, y - wsprzdne okienkowe pocztku napisu
// str - tekst napisu
// color - kolor napisu, domylnie czarny
//////////////////////////////////////////////////////////////////////
void DrawText8x16( const int x, const int y, const std::string &str,
                   const glm::vec4 &color = glm::vec4( 0.0f, 0.0f, 0.0f, 1.0f ) );

//////////////////////////////////////////////////////////////////////
// usunicie mechanizmw uywanych podczas renderingu tekstu
//////////////////////////////////////////////////////////////////////
void DeleteDrawText();

#endif // __TEXT__H__
