//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry materiau
//////////////////////////////////////////////////////////////////////
struct MaterialParameters
{
    vec4 ambient;       // wspczynnik odbicia wiata otoczenia; oznaczenie Ma
    vec4 diffuse;       // wspczynnik odbicia wiata rozproszonego; oznaczenie Md
    vec4 specular;      // wspczynnik odbicia wiata zwierciadlanego; oznaczenie Ms
    float shininess;    // wykadnik wspczynnika funkcji rozbysku;
                        // zakres wartoci <0;128>; oznaczenie Msh
};

//////////////////////////////////////////////////////////////////////
// prototypy funkcji
//////////////////////////////////////////////////////////////////////
MaterialParameters GetMaterial( const int material );
vec4 BlinnPhongLight( const int light, const vec3 normal, const vec3 position,
                        const vec4 ambient, const vec4 diffuse,
                        const vec4 specular, const float shininess );
vec4 LambertLight( const int light, const vec3 normal, const vec3 position,
                    const vec4 ambient, const vec4 diffuse );

//////////////////////////////////////////////////////////////////////
// rozmiar tablicy z mask filtra 5x5
//////////////////////////////////////////////////////////////////////
#define FILTER_5X5_SIZE 25

//////////////////////////////////////////////////////////////////////
// maska filtra Gaussa 5x5
//////////////////////////////////////////////////////////////////////
const float Gauss5x5[FILTER_5X5_SIZE] = float[FILTER_5X5_SIZE]
(
    2.0f/571.0f,  7.0f/571.0f,  12.0f/571.0f,  7.0f/571.0f,  2.0f/571.0f,
    7.0f/571.0f, 31.0f/571.0f,  52.0f/571.0f, 31.0f/571.0f,  7.0f/571.0f,
    12.0f/571.0f, 52.0f/571.0f, 127.0f/571.0f, 52.0f/571.0f, 12.0f/571.0f,
    7.0f/571.0f, 31.0f/571.0f,  52.0f/571.0f, 31.0f/571.0f,  7.0f/571.0f,
    2.0f/571.0f,  7.0f/571.0f,  12.0f/571.0f,  7.0f/571.0f,  2.0f/571.0f
);

//////////////////////////////////////////////////////////////////////
// numer materiau
//////////////////////////////////////////////////////////////////////
uniform int material;

//////////////////////////////////////////////////////////////////////
// tekstura gbokoci z map cienia
//////////////////////////////////////////////////////////////////////
uniform sampler2DShadow shadowTex;

//////////////////////////////////////////////////////////////////////
// interpolowany wektor normalny
//////////////////////////////////////////////////////////////////////
in vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
in vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec4 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

void main()
{
    // normalizacja wektora normalnego zalena od strony wielokta
    vec3 normal = gl_FrontFacing ? normalize( inoutNormal ) : -normalize( inoutNormal );

    // pobranie wybranego materiau
    MaterialParameters mat = GetMaterial( material );

    // kolor owietlonego fragmentu
    vec4 lightColor = BlinnPhongLight( 0, normal, inoutPosition, mat.ambient, mat.diffuse, mat.specular, mat.shininess );

    // kolor fragmentu w cieniu
    vec4 shadowColor = LambertLight( 0, normal, inoutPosition, mat.ambient, mat.diffuse );

    // prbkowanie tekstury cienia
    float shadow = 0.0;
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -2, -2 ) ) * Gauss5x5[0];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -2, -1 ) ) * Gauss5x5[1];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -2,  0 ) ) * Gauss5x5[2];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -2,  1 ) ) * Gauss5x5[3];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -2,  2 ) ) * Gauss5x5[4];

    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1, -2 ) ) * Gauss5x5[5];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1, -1 ) ) * Gauss5x5[6];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1,  0 ) ) * Gauss5x5[7];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1,  1 ) ) * Gauss5x5[8];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2( -1,  2 ) ) * Gauss5x5[9];

    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0, -2 ) ) * Gauss5x5[10];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0, -1 ) ) * Gauss5x5[11];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0,  0 ) ) * Gauss5x5[12];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0,  1 ) ) * Gauss5x5[13];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  0,  2 ) ) * Gauss5x5[14];

    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1, -2 ) ) * Gauss5x5[15];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1, -1 ) ) * Gauss5x5[16];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1,  0 ) ) * Gauss5x5[17];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1,  1 ) ) * Gauss5x5[18];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  1,  2 ) ) * Gauss5x5[19];

    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  2, -2 ) ) * Gauss5x5[20];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  2, -1 ) ) * Gauss5x5[21];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  2,  0 ) ) * Gauss5x5[22];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  2,  1 ) ) * Gauss5x5[23];
    shadow += textureProjOffset( shadowTex, inoutTexCoord, ivec2(  2,  2 ) ) * Gauss5x5[24];

    // kolor fragmentu z cieniem pomnoonym przez kolor cienia
    outColor = mix( 1.5 * shadowColor * vec4( 0.184314f, 0.309804f, 0.309804f, 1.000000f ), lightColor, shadow );
}
