//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw w wyjciowym pacie wierzchokw
//////////////////////////////////////////////////////////////////////
layout( vertices = 3 ) out;

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In[];

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} Out[];

//////////////////////////////////////////////////////////////////////
// wewntrzny i zewntrzny poziom teselacji
//////////////////////////////////////////////////////////////////////
uniform float tessLevel;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // parametry teselacji zapisywane tylko w pierwszym wywoaniu shadera
    if( gl_InvocationID == 0 )
    {
        gl_TessLevelOuter[0] = tessLevel;
        gl_TessLevelOuter[1] = tessLevel;
        gl_TessLevelOuter[2] = tessLevel;
        gl_TessLevelInner[0] = tessLevel;
    }

    // wsprzdne wierzchoka
    Out[gl_InvocationID].position = In[gl_InvocationID].position;

    // wsprzdne wektora normalnego
    Out[gl_InvocationID].normal = In[gl_InvocationID].normal;
}
