//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry materiau
//////////////////////////////////////////////////////////////////////
struct MaterialParameters
{
    vec4 ambient;       // wspczynnik odbicia wiata otoczenia; oznaczenie Ma
    vec4 diffuse;       // wspczynnik odbicia wiata rozproszonego; oznaczenie Md
    vec4 specular;      // wspczynnik odbicia wiata zwierciadlanego; oznaczenie Ms
    float shininess;    // wykadnik wspczynnika funkcji rozbysku;
                        // zakres wartoci <0;128>; oznaczenie Msh
};

//////////////////////////////////////////////////////////////////////
// prototypy funkcji
//////////////////////////////////////////////////////////////////////
MaterialParameters GetMaterial( const int material );
vec4 BlinnPhongLight( const int light, const vec3 normal, const vec3 position,
                      const vec4 ambient, const vec4 diffuse,
                      const vec4 specular, const float shininess );
vec4 PhongLight( const int light, const vec3 normal, const vec3 position,
                 const vec4 ambient, const vec4 diffuse,
                 const vec4 specular, const float shininess );
vec4 LambertLight( const int light, const vec3 normal, const vec3 position,
                   const vec4 ambient, const vec4 diffuse );

//////////////////////////////////////////////////////////////////////
// deklaracja typu podprogramu obsugujcego model owietlenia
//////////////////////////////////////////////////////////////////////
subroutine vec4 lightSubroutine( const vec3 normal, const vec3 position,
                                 const vec4 ambient, const vec4 diffuse,
                                 const vec4 specular, const float shininess );

//////////////////////////////////////////////////////////////////////
// podprogram obsugujcy model owietlenia Phonga
//////////////////////////////////////////////////////////////////////
subroutine( lightSubroutine ) vec4 Phong( const vec3 normal, const vec3 position,
                                          const vec4 ambient, const vec4 diffuse,
                                          const vec4 specular, const float shininess )
{
    return PhongLight( 0, normal, position, ambient, diffuse, specular, shininess );
}

//////////////////////////////////////////////////////////////////////
// podprogram obsugujcy model owietlenia Blinna-Phonga
//////////////////////////////////////////////////////////////////////
subroutine( lightSubroutine ) vec4 BlinnPhong( const vec3 normal, const vec3 position,
                                                const vec4 ambient, const vec4 diffuse,
                                                const vec4 specular, const float shininess )
{
    return BlinnPhongLight( 0, normal, position, ambient, diffuse, specular, shininess );
}

//////////////////////////////////////////////////////////////////////
// podprogram obsugujcy model owietlenia Lamberta
//////////////////////////////////////////////////////////////////////
subroutine( lightSubroutine ) vec4 Lambert( const vec3 normal, const vec3 position,
                                            const vec4 ambient, const vec4 diffuse,
                                            const vec4 specular, const float shininess )
{
    return LambertLight( 0, normal, position, ambient, diffuse );
}

//////////////////////////////////////////////////////////////////////
// wybr rodzaju modelu owietlenia
//////////////////////////////////////////////////////////////////////
subroutine uniform lightSubroutine lightType;

//////////////////////////////////////////////////////////////////////
// wybrany materia
//////////////////////////////////////////////////////////////////////
uniform int material = 0;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

void main()
{
    // normalizacja wektora normalnego zalena od strony wielokta
    vec3 normal = gl_FrontFacing ? normalize( In.normal ) : -normalize( In.normal );

    // pobranie wybranego materiau
    MaterialParameters mat = GetMaterial( material );

    // kolor fragmentu zaleny od modelu owietlenia
    outColor = lightType( normal, In.position, mat.ambient, mat.diffuse, mat.specular, mat.shininess );
}
