//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat position[4*2];
extern int segments;

//////////////////////////////////////////////////////////////////////
// identyfikator wybranego obiektu: 0 - oznacza brak obiektu,
// 1-4 oznaczaj poszczeglne punkty kontrolne krzywej
//////////////////////////////////////////////////////////////////////
int selectObject = 0;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // teset selekcji punktu
        if( state == GLUT_DOWN )
        {
            // zamiana wsprzdnej pooenia myszy
            y = glutGet( GLUT_WINDOW_HEIGHT ) - y;

            // sprawdzenie trafienia w prostokt reprezentujcy punkt kontrolny
            selectObject = 0;
            for( int i = 0; i < 4; i++ )
            {
                if( position[2*i + 0] >= x - 5 &&
                    position[2*i + 0] <= x + 5 &&
                    position[2*i + 1] >= y - 5 &&
                    position[2*i + 1] <= y + 5 )
                {
                    selectObject = i + 1;
                    break;
                }
            }
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        if( selectObject )
        {
            // zmiana pooenia wybranego punktu kontrolnego
            position[2*(selectObject - 1) + 0] = static_cast<GLfloat>( x );
            position[2*(selectObject - 1) + 1] = static_cast<GLfloat>( glutGet( GLUT_WINDOW_HEIGHT ) - y );
            glutPostRedisplay();
        }

    }
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // liczba segmentw krzywej
    SEGMENTS_10,
    SEGMENTS_20,
    SEGMENTS_30,
    SEGMENTS_40,
    SEGMENTS_50,

    EXIT // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // liczba segmentw krzywej
        case SEGMENTS_10:
        case SEGMENTS_20:
        case SEGMENTS_30:
        case SEGMENTS_40:
        case SEGMENTS_50:
            segments = 10*(value + 1);
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 4, 0 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "Krzywa Bziera - teselacja" );
#else
    glutCreateWindow( "Krzywa Beziera - teselacja" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_4_0 )
    {
        std::cout << "Brak OpenGL 4.0" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu "Liczba segmentw krzywej"
    int menuSegments = glutCreateMenu( Menu );
    glutAddMenuEntry( "10", SEGMENTS_10 );
    glutAddMenuEntry( "20", SEGMENTS_20 );
    glutAddMenuEntry( "30", SEGMENTS_30 );
    glutAddMenuEntry( "40", SEGMENTS_40 );
    glutAddMenuEntry( "50", SEGMENTS_50 );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "Liczba segmentow krzywej", menuSegments );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
