//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat scale;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateY;
extern GLint instCount;
extern GLfloat refAlpha;
extern int texNumber;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // numer tekstury 3D
    TEXTURE_3D_0,
    TEXTURE_3D_1,

    // liczba instancji
    INSTANCE_128,
    INSTANCE_256,
    INSTANCE_384,
    INSTANCE_512,
    INSTANCE_640,
    INSTANCE_768,
    INSTANCE_896,
    INSTANCE_1024,

    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // numer tekstury 3D
        case TEXTURE_3D_0:
        case TEXTURE_3D_1:
            texNumber = value;
            break;

        // liczba instancji
        case INSTANCE_128:
        case INSTANCE_256:
        case INSTANCE_384:
        case INSTANCE_512:
        case INSTANCE_640:
        case INSTANCE_768:
        case INSTANCE_896:
        case INSTANCE_1024:
            instCount = 128 * (value - INSTANCE_128 + 1);
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // 1
        case '1':
            texNumber = TEXTURE_3D_0;
            break;
        // 2
        case '2':
            texNumber = TEXTURE_3D_1;
            break;
        // q
        case 'Q':
        case 'q':
            if( instCount > 16 ) instCount -= 16;
            break;
        // a
        case 'A':
        case 'a':
            if( refAlpha > 0.02f ) refAlpha -= 0.02f;
            break;
        // w
        case 'W':
        case 'w':
            instCount += 16;
            break;
        // s
        case 'S':
        case 's':
            if( refAlpha < 0.98f ) refAlpha += 0.02f;
            break;
        // klawisz +
        case '+':
            scale += 0.03f;
            break;
        // klawisz -
        case '-':
            if( scale > 0.03f ) scale -= 0.03f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        // kursor w lewo
        case GLUT_KEY_LEFT:
            translateX -= 0.03f;
            break;

        // kursor w gr
        case GLUT_KEY_UP:
            translateY += 0.03f;
            break;

        // kursor w prawo
        case GLUT_KEY_RIGHT:
            translateX += 0.03f;
            break;

        // kursor w d
        case GLUT_KEY_DOWN:
            translateY -= 0.03f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
    glutCreateWindow( "Tekstura 3D" );

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - Liczba instancji
    int menuInstCount = glutCreateMenu( Menu );
    glutAddMenuEntry( "128", INSTANCE_128 );
    glutAddMenuEntry( "256", INSTANCE_256 );
    glutAddMenuEntry( "384", INSTANCE_384 );
    glutAddMenuEntry( "512", INSTANCE_512 );
    glutAddMenuEntry( "640", INSTANCE_640 );
    glutAddMenuEntry( "768", INSTANCE_768 );
    glutAddMenuEntry( "896", INSTANCE_896 );
    glutAddMenuEntry( "1024", INSTANCE_1024 );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddMenuEntry( "Tekstura 3D nr 1", TEXTURE_3D_0 );
    glutAddMenuEntry( "Tekstura 3D nr 2", TEXTURE_3D_1 );
    glutAddSubMenu( "Liczba instancji", menuInstCount );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
