//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// wspczynniki rwnania paszczyzny obcinania
//////////////////////////////////////////////////////////////////////
const vec4 clipPlane = vec4( 1.0, 0.0, 0.0, 0.0 );

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// tablica z odlegociami od paszczyzn obcinania
//////////////////////////////////////////////////////////////////////
out float gl_ClipDistance[1];

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // standardowe przeksztacenie wierzchokw
    gl_Position = modelViewProjectionMatrix * inPosition;

    // obliczenie odlegoci wierzchoka od paszczyzny obcinania
    gl_ClipDistance[0] = dot( clipPlane, gl_Position );
}
