//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////
// rdo danych:
// Advanced Graphics Programming Techniques Using OpenGL
// SIGGRAPH `99 Course
// http://www.opengl.org/resources/code/samples/sig99/advanced99/notes/node153.html
// oraz:
// http://www.sc.ehu.es/ccwgamoa/docencia/Material/OpenGL/Materials-Parameters/materials_cpp_values.html
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry materiau
//////////////////////////////////////////////////////////////////////
struct MaterialParameters
{
    vec4 ambient;       // wspczynnik odbicia wiata otoczenia; oznaczenie Ma
    vec4 diffuse;       // wspczynnik odbicia wiata rozproszonego; oznaczenie Md
    vec4 specular;      // wspczynnik odbicia wiata zwierciadlanego; oznaczenie Ms
    float shininess;    // wykadnik wspczynnika funkcji rozbysku;
                        // zakres wartoci <0;128>; oznaczenie Msh
};

//////////////////////////////////////////////////////////////////////
// stae okrelajce poszczeglne materiay
//////////////////////////////////////////////////////////////////////
#define MTL_DEFAULT              0  // materia domylny
#define MTL_BRASS                1  // mosidz
#define MTL_BRONZE               2  // brz
#define MTL_POLISHED_BRONZE      3  // polerowany brz
#define MTL_CHROME               4  // chrom
#define MTL_COPPER               5  // mied
#define MTL_POLISHED_COPPER      6  // polerowana mied
#define MTL_GOLD                 7  // zoto
#define MTL_POLISHED_GOLD        8  // polerowane zoto
#define MTL_PEWTER               9  // grafit (cyna z oowiem)
#define MTL_SILVER              10  // srebro
#define MTL_POLISHED_SILVER     11  // polerowane srebro
#define MTL_EMERALD             12  // szmaragd
#define MTL_JADE                13  // jadeit
#define MTL_OBSIDIAN            14  // obsydian (szko wulkaniczne)
#define MTL_PEARL               15  // pera
#define MTL_RUBY                16  // rubin
#define MTL_TURQUOISE           17  // turkus
#define MTL_BRIGHT_WHITE        18  // jasny biay
#define MTL_LESS_BRIGHT_WHITE   19  // mniej jasny biay
#define MTL_WARMISH_WHITE       20  // ciepy biay
#define MTL_COOLISH_WHITE       21  // zimny biay
#define MTL_BLACK_PLASTIC       22  // czarny plastik
#define MTL_CYAN_PLASTIC        23  // niebieskozielony plastik
#define MTL_GREEN_PLASTIC       24  // zielony plastik
#define MTL_RED_PLASTIC         25  // czerwony plastik
#define MTL_WHITE_PLASTIC       26  // biay plastik
#define MTL_YELLOW_PLASTIC      27  // ty plastik
#define MTL_BLACK_RUBBER        28  // czarna guma
#define MTL_CYAN_RUBBER         29  // niebieskozielona guma
#define MTL_GREEN_RUBBER        30  // zielona guma
#define MTL_RED_RUBBER          31  // czerwona guma
#define MTL_WHITE_RUBBER        32  // biaa guma
#define MTL_YELLOW_RUBBER       33  // ta guma

//////////////////////////////////////////////////////////////////////
// dane poszczeglnych materiaw
//////////////////////////////////////////////////////////////////////
layout( std140 ) uniform Materials
{
     MaterialParameters materials[34];
};

//////////////////////////////////////////////////////////////////////
// pobranie okrelonego materiau
//////////////////////////////////////////////////////////////////////
MaterialParameters GetMaterial( const int material )
{
    if( material >= MTL_DEFAULT && material <= MTL_YELLOW_RUBBER )
        return materials[material];
    else
        return materials[MTL_DEFAULT];
}
