//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <string>
#include <sstream>
#include <iomanip>
#include "shaders.h"
#include "text.h"

//////////////////////////////////////////////////////////////////////
// identyfikator obiektu programu
//////////////////////////////////////////////////////////////////////
GLuint program;

//////////////////////////////////////////////////////////////////////
// identyfikator obiektu bufora z danymi tablicy
// wierzchokw - wsprzdnymi wierzchokw trjkta
//////////////////////////////////////////////////////////////////////
GLuint vertexBuffer;

//////////////////////////////////////////////////////////////////////
// identyfikator obiektu tablic wierzchokw
//////////////////////////////////////////////////////////////////////
GLuint vertexArray;

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw trjktw skadajcych si na trjkt
//////////////////////////////////////////////////////////////////////
GLfloat position[2*3] =
{
    -0.75f, -0.75f,
     0.75f, -0.75f,
     0.0f,  0.75f,
};

//////////////////////////////////////////////////////////////////////
// poziomy teselacji
//////////////////////////////////////////////////////////////////////
GLfloat tessLevelOuter[3] = { 4.0f, 4.0f, 4.0f };
GLfloat tessLevelInner[1] = { 4.0f };

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0

//////////////////////////////////////////////////////////////////////
// funkcja generujca scen 3D
//////////////////////////////////////////////////////////////////////
void DisplayScene()
{
    // czyszczenie bufora koloru
    glClear( GL_COLOR_BUFFER_BIT );

    // wczenie obiektu tablic wierzchokw
    glBindVertexArray( vertexArray );

    // wczenie programu
    glUseProgram( program );

    // zaadowanie zmiennych jednorodnych z poziomami teselacji
    glUniform3fv( glGetUniformLocation( program, "tessLevelOuter" ), 1, tessLevelOuter );
    glUniform1fv( glGetUniformLocation( program, "tessLevelInner" ), 1, tessLevelInner );

    // narysowanie danych zawartych w tablicach wierzchokw
    glDrawArrays( GL_PATCHES, 0, 3 );

    // wyczenie programu
    glUseProgram( 0 );

    // wyczenie obiektu tablic wierzchokw
    glBindVertexArray( 0 );

    // wypisanie poziomw teselacji
    std::ostringstream txt;
    txt << std::setprecision( 0 ) << std::fixed
        << "gl_TessLevelOuter=[" << tessLevelOuter[0] << "," << tessLevelOuter[1] << "," << tessLevelOuter[2] << "]";
    DrawText8x16( 3, 3, txt.str() );
    txt.str( "" );;
    txt << std::setprecision( 0 ) << std::fixed
        << "gl_TessLevelInner=[" << tessLevelInner[0] << "]";
    DrawText8x16( 3, 21, txt.str() );
}

//////////////////////////////////////////////////////////////////////
// zmiana wielkoci okna
//////////////////////////////////////////////////////////////////////
void Reshape( int width, int height )
{
    // obszar renderingu - cae okno
    glViewport( 0, 0, width, height );
}

//////////////////////////////////////////////////////////////////////
// inicjalizacja staych elementw maszyny stanu OpenGL
//////////////////////////////////////////////////////////////////////
void InitScene()
{
    // kolor ta - zawarto bufora koloru
    glClearColor( 1.0f, 1.0f, 1.0f, 1.0f );

    // wczytanie shaderw i przygotowanie obsugi programu
    program = glCreateProgram();
    glAttachShader( program, LoadShader( GL_VERTEX_SHADER, "trojkat_teselacja_vs.glsl" ) );
    glAttachShader( program, LoadShader( GL_TESS_CONTROL_SHADER, "trojkat_teselacja_tcs.glsl" ) );
    glAttachShader( program, LoadShader( GL_TESS_EVALUATION_SHADER, "trojkat_teselacja_tes.glsl" ) );
    glAttachShader( program, LoadShader( GL_FRAGMENT_SHADER, "trojkat_teselacja_fs.glsl" ) );
    LinkValidateProgram( program );

    // generowanie identyfikatora obiektu tablic wierzchokw
    glGenVertexArrays( 1, &vertexArray );

    // utworzenie obiektu tablic wierzchokw
    glBindVertexArray( vertexArray );

    // generowanie identyfikatora obiektu bufora
    glGenBuffers( 1, &vertexBuffer );

    // utworzenie obiektu bufora wierzchokw (VBO)
    glBindBuffer( GL_ARRAY_BUFFER, vertexBuffer );

    // zaadowanie danych obiektu bufora wierzchokw
    glBufferData( GL_ARRAY_BUFFER, sizeof( position ), position, GL_STATIC_DRAW );

    // zdefiniowanie tablicy wierzchokw
    glVertexAttribPointer( POSITION, 2, GL_FLOAT, GL_FALSE, 0, NULL );

    // wczenie tablic wierzchokw
    glEnableVertexAttribArray( POSITION );

    // wyczenie obiektu tablic wierzchokw
    glBindVertexArray( 0 );

    // wielko wejciowego pata wierzchokw
    glPatchParameteri( GL_PATCH_VERTICES, 3 );

    // szeroko linii
    glLineWidth( 1.5 );

    // tryb renderingu wieloktw - linie
    glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );

    // wczenie mechanizmw uywanych podczas renderingu tekstu
    InitDrawText();
}

//////////////////////////////////////////////////////////////////////
// usunicie obiektw OpenGL
//////////////////////////////////////////////////////////////////////
void DeleteScene()
{
    // usunicie obiektu programu
    glDeleteProgram( program );

    // usunicie obiektu bufora wierzchokw
    glDeleteBuffers( 1, &vertexBuffer );

    // usunicie obiektu tablic wierzchokw
    glDeleteVertexArrays( 1, &vertexArray );

    // usunicie mechanizmw uywanych podczas renderingu tekstu
    DeleteDrawText();
}
