//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.0
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy
//////////////////////////////////////////////////////////////////////
layout( lines ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy - cztery odcinki
//////////////////////////////////////////////////////////////////////
layout( line_strip, max_vertices = 8 ) out;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// wejciowe wsprzdne punktu w przestrzeni obiektu
//////////////////////////////////////////////////////////////////////
in vec4 inoutPosition[2];

//////////////////////////////////////////////////////////////////////
// wyjciowe wsprzdne punktu w przestrzeni obiektu
//////////////////////////////////////////////////////////////////////
out vec4 outPosition;

void main()
{
    // wektor utworzony z kocw odcinka
    vec4 diff = inoutPosition[1] - inoutPosition[0];

    // wektor prostopady do wektora diff, przy zaoeniu,
    // e oba wektory le w paszczynie o rwnaniu Z = 0
    vec4 perp = vec4( diff.y, -diff.x, 0.0, 0.0 );

    // pierwszy odcinek
    outPosition = inoutPosition[0];
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();
    outPosition = inoutPosition[0] + diff / 3.0;
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();

    // koniec prymitywu
    EndPrimitive();

    // drugi odcinek
    outPosition = inoutPosition[0] + diff / 3.0;
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();
    outPosition = inoutPosition[0] + 0.5 * diff + perp / 3.0;
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();

    // koniec prymitywu
    EndPrimitive();

    // trzeci odcinek
    outPosition = inoutPosition[0] + 0.5 * diff + perp / 3.0;
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();
    outPosition = inoutPosition[0] + 2.0 * diff / 3.0;
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();

    // koniec prymitywu
    EndPrimitive();

    // czwarty odcinek
    outPosition = inoutPosition[0] + 2.0 * diff / 3.0;
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();
    outPosition = inoutPosition[1];
    gl_Position = modelViewProjectionMatrix * outPosition;
    EmitVertex();

    // koniec prymitywu
    EndPrimitive();
}
